/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.ui.WidthBasedLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

final class CombinedPopupLayout
implements LayoutManager {
    private static final int MAX_POPUP_WIDTH = 950;
    @Nullable
    private final JComponent highlightInfoComponent;
    @Nullable
    private final JComponent quickDocComponent;

    CombinedPopupLayout(@Nullable JComponent highlightInfoComponent, @Nullable JComponent quickDocComponent) {
        this.highlightInfoComponent = highlightInfoComponent;
        this.quickDocComponent = quickDocComponent;
    }

    @Override
    public void addLayoutComponent(String name2, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int w1 = WidthBasedLayout.getPreferredWidth((Component)this.highlightInfoComponent);
        int w2 = WidthBasedLayout.getPreferredWidth((Component)this.quickDocComponent);
        int preferredWidth = Math.min(JBUI.scale((int)950), Math.max(w1, w2));
        int h1 = WidthBasedLayout.getPreferredHeight((Component)this.highlightInfoComponent, (int)preferredWidth);
        int h2 = WidthBasedLayout.getPreferredHeight((Component)this.quickDocComponent, (int)preferredWidth);
        return new Dimension(preferredWidth, h1 + h2);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension d1 = this.highlightInfoComponent == null ? new Dimension() : this.highlightInfoComponent.getMinimumSize();
        Dimension d2 = this.quickDocComponent == null ? new Dimension() : this.quickDocComponent.getMinimumSize();
        return new Dimension(Math.max(d1.width, d2.width), d1.height + d2.height);
    }

    @Override
    public void layoutContainer(Container parent) {
        int width = parent.getWidth();
        int height = parent.getHeight();
        if (this.highlightInfoComponent == null) {
            if (this.quickDocComponent != null) {
                this.quickDocComponent.setBounds(0, 0, width, height);
            }
        } else if (this.quickDocComponent == null) {
            this.highlightInfoComponent.setBounds(0, 0, width, height);
        } else {
            int h1 = Math.min(height, this.highlightInfoComponent.getPreferredSize().height);
            this.highlightInfoComponent.setBounds(0, 0, width, h1);
            this.quickDocComponent.setBounds(0, h1, width, height - h1);
        }
    }
}

