/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;

public final class ConvertIndentsUtil {
    private static final IndentBuilder tabIndentBuilder = new IndentBuilder(){

        @Override
        public String buildIndent(int length, int tabSize) {
            return StringUtil.repeatSymbol((char)'\t', (int)(length / tabSize)) + StringUtil.repeatSymbol((char)' ', (int)(length % tabSize));
        }
    };
    private static final IndentBuilder spaceIndentBuilder = new IndentBuilder(){

        @Override
        public String buildIndent(int length, int tabSize) {
            return StringUtil.repeatSymbol((char)' ', (int)length);
        }
    };

    public static int convertIndentsToTabs(Document document, int tabSize, TextRange textRange) {
        return ConvertIndentsUtil.processIndents(document, tabSize, textRange, tabIndentBuilder);
    }

    public static int convertIndentsToSpaces(Document document, int tabSize, TextRange textRange) {
        return ConvertIndentsUtil.processIndents(document, tabSize, textRange, spaceIndentBuilder);
    }

    private static int processIndents(Document document, int tabSize, TextRange textRange, IndentBuilder indentBuilder) {
        int[] changedLines = new int[]{0};
        DocumentUtil.executeInBulk(document, () -> {
            int startLine = document.getLineNumber(textRange.getStartOffset());
            int endLine = document.getLineNumber(textRange.getEndOffset());
            for (int line = startLine; line <= endLine; ++line) {
                String newIndent;
                String oldIndent;
                int lineEnd;
                int indent = 0;
                int lineStart = document.getLineStartOffset(line);
                int indentEnd = lineEnd = document.getLineEndOffset(line);
                for (int offset = Math.max(lineStart, textRange.getStartOffset()); offset < lineEnd; ++offset) {
                    char c = document.getCharsSequence().charAt(offset);
                    if (c == ' ') {
                        ++indent;
                        continue;
                    }
                    if (c == '\t') {
                        indent = (indent / tabSize + 1) * tabSize;
                        continue;
                    }
                    indentEnd = offset;
                    break;
                }
                if (indent <= 0 || (oldIndent = document.getCharsSequence().subSequence(lineStart, indentEnd).toString()).equals(newIndent = indentBuilder.buildIndent(indent, tabSize))) continue;
                document.replaceString(lineStart, indentEnd, (CharSequence)newIndent);
                changedLines[0] = changedLines[0] + 1;
            }
        });
        return changedLines[0];
    }

    private static interface IndentBuilder {
        public String buildIndent(int var1, int var2);
    }
}

