/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContentChooser<Data>
extends DialogWrapper {
    public static final String RETURN_SYMBOL = "\u23ce";
    private List<Data> myAllContents;
    private Editor myViewer;
    private final boolean myUseIdeaEditor;
    private final JBList<Item> myList;
    private final JBSplitter mySplitter;
    private final Project myProject;
    private final boolean myAllowMultipleSelections;
    private final Alarm myUpdateAlarm;
    private Icon myListEntryIcon = AllIcons.FileTypes.Text;
    private boolean myUseNumbering = true;

    public ContentChooser(Project project, @NlsContexts.DialogTitle String title2, boolean useIdeaEditor) {
        this(project, title2, useIdeaEditor, false);
    }

    public ContentChooser(Project project, @NlsContexts.DialogTitle String title2, boolean useIdeaEditor, boolean allowMultipleSelections) {
        super(project, true);
        this.myProject = project;
        this.myUseIdeaEditor = useIdeaEditor;
        this.myAllowMultipleSelections = allowMultipleSelections;
        this.myUpdateAlarm = new Alarm(this.getDisposable());
        this.mySplitter = new JBSplitter(true, 0.3f);
        this.mySplitter.setSplitterProportionKey(this.getDimensionServiceKey() + ".splitter");
        this.myList = new JBList<Item>((ListModel)new CollectionListModel((Object[])new Item[0])){

            protected void doCopyToClipboardAction() {
                String text2 = ContentChooser.this.getSelectedText();
                if (!text2.isEmpty()) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
                }
            }
        };
        this.setOKButtonText(CommonBundle.getOkButtonText());
        this.setTitle(title2);
        this.init();
    }

    public void setContentIcon(@Nullable Icon icon2) {
        this.myListEntryIcon = icon2;
    }

    public void setSplitterOrientation(boolean vertical) {
        this.mySplitter.setOrientation(vertical);
    }

    public void setUseNumbering(boolean useNumbering) {
        this.myUseNumbering = useNumbering;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    protected JComponent createCenterPanel() {
        int selectionMode = this.myAllowMultipleSelections ? 2 : 0;
        this.myList.setSelectionMode(selectionMode);
        if (this.myUseIdeaEditor) {
            EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
            this.myList.setFont(scheme2.getFont(EditorFontType.PLAIN));
            Color fg = (Color)ObjectUtils.chooseNotNull((Object)scheme2.getDefaultForeground(), (Object)new JBColor(UIUtil::getListForeground));
            Color bg = (Color)ObjectUtils.chooseNotNull((Object)scheme2.getDefaultBackground(), (Object)new JBColor(UIUtil::getListBackground));
            this.myList.setForeground(fg);
            this.myList.setBackground(bg);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ContentChooser.this.close(0);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/actions/ContentChooser$2", "onDoubleClick"));
            }
        }.installOn(this.myList);
        final MyListCellRenderer renderer2 = new MyListCellRenderer();
        this.myList.setCellRenderer((ListCellRenderer)((Object)renderer2));
        this.myList.addKeyListener(new KeyListener(){
            boolean doConsume;

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int newSelectionIndex = -1;
                    for (Item o : ContentChooser.this.myList.getSelectedValuesList()) {
                        int i2 = o.index;
                        ContentChooser.this.removeContentAt(ContentChooser.this.myAllContents.get(i2));
                        if (newSelectionIndex >= 0) continue;
                        newSelectionIndex = i2;
                    }
                    ContentChooser.this.rebuildListContent();
                    if (ContentChooser.this.myAllContents.isEmpty()) {
                        ContentChooser.this.close(1);
                        return;
                    }
                    newSelectionIndex = Math.min(newSelectionIndex, ContentChooser.this.myAllContents.size() - 1);
                    ContentChooser.this.myList.setSelectedIndex(newSelectionIndex);
                } else if (e.getKeyCode() == 10) {
                    ContentChooser.this.doOKAction();
                } else if (ContentChooser.this.myUseNumbering) {
                    SpeedSearchSupply supply2 = SpeedSearchSupply.getSupply(ContentChooser.this.myList);
                    if (supply2 != null && supply2.isPopupActive()) {
                        return;
                    }
                    char aChar = e.getKeyChar();
                    if (aChar >= '0' && aChar <= '9') {
                        int idx;
                        int n = idx = aChar == '0' ? 9 : aChar - 49;
                        if (idx < ContentChooser.this.myAllContents.size()) {
                            ContentChooser.this.myList.setSelectedIndex(idx);
                            e.consume();
                            this.doConsume = true;
                            ApplicationManager.getApplication().invokeLater(() -> ContentChooser.this.doOKAction());
                        }
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.doConsume) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (this.doConsume) {
                    e.consume();
                }
            }
        });
        this.mySplitter.setFirstComponent(ListWithFilter.wrap(this.myList, (JScrollPane)ScrollPaneFactory.createScrollPane(this.myList), o -> o.getShortText(renderer2.previewChars), (boolean)true));
        this.mySplitter.setSecondComponent((JComponent)new JPanel());
        this.mySplitter.getFirstComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FontMetrics metrics = ContentChooser.this.myList.getFontMetrics(ContentChooser.this.myList.getFont());
                int charWidth = metrics.charWidth('i');
                renderer2.previewChars = ContentChooser.this.myList.getParent().getParent().getWidth() / charWidth + 10;
            }
        });
        this.rebuildListContent();
        ScrollingUtil.installActions(this.myList);
        ScrollingUtil.ensureSelectionExists(this.myList);
        this.updateViewerForSelection();
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ContentChooser.this.myUpdateAlarm.isDisposed()) {
                    return;
                }
                ContentChooser.this.myUpdateAlarm.cancelAllRequests();
                ContentChooser.this.myUpdateAlarm.addRequest(() -> ContentChooser.this.updateViewerForSelection(), 100);
            }
        });
        this.mySplitter.setPreferredSize((Dimension)JBUI.size((int)500, (int)500));
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.externalizeToDimensionService(((Object)((Object)this)).getClass().getName());
        d.restoreSplitterProportions((Component)this.mySplitter);
        return this.mySplitter;
    }

    protected abstract void removeContentAt(Data var1);

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void doOKAction() {
        if (this.getSelectedIndex() < 0) {
            return;
        }
        super.doOKAction();
    }

    private void updateViewerForSelection() {
        if (this.myAllContents.isEmpty()) {
            return;
        }
        @NonNls String fullString = this.getSelectedText();
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
        }
        if (this.myUseIdeaEditor) {
            this.myViewer = this.createIdeaEditor(fullString);
            JComponent component2 = this.myViewer.getComponent();
            component2.setPreferredSize((Dimension)JBUI.size((int)300, (int)500));
            this.mySplitter.setSecondComponent(component2);
        } else {
            JTextArea textArea2 = new JTextArea(fullString);
            textArea2.setRows(3);
            textArea2.setWrapStyleWord(true);
            textArea2.setLineWrap(true);
            textArea2.setSelectionStart(0);
            textArea2.setSelectionEnd(textArea2.getText().length());
            textArea2.setEditable(false);
            this.mySplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)textArea2));
        }
        this.mySplitter.revalidate();
    }

    protected Editor createIdeaEditor(String text2) {
        Document doc = EditorFactory.getInstance().createDocument((CharSequence)text2);
        Editor editor2 = EditorFactory.getInstance().createViewer(doc, this.myProject);
        editor2.getSettings().setFoldingOutlineShown(false);
        editor2.getSettings().setLineNumbersShown(false);
        editor2.getSettings().setLineMarkerAreaShown(false);
        editor2.getSettings().setIndentGuidesShown(false);
        return editor2;
    }

    public void dispose() {
        super.dispose();
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.externalizeToDimensionService(((Object)((Object)this)).getClass().getName());
        d.saveSplitterProportions((Component)this.mySplitter);
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
            this.myViewer = null;
        }
    }

    private void rebuildListContent() {
        ArrayList<Item> items = new ArrayList<Item>();
        int index2 = 0;
        ArrayList<Data> contents = new ArrayList<Data>(this.getContents());
        for (Object content2 : contents) {
            String longText = this.getStringRepresentationFor(content2);
            if (!StringUtil.isEmpty((String)longText)) {
                items.add(new Item(index2, longText));
            }
            ++index2;
        }
        this.myAllContents = contents;
        FilteringListModel listModel = (FilteringListModel)this.myList.getModel();
        ((CollectionListModel)listModel.getOriginalModel()).removeAll();
        listModel.addAll(items);
        ListWithFilter listWithFilter = (ListWithFilter)ComponentUtil.getParentOfType(ListWithFilter.class, this.myList);
        if (listWithFilter != null) {
            listWithFilter.getSpeedSearch().update();
            if (listModel.getSize() == 0) {
                listWithFilter.resetFilter();
            }
        }
    }

    @Nullable
    @NlsSafe
    protected abstract String getStringRepresentationFor(Data var1);

    @NotNull
    protected abstract List<Data> getContents();

    public int getSelectedIndex() {
        Item o = (Item)this.myList.getSelectedValue();
        return o == null ? -1 : o.index;
    }

    public void setSelectedIndex(int index2) {
        this.myList.setSelectedIndex(index2);
        ScrollingUtil.ensureIndexIsVisible(this.myList, (int)index2, (int)0);
        this.updateViewerForSelection();
    }

    @NotNull
    public List<Data> getSelectedContents() {
        List list2 = JBIterable.from((Iterable)this.myList.getSelectedValuesList()).map(o -> this.myAllContents.get(o.index)).toList();
        if (list2 == null) {
            ContentChooser.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public List<Data> getAllContents() {
        List<Data> list2 = this.myAllContents;
        if (list2 == null) {
            ContentChooser.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public String getSelectedText() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Item o : this.myList.getSelectedValuesList()) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            String s = o.longText;
            sb.append(StringUtil.convertLineSeparators((String)s));
        }
        String string = sb.toString();
        if (string == null) {
            ContentChooser.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/editor/actions/ContentChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedContents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class Item {
        final int index;
        protected final String longText;
        String shortText = "";
        boolean trimmed;

        protected Item(int index2, String longText) {
            this.index = index2;
            this.longText = longText;
        }

        @NlsSafe
        public String getShortText(int maxChars) {
            boolean hasSlashR;
            int len = this.shortText.length();
            if (len > 0 && !this.trimmed) {
                return this.shortText;
            }
            if (len >= maxChars && (len - maxChars) * 10 / len == 0) {
                return this.shortText;
            }
            if (len > maxChars) {
                this.shortText = StringUtil.first((String)this.shortText, (int)maxChars, (boolean)true);
                this.trimmed = true;
                return this.shortText;
            }
            boolean bl = hasSlashR = StringUtil.indexOf((CharSequence)this.longText, (char)'\r', (int)0, (int)Math.min(this.longText.length(), maxChars * 2 + 1)) > 0;
            if (!hasSlashR) {
                String s = StringUtil.first((String)this.longText, (int)maxChars, (boolean)true);
                this.trimmed = s != this.longText;
                this.shortText = StringUtil.convertLineSeparators((String)s, (String)ContentChooser.RETURN_SYMBOL);
            } else {
                String s = StringUtil.first((String)this.longText, (int)(maxChars * 2 + 1), (boolean)false);
                String s2 = StringUtil.convertLineSeparators((String)s, (String)ContentChooser.RETURN_SYMBOL);
                this.shortText = StringUtil.first((String)s2, (int)maxChars, (boolean)true);
                this.trimmed = s != this.longText || s2 != this.shortText;
            }
            return this.shortText;
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<Item> {
        int previewChars = 80;

        private MyListCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list2, Item value2, int index2, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
            this.setIcon(ContentChooser.this.myListEntryIcon);
            if (ContentChooser.this.myUseIdeaEditor && ContentChooser.this.myUseNumbering) {
                int max = list2.getModel().getSize();
                String indexString = String.valueOf(index2 + 1);
                int count = String.valueOf(max).length() - indexString.length();
                String prefix = indexString + StringUtil.repeatSymbol((char)' ', (int)count) + "  ";
                this.append(prefix, SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
            }
            String text2 = value2.getShortText(this.previewChars);
            this.append(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)this, (boolean)true, (boolean)selected2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/editor/actions/ContentChooser$MyListCellRenderer", "customizeCellRenderer"));
        }
    }
}

