/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CutLineEndAction
extends TextComponentEditorAction {
    public CutLineEndAction() {
        super((EditorActionHandler)new Handler());
    }

    private static final class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null && editor2.getCaretModel().getCaretCount() > 1) {
                editor2.getCaretModel().runForEachCaret(c -> c.setSelection(c.getOffset(), Handler.getEndOffset(c)));
                EditorCopyPasteHelper.getInstance().copySelectionToClipboard(editor2);
                EditorModificationUtil.deleteSelectedTextForAllCarets((Editor)editor2);
            } else {
                if (caret == null) {
                    caret = editor2.getCaretModel().getCurrentCaret();
                }
                int startOffset = caret.getOffset();
                int endOffset = Handler.getEndOffset(caret);
                KillRingUtil.cut(editor2, startOffset, endOffset);
                caret.moveToOffset(startOffset);
            }
        }

        private static int getEndOffset(@NotNull Caret caret) {
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            Document document = caret.getEditor().getDocument();
            int startOffset = caret.getOffset();
            int endOffset = DocumentUtil.getLineEndOffset(startOffset, document);
            if (endOffset < document.getTextLength() && CharArrayUtil.isEmptyOrSpaces((CharSequence)document.getImmutableCharSequence(), (int)startOffset, (int)endOffset)) {
                ++endOffset;
            }
            return endOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/CutLineEndAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeWriteAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEndOffset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

