/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actionSystem.LatencyAwareEditorAction;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterAction
extends EditorAction
implements LatencyAwareEditorAction {
    public EnterAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    public static void insertNewLineAtCaret(Editor editor2) {
        EditorUIUtil.hideCursorInEditor(editor2);
        Document document = editor2.getDocument();
        if (!editor2.isInsertMode()) {
            int caretLine = editor2.getCaretModel().getLogicalPosition().line;
            int lineCount = document.getLineCount();
            if (caretLine < lineCount) {
                if (caretLine == lineCount - 1) {
                    document.insertString(document.getTextLength(), (CharSequence)"\n");
                }
                LogicalPosition pos = new LogicalPosition(caretLine + 1, 0);
                editor2.getCaretModel().moveToLogicalPosition(pos);
                editor2.getSelectionModel().removeSelection();
                EditorModificationUtil.scrollToCaret((Editor)editor2);
            }
            return;
        }
        EditorModificationUtil.deleteSelectedText((Editor)editor2);
        CharSequence text2 = document.getCharsSequence();
        int caretOffset = editor2.getCaretModel().getOffset();
        int lineStartOffset = DocumentUtil.getLineStartOffset(caretOffset, document);
        int lineStartWsEndOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)lineStartOffset, (String)" \t");
        String s = "\n" + text2.subSequence(lineStartOffset, Math.min(caretOffset, lineStartWsEndOffset));
        document.insertString(caretOffset, (CharSequence)s);
        editor2.getCaretModel().moveToOffset(caretOffset + s.length());
        EditorModificationUtil.scrollToCaret((Editor)editor2);
        editor2.getSelectionModel().removeSelection();
    }

    private static class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.command.name", (Object[])new Object[0]));
            EnterAction.insertNewLineAtCaret(editor2);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(3);
            }
            return !editor2.isOneLineMode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/EnterAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeWriteAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

