/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.IndentStrategy;
import com.intellij.openapi.editor.LanguageIndentStrategy;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IndentSelectionAction
extends EditorAction {
    public IndentSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    public void update(Editor editor2, Presentation presentation2, DataContext dataContext) {
        presentation2.setEnabled(IndentSelectionAction.originalIsEnabled(editor2, true));
    }

    public void updateForKeyboardAccess(Editor editor2, Presentation presentation2, DataContext dataContext) {
        presentation2.setEnabled(this.isEnabled(editor2, dataContext));
    }

    protected boolean isEnabled(Editor editor2, DataContext dataContext) {
        return IndentSelectionAction.originalIsEnabled(editor2, true);
    }

    protected static boolean originalIsEnabled(Editor editor2, boolean wantSelection) {
        return (!wantSelection || IndentSelectionAction.hasSuitableSelection(editor2)) && !editor2.isOneLineMode() && !editor2.isViewer();
    }

    private static boolean hasSuitableSelection(Editor editor2) {
        if (!editor2.getSelectionModel().hasSelection()) {
            return false;
        }
        Document document = editor2.getDocument();
        int selectionStart = editor2.getSelectionModel().getSelectionStart();
        int selectionEnd = editor2.getSelectionModel().getSelectionEnd();
        return !CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)document.getCharsSequence().subSequence(selectionStart, selectionEnd));
    }

    private static void indentSelection(Editor editor2, Project project) {
        int endIndex;
        Document document;
        int startIndex;
        int oldSelectionStart = editor2.getSelectionModel().getSelectionStart();
        int oldSelectionEnd = editor2.getSelectionModel().getSelectionEnd();
        if (!editor2.getSelectionModel().hasSelection()) {
            oldSelectionEnd = oldSelectionStart = editor2.getCaretModel().getOffset();
        }
        if ((startIndex = (document = editor2.getDocument()).getLineNumber(oldSelectionStart)) == -1) {
            startIndex = document.getLineCount() - 1;
        }
        if ((endIndex = document.getLineNumber(oldSelectionEnd)) > 0 && document.getLineStartOffset(endIndex) == oldSelectionEnd && editor2.getSelectionModel().hasSelection()) {
            --endIndex;
        }
        if (endIndex == -1) {
            endIndex = document.getLineCount() - 1;
        }
        int blockIndent = CodeStyle.getIndentOptions((Project)project, (Document)document).INDENT_SIZE;
        IndentSelectionAction.doIndent(endIndex, startIndex, document, project, editor2, blockIndent);
    }

    static void doIndent(int endIndex, int startIndex, Document document, Project project, Editor editor2, int blockIndent) {
        int[] caretOffset = new int[]{editor2.getCaretModel().getOffset()};
        SelectionModel selectionModel = editor2.getSelectionModel();
        boolean extendSelection = selectionModel.hasSelection() && DocumentUtil.isAtLineStart(selectionModel.getSelectionStart(), document) && (selectionModel.getSelectionEnd() == document.getTextLength() || DocumentUtil.isAtLineStart(selectionModel.getSelectionEnd(), document));
        boolean bulkMode = endIndex - startIndex > 50;
        DocumentUtil.executeInBulk(document, bulkMode, () -> {
            ArrayList<Integer> nonModifiableLines = new ArrayList<Integer>();
            if (project != null) {
                int indentationStartOffset = document.getLineStartOffset(startIndex);
                int indentationEndOffset = document.getLineStartOffset(endIndex);
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                IndentStrategy indentStrategy = LanguageIndentStrategy.getIndentStrategy((PsiFile)file2);
                if (file2 != null && !LanguageIndentStrategy.isDefault((IndentStrategy)indentStrategy)) {
                    for (int i2 = startIndex; i2 <= endIndex; ++i2) {
                        PsiElement element2 = file2.findElementAt(document.getLineStartOffset(i2));
                        if (element2 == null || indentStrategy.canIndent(indentationStartOffset, indentationEndOffset, element2)) continue;
                        nonModifiableLines.add(i2);
                    }
                }
            }
            for (int i3 = startIndex; i3 <= endIndex; ++i3) {
                if (nonModifiableLines.contains(i3)) continue;
                caretOffset[0] = EditorActionUtil.indentLine(project, editor2, i3, blockIndent, caretOffset[0]);
            }
        });
        if (extendSelection) {
            selectionModel.setSelection(DocumentUtil.getLineStartOffset(selectionModel.getSelectionStart(), document), selectionModel.getSelectionEnd());
        }
        editor2.getCaretModel().moveToOffset(caretOffset[0]);
    }

    private static class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (this.isEnabled(editor2, caret, dataContext)) {
                IndentSelectionAction.indentSelection(editor2, project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/IndentSelectionAction$Handler";
            objectArray[2] = "executeWriteAction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

