/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.EventListener;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFactoryImpl
extends EditorFactory {
    private static final ExtensionPointName<EditorFactoryListener> EP = new ExtensionPointName("com.intellij.editorFactoryListener");
    private static final Logger LOG = Logger.getInstance(EditorFactoryImpl.class);
    private final EditorEventMulticasterImpl myEditorEventMulticaster = new EditorEventMulticasterImpl();
    private final EventDispatcher<EditorFactoryListener> myEditorFactoryEventDispatcher = EventDispatcher.create(EditorFactoryListener.class);

    public EditorFactoryImpl() {
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                Disposer.register((Disposable)project, () -> {
                    Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                    boolean isLastProjectClosed = openProjects.length == 0;
                    ApplicationManager.getApplication().invokeLater(() -> EditorFactoryImpl.this.validateEditorsAreReleased(project, isLastProjectClosed), ModalityState.any());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/impl/EditorFactoryImpl$1", "projectClosed"));
            }
        });
        busConnection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(@Nullable EditorColorsScheme scheme2) {
                EditorFactoryImpl.this.refreshAllEditors();
            }
        });
        busConnection.subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

            public void advancedSettingChanged(@NotNull String id2, @NotNull Object oldValue, @NotNull Object newValue2) {
                if (id2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (oldValue == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (newValue2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (id2.equals("editor.distraction.free.margin") || id2.equals("editor.tab.painting") || id2.equals("editor.show.special.chars")) {
                    EditorFactoryImpl.this.refreshAllEditors();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "id";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldValue";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newValue";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/EditorFactoryImpl$3";
                objectArray[2] = "advancedSettingChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LaterInvocator.addModalityStateListener(new ModalityStateListener(){

            public void beforeModalityStateChanged(boolean entering, @NotNull Object modalEntity) {
                if (modalEntity == null) {
                    4.$$$reportNull$$$0(0);
                }
                EditorFactoryImpl.collectAllEditors().forEach(editor2 -> ((EditorImpl)editor2).beforeModalityStateChanged());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntity", "com/intellij/openapi/editor/impl/EditorFactoryImpl$4", "beforeModalityStateChanged"));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    public void validateEditorsAreReleased(@NotNull Project project, boolean isLastProjectClosed) {
        if (project == null) {
            EditorFactoryImpl.$$$reportNull$$$0(0);
        }
        EditorFactoryImpl.collectAllEditors().forEach(editor2 -> {
            if (editor2.getProject() == project || editor2.getProject() == null && isLastProjectClosed) {
                try {
                    EditorFactoryImpl.throwNotReleasedError(editor2);
                }
                finally {
                    this.releaseEditor((Editor)editor2);
                }
            }
        });
    }

    @NonNls
    public static void throwNotReleasedError(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(1);
        }
        if (editor2 instanceof EditorImpl) {
            ((EditorImpl)editor2).throwDisposalError("Editor " + editor2 + " hasn't been released:");
        }
        throw new RuntimeException("Editor of " + editor2.getClass() + " and the following text hasn't been released:\n" + editor2.getDocument().getText());
    }

    @NotNull
    public Document createDocument(char @NotNull [] text2) {
        if (text2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(2);
        }
        Document document = this.createDocument((CharSequence)new CharArrayCharSequence(text2));
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(3);
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text2) {
        if (text2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(4);
        }
        DocumentImpl document = new DocumentImpl(text2);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(5);
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl("", allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(6);
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text2, boolean acceptsSlashR, boolean allowUpdatesWithoutWriteAction) {
        if (text2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(7);
        }
        DocumentImpl document = new DocumentImpl(text2, acceptsSlashR, allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(8);
        }
        return documentImpl;
    }

    public void refreshAllEditors() {
        EditorFactoryImpl.collectAllEditors().forEach(editor2 -> ((EditorEx)editor2).reinitSettings());
    }

    public Editor createEditor(@NotNull Document document) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(9);
        }
        return this.createEditor(document, false, null, EditorKind.UNTYPED);
    }

    public Editor createViewer(@NotNull Document document) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(10);
        }
        return this.createEditor(document, true, null, EditorKind.UNTYPED);
    }

    public Editor createEditor(@NotNull Document document, Project project) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(11);
        }
        return this.createEditor(document, false, project, EditorKind.UNTYPED);
    }

    public Editor createEditor(@NotNull Document document, @Nullable Project project, @NotNull EditorKind kind) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(12);
        }
        if (kind == null) {
            EditorFactoryImpl.$$$reportNull$$$0(13);
        }
        return this.createEditor(document, false, project, kind);
    }

    public Editor createViewer(@NotNull Document document, Project project) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(14);
        }
        return this.createEditor(document, true, project, EditorKind.UNTYPED);
    }

    public Editor createViewer(@NotNull Document document, @Nullable Project project, @NotNull EditorKind kind) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            EditorFactoryImpl.$$$reportNull$$$0(16);
        }
        return this.createEditor(document, true, project, kind);
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull FileType fileType, boolean isViewer) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(17);
        }
        if (fileType == null) {
            EditorFactoryImpl.$$$reportNull$$$0(18);
        }
        EditorEx editor2 = this.createEditor(document, isViewer, project, EditorKind.UNTYPED);
        editor2.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType));
        return editor2;
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file2, boolean isViewer) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(20);
        }
        EditorEx editor2 = this.createEditor(document, isViewer, project, EditorKind.UNTYPED);
        editor2.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2));
        return editor2;
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file2, boolean isViewer, @NotNull EditorKind kind) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(21);
        }
        if (file2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(22);
        }
        if (kind == null) {
            EditorFactoryImpl.$$$reportNull$$$0(23);
        }
        EditorEx editor2 = this.createEditor(document, isViewer, project, kind);
        editor2.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file2));
        return editor2;
    }

    @NotNull
    private EditorEx createEditor(@NotNull Document document, boolean isViewer, Project project, @NotNull EditorKind kind) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(24);
        }
        if (kind == null) {
            EditorFactoryImpl.$$$reportNull$$$0(25);
        }
        Document hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        EditorImpl editor2 = new EditorImpl(hostDocument, isViewer, project, kind);
        ClientEditorManager editorManager = ClientEditorManager.getCurrentInstance();
        editorManager.editorCreated((Editor)editor2);
        this.myEditorEventMulticaster.registerEditor(editor2);
        EditorFactoryEvent event = new EditorFactoryEvent((EditorFactory)this, (Editor)editor2);
        ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorCreated(event);
        EP.forEachExtensionSafe(it -> it.editorCreated(event));
        if (LOG.isDebugEnabled()) {
            LOG.debug("number of Editors after create: " + editorManager.editors().count());
        }
        EditorImpl editorImpl = editor2;
        if (editorImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(26);
        }
        return editorImpl;
    }

    public void releaseEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(27);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        WriteAction.run(() -> {
            try {
                EditorFactoryEvent event = new EditorFactoryEvent((EditorFactory)this, editor2);
                ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorReleased(event);
                EP.forEachExtensionSafe(it -> it.editorReleased(event));
            }
            finally {
                try {
                    ((EditorImpl)editor2).release();
                }
                finally {
                    for (ClientEditorManager clientEditors : ClientEditorManager.getAllInstances()) {
                        if (!clientEditors.editorReleased(editor2)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("number of Editors after release: " + clientEditors.editors().count());
                        }
                        if (clientEditors == ClientEditorManager.getCurrentInstance()) break;
                        LOG.warn("Released editor didn't belong to current session");
                        break;
                    }
                }
            }
        });
    }

    @NotNull
    public Stream<Editor> editors(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            EditorFactoryImpl.$$$reportNull$$$0(28);
        }
        Stream<Editor> stream = EditorFactoryImpl.collectAllEditors().filter(editor2 -> editor2.getDocument().equals(document) && (project == null || project.equals(editor2.getProject())));
        if (stream == null) {
            EditorFactoryImpl.$$$reportNull$$$0(29);
        }
        return stream;
    }

    @NotNull
    private static Stream<Editor> collectAllEditors() {
        Stream<Editor> stream = ClientEditorManager.getAllInstances().stream().flatMap(it -> it.editors());
        if (stream == null) {
            EditorFactoryImpl.$$$reportNull$$$0(30);
        }
        return stream;
    }

    public Editor @NotNull [] getAllEditors() {
        Editor[] editorArray = (Editor[])EditorFactoryImpl.collectAllEditors().toArray(Editor[]::new);
        if (editorArray == null) {
            EditorFactoryImpl.$$$reportNull$$$0(31);
        }
        return editorArray;
    }

    @Deprecated
    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        if (listener2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(32);
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2);
    }

    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(33);
        }
        if (parentDisposable == null) {
            EditorFactoryImpl.$$$reportNull$$$0(34);
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Deprecated
    public void removeEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        if (listener2 == null) {
            EditorFactoryImpl.$$$reportNull$$$0(35);
        }
        this.myEditorFactoryEventDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public EditorEventMulticaster getEventMulticaster() {
        EditorEventMulticasterImpl editorEventMulticasterImpl = this.myEditorEventMulticaster;
        if (editorEventMulticasterImpl == null) {
            EditorFactoryImpl.$$$reportNull$$$0(36);
        }
        return editorEventMulticasterImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorFactoryImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: 
            case 16: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorFactoryImpl";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "editors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllEditors";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventMulticaster";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validateEditorsAreReleased";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "throwNotReleasedError";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 36: {
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createViewer";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "releaseEditor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "editors";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addEditorFactoryListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorFactoryListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MyRawTypedHandler
    implements TypedActionHandlerEx {
        private final TypedActionHandler myDelegate;

        public MyRawTypedHandler(TypedActionHandler delegate2) {
            this.myDelegate = delegate2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(@NotNull Editor editor2, char charTyped, @NotNull DataContext dataContext) {
            if (editor2 == null) {
                MyRawTypedHandler.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyRawTypedHandler.$$$reportNull$$$0(1);
            }
            editor2.putUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION, (Object)Boolean.TRUE);
            try {
                this.myDelegate.execute(editor2, charTyped, dataContext);
            }
            finally {
                editor2.putUserData(EditorImpl.DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION, null);
            }
        }

        public void beforeExecute(@NotNull Editor editor2, char c, @NotNull DataContext context2, @NotNull ActionPlan plan) {
            if (editor2 == null) {
                MyRawTypedHandler.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                MyRawTypedHandler.$$$reportNull$$$0(3);
            }
            if (plan == null) {
                MyRawTypedHandler.$$$reportNull$$$0(4);
            }
            if (this.myDelegate instanceof TypedActionHandlerEx) {
                ((TypedActionHandlerEx)this.myDelegate).beforeExecute(editor2, c, context2, plan);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "plan";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorFactoryImpl$MyRawTypedHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeExecute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

