/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.diagnostic.Dumpable;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PopupMenuPreloader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.impl.AccessibleGutterLine;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorActionPlan;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorFilteringMarkupModelEx;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.editor.impl.EditorLocation;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.EditorSizeAdjustmentStrategy;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.FoldingPopupManager;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.GutterIconDropAnimator;
import com.intellij.openapi.editor.impl.HighlighterListener;
import com.intellij.openapi.editor.impl.ImmediatePainter;
import com.intellij.openapi.editor.impl.IndentsModelCaretListener;
import com.intellij.openapi.editor.impl.IndentsModelImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.toolbar.floating.EditorFloatingToolbar;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.mac.MacGestureSupportInstaller;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextHitInfo;
import java.awt.geom.Point2D;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TooManyListenersException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EditorImpl
extends UserDataHolderBase
implements EditorEx,
HighlighterClient,
Queryable,
Dumpable,
CodeStyleSettingsListener,
FocusListener {
    public static final int TEXT_ALIGNMENT_LEFT = 0;
    public static final int TEXT_ALIGNMENT_RIGHT = 1;
    private static final int MIN_FONT_SIZE = 8;
    private static final Logger LOG = Logger.getInstance(EditorImpl.class);
    static final Logger EVENT_LOG = Logger.getInstance((String)"editor.input.events");
    private static final Object DND_COMMAND_GROUP = ObjectUtils.sentinel((String)"DndCommand");
    private static final Object MOUSE_DRAGGED_COMMAND_GROUP = ObjectUtils.sentinel((String)"MouseDraggedGroup");
    private static final Key<JComponent> PERMANENT_HEADER = Key.create((String)"PERMANENT_HEADER");
    static final Key<Boolean> CONTAINS_BIDI_TEXT = Key.create((String)"contains.bidi.text");
    public static final Key<Boolean> FORCED_SOFT_WRAPS = Key.create((String)"forced.soft.wraps");
    public static final Key<Boolean> SOFT_WRAPS_EXIST = Key.create((String)"soft.wraps.exist");
    public static final Key<Boolean> DISABLE_CARET_POSITION_KEEPING = Key.create((String)"editor.disable.caret.position.keeping");
    public static final Key<Boolean> DISABLE_CARET_SHIFT_ON_WHITESPACE_INSERTION = Key.create((String)"editor.disable.caret.shift.on.whitespace.insertion");
    private static final boolean HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK = Boolean.parseBoolean(System.getProperty("idea.honor.camel.humps.on.triple.click"));
    private static final Key<BufferedImage> BUFFER = Key.create((String)"buffer");
    private static final Key<Boolean> INITIALIZED = Key.create((String)"editor.is.fully.initialized");
    @NotNull
    private final DocumentEx myDocument;
    private final JPanel myPanel;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final EditorComponentImpl myEditorComponent;
    @NotNull
    private final EditorGutterComponentImpl myGutterComponent;
    private final TraceableDisposable myTraceableDisposable;
    private final FocusModeModel myFocusModeModel;
    private volatile long myLastTypedActionTimestamp;
    private String myLastTypedAction;
    private LatencyListener myLatencyPublisher;
    private static final Cursor EMPTY_CURSOR;
    private final Map<Object, Cursor> myCustomCursors;
    private Cursor myDefaultCursor;
    boolean myCursorSetExternally;
    private final CommandProcessor myCommandProcessor;
    @NotNull
    private final MyScrollBar myVerticalScrollBar;
    private final List<EditorMouseListener> myMouseListeners;
    @NotNull
    private final List<EditorMouseMotionListener> myMouseMotionListeners;
    private boolean myIsInsertMode;
    @NotNull
    private final CaretCursor myCaretCursor;
    private final ScrollingTimer myScrollingTimer;
    @NotNull
    private final SettingsImpl mySettings;
    private boolean isReleased;
    @Nullable
    private MouseEvent myMousePressedEvent;
    @Nullable
    private MouseEvent myMouseMovedEvent;
    private final MouseListener myMouseListener;
    private final MouseMotionListener myMouseMotionListener;
    @Nullable
    private EditorMouseEventArea myMousePressArea;
    private int mySavedSelectionStart;
    private int mySavedSelectionEnd;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private MyEditable myEditable;
    @NotNull
    private EditorColorsScheme myScheme;
    private boolean myIsViewer;
    @NotNull
    private final SelectionModelImpl mySelectionModel;
    @NotNull
    private final EditorMarkupModelImpl myMarkupModel;
    @NotNull
    private final EditorFilteringMarkupModelEx myDocumentMarkupModel;
    @NotNull
    private final MarkupModelListener myMarkupModelListener;
    @NotNull
    private final List<HighlighterListener> myHighlighterListeners;
    @NotNull
    private final FoldingModelImpl myFoldingModel;
    @NotNull
    private final ScrollingModelImpl myScrollingModel;
    @NotNull
    private final CaretModelImpl myCaretModel;
    @NotNull
    private final SoftWrapModelImpl mySoftWrapModel;
    @NotNull
    private final InlayModelImpl myInlayModel;
    @NotNull
    private static final RepaintCursorCommand ourCaretBlinkingCommand;
    @MouseSelectionState
    private int myMouseSelectionState;
    @Nullable
    private FoldRegion myMouseSelectedRegion;
    private int myHorizontalTextAlignment;
    private static final int MOUSE_SELECTION_STATE_NONE = 0;
    private static final int MOUSE_SELECTION_STATE_WORD_SELECTED = 1;
    private static final int MOUSE_SELECTION_STATE_LINE_SELECTED = 2;
    private volatile EditorHighlighter myHighlighter;
    private Disposable myHighlighterDisposable;
    private final TextDrawingCallback myTextDrawingCallback;
    private int myScrollBarOrientation;
    private boolean myKeepSelectionOnMousePress;
    private boolean myUpdateCursor;
    private final EditorScrollingPositionKeeper myScrollingPositionKeeper;
    private boolean myRestoreScrollingPosition;
    private int myRangeToRepaintStart;
    private int myRangeToRepaintEnd;
    @Nullable
    private final Project myProject;
    private long myMouseSelectionChangeTimestamp;
    private int mySavedCaretOffsetForDNDUndoHack;
    private final List<FocusChangeListener> myFocusListeners;
    private MyInputMethodHandler myInputMethodRequestsHandler;
    private InputMethodRequests myInputMethodRequestsSwingWrapper;
    private boolean myIsOneLineMode;
    private boolean myIsRendererMode;
    private VirtualFile myVirtualFile;
    private boolean myIsColumnMode;
    @Nullable
    private Color myForcedBackground;
    @Nullable
    private Dimension myPreferredSize;
    private final Alarm myMouseSelectionStateAlarm;
    private Runnable myMouseSelectionStateResetRunnable;
    private boolean myEmbeddedIntoDialogWrapper;
    private int myDragOnGutterSelectionStartLine;
    private RangeMarker myDraggedRange;
    private boolean myDragStarted;
    @NotNull
    private final JPanel myHeaderPanel;
    @Nullable
    private MouseEvent myInitialMouseEvent;
    private boolean myIgnoreMouseEventsConsecutiveToInitial;
    private EditorDropHandler myDropHandler;
    private Predicate<? super RangeHighlighter> myHighlightingFilter;
    @NotNull
    private final IndentsModel myIndentsModel;
    @Nullable
    private CharSequence myPlaceholderText;
    @Nullable
    private TextAttributes myPlaceholderAttributes;
    private boolean myShowPlaceholderWhenFocused;
    private boolean myStickySelection;
    private int myStickySelectionStart;
    private boolean myScrollToCaret;
    private boolean myPurePaintingMode;
    private boolean myPaintSelection;
    private final EditorSizeAdjustmentStrategy mySizeAdjustmentStrategy;
    private final Disposable myDisposable;
    private List<CaretState> myCaretStateBeforeLastPress;
    LogicalPosition myLastMousePressedLocation;
    private VisualPosition myTargetMultiSelectionPosition;
    private boolean myMultiSelectionInProgress;
    private boolean myRectangularSelectionInProgress;
    private boolean myLastPressCreatedCaret;
    private boolean myLastPressWasAtBlockInlay;
    private boolean myCurrentDragIsSubstantial;
    private CaretImpl myPrimaryCaret;
    public final boolean myDisableRtl;
    @Deprecated
    public Object myFractionalMetricsHintValue;
    final EditorView myView;
    private boolean myCharKeyPressed;
    private boolean myNeedToSelectPreviousChar;
    boolean myDocumentChangeInProgress;
    private boolean myErrorStripeNeedsRepaint;
    private String myContextMenuGroupId;
    private final List<EditorPopupHandler> myPopupHandlers;
    private boolean myUseEditorAntialiasing;
    private final ImmediatePainter myImmediatePainter;
    private final List<IntFunction<? extends @NotNull Collection<? extends LineExtensionInfo>>> myLineExtensionPainters;
    private volatile int myExpectedCaretOffset;
    private boolean myBackgroundImageSet;
    private final EditorKind myKind;
    private boolean myScrollingToCaret;
    private boolean updatingSize;
    private static final Field decrButtonField;
    private static final Field incrButtonField;

    EditorImpl(@NotNull Document document, boolean viewer, @Nullable Project project, @NotNull EditorKind kind) {
        if (document == null) {
            EditorImpl.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            EditorImpl.$$$reportNull$$$0(1);
        }
        this.myTraceableDisposable = new TraceableDisposable(true);
        this.myLastTypedActionTimestamp = -1L;
        this.myCustomCursors = new LinkedHashMap<Object, Cursor>();
        this.myMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseMotionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIsInsertMode = true;
        this.myScrollingTimer = new ScrollingTimer();
        this.myMouseListener = new MyMouseAdapter();
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.mySavedSelectionStart = -1;
        this.mySavedSelectionEnd = -1;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myHighlighterListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myHorizontalTextAlignment = 0;
        this.myHighlighterDisposable = Disposer.newDisposable();
        this.myTextDrawingCallback = new MyTextDrawingCallback();
        this.myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseSelectionStateAlarm = new Alarm();
        this.myDragOnGutterSelectionStartLine = -1;
        this.myScrollToCaret = true;
        this.mySizeAdjustmentStrategy = new EditorSizeAdjustmentStrategy();
        this.myDisposable = Disposer.newDisposable();
        this.myDisableRtl = Registry.is((String)"editor.disable.rtl");
        this.myFractionalMetricsHintValue = UISettings.getEditorFractionalMetricsHint();
        this.myContextMenuGroupId = "BasicEditorPopupMenu";
        this.myPopupHandlers = new ArrayList<EditorPopupHandler>();
        this.myUseEditorAntialiasing = true;
        this.myLineExtensionPainters = new SmartList();
        this.myExpectedCaretOffset = -1;
        EditorImpl.assertIsDispatchThread();
        this.myProject = project;
        this.myDocument = (DocumentEx)document;
        this.myScheme = this.createBoundColorSchemeDelegate(null);
        this.myScrollPane = new MyScrollPane();
        this.myIsViewer = viewer;
        this.myKind = kind;
        this.mySettings = new SettingsImpl(this, kind);
        MarkupModelEx documentMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true);
        this.mySelectionModel = new SelectionModelImpl(this);
        this.myMarkupModel = new EditorMarkupModelImpl(this);
        this.myDocumentMarkupModel = new EditorFilteringMarkupModelEx(this, documentMarkup);
        this.myFoldingModel = new FoldingModelImpl(this);
        this.myCaretModel = new CaretModelImpl(this);
        this.myScrollingModel = new ScrollingModelImpl(this);
        this.myInlayModel = new InlayModelImpl(this);
        Disposer.register((Disposable)this.myCaretModel, (Disposable)this.myInlayModel);
        this.mySoftWrapModel = new SoftWrapModelImpl(this);
        this.myCommandProcessor = CommandProcessor.getInstance();
        this.myImmediatePainter = new ImmediatePainter(this);
        this.myMarkupModelListener = new MarkupModelListener(){

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                TextAttributes attributes2 = highlighter.getTextAttributes(EditorImpl.this.getColorsScheme());
                EditorImpl.this.onHighlighterChanged(highlighter, EditorImpl.this.canImpactGutterSize(highlighter), EditorUtil.attributesImpactFontStyle(attributes2), EditorUtil.attributesImpactForegroundColor(attributes2));
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextAttributes attributes2 = highlighter.getTextAttributes(EditorImpl.this.getColorsScheme());
                EditorImpl.this.onHighlighterChanged(highlighter, EditorImpl.this.canImpactGutterSize(highlighter), EditorUtil.attributesImpactFontStyle(attributes2), EditorUtil.attributesImpactForegroundColor(attributes2));
            }

            @Override
            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(2);
                }
                EditorImpl.this.onHighlighterChanged(highlighter, renderersChanged, fontStyleChanged, foregroundColorChanged);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "attributesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myMarkupModel.addErrorMarkerListener(new ErrorStripeListener(){

            @Override
            public void errorMarkerChanged(@NotNull ErrorStripeEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                EditorImpl.this.errorStripeMarkerChanged((RangeHighlighterEx)e.getHighlighter());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$2", "errorMarkerChanged"));
            }
        }, this.myCaretModel);
        this.myDocumentMarkupModel.addMarkupModelListener(this.myCaretModel, this.myMarkupModelListener);
        this.myMarkupModel.addMarkupModelListener(this.myCaretModel, this.myMarkupModelListener);
        this.myDocument.addDocumentListener((DocumentListener)this.myFoldingModel, this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)this.myCaretModel, this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)new EditorDocumentAdapter(), this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)this.mySoftWrapModel, this.myCaretModel);
        this.myDocument.addDocumentListener((DocumentListener)this.myMarkupModel, this.myCaretModel);
        this.myFoldingModel.addListener(this.mySoftWrapModel, this.myCaretModel);
        this.myInlayModel.addListener((InlayModel.Listener)this.myFoldingModel, this.myCaretModel);
        this.myInlayModel.addListener(this.myCaretModel, this.myCaretModel);
        this.myIndentsModel = new IndentsModelImpl(this);
        this.myCaretModel.addCaretListener(new IndentsModelCaretListener(this));
        this.myCaretModel.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (EditorImpl.this.myStickySelection) {
                    int selectionStart = Math.min(EditorImpl.this.myStickySelectionStart, EditorImpl.this.getDocument().getTextLength());
                    EditorImpl.this.mySelectionModel.setSelection(selectionStart, EditorImpl.this.myCaretModel.getVisualPosition(), EditorImpl.this.myCaretModel.getOffset());
                }
            }

            public void caretAdded(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (EditorImpl.this.myPrimaryCaret != null) {
                    EditorImpl.this.myPrimaryCaret.updateVisualPosition();
                }
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                EditorImpl.this.repaintCaretRegion(e);
                EditorImpl.this.myPrimaryCaret = EditorImpl.this.myCaretModel.getPrimaryCaret();
                EditorImpl.this.myPrimaryCaret.updateVisualPosition();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myCaretModel.addCaretListener(this.myMarkupModel, this.myCaretModel);
        this.myCaretCursor = new CaretCursor();
        this.myScrollBarOrientation = 1;
        this.mySoftWrapModel.addSoftWrapChangeListener(new SoftWrapChangeListener(){

            @Override
            public void recalculationEnds() {
                if (EditorImpl.this.myCaretModel.isUpToDate()) {
                    EditorImpl.this.myCaretModel.updateVisualPosition();
                }
            }

            @Override
            public void softWrapsChanged() {
                EditorImpl.this.myGutterComponent.clearLineToGutterRenderersCache();
            }
        });
        NullEditorHighlighter highlighter = new NullEditorHighlighter();
        this.setHighlighter((EditorHighlighter)highlighter);
        new FoldingPopupManager(this);
        this.myEditorComponent = new EditorComponentImpl(this);
        this.myVerticalScrollBar = (MyScrollBar)((Object)this.myScrollPane.getVerticalScrollBar());
        if (this.shouldScrollBarBeOpaque()) {
            this.myVerticalScrollBar.setOpaque(true);
        }
        this.myPanel = new JPanel();
        ComponentUtil.putClientProperty((JComponent)this.myPanel, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> {
            JComponent component2 = this.getPermanentHeaderComponent();
            if (component2 != null && component2.getParent() == null) {
                return Collections.singleton(component2).iterator();
            }
            return Collections.emptyIterator();
        });
        this.myHeaderPanel = new MyHeaderPanel();
        this.myGutterComponent = new EditorGutterComponentImpl(this);
        ComponentUtil.putClientProperty((JComponent)this.myGutterComponent, (Key)ColorKey.FUNCTION_KEY, key -> this.getColorsScheme().getColor(key));
        this.initComponent();
        this.myView = new EditorView(this);
        this.myView.reinitSettings();
        this.myInlayModel.addListener((InlayModel.Listener)new InlayModel.SimpleAdapter(){

            public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
                if (inlay == null) {
                    5.$$$reportNull$$$0(0);
                }
                EditorImpl.this.onInlayUpdated(inlay, changeFlags);
            }

            public void onBatchModeFinish(@NotNull Editor editor2) {
                if (editor2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                EditorImpl.this.onInlayBatchModeFinish();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inlay";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onUpdated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBatchModeFinish";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myCaretModel);
        if (UISettings.getInstance().getPresentationMode()) {
            this.setFontSize(UISettings.getInstance().getPresentationModeFontSize());
        }
        this.myGutterComponent.updateSize();
        Dimension preferredSize = this.getPreferredSize();
        this.myEditorComponent.setSize(preferredSize);
        this.updateCaretCursor();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && SystemInfo.isMac && SystemInfo.isJetBrainsJvm) {
            MacGestureSupportInstaller.installOnComponent(this.getComponent());
        }
        this.myScrollingModel.addVisibleAreaListener(this::moveCaretIntoViewIfCoveredByToolWindowBelow);
        this.myScrollingModel.addVisibleAreaListener(this.myMarkupModel);
        PropertyChangeListener propertyChangeListener2 = e -> {
            if ("writable".equals(e.getPropertyName())) {
                this.myEditorComponent.repaint();
            }
        };
        this.myDocument.addPropertyChangeListener(propertyChangeListener2);
        Disposer.register((Disposable)this.myDisposable, () -> this.myDocument.removePropertyChangeListener(propertyChangeListener2));
        CodeStyleSettingsManager.getInstance((Project)this.myProject).addListener((CodeStyleSettingsListener)this);
        this.myFocusModeModel = new FocusModeModel(this);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myFocusModeModel);
        this.myPopupHandlers.add(new DefaultPopupHandler());
        PopupMenuPreloader.install(this.myEditorComponent, "EditorPopup", null, () -> ContextMenuPopupHandler.getGroupForId(this.myContextMenuGroupId));
        this.myScrollingPositionKeeper = new EditorScrollingPositionKeeper(this);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScrollingPositionKeeper);
        this.putUserData(INITIALIZED, Boolean.TRUE);
    }

    public void applyFocusMode() {
        this.myFocusModeModel.applyFocusMode(this.myCaretModel.getPrimaryCaret());
    }

    public boolean isInFocusMode(@NotNull FoldRegion region) {
        if (region == null) {
            EditorImpl.$$$reportNull$$$0(2);
        }
        return this.myFocusModeModel.isInFocusMode((RangeMarker)region);
    }

    public Segment getFocusModeRange() {
        return this.myFocusModeModel.getFocusModeRange();
    }

    @NotNull
    public FocusModeModel getFocusModeModel() {
        FocusModeModel focusModeModel = this.myFocusModeModel;
        if (focusModeModel == null) {
            EditorImpl.$$$reportNull$$$0(3);
        }
        return focusModeModel;
    }

    @Override
    public void focusGained(@NotNull FocusEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(4);
        }
        this.myCaretCursor.activate();
        for (Caret caret : this.myCaretModel.getAllCarets()) {
            int caretLine = caret.getLogicalPosition().line;
            this.repaintLines(caretLine, caretLine);
        }
        this.fireFocusGained(e);
    }

    @Override
    public void focusLost(@NotNull FocusEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(5);
        }
        this.clearCaretThread();
        for (Caret caret : this.myCaretModel.getAllCarets()) {
            int caretLine = caret.getLogicalPosition().line;
            this.repaintLines(caretLine, caretLine);
        }
        this.fireFocusLost(e);
    }

    private boolean canImpactGutterSize(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(6);
        }
        if (highlighter.getGutterIconRenderer() != null) {
            return true;
        }
        LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
        if (lineMarkerRenderer == null) {
            return false;
        }
        LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(lineMarkerRenderer);
        return position == LineMarkerRendererEx.Position.LEFT && !this.myGutterComponent.myForceLeftFreePaintersAreaShown || position == LineMarkerRendererEx.Position.RIGHT && !this.myGutterComponent.myForceRightFreePaintersAreaShown;
    }

    private void errorStripeMarkerChanged(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(7);
        }
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        if (this.myDocumentChangeInProgress) {
            this.myErrorStripeNeedsRepaint = true;
            return;
        }
        if (this.myFoldingModel.isInBatchFoldingOperation()) {
            this.myErrorStripeNeedsRepaint = true;
        } else {
            int start2 = highlighter.getAffectedAreaStartOffset();
            int end = highlighter.getAffectedAreaEndOffset();
            this.myMarkupModel.repaint(start2, end);
        }
    }

    private void onHighlighterChanged(@NotNull RangeHighlighterEx highlighter, boolean canImpactGutterSize, boolean fontStyleChanged, boolean foregroundColorChanged) {
        int endLine;
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(8);
        }
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        if (canImpactGutterSize) {
            this.updateGutterSize();
        }
        if (this.myDocumentChangeInProgress) {
            return;
        }
        int textLength = this.myDocument.getTextLength();
        int start2 = MathUtil.clamp((int)highlighter.getAffectedAreaStartOffset(), (int)0, (int)textLength);
        int end = MathUtil.clamp((int)highlighter.getAffectedAreaEndOffset(), (int)0, (int)textLength);
        if (this.getGutterComponentEx().getCurrentAccessibleLine() != null && AccessibleGutterLine.isAccessibleGutterElement(highlighter.getGutterIconRenderer())) {
            this.escapeGutterAccessibleLine(start2, end);
        }
        int startLine = start2 == -1 ? 0 : this.myDocument.getLineNumber(start2);
        int n = endLine = end == -1 ? this.myDocument.getLineCount() : this.myDocument.getLineNumber(end);
        if (start2 != end && (fontStyleChanged || foregroundColorChanged)) {
            this.myView.invalidateRange(start2, end, fontStyleChanged);
        }
        if (!this.myFoldingModel.isInBatchFoldingOperation()) {
            this.repaintLines(Math.max(0, startLine - 1), Math.min(endLine + 1, this.getDocument().getLineCount()));
        }
        this.updateCaretCursor();
    }

    private void onInlayUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
        if (inlay == null) {
            EditorImpl.$$$reportNull$$$0(9);
        }
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        if ((changeFlags & 4) != 0) {
            this.updateGutterSize();
        }
        if (this.myDocument.isInEventsHandling() || (changeFlags & 3) == 0) {
            return;
        }
        this.validateSize();
        int offset = inlay.getOffset();
        Inlay.Placement placement = inlay.getPlacement();
        if (placement == Inlay.Placement.INLINE) {
            this.repaint(offset, offset, false);
        } else if (placement == Inlay.Placement.AFTER_LINE_END) {
            int lineEndOffset = DocumentUtil.getLineEndOffset(offset, this.myDocument);
            this.repaint(lineEndOffset, lineEndOffset, false);
        } else {
            int visualLine = this.offsetToVisualLine(offset);
            int y = EditorUtil.getVisualLineAreaStartY(this, visualLine);
            this.repaintToScreenBottomStartingFrom(y);
        }
    }

    private void onInlayBatchModeFinish() {
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.validateSize();
        this.updateGutterSize();
        this.myEditorComponent.repaint();
        this.myGutterComponent.repaint();
        this.myMarkupModel.repaint();
        this.updateCaretCursor();
    }

    private void moveCaretIntoViewIfCoveredByToolWindowBelow(@NotNull VisibleAreaEvent e) {
        int caretY;
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(10);
        }
        Rectangle oldRectangle = e.getOldRectangle();
        Rectangle newRectangle = e.getNewRectangle();
        if (!this.myScrollingToCaret && oldRectangle != null && oldRectangle.height != newRectangle.height && oldRectangle.y == newRectangle.y && newRectangle.height > 0 && (double)(caretY = this.myView.visualLineToY(this.myCaretModel.getVisualPosition().line)) < oldRectangle.getMaxY() && (double)caretY > newRectangle.getMaxY()) {
            this.myScrollingToCaret = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myScrollingToCaret = false;
                if (!this.isReleased) {
                    EditorUtil.runWithAnimationDisabled(this, () -> this.myScrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE));
                }
            }, ModalityState.any());
        }
    }

    boolean shouldScrollBarBeOpaque() {
        return !this.myBackgroundImageSet && !Registry.is((String)"editor.transparent.scrollbar");
    }

    @NotNull
    static Color adjustThumbColor(@NotNull Color base, boolean dark) {
        if (base == null) {
            EditorImpl.$$$reportNull$$$0(11);
        }
        Color color = dark ? ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)1.35), (double)0.5) : ColorUtil.withAlpha((Color)ColorUtil.shift((Color)base, (double)0.68), (double)0.4);
        if (color == null) {
            EditorImpl.$$$reportNull$$$0(12);
        }
        return color;
    }

    boolean isDarkEnough() {
        return ColorUtil.isDark((Color)this.getBackgroundColor());
    }

    private void repaintCaretRegion(@NotNull CaretEvent e) {
        CaretImpl caretImpl;
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(13);
        }
        if ((caretImpl = (CaretImpl)e.getCaret()) != null) {
            caretImpl.updateVisualPosition();
            if (caretImpl.hasSelection()) {
                this.repaint(caretImpl.getSelectionStart(), caretImpl.getSelectionEnd(), false);
            }
        }
    }

    @Override
    @NotNull
    public EditorColorsScheme createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        return new MyColorSchemeDelegate(customGlobalScheme);
    }

    @Override
    public int getPrefixTextWidthInPixels() {
        return (int)this.myView.getPrefixTextWidthInPixels();
    }

    @Override
    public void setPrefixTextAndAttributes(@Nullable String prefixText, @Nullable TextAttributes attributes2) {
        this.mySoftWrapModel.recalculate();
        this.myView.setPrefix(prefixText, attributes2);
    }

    @Override
    public boolean isPurePaintingMode() {
        return this.myPurePaintingMode;
    }

    @Override
    public void setPurePaintingMode(boolean enabled) {
        this.myPurePaintingMode = enabled;
    }

    @Override
    public void registerLineExtensionPainter(@NotNull @NotNull IntFunction<? extends @NotNull Collection<? extends LineExtensionInfo>> lineExtensionPainter) {
        if (lineExtensionPainter == null) {
            EditorImpl.$$$reportNull$$$0(14);
        }
        this.myLineExtensionPainters.add(lineExtensionPainter);
    }

    public boolean processLineExtensions(int line, @NotNull Processor<? super LineExtensionInfo> processor2) {
        if (processor2 == null) {
            EditorImpl.$$$reportNull$$$0(15);
        }
        for (IntFunction<? extends Collection<? extends LineExtensionInfo>> painter : this.myLineExtensionPainters) {
            for (LineExtensionInfo lineExtensionInfo : painter.apply(line)) {
                if (processor2.process((Object)lineExtensionInfo)) continue;
                return false;
            }
        }
        if (this.myProject != null && this.myVirtualFile != null) {
            for (EditorLinePainter editorLinePainter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
                Collection<LineExtensionInfo> extensions2;
                if (LightEdit.owns((Project)this.myProject) && !(editorLinePainter instanceof LightEditCompatible) || (extensions2 = editorLinePainter.getLineExtensions(this.myProject, this.myVirtualFile, line)) == null) continue;
                for (LineExtensionInfo extension3 : extensions2) {
                    if (processor2.process((Object)extension3)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void registerScrollBarRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback2) {
        this.myVerticalScrollBar.registerRepaintCallback(callback2);
    }

    @Override
    public int getExpectedCaretOffset() {
        int expectedCaretOffset = this.myExpectedCaretOffset;
        return expectedCaretOffset == -1 ? this.getCaretModel().getOffset() : expectedCaretOffset;
    }

    @Override
    public void setContextMenuGroupId(@Nullable String groupId2) {
        this.myContextMenuGroupId = groupId2;
    }

    @Override
    @Nullable
    public String getContextMenuGroupId() {
        return this.myContextMenuGroupId;
    }

    @Override
    public void installPopupHandler(@NotNull EditorPopupHandler popupHandler2) {
        if (popupHandler2 == null) {
            EditorImpl.$$$reportNull$$$0(16);
        }
        this.myPopupHandlers.add(popupHandler2);
    }

    @Override
    public void uninstallPopupHandler(@NotNull EditorPopupHandler popupHandler2) {
        if (popupHandler2 == null) {
            EditorImpl.$$$reportNull$$$0(17);
        }
        this.myPopupHandlers.remove(popupHandler2);
    }

    @Nullable
    private Cursor getCustomCursor() {
        return (Cursor)ContainerUtil.getFirstItem(this.myCustomCursors.values());
    }

    @Override
    public void setCustomCursor(@NotNull Object requestor, @Nullable Cursor cursor) {
        if (requestor == null) {
            EditorImpl.$$$reportNull$$$0(18);
        }
        if (cursor == null) {
            this.myCustomCursors.remove(requestor);
        } else {
            this.myCustomCursors.put(requestor, cursor);
        }
        this.updateEditorCursor();
    }

    @Override
    public void setViewer(boolean isViewer) {
        this.myIsViewer = isViewer;
    }

    public boolean isViewer() {
        return this.myIsViewer || this.myIsRendererMode;
    }

    @Override
    public boolean isRendererMode() {
        return this.myIsRendererMode;
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myIsRendererMode = isRendererMode;
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myVirtualFile = vFile;
        this.reinitSettings();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public SelectionModelImpl getSelectionModel() {
        SelectionModelImpl selectionModelImpl = this.mySelectionModel;
        if (selectionModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(19);
        }
        return selectionModelImpl;
    }

    @Override
    @NotNull
    public MarkupModelEx getMarkupModel() {
        EditorMarkupModelImpl editorMarkupModelImpl = this.myMarkupModel;
        if (editorMarkupModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(20);
        }
        return editorMarkupModelImpl;
    }

    @Override
    @NotNull
    public MarkupModelEx getFilteredDocumentMarkupModel() {
        EditorFilteringMarkupModelEx editorFilteringMarkupModelEx = this.myDocumentMarkupModel;
        if (editorFilteringMarkupModelEx == null) {
            EditorImpl.$$$reportNull$$$0(21);
        }
        return editorFilteringMarkupModelEx;
    }

    @Override
    @NotNull
    public FoldingModelImpl getFoldingModel() {
        FoldingModelImpl foldingModelImpl = this.myFoldingModel;
        if (foldingModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(22);
        }
        return foldingModelImpl;
    }

    @NotNull
    public CaretModelImpl getCaretModel() {
        CaretModelImpl caretModelImpl = this.myCaretModel;
        if (caretModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(23);
        }
        return caretModelImpl;
    }

    @Override
    @NotNull
    public ScrollingModelEx getScrollingModel() {
        ScrollingModelImpl scrollingModelImpl = this.myScrollingModel;
        if (scrollingModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(24);
        }
        return scrollingModelImpl;
    }

    @Override
    @NotNull
    public SoftWrapModelImpl getSoftWrapModel() {
        SoftWrapModelImpl softWrapModelImpl = this.mySoftWrapModel;
        if (softWrapModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(25);
        }
        return softWrapModelImpl;
    }

    @NotNull
    public InlayModelImpl getInlayModel() {
        InlayModelImpl inlayModelImpl = this.myInlayModel;
        if (inlayModelImpl == null) {
            EditorImpl.$$$reportNull$$$0(26);
        }
        return inlayModelImpl;
    }

    @NotNull
    public EditorKind getEditorKind() {
        EditorKind editorKind = this.myKind;
        if (editorKind == null) {
            EditorImpl.$$$reportNull$$$0(27);
        }
        return editorKind;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorImpl.assertReadAccess();
        SettingsImpl settingsImpl = this.mySettings;
        if (settingsImpl == null) {
            EditorImpl.$$$reportNull$$$0(28);
        }
        return settingsImpl;
    }

    public void resetSizes() {
        this.myView.reset();
    }

    @Override
    public void reinitSettings() {
        this.reinitSettings(true);
    }

    private void reinitSettings(boolean updateGutterSize) {
        EditorImpl.assertIsDispatchThread();
        EditorColorsScheme scheme2 = this.myScheme;
        while (scheme2 instanceof DelegateColorScheme) {
            if (scheme2 instanceof MyColorSchemeDelegate) {
                ((MyColorSchemeDelegate)scheme2).updateGlobalScheme();
                break;
            }
            scheme2 = ((DelegateColorScheme)scheme2).getDelegate();
        }
        boolean softWrapsUsedBefore = this.mySoftWrapModel.isSoftWrappingEnabled();
        this.mySettings.reinitSettings();
        this.mySoftWrapModel.reinitSettings();
        this.myCaretModel.reinitSettings();
        this.mySelectionModel.reinitSettings();
        ourCaretBlinkingCommand.setBlinkCaret(this.mySettings.isBlinkCaret());
        ourCaretBlinkingCommand.setBlinkPeriod(this.mySettings.getCaretBlinkPeriod());
        this.myView.reinitSettings();
        this.myFoldingModel.refreshSettings();
        this.myFoldingModel.rebuild();
        this.myInlayModel.reinitSettings();
        if (softWrapsUsedBefore ^ this.mySoftWrapModel.isSoftWrappingEnabled()) {
            this.validateSize();
        }
        this.myHighlighter.setColorScheme(this.myScheme);
        this.myMarkupModel.rebuild();
        this.myGutterComponent.reinitSettings(updateGutterSize);
        this.myGutterComponent.revalidate();
        this.myEditorComponent.repaint();
        this.updateCaretCursor();
        if (this.myInitialMouseEvent != null) {
            this.myIgnoreMouseEventsConsecutiveToInitial = true;
        }
        this.myCaretModel.updateVisualPosition();
        this.getCaretModel().doWithCaretMerging(() -> this.myCaretModel.getAllCarets().forEach(caret -> caret.moveToOffset(caret.getOffset())));
        if (this.myVirtualFile != null && this.myProject != null) {
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        }
        if (this.myFocusModeModel != null) {
            this.myFocusModeModel.clearFocusMode();
        }
        this.myFractionalMetricsHintValue = UISettings.getEditorFractionalMetricsHint();
    }

    @Contract(value="_->fail")
    public void throwDisposalError(@NonNls @NotNull String msg) {
        if (msg == null) {
            EditorImpl.$$$reportNull$$$0(29);
        }
        this.myTraceableDisposable.throwDisposalError(msg);
    }

    void release() {
        EditorImpl.assertIsDispatchThread();
        if (this.isReleased) {
            this.throwDisposalError("Double release of editor:");
        }
        this.myTraceableDisposable.kill(null);
        this.isReleased = true;
        this.mySizeAdjustmentStrategy.cancelAllRequests();
        this.cancelAutoResetForMouseSelectionState();
        this.myFoldingModel.dispose();
        this.mySoftWrapModel.release();
        this.myMarkupModel.dispose();
        this.myScrollingModel.dispose();
        this.myGutterComponent.dispose();
        this.myMousePressedEvent = null;
        this.myMouseMovedEvent = null;
        Disposer.dispose((Disposable)this.myCaretModel);
        Disposer.dispose((Disposable)this.mySoftWrapModel);
        Disposer.dispose((Disposable)this.myView);
        this.clearCaretThread();
        this.myFocusListeners.clear();
        this.myMouseListeners.clear();
        this.myMouseMotionListeners.clear();
        this.myEditorComponent.removeFocusListener(this);
        this.myEditorComponent.removeMouseListener(this.myMouseListener);
        this.myGutterComponent.removeMouseListener(this.myMouseListener);
        this.myEditorComponent.removeMouseMotionListener(this.myMouseMotionListener);
        this.myGutterComponent.removeMouseMotionListener(this.myMouseMotionListener);
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
        Disposer.dispose((Disposable)this.myDisposable);
        this.myVerticalScrollBar.setPersistentUI(JBScrollBar.createUI(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaretThread() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            if (EditorImpl.ourCaretBlinkingCommand.myEditor == this) {
                EditorImpl.ourCaretBlinkingCommand.myEditor = null;
            }
        }
    }

    private void initComponent() {
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)this.myHeaderPanel, "North");
        this.myGutterComponent.setOpaque(true);
        if (ExperimentalUI.isNewEditorTabs()) {
            this.myScrollPane.setViewport((JViewport)((Object)new GradientViewport(this.myEditorComponent, (Insets)JBUI.insets((int)10), true)));
        } else {
            this.myScrollPane.setViewportView(this.myEditorComponent);
        }
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setRowHeaderView(this.myGutterComponent);
        this.myScrollingModel.initListeners();
        this.myEditorComponent.setTransferHandler(new MyTransferHandler());
        this.myEditorComponent.setAutoscrolls(false);
        if (this.mayShowToolbar()) {
            JBLayeredPane layeredPane2 = new JBLayeredPane(){

                public void doLayout() {
                    Component[] components = this.getComponents();
                    Rectangle r = this.getBounds();
                    for (Component c : components) {
                        if (c instanceof JScrollPane) {
                            c.setBounds(0, 0, r.width, r.height);
                            continue;
                        }
                        Dimension d = c.getPreferredSize();
                        int rightInsets = EditorImpl.this.getVerticalScrollBar().getWidth() + (EditorImpl.this.isMirrored() ? EditorImpl.this.myGutterComponent.getWidth() : 0);
                        c.setBounds(r.width - d.width - rightInsets - 20, 20, d.width, d.height);
                    }
                }

                public Dimension getPreferredSize() {
                    return EditorImpl.this.myScrollPane.getPreferredSize();
                }
            };
            layeredPane2.add((Component)this.myScrollPane, JLayeredPane.DEFAULT_LAYER);
            UiNotifyConnector.doWhenFirstShown((Component)this.myPanel, () -> this.lambda$initComponent$9((JLayeredPane)layeredPane2), (Disposable)this.getDisposable());
            this.myPanel.add((Component)layeredPane2);
        } else {
            this.myPanel.add(this.myScrollPane);
        }
        this.myEditorComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (EVENT_LOG.isDebugEnabled()) {
                    EVENT_LOG.debug(e.toString());
                }
                if (e.getKeyCode() >= 65 && e.getKeyCode() <= 90) {
                    EditorImpl.this.myCharKeyPressed = true;
                }
            }

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                if (event == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (EVENT_LOG.isDebugEnabled()) {
                    EVENT_LOG.debug(event.toString());
                }
                EditorImpl.this.myNeedToSelectPreviousChar = false;
                if (event.isConsumed()) {
                    return;
                }
                if (EditorImpl.this.processKeyTyped(event)) {
                    event.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (EVENT_LOG.isDebugEnabled()) {
                    EVENT_LOG.debug(e.toString());
                }
                EditorImpl.this.myCharKeyPressed = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "keyPressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "keyTyped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myEditorComponent.addMouseListener(this.myMouseListener);
        this.myGutterComponent.addMouseListener(this.myMouseListener);
        this.myEditorComponent.addMouseMotionListener(this.myMouseMotionListener);
        this.myGutterComponent.addMouseMotionListener(this.myMouseMotionListener);
        this.myEditorComponent.addFocusListener(this);
        UiNotifyConnector.doWhenFirstShown((Component)this.myEditorComponent, this.myGutterComponent::updateSizeOnShowNotify, (Disposable)this.getDisposable());
        try {
            DropTarget dropTarget = this.myEditorComponent.getDropTarget();
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(new DropTargetAdapter(){

                    @Override
                    public void drop(@NotNull DropTargetDropEvent e) {
                        if (e == null) {
                            8.$$$reportNull$$$0(0);
                        }
                    }

                    @Override
                    public void dragOver(@NotNull DropTargetDragEvent e) {
                        if (e == null) {
                            8.$$$reportNull$$$0(1);
                        }
                        Point location = e.getLocation();
                        EditorImpl.this.getCaretModel().moveToVisualPosition(EditorImpl.this.getTargetPosition(location.x, location.y, true));
                        EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        EditorImpl.this.requestFocus();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$8";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "drop";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "dragOver";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        catch (TooManyListenersException e2) {
            LOG.error((Throwable)e2);
        }
        this.myPanel.addHierarchyListener(e -> this.mySoftWrapModel.getApplianceManager().updateAvailableArea());
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            @DirtyUI
            public void componentResized(@NotNull ComponentEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                EditorImpl.this.myMarkupModel.recalcEditorDimensions();
                EditorImpl.this.myMarkupModel.repaint();
                if (!EditorImpl.this.isRightAligned()) {
                    return;
                }
                EditorImpl.this.updateCaretCursor();
                EditorImpl.this.myCaretCursor.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$9", "componentResized"));
            }
        });
    }

    private boolean mayShowToolbar() {
        return !this.isEmbeddedIntoDialogWrapper() && !this.isOneLineMode() && !DiffUtil.isDiffEditor(this) && this.isFileEditor();
    }

    private boolean isFileEditor() {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile2 = documentManager.getFile((Document)this.myDocument);
        return virtualFile2 != null && virtualFile2.isValid();
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(fontSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontSize(int fontSize, @Nullable Point zoomCenter) {
        int oldFontSize = this.myScheme.getEditorFontSize();
        Rectangle visibleArea = this.myScrollingModel.getVisibleArea();
        Point zoomCenterRelative = zoomCenter == null ? new Point() : zoomCenter;
        Point zoomCenterAbsolute = new Point(visibleArea.x + zoomCenterRelative.x, visibleArea.y + zoomCenterRelative.y);
        LogicalPosition zoomCenterLogical = this.xyToLogicalPosition(zoomCenterAbsolute);
        int oldLineHeight = this.getLineHeight();
        int intraLineOffset = zoomCenterAbsolute.y % oldLineHeight;
        this.myScheme.setEditorFontSize(fontSize);
        fontSize = this.myScheme.getEditorFontSize();
        this.myPropertyChangeSupport.firePropertyChange("fontSize", oldFontSize, fontSize);
        this.myScrollPane.getViewport().invalidate();
        Point shiftedZoomCenterAbsolute = this.logicalPositionToXY(zoomCenterLogical);
        this.myScrollingModel.disableAnimation();
        try {
            int targetX = visibleArea.x == 0 ? 0 : shiftedZoomCenterAbsolute.x - zoomCenterRelative.x;
            int targetY = shiftedZoomCenterAbsolute.y - zoomCenterRelative.y + (intraLineOffset * this.getLineHeight() + oldLineHeight / 2) / oldLineHeight;
            this.myScrollingModel.scroll(targetX, targetY);
        }
        finally {
            this.myScrollingModel.enableAnimation();
        }
    }

    public int getFontSize() {
        return this.myScheme.getEditorFontSize();
    }

    @NotNull
    public ActionCallback type(@NotNull String text2) {
        if (text2 == null) {
            EditorImpl.$$$reportNull$$$0(30);
        }
        ActionCallback result2 = new ActionCallback();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            this.myLastTypedActionTimestamp = System.currentTimeMillis();
            char c = text2.charAt(i2);
            this.myLastTypedAction = Character.toString(c);
            if (this.processKeyTyped(c)) continue;
            result2.setRejected();
            ActionCallback actionCallback = result2;
            if (actionCallback == null) {
                EditorImpl.$$$reportNull$$$0(31);
            }
            return actionCallback;
        }
        result2.setDone();
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            EditorImpl.$$$reportNull$$$0(32);
        }
        return actionCallback;
    }

    private boolean processKeyTyped(char c) {
        if (ProgressManager.getInstance().hasModalProgressIndicator()) {
            return false;
        }
        FileDocumentManager manager2 = FileDocumentManager.getInstance();
        VirtualFile file2 = manager2.getFile((Document)this.myDocument);
        if (file2 != null && !file2.isValid()) {
            return false;
        }
        DataContext context2 = this.getDataContext();
        Graphics graphics = GraphicsUtil.safelyGetGraphics((Component)this.myEditorComponent);
        if (graphics != null) {
            PaintUtil.alignTxToInt((Graphics2D)((Graphics2D)graphics), (Point2D)PaintUtil.insets2offset((Insets)this.getInsets()), (boolean)true, (boolean)false, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
            this.processKeyTypedImmediately(c, graphics, context2);
            graphics.dispose();
        }
        ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c, context2);
        EditorUIUtil.hideCursorInEditor(this);
        this.processKeyTypedNormally(c, context2);
        ActionManagerEx.getInstanceEx().fireAfterEditorTyping(c, context2);
        return true;
    }

    void processKeyTypedImmediately(char c, @NotNull Graphics graphics, @NotNull DataContext dataContext) {
        if (graphics == null) {
            EditorImpl.$$$reportNull$$$0(33);
        }
        if (dataContext == null) {
            EditorImpl.$$$reportNull$$$0(34);
        }
        EditorActionPlan plan = new EditorActionPlan(this);
        EditorActionManager.getInstance();
        TypedAction.getInstance().beforeActionPerformed((Editor)this, c, dataContext, (ActionPlan)plan);
        if (this.myImmediatePainter.paint(graphics, plan)) {
            this.measureTypingLatency();
            this.myLastTypedActionTimestamp = -1L;
        }
    }

    void processKeyTypedNormally(char c, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            EditorImpl.$$$reportNull$$$0(35);
        }
        EditorActionManager.getInstance();
        TypedAction.getInstance().actionPerformed((Editor)this, c, dataContext);
    }

    private void fireFocusLost(@NotNull FocusEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(36);
        }
        for (FocusChangeListener listener2 : this.myFocusListeners) {
            listener2.focusLost(this, event);
        }
    }

    private void fireFocusGained(@NotNull FocusEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(37);
        }
        for (FocusChangeListener listener2 : this.myFocusListeners) {
            listener2.focusGained(this, event);
        }
    }

    @Override
    public void setHighlighter(@NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(38);
        }
        if (this.isReleased) {
            return;
        }
        EditorImpl.assertIsDispatchThread();
        DocumentEx document = this.getDocument();
        Disposer.dispose((Disposable)this.myHighlighterDisposable);
        document.addDocumentListener((DocumentListener)highlighter);
        this.myHighlighterDisposable = () -> document.removeDocumentListener((DocumentListener)highlighter);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myHighlighterDisposable);
        highlighter.setEditor((HighlighterClient)this);
        highlighter.setText(document.getImmutableCharSequence());
        if (!(highlighter instanceof EmptyEditorHighlighter)) {
            EditorHighlighterCache.rememberEditorHighlighterForCachesOptimization(document, highlighter);
        }
        this.myHighlighter = highlighter;
        if (this.myPanel != null) {
            this.reinitSettings();
        }
    }

    @NotNull
    public EditorHighlighter getHighlighter() {
        EditorImpl.assertReadAccess();
        EditorHighlighter editorHighlighter = this.myHighlighter;
        if (editorHighlighter == null) {
            EditorImpl.$$$reportNull$$$0(39);
        }
        return editorHighlighter;
    }

    @NotNull
    public EditorComponentImpl getContentComponent() {
        EditorComponentImpl editorComponentImpl = this.myEditorComponent;
        if (editorComponentImpl == null) {
            EditorImpl.$$$reportNull$$$0(40);
        }
        return editorComponentImpl;
    }

    @Override
    @NotNull
    public EditorGutterComponentImpl getGutterComponentEx() {
        EditorGutterComponentImpl editorGutterComponentImpl = this.myGutterComponent;
        if (editorGutterComponentImpl == null) {
            EditorImpl.$$$reportNull$$$0(41);
        }
        return editorGutterComponentImpl;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(42);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(43);
        }
        if (parentDisposable == null) {
            EditorImpl.$$$reportNull$$$0(44);
        }
        this.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removePropertyChangeListener(listener2));
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(45);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @Override
    public void setInsertMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        boolean oldValue = this.myIsInsertMode;
        this.myIsInsertMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("insertMode", oldValue, mode);
        this.myCaretCursor.repaint();
    }

    public boolean isInsertMode() {
        return this.myIsInsertMode;
    }

    @Override
    public void setColumnMode(boolean mode) {
        EditorImpl.assertIsDispatchThread();
        boolean oldValue = this.myIsColumnMode;
        this.myIsColumnMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("columnMode", oldValue, mode);
    }

    public boolean isColumnMode() {
        return this.myIsColumnMode;
    }

    public int yToVisualLine(int y) {
        return this.myView.yToVisualLine(y);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            EditorImpl.$$$reportNull$$$0(46);
        }
        VisualPosition visualPosition = this.myView.xyToVisualPosition(p);
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(47);
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        if (p == null) {
            EditorImpl.$$$reportNull$$$0(48);
        }
        VisualPosition visualPosition = this.myView.xyToVisualPosition(p);
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(49);
        }
        return visualPosition;
    }

    @NotNull
    public Point2D offsetToPoint2D(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        Point2D point2D = this.myView.offsetToXY(offset, leanTowardsLargerOffsets, beforeSoftWrap);
        if (point2D == null) {
            EditorImpl.$$$reportNull$$$0(50);
        }
        return point2D;
    }

    @NotNull
    public Point offsetToXY(int offset, boolean leanForward, boolean beforeSoftWrap) {
        Point2D point2D = this.offsetToPoint2D(offset, leanForward, beforeSoftWrap);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, false, false);
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(51);
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.myView.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(52);
        }
        return visualPosition;
    }

    public int offsetToVisualColumnInFoldRegion(@NotNull FoldRegion region, int offset, boolean leanTowardsLargerOffsets) {
        if (region == null) {
            EditorImpl.$$$reportNull$$$0(53);
        }
        EditorImpl.assertIsDispatchThread();
        return this.myView.offsetToVisualColumnInFoldRegion(region, offset, leanTowardsLargerOffsets);
    }

    public int visualColumnToOffsetInFoldRegion(@NotNull FoldRegion region, int visualColumn, boolean leansRight) {
        if (region == null) {
            EditorImpl.$$$reportNull$$$0(54);
        }
        EditorImpl.assertIsDispatchThread();
        return this.myView.visualColumnToOffsetInFoldRegion(region, visualColumn, leansRight);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.myView.offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            EditorImpl.$$$reportNull$$$0(55);
        }
        return logicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void setCaretActive() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            EditorImpl.ourCaretBlinkingCommand.myEditor = this;
        }
    }

    public int offsetToVisualLine(int offset) {
        return this.offsetToVisualLine(offset, false);
    }

    public int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        return this.myView.offsetToVisualLine(offset, beforeSoftWrap);
    }

    public int visualLineStartOffset(int visualLine) {
        return this.myView.visualLineToOffset(visualLine);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            EditorImpl.$$$reportNull$$$0(56);
        }
        Point pp = p.x >= 0 && p.y >= 0 ? p : new Point(Math.max(p.x, 0), Math.max(p.y, 0));
        LogicalPosition logicalPosition = this.visualToLogicalPosition(this.xyToVisualPosition(pp));
        if (logicalPosition == null) {
            EditorImpl.$$$reportNull$$$0(57);
        }
        return logicalPosition;
    }

    private int logicalToVisualLine(int logicalLine) {
        return logicalLine < this.myDocument.getLineCount() ? this.offsetToVisualLine(this.myDocument.getLineStartOffset(logicalLine)) : this.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)logicalLine, (int)0)).line;
    }

    int logicalLineToY(int line) {
        int visualLine = this.logicalToVisualLine(line);
        return this.visualLineToY(visualLine);
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            EditorImpl.$$$reportNull$$$0(58);
        }
        VisualPosition visible = this.logicalToVisualPosition(pos);
        Point point = this.visualPositionToXY(visible);
        if (point == null) {
            EditorImpl.$$$reportNull$$$0(59);
        }
        return point;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            EditorImpl.$$$reportNull$$$0(60);
        }
        Point2D point2D = this.myView.visualPositionToXY(visible);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition visible) {
        if (visible == null) {
            EditorImpl.$$$reportNull$$$0(61);
        }
        Point2D point2D = this.myView.visualPositionToXY(visible);
        if (point2D == null) {
            EditorImpl.$$$reportNull$$$0(62);
        }
        return point2D;
    }

    public float getScale() {
        if (!Registry.is((String)"editor.scale.gutter.icons")) {
            return 1.0f;
        }
        float normLineHeight = (float)this.getLineHeight() / this.myScheme.getLineSpacing();
        return normLineHeight / JBUIScale.scale((float)16.0f);
    }

    public int findNearestDirectionBoundary(int offset, boolean lookForward) {
        return this.myView.findNearestDirectionBoundary(offset, lookForward);
    }

    public int visualLineToY(int line) {
        return this.myView.visualLineToY(line);
    }

    public int @NotNull [] visualLineToYRange(int visualLine) {
        int[] nArray = this.myView.visualLineToYRange(visualLine);
        if (nArray == null) {
            EditorImpl.$$$reportNull$$$0(63);
        }
        return nArray;
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        this.repaint(startOffset, endOffset, true);
        this.myHighlighterListeners.forEach(listener2 -> listener2.highlighterChanged(startOffset, endOffset));
    }

    public void addHighlighterListener(@NotNull HighlighterListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(64);
        }
        if (parentDisposable == null) {
            EditorImpl.$$$reportNull$$$0(65);
        }
        ContainerUtil.add((Object)listener2, this.myHighlighterListeners, (Disposable)parentDisposable);
    }

    void repaint(int startOffset, int endOffset, boolean invalidateTextLayout) {
        if (this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode()) {
            return;
        }
        EditorImpl.assertIsDispatchThread();
        endOffset = Math.min(endOffset, this.myDocument.getTextLength());
        if (invalidateTextLayout) {
            this.myView.invalidateRange(startOffset, endOffset, true);
        }
        if (!this.isShowing()) {
            return;
        }
        if (this.myDocumentChangeInProgress) {
            if (startOffset < this.myRangeToRepaintStart) {
                this.myRangeToRepaintStart = startOffset;
            }
            if (endOffset > this.myRangeToRepaintEnd) {
                this.myRangeToRepaintEnd = endOffset;
            }
            return;
        }
        if (startOffset <= endOffset) {
            int startLine = this.myView.offsetToVisualLine(startOffset, false);
            int endLine = this.myView.offsetToVisualLine(endOffset, true);
            this.doRepaint(startLine, endLine);
        }
    }

    private boolean isShowing() {
        return this.myGutterComponent.isShowing();
    }

    private void repaintToScreenBottom(int startLine) {
        int yStartLine = this.logicalLineToY(startLine);
        this.repaintToScreenBottomStartingFrom(yStartLine);
    }

    private void repaintToScreenBottomStartingFrom(int y) {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yEndLine = visibleArea.y + visibleArea.height;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, y, visibleArea.x + visibleArea.width, yEndLine - y);
        this.myGutterComponent.repaint(0, y, this.myGutterComponent.getWidth(), yEndLine - y);
        this.myMarkupModel.repaint();
    }

    void repaintLines(int startLine, int endLine) {
        if (!this.isShowing()) {
            return;
        }
        int startVisualLine = this.logicalToVisualLine(startLine);
        int endVisualLine = this.myDocument.getTextLength() <= 0 ? 0 : this.offsetToVisualLine(this.myDocument.getLineEndOffset(Math.min(this.myDocument.getLineCount() - 1, endLine)));
        this.doRepaint(startVisualLine, endVisualLine);
    }

    private void doRepaint(int startVisualLine, int endVisualLine) {
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int yStart = this.visualLineToY(startVisualLine);
        int height = this.visualLineToYRange(endVisualLine)[1] + 2 - yStart;
        this.myEditorComponent.repaintEditorComponent(visibleArea.x, yStart, visibleArea.x + visibleArea.width, height);
        this.myGutterComponent.repaint(0, yStart, this.myGutterComponent.getWidth(), height);
    }

    private void bulkUpdateStarted() {
        if (this.myInlayModel.isInBatchMode()) {
            LOG.error("Document bulk mode shouldn't be started from batch inlay operation");
        }
        this.myView.getPreferredSize();
        this.myScrollingModel.onBulkDocumentUpdateStarted();
        this.myScrollingPositionKeeper.savePosition();
        this.myCaretModel.onBulkDocumentUpdateStarted();
        this.mySoftWrapModel.onBulkDocumentUpdateStarted();
        this.myFoldingModel.onBulkDocumentUpdateStarted();
    }

    private void bulkUpdateFinished() {
        if (this.myInlayModel.isInBatchMode()) {
            LOG.error("Document bulk mode shouldn't be finished from batch inlay operation");
        }
        this.myFoldingModel.onBulkDocumentUpdateFinished();
        this.mySoftWrapModel.onBulkDocumentUpdateFinished();
        this.myView.reset();
        this.myCaretModel.onBulkDocumentUpdateFinished();
        this.setMouseSelectionState(0);
        this.validateSize();
        this.updateGutterSize();
        this.repaintToScreenBottom(0);
        this.updateCaretCursor();
        if (!Boolean.TRUE.equals(this.getUserData(DISABLE_CARET_POSITION_KEEPING))) {
            this.myScrollingPositionKeeper.restorePosition(true);
        }
    }

    private void beforeChangedUpdate(@NotNull DocumentEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(66);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDocumentChangeInProgress = true;
        if (this.isStickySelection()) {
            this.setStickySelection(false);
        }
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.myRangeToRepaintStart = Integer.MAX_VALUE;
        this.myRangeToRepaintEnd = 0;
        boolean bl = this.myRestoreScrollingPosition = this.getCaretModel().getOffset() < e.getOffset() || this.getCaretModel().getOffset() > e.getOffset() + e.getOldLength();
        if (this.myRestoreScrollingPosition) {
            this.myScrollingPositionKeeper.savePosition();
        }
    }

    void invokeDelayedErrorStripeRepaint() {
        if (this.myErrorStripeNeedsRepaint) {
            this.myMarkupModel.repaint();
            this.myErrorStripeNeedsRepaint = false;
        }
    }

    private void changedUpdate(@NotNull DocumentEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(67);
        }
        this.myDocumentChangeInProgress = false;
        if (this.myDocument.isInBulkUpdate()) {
            return;
        }
        if (this.myErrorStripeNeedsRepaint) {
            this.myMarkupModel.repaint(e.getOffset(), e.getOffset() + e.getNewLength());
            this.myErrorStripeNeedsRepaint = false;
        }
        this.setMouseSelectionState(0);
        if (this.getGutterComponentEx().getCurrentAccessibleLine() != null) {
            this.escapeGutterAccessibleLine(e.getOffset(), e.getOffset() + e.getNewLength());
        }
        this.validateSize();
        int startLine = this.offsetToLogicalLine(e.getOffset());
        int endLine = this.offsetToLogicalLine(e.getOffset() + e.getNewLength());
        if (startLine != endLine || StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1) {
            this.myGutterComponent.clearLineToGutterRenderersCache();
        }
        if (this.myRangeToRepaintStart < this.myDocument.getLineStartOffset(startLine)) {
            startLine = this.myDocument.getLineNumber(this.myRangeToRepaintStart);
        }
        if (this.myRangeToRepaintEnd > this.myDocument.getLineEndOffset(endLine)) {
            endLine = this.myDocument.getLineNumber(Math.min(this.myRangeToRepaintEnd, this.myDocument.getTextLength()));
        }
        if (EditorImpl.countLineFeeds(e.getOldFragment()) != EditorImpl.countLineFeeds(e.getNewFragment())) {
            this.repaintToScreenBottom(startLine);
        } else {
            this.repaintLines(startLine, endLine);
        }
        this.updateCaretCursor();
        if (this.myRestoreScrollingPosition && !Boolean.TRUE.equals(this.getUserData(DISABLE_CARET_POSITION_KEEPING))) {
            this.myScrollingPositionKeeper.restorePosition(true);
        }
    }

    private void escapeGutterAccessibleLine(int offsetStart, int offsetEnd) {
        int startVisLine = this.offsetToVisualLine(offsetStart);
        int endVisLine = this.offsetToVisualLine(offsetEnd);
        int line = this.getCaretModel().getPrimaryCaret().getVisualPosition().line;
        if (startVisLine <= line && endVisLine >= line) {
            this.getGutterComponentEx().escapeCurrentAccessibleLine();
        }
    }

    public void hideCursor() {
        if (!this.myIsViewer && EMPTY_CURSOR != null && Registry.is((String)"ide.hide.cursor.when.typing")) {
            this.myDefaultCursor = EMPTY_CURSOR;
            this.updateEditorCursor();
        }
    }

    public boolean isCursorHidden() {
        return this.myDefaultCursor == EMPTY_CURSOR;
    }

    public boolean isScrollToCaret() {
        return this.myScrollToCaret;
    }

    public void setScrollToCaret(boolean scrollToCaret) {
        this.myScrollToCaret = scrollToCaret;
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable2 = this.myDisposable;
        if (disposable2 == null) {
            EditorImpl.$$$reportNull$$$0(68);
        }
        return disposable2;
    }

    private static int countLineFeeds(@NotNull CharSequence c) {
        if (c == null) {
            EditorImpl.$$$reportNull$$$0(69);
        }
        return StringUtil.countNewLines((CharSequence)c);
    }

    private void updateGutterSize() {
        EditorImpl.assertIsDispatchThread();
        if (!this.updatingSize) {
            this.updatingSize = true;
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    if (!this.isDisposed()) {
                        this.myGutterComponent.updateSize();
                    }
                }
                finally {
                    this.updatingSize = false;
                }
            }, ModalityState.any(), __ -> this.isDisposed());
        }
    }

    void validateSize() {
        if (this.isReleased) {
            return;
        }
        Dimension dim = this.getPreferredSize();
        if (!(dim.equals(this.myPreferredSize) || this.myDocument.isInBulkUpdate() || this.myInlayModel.isInBatchMode() || (dim = this.mySizeAdjustmentStrategy.adjust(dim, this.myPreferredSize, this)).equals(this.myPreferredSize))) {
            this.myPreferredSize = dim;
            this.updateGutterSize();
            this.myEditorComponent.setSize(dim);
            this.myEditorComponent.fireResized();
            this.myMarkupModel.recalcEditorDimensions();
            this.myMarkupModel.repaint();
        }
    }

    void recalculateSizeAndRepaint() {
        this.validateSize();
        this.myEditorComponent.repaint();
    }

    @Override
    @NotNull
    public DocumentEx getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            EditorImpl.$$$reportNull$$$0(70);
        }
        return documentEx;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel2 = this.myPanel;
        if (jPanel2 == null) {
            EditorImpl.$$$reportNull$$$0(71);
        }
        return jPanel2;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(72);
        }
        this.myMouseListeners.add(listener2);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        boolean success2;
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(73);
        }
        LOG.assertTrue((success2 = this.myMouseListeners.remove(listener2)) || this.isReleased);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(74);
        }
        this.myMouseMotionListeners.add(listener2);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        boolean success2;
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(75);
        }
        LOG.assertTrue((success2 = this.myMouseMotionListeners.remove(listener2)) || this.isReleased);
    }

    @Override
    public boolean isStickySelection() {
        return this.myStickySelection;
    }

    @Override
    public void setStickySelection(boolean enable) {
        this.myStickySelection = enable;
        if (enable) {
            this.myStickySelectionStart = this.getCaretModel().getOffset();
        } else {
            this.mySelectionModel.removeSelection();
        }
    }

    public void setHorizontalTextAlignment(int alignment) {
        this.myHorizontalTextAlignment = alignment;
    }

    public boolean isRightAligned() {
        return this.myHorizontalTextAlignment == 1;
    }

    public boolean isDisposed() {
        return this.isReleased;
    }

    public void stopDumbLater() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::stopDumb, ModalityState.current(), __ -> this.isDisposed());
    }

    private void stopDumb() {
        this.putUserData(BUFFER, null);
        this.myEditorComponent.repaint();
    }

    public void startDumb() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !this.myEditorComponent.isShowing()) {
            return;
        }
        if (!Registry.is((String)"editor.dumb.mode.available")) {
            return;
        }
        this.putUserData(BUFFER, null);
        Rectangle rect = ((JViewport)this.myEditorComponent.getParent()).getViewRect();
        BufferedImage image = UIUtil.createImage((Component)this.myEditorComponent, (int)rect.width, (int)rect.height, (int)1);
        Graphics2D imageGraphics = image.createGraphics();
        ((Graphics)imageGraphics).translate(-rect.x, -rect.y);
        Graphics2D graphics = JBSwingUtilities.runGlobalCGTransform((JComponent)this.myEditorComponent, (Graphics)imageGraphics);
        graphics.setClip(rect.x, rect.y, rect.width, rect.height);
        this.myEditorComponent.paintComponent(graphics);
        graphics.dispose();
        this.putUserData(BUFFER, image);
    }

    public boolean isDumb() {
        return this.getUserData(BUFFER) != null;
    }

    void paint(@NotNull Graphics2D g) {
        BufferedImage buffer;
        Rectangle clip;
        if (g == null) {
            EditorImpl.$$$reportNull$$$0(76);
        }
        if ((clip = g.getClipBounds()) == null) {
            return;
        }
        BufferedImage bufferedImage = buffer = Registry.is((String)"editor.dumb.mode.available") ? (BufferedImage)this.getUserData(BUFFER) : null;
        if (buffer != null) {
            Rectangle rect = this.getContentComponent().getVisibleRect();
            StartupUiUtil.drawImage((Graphics)g, (BufferedImage)buffer, null, (int)rect.x, (int)rect.y);
            return;
        }
        if (this.isReleased) {
            g.setColor(EditorImpl.getDisposedBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            return;
        }
        if (this.myUpdateCursor && !this.myPurePaintingMode) {
            this.setCursorPosition();
            this.myUpdateCursor = false;
        }
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        this.myView.paint(g);
        boolean isBackgroundImageSet = IdeBackgroundUtil.isEditorBackgroundImageSet(this.myProject);
        if (this.myBackgroundImageSet != isBackgroundImageSet) {
            this.myBackgroundImageSet = isBackgroundImageSet;
            EditorImpl.updateOpaque(this.myScrollPane.getHorizontalScrollBar());
            EditorImpl.updateOpaque(this.myScrollPane.getVerticalScrollBar());
        }
    }

    @NotNull
    static Color getDisposedBackground() {
        return new JBColor(new Color(128, 255, 128), new Color(128, 255, 128));
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        IndentsModel indentsModel = this.myIndentsModel;
        if (indentsModel == null) {
            EditorImpl.$$$reportNull$$$0(77);
        }
        return indentsModel;
    }

    public void setHeaderComponent(JComponent header2) {
        this.myHeaderPanel.removeAll();
        JComponent jComponent = header2 = header2 == null ? this.getPermanentHeaderComponent() : header2;
        if (header2 != null) {
            this.myHeaderPanel.add(header2);
        }
        this.myHeaderPanel.revalidate();
        this.myHeaderPanel.repaint();
        if (SystemInfo.isMac) {
            TouchbarSupport.onUpdateEditorHeader(this);
        }
    }

    public boolean hasHeaderComponent() {
        JComponent header2 = this.getHeaderComponent();
        return header2 != null && header2 != this.getPermanentHeaderComponent();
    }

    @Override
    @Nullable
    public JComponent getPermanentHeaderComponent() {
        return (JComponent)this.getUserData(PERMANENT_HEADER);
    }

    @Override
    public void setPermanentHeaderComponent(@Nullable JComponent component2) {
        this.putUserData(PERMANENT_HEADER, component2);
    }

    @Nullable
    public JComponent getHeaderComponent() {
        if (this.myHeaderPanel.getComponentCount() > 0) {
            return (JComponent)this.myHeaderPanel.getComponent(0);
        }
        return null;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.myScrollPane.setBackground(color);
        if (this.getBackgroundIgnoreForced().equals(color)) {
            this.myForcedBackground = null;
            return;
        }
        this.myForcedBackground = color;
    }

    @NotNull
    Color getForegroundColor() {
        Color color = this.myScheme.getDefaultForeground();
        if (color == null) {
            EditorImpl.$$$reportNull$$$0(78);
        }
        return color;
    }

    @Override
    @NotNull
    public Color getBackgroundColor() {
        if (this.myForcedBackground != null) {
            Color color = this.myForcedBackground;
            if (color == null) {
                EditorImpl.$$$reportNull$$$0(79);
            }
            return color;
        }
        return this.getBackgroundIgnoreForced();
    }

    @Override
    @NotNull
    public TextDrawingCallback getTextDrawingCallback() {
        TextDrawingCallback textDrawingCallback = this.myTextDrawingCallback;
        if (textDrawingCallback == null) {
            EditorImpl.$$$reportNull$$$0(80);
        }
        return textDrawingCallback;
    }

    @Override
    public void setPlaceholder(@Nullable CharSequence text2) {
        this.myPlaceholderText = text2;
    }

    @Override
    public void setPlaceholderAttributes(@Nullable TextAttributes attributes2) {
        this.myPlaceholderAttributes = attributes2;
    }

    @Nullable
    public TextAttributes getPlaceholderAttributes() {
        return this.myPlaceholderAttributes;
    }

    public CharSequence getPlaceholder() {
        return this.myPlaceholderText;
    }

    @Override
    public void setShowPlaceholderWhenFocused(boolean show2) {
        this.myShowPlaceholderWhenFocused = show2;
    }

    public boolean getShowPlaceholderWhenFocused() {
        return this.myShowPlaceholderWhenFocused;
    }

    Color getBackgroundColor(@NotNull TextAttributes attributes2) {
        Color attrColor;
        if (attributes2 == null) {
            EditorImpl.$$$reportNull$$$0(81);
        }
        return Comparing.equal((Object)(attrColor = attributes2.getBackgroundColor()), (Object)this.myScheme.getDefaultBackground()) ? this.getBackgroundColor() : attrColor;
    }

    @NotNull
    private Color getBackgroundIgnoreForced() {
        Color color = this.myScheme.getDefaultBackground();
        if (this.myDocument.isWritable()) {
            Color color2 = color;
            if (color2 == null) {
                EditorImpl.$$$reportNull$$$0(82);
            }
            return color2;
        }
        Color readOnlyColor = this.myScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
        Color color3 = readOnlyColor != null ? readOnlyColor : color;
        if (color3 == null) {
            EditorImpl.$$$reportNull$$$0(83);
        }
        return color3;
    }

    @Nullable
    public TextRange getComposedTextRange() {
        return this.myInputMethodRequestsHandler == null || this.myInputMethodRequestsHandler.composedText == null ? null : this.myInputMethodRequestsHandler.composedTextRange;
    }

    private boolean composedTextExists() {
        return this.myInputMethodRequestsHandler != null && this.myInputMethodRequestsHandler.composedText != null;
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return this.myView.getMaxWidthInRange(startOffset, endOffset);
    }

    public boolean isPaintSelection() {
        return this.myPaintSelection || !this.isOneLineMode() || IJSwingUtilities.hasFocus(this.getContentComponent());
    }

    public void setPaintSelection(boolean paintSelection) {
        this.myPaintSelection = paintSelection;
    }

    @NotNull
    @NonNls
    public String dumpState() {
        String string = "allow caret inside tab: " + this.mySettings.isCaretInsideTabs() + ", allow caret after line end: " + this.mySettings.isVirtualSpace() + ", soft wraps: " + (this.mySoftWrapModel.isSoftWrappingEnabled() ? "on" : "off") + ", caret model: " + this.getCaretModel().dumpState() + ", soft wraps data: " + this.getSoftWrapModel().dumpState() + "\n\nfolding data: " + this.getFoldingModel().dumpState() + "\ninlay model: " + this.getInlayModel().dumpState() + (String)(this.myDocument instanceof DocumentImpl ? "\n\ndocument info: " + ((DocumentImpl)this.myDocument).dumpState() : "") + "\nfont preferences: " + this.myScheme.getFontPreferences() + "\npure painting mode: " + this.myPurePaintingMode + "\ninsets: " + this.myEditorComponent.getInsets() + (String)(this.myView == null ? "" : "\nview: " + this.myView.dumpState());
        if (string == null) {
            EditorImpl.$$$reportNull$$$0(84);
        }
        return string;
    }

    public CaretRectangle @Nullable [] getCaretLocations(boolean onlyIfShown) {
        return this.myCaretCursor.getCaretLocations(onlyIfShown);
    }

    public int getAscent() {
        return this.myView.getAscent();
    }

    public int getLineHeight() {
        return this.myView.getLineHeight();
    }

    public int getDescent() {
        return this.myView.getDescent();
    }

    public int getCharHeight() {
        return this.myView.getCharHeight();
    }

    @NotNull
    public FontMetrics getFontMetrics(@JdkConstants.FontStyle int fontType) {
        EditorFontType ft;
        if (fontType == 0) {
            ft = EditorFontType.PLAIN;
        } else if (fontType == 1) {
            ft = EditorFontType.BOLD;
        } else if (fontType == 2) {
            ft = EditorFontType.ITALIC;
        } else if (fontType == 3) {
            ft = EditorFontType.BOLD_ITALIC;
        } else {
            LOG.error("Unknown font type: " + fontType);
            ft = EditorFontType.PLAIN;
        }
        FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(ft));
        if (fontMetrics == null) {
            EditorImpl.$$$reportNull$$$0(85);
        }
        return fontMetrics;
    }

    public int getPreferredHeight() {
        return this.isReleased ? 0 : this.myView.getPreferredHeight();
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.isReleased ? new Dimension() : (Registry.is((String)"idea.true.smooth.scrolling.dynamic.scrollbars") ? new Dimension(this.getPreferredWidthOfVisibleLines(), this.myView.getPreferredHeight()) : this.myView.getPreferredSize());
        if (dimension == null) {
            EditorImpl.$$$reportNull$$$0(86);
        }
        return dimension;
    }

    private int getPreferredWidthOfVisibleLines() {
        Rectangle area = this.getScrollingModel().getVisibleArea();
        VisualPosition begin = this.xyToVisualPosition(area.getLocation());
        VisualPosition end = this.xyToVisualPosition(new Point(area.x + area.width, area.y + area.height));
        return Math.max(this.myView.getPreferredWidth(begin.line, end.line), this.getScrollingWidth());
    }

    private int getScrollingWidth() {
        BoundedRangeModel model2;
        JScrollBar scrollbar = this.myScrollPane.getHorizontalScrollBar();
        if (scrollbar != null && (model2 = scrollbar.getModel()) != null) {
            return model2.getValue() + model2.getExtent();
        }
        return 0;
    }

    @Override
    @NotNull
    public Dimension getContentSize() {
        Dimension dimension = this.isReleased ? new Dimension() : this.myView.getPreferredSize();
        if (dimension == null) {
            EditorImpl.$$$reportNull$$$0(87);
        }
        return dimension;
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            EditorImpl.$$$reportNull$$$0(88);
        }
        return jScrollPane;
    }

    public void setBorder(@Nullable Border border) {
        if (border == null) {
            border = JBUI.Borders.empty();
        }
        this.myScrollPane.setBorder(border);
    }

    public Insets getInsets() {
        return this.myScrollPane.getInsets();
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            EditorImpl.$$$reportNull$$$0(89);
        }
        return this.myView.logicalPositionToOffset(pos);
    }

    public int getVisibleLineCount() {
        return Math.max(1, this.getVisibleLogicalLinesCount() + this.getSoftWrapModel().getSoftWrapsIntroducedLinesNumber());
    }

    private int getVisibleLogicalLinesCount() {
        return this.getDocument().getLineCount() - this.myFoldingModel.getTotalNumberOfFoldedLines();
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            EditorImpl.$$$reportNull$$$0(90);
        }
        VisualPosition visualPosition = this.myView.logicalToVisualPosition(logicalPos, false);
        if (visualPosition == null) {
            EditorImpl.$$$reportNull$$$0(91);
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            EditorImpl.$$$reportNull$$$0(92);
        }
        LogicalPosition logicalPosition = this.myView.visualToLogicalPosition(visiblePos);
        if (logicalPosition == null) {
            EditorImpl.$$$reportNull$$$0(93);
        }
        return logicalPosition;
    }

    private int offsetToLogicalLine(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0) {
            return 0;
        }
        if (offset > textLength || offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + " textLength: " + textLength);
        }
        int lineIndex = this.myDocument.getLineNumber(offset);
        LOG.assertTrue(lineIndex >= 0 && lineIndex < this.myDocument.getLineCount());
        return lineIndex;
    }

    @NotNull
    private VisualPosition getTargetPosition(int x, int y, boolean trimToLineWidth) {
        if (this.myDocument.getLineCount() == 0) {
            return new VisualPosition(0, 0);
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        int visualLineCount = this.getVisibleLineCount();
        if (this.yToVisualLine(y) >= visualLineCount) {
            y = this.visualLineToY(Math.max(0, visualLineCount - 1));
        }
        VisualPosition visualPosition = this.xyToVisualPosition(new Point(x, y));
        if (this.myIsInsertMode == this.mySettings.isBlockCursor() && !visualPosition.leansRight && visualPosition.column > 0) {
            visualPosition = new VisualPosition(visualPosition.line, visualPosition.column - 1, true);
        }
        if (trimToLineWidth && !this.mySettings.isVirtualSpace()) {
            LogicalPosition logicalPosition = this.visualToLogicalPosition(visualPosition);
            LogicalPosition lineEndPosition = this.offsetToLogicalPosition(this.myDocument.getLineEndOffset(logicalPosition.line));
            if (logicalPosition.column > lineEndPosition.column) {
                visualPosition = this.logicalToVisualPosition(lineEndPosition.leanForward(true));
            } else if (this.mySoftWrapModel.isInsideSoftWrap(visualPosition)) {
                VisualPosition beforeSoftWrapPosition = this.myView.logicalToVisualPosition(logicalPosition, true);
                visualPosition = visualPosition.line == beforeSoftWrapPosition.line ? beforeSoftWrapPosition : this.myView.logicalToVisualPosition(logicalPosition, false);
            }
        }
        VisualPosition visualPosition2 = visualPosition;
        if (visualPosition2 == null) {
            EditorImpl.$$$reportNull$$$0(94);
        }
        return visualPosition2;
    }

    private boolean checkIgnore(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(95);
        }
        if (!this.myIgnoreMouseEventsConsecutiveToInitial) {
            this.myInitialMouseEvent = null;
            return false;
        }
        if (!(this.myInitialMouseEvent == null || e.getComponent() == this.myInitialMouseEvent.getComponent() && e.getPoint().equals(this.myInitialMouseEvent.getPoint()))) {
            this.myIgnoreMouseEventsConsecutiveToInitial = false;
            this.myInitialMouseEvent = null;
            return false;
        }
        this.myIgnoreMouseEventsConsecutiveToInitial = false;
        this.myInitialMouseEvent = null;
        e.consume();
        return true;
    }

    private void processMouseReleased(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(96);
        }
        if (this.checkIgnore(e)) {
            return;
        }
        if (!(e.getSource() != this.myGutterComponent || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed())) {
            this.myGutterComponent.mouseReleased(e);
        }
        if (this.getMouseEventArea(e) != EditorMouseEventArea.EDITING_AREA || e.getY() < 0 || e.getX() < 0) {
            return;
        }
        FoldRegion region = this.getFoldingModel().getFoldingPlaceholderAt(e.getPoint());
        if (region != null && region == this.myMouseSelectedRegion) {
            this.getFoldingModel().runBatchFoldingOperation(() -> region.setExpanded(true), true, false);
            this.validateMousePointer(e, null);
        }
        if (!(this.myMousePressedEvent == null || !this.myKeepSelectionOnMousePress || this.myLastPressWasAtBlockInlay || this.myDragStarted || this.myMousePressedEvent.getClickCount() != 1 || this.myMousePressedEvent.isShiftDown() || this.myMousePressedEvent.isPopupTrigger() || EditorImpl.isToggleCaretEvent(this.myMousePressedEvent) || EditorImpl.isCreateRectangularSelectionEvent(this.myMousePressedEvent))) {
            this.getSelectionModel().removeSelection();
        }
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = EditorUtil.getEditorDataContext(this);
        if (dataContext == null) {
            EditorImpl.$$$reportNull$$$0(97);
        }
        return dataContext;
    }

    private boolean isInsideGutterWhitespaceArea(@NotNull MouseEvent e) {
        EditorMouseEventArea area;
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(98);
        }
        return (area = this.getMouseEventArea(e)) == EditorMouseEventArea.FOLDING_OUTLINE_AREA && this.myGutterComponent.convertX(e.getX()) > this.myGutterComponent.getWhitespaceSeparatorOffset();
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(99);
        }
        if (this.myGutterComponent != e.getSource()) {
            return EditorMouseEventArea.EDITING_AREA;
        }
        int x = this.myGutterComponent.convertX(e.getX());
        return this.myGutterComponent.getEditorMouseAreaByOffset(x);
    }

    private void requestFocus() {
        if (!this.myEditorComponent.hasFocus()) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditorComponent, true);
        }
    }

    private void resetMousePointer() {
        UIUtil.setCursor((Component)this.myEditorComponent, (Cursor)UIUtil.getTextCursor((Color)this.getBackgroundColor()));
    }

    private void validateMousePointer(@NotNull MouseEvent e, @Nullable EditorMouseEvent editorMouseEvent) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(100);
        }
        if (e.getSource() == this.myGutterComponent) {
            this.myGutterComponent.validateMousePointer(e);
        } else {
            this.myGutterComponent.setActiveFoldRegions(Collections.emptyList());
            this.myDefaultCursor = this.getDefaultCursor(e, editorMouseEvent);
            this.updateEditorCursor();
        }
    }

    private void updateEditorCursor() {
        Cursor cursor;
        Cursor customCursor = this.getCustomCursor();
        if (customCursor == null && this.myCursorSetExternally && this.myEditorComponent.isCursorSet() && (cursor = this.myEditorComponent.getCursor()) != Cursor.getPredefinedCursor(0) && cursor != Cursor.getPredefinedCursor(2) && cursor != EMPTY_CURSOR && (!SystemInfo.isMac || cursor != MacUIUtil.getInvertedTextCursor())) {
            return;
        }
        UIUtil.setCursor((Component)this.myEditorComponent, (Cursor)(customCursor == null ? this.myDefaultCursor : customCursor));
        this.myCursorSetExternally = false;
    }

    @NotNull
    private Cursor getDefaultCursor(@NotNull MouseEvent e, @Nullable EditorMouseEvent editorMouseEvent) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(101);
        }
        Cursor result2 = null;
        if (this.getSelectionModel().hasSelection() && (e.getModifiersEx() & 0xC00) == 0) {
            int offset;
            int n = offset = editorMouseEvent == null ? this.logicalPositionToOffset(this.xyToLogicalPosition(e.getPoint())) : editorMouseEvent.getOffset();
            if (this.getSelectionModel().getSelectionStart() <= offset && offset < this.getSelectionModel().getSelectionEnd()) {
                result2 = Cursor.getPredefinedCursor(0);
            }
        }
        if (result2 == null) {
            FoldRegion foldRegion;
            FoldRegion foldRegion2 = foldRegion = editorMouseEvent == null ? this.myFoldingModel.getFoldingPlaceholderAt(e.getPoint()) : editorMouseEvent.getCollapsedFoldRegion();
            if (foldRegion != null && !(foldRegion instanceof CustomFoldRegion)) {
                result2 = Cursor.getPredefinedCursor(12);
            }
        }
        Cursor cursor = result2 == null ? UIUtil.getTextCursor((Color)this.getBackgroundColor()) : result2;
        if (cursor == null) {
            EditorImpl.$$$reportNull$$$0(102);
        }
        return cursor;
    }

    private void runMouseDraggedCommand(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(103);
        }
        if (this.myCommandProcessor == null || e.isConsumed() || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed()) {
            return;
        }
        this.myCommandProcessor.executeCommand(this.myProject, () -> this.processMouseDragged(e), "", MOUSE_DRAGGED_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)this.getDocument());
    }

    private void processMouseDragged(@NotNull MouseEvent e) {
        boolean columnSelectionDrag;
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(104);
        }
        if (!SwingUtilities.isLeftMouseButton(e) && !SwingUtilities.isMiddleMouseButton(e) || Registry.is((String)"editor.disable.drag.with.right.button") && SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        EditorMouseEventArea eventArea = this.getMouseEventArea(e);
        if (eventArea == EditorMouseEventArea.ANNOTATIONS_AREA) {
            return;
        }
        if (eventArea == EditorMouseEventArea.LINE_MARKERS_AREA || eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && !this.isInsideGutterWhitespaceArea(e)) {
            if (this.myDragOnGutterSelectionStartLine >= 0) {
                this.mySelectionModel.removeSelection();
                this.myCaretModel.moveToOffset(this.myDragOnGutterSelectionStartLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(this.myDragOnGutterSelectionStartLine) : this.myDocument.getTextLength());
            }
            this.myDragOnGutterSelectionStartLine = -1;
        }
        boolean columnSelectionDragEvent = EditorImpl.isColumnSelectionDragEvent(e);
        boolean toggleCaretEvent = EditorImpl.isToggleCaretEvent(e);
        boolean addRectangularSelectionEvent = EditorImpl.isAddRectangularSelectionEvent(e);
        boolean bl = columnSelectionDrag = this.isColumnMode() && !this.myLastPressCreatedCaret || columnSelectionDragEvent;
        if (!columnSelectionDragEvent && toggleCaretEvent && !this.myLastPressCreatedCaret) {
            return;
        }
        if (this.myLastPressWasAtBlockInlay) {
            return;
        }
        Rectangle visibleArea = this.getScrollingModel().getVisibleArea();
        int x = e.getX();
        if (e.getSource() == this.myGutterComponent) {
            x = 0;
        }
        int dx = 0;
        if (x < visibleArea.x && visibleArea.x > 0) {
            dx = x - visibleArea.x;
        } else if (x > visibleArea.x + visibleArea.width) {
            dx = x - visibleArea.x - visibleArea.width;
        }
        int dy = 0;
        int y = e.getY();
        if (y < visibleArea.y && visibleArea.y > 0) {
            dy = y - visibleArea.y;
        } else if (y > visibleArea.y + visibleArea.height && visibleArea.y + visibleArea.height < this.myEditorComponent.getHeight()) {
            dy = y - visibleArea.y - visibleArea.height;
        }
        if (dx == 0 && dy == 0) {
            this.myScrollingTimer.stop();
            SelectionModelImpl selectionModel = this.getSelectionModel();
            Caret leadCaret = this.getLeadCaret();
            int oldSelectionStart = leadCaret.getLeadSelectionOffset();
            VisualPosition oldVisLeadSelectionStart = leadCaret.getLeadSelectionPosition();
            int oldCaretOffset = this.getCaretModel().getOffset();
            boolean multiCaretSelection = columnSelectionDrag || toggleCaretEvent;
            VisualPosition newVisualCaret = this.getTargetPosition(x, y, !multiCaretSelection);
            LogicalPosition newLogicalCaret = this.visualToLogicalPosition(newVisualCaret);
            if (multiCaretSelection) {
                this.myMultiSelectionInProgress = true;
                this.myRectangularSelectionInProgress = columnSelectionDrag || addRectangularSelectionEvent;
                this.myTargetMultiSelectionPosition = this.xyToVisualPosition(new Point(Math.max(x, 0), Math.max(y, 0)));
            } else {
                this.getCaretModel().moveToVisualPosition(newVisualCaret);
            }
            int newCaretOffset = this.getCaretModel().getOffset();
            newVisualCaret = this.getCaretModel().getVisualPosition();
            int caretShift = newCaretOffset - this.mySavedSelectionStart;
            if (this.myMousePressedEvent != null && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.EDITING_AREA && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.LINE_NUMBERS_AREA) {
                selectionModel.setSelection(oldSelectionStart, newCaretOffset);
            } else if (multiCaretSelection) {
                if (this.myLastMousePressedLocation != null && (this.myCurrentDragIsSubstantial || !newLogicalCaret.equals((Object)this.myLastMousePressedLocation))) {
                    this.createSelectionTill(newLogicalCaret);
                    this.blockActionsIfNeeded(e, this.myLastMousePressedLocation, newLogicalCaret);
                }
            } else {
                if (this.getMouseSelectionState() != 0) {
                    this.setupSpecialSelectionOnMouseDrag(newCaretOffset, caretShift);
                    this.cancelAutoResetForMouseSelectionState();
                    return;
                }
                if (!this.myKeepSelectionOnMousePress) {
                    if ((this.myMousePressArea == EditorMouseEventArea.LINE_NUMBERS_AREA || this.myMousePressArea == EditorMouseEventArea.LINE_MARKERS_AREA) && selectionModel.hasSelection()) {
                        if (newCaretOffset >= selectionModel.getSelectionEnd()) {
                            oldSelectionStart = selectionModel.getSelectionStart();
                            oldVisLeadSelectionStart = selectionModel.getSelectionStartPosition();
                        } else if (newCaretOffset <= selectionModel.getSelectionStart()) {
                            oldSelectionStart = selectionModel.getSelectionEnd();
                            oldVisLeadSelectionStart = selectionModel.getSelectionEndPosition();
                        }
                    } else if (this.mySettings.isBlockCursor() && Registry.is((String)"editor.block.caret.selection.vim-like")) {
                        if (this.mySelectionModel.hasSelection() && oldVisLeadSelectionStart.equals((Object)this.mySelectionModel.getSelectionEndPosition())) {
                            oldVisLeadSelectionStart = this.prevSelectionVisualPosition(oldVisLeadSelectionStart);
                        }
                        if (newVisualCaret.after(oldVisLeadSelectionStart)) {
                            newVisualCaret = this.nextSelectionVisualPosition(newVisualCaret);
                            newCaretOffset = this.visualPositionToOffset(newVisualCaret);
                        } else if (oldVisLeadSelectionStart.after(newVisualCaret) || oldVisLeadSelectionStart.equals((Object)newVisualCaret) && this.mySelectionModel.hasSelection()) {
                            oldVisLeadSelectionStart = this.nextSelectionVisualPosition(oldVisLeadSelectionStart);
                        }
                        oldSelectionStart = this.visualPositionToOffset(oldVisLeadSelectionStart);
                    }
                    this.setSelectionAndBlockActions(e, oldVisLeadSelectionStart, oldSelectionStart, newVisualCaret, newCaretOffset);
                    this.cancelAutoResetForMouseSelectionState();
                } else if (caretShift != 0 && this.myMousePressedEvent != null) {
                    if (this.mySettings.isDndEnabled()) {
                        if (!this.myDragStarted) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                throw new UnsupportedOperationException("Drag'n'drop operation shouldn't be started in tests");
                            }
                            this.myDragStarted = true;
                            boolean isCopy = UIUtil.isControlKeyDown((MouseEvent)e) || this.isViewer() || !this.getDocument().isWritable();
                            this.mySavedCaretOffsetForDNDUndoHack = oldCaretOffset;
                            this.getContentComponent().getTransferHandler().exportAsDrag(this.getContentComponent(), e, isCopy ? 1 : 2);
                        }
                    } else {
                        selectionModel.removeSelection();
                    }
                }
            }
        } else {
            this.myScrollingTimer.start(dx, dy);
            this.onSubstantialDrag(e);
        }
    }

    private VisualPosition nextSelectionVisualPosition(VisualPosition pos) {
        if (!this.isColumnMode() && pos.column >= EditorUtil.getLastVisualLineColumnNumber(this, pos.line)) {
            return new VisualPosition(pos.line + 1, 0, false);
        }
        return new VisualPosition(pos.line, pos.column + 1, false);
    }

    private VisualPosition prevSelectionVisualPosition(VisualPosition pos) {
        int prevColumn = pos.column - 1;
        if (prevColumn >= 0) {
            return new VisualPosition(pos.line, prevColumn, true);
        }
        if (this.isColumnMode() || pos.line == 0) {
            return new VisualPosition(pos.line, 0, true);
        }
        int prevLine = pos.line - 1;
        return new VisualPosition(prevLine, EditorUtil.getLastVisualLineColumnNumber(this, prevLine), true);
    }

    private void setupSpecialSelectionOnMouseDrag(int newCaretOffset, int caretShift) {
        int newSelectionStart;
        int newSelectionEnd = newCaretOffset;
        if (caretShift < 0) {
            if (this.getMouseSelectionState() == 1) {
                newSelectionEnd = this.myCaretModel.getWordAtCaretStart(this.mySettings.isCamelWords() && this.mySettings.isMouseClickSelectionHonorsCamelWords());
            } else if (this.getMouseSelectionState() == 2) {
                newSelectionEnd = this.visualPositionToOffset(new VisualPosition(this.getCaretModel().getVisualPosition().line, 0));
            }
            newSelectionStart = this.validateOffset(this.mySavedSelectionEnd);
        } else {
            if (this.getMouseSelectionState() == 1) {
                newSelectionEnd = this.myCaretModel.getWordAtCaretEnd(this.mySettings.isCamelWords() && this.mySettings.isMouseClickSelectionHonorsCamelWords());
            } else if (this.getMouseSelectionState() == 2) {
                newSelectionEnd = this.visualPositionToOffset(new VisualPosition(this.getCaretModel().getVisualPosition().line + 1, 0));
            }
            newSelectionStart = this.validateOffset(this.mySavedSelectionStart);
        }
        if (newSelectionEnd < 0) {
            newSelectionEnd = newCaretOffset;
        }
        this.mySelectionModel.setSelection(newSelectionStart, newSelectionEnd);
        this.myCaretModel.moveToOffset(newSelectionEnd);
    }

    private int validateOffset(int offset) {
        if (offset < 0) {
            return 0;
        }
        if (offset > this.myDocument.getTextLength()) {
            return this.myDocument.getTextLength();
        }
        return offset;
    }

    private void clearDnDContext() {
        if (this.myDraggedRange != null) {
            this.myDraggedRange.dispose();
            this.myDraggedRange = null;
        }
        this.myGutterComponent.myDnDInProgress = false;
    }

    private void createSelectionTill(@NotNull LogicalPosition targetPosition) {
        if (targetPosition == null) {
            EditorImpl.$$$reportNull$$$0(105);
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>(this.myCaretStateBeforeLastPress);
        if (this.myRectangularSelectionInProgress) {
            caretStates.addAll(EditorModificationUtil.calcBlockSelectionState((Editor)this, (LogicalPosition)this.myLastMousePressedLocation, (LogicalPosition)targetPosition));
        } else {
            LogicalPosition selectionStart = this.myLastMousePressedLocation;
            LogicalPosition selectionEnd = targetPosition;
            if (this.getMouseSelectionState() != 0) {
                int newCaretOffset = this.logicalPositionToOffset(targetPosition);
                if (newCaretOffset < this.mySavedSelectionStart) {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(newCaretOffset), 0));
                    }
                } else {
                    selectionStart = this.offsetToLogicalPosition(this.mySavedSelectionStart);
                    int selectionEndOffset = Math.max(newCaretOffset, this.mySavedSelectionEnd);
                    if (this.getMouseSelectionState() == 1) {
                        targetPosition = selectionEnd = this.offsetToLogicalPosition(selectionEndOffset);
                    } else if (this.getMouseSelectionState() == 2) {
                        targetPosition = selectionEnd = this.visualToLogicalPosition(new VisualPosition(this.offsetToVisualLine(selectionEndOffset) + 1, 0));
                    }
                }
                this.cancelAutoResetForMouseSelectionState();
            }
            caretStates.add(new CaretState(targetPosition, selectionStart, selectionEnd));
        }
        this.myCaretModel.setCaretsAndSelections(caretStates);
    }

    @NotNull
    private Caret getLeadCaret() {
        List<Caret> allCarets = this.myCaretModel.getAllCarets();
        Caret firstCaret = allCarets.get(0);
        if (firstCaret == this.myCaretModel.getPrimaryCaret()) {
            Caret caret = allCarets.get(allCarets.size() - 1);
            if (caret == null) {
                EditorImpl.$$$reportNull$$$0(106);
            }
            return caret;
        }
        Caret caret = firstCaret;
        if (caret == null) {
            EditorImpl.$$$reportNull$$$0(107);
        }
        return caret;
    }

    private void setSelectionAndBlockActions(@NotNull MouseEvent mouseDragEvent, VisualPosition startPosition, int startOffset, VisualPosition endPosition, int endOffset) {
        if (mouseDragEvent == null) {
            EditorImpl.$$$reportNull$$$0(108);
        }
        this.mySelectionModel.setSelection(startPosition, startOffset, endPosition, endOffset);
        if (this.myCurrentDragIsSubstantial || startOffset != endOffset || !Comparing.equal((Object)startPosition, (Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void blockActionsIfNeeded(@NotNull MouseEvent mouseDragEvent, @NotNull LogicalPosition startPosition, @NotNull LogicalPosition endPosition) {
        if (mouseDragEvent == null) {
            EditorImpl.$$$reportNull$$$0(109);
        }
        if (startPosition == null) {
            EditorImpl.$$$reportNull$$$0(110);
        }
        if (endPosition == null) {
            EditorImpl.$$$reportNull$$$0(111);
        }
        if (this.myCurrentDragIsSubstantial || !startPosition.equals((Object)endPosition)) {
            this.onSubstantialDrag(mouseDragEvent);
        }
    }

    private void onSubstantialDrag(@NotNull MouseEvent mouseDragEvent) {
        if (mouseDragEvent == null) {
            EditorImpl.$$$reportNull$$$0(112);
        }
        IdeEventQueue.getInstance().blockNextEvents(mouseDragEvent, IdeEventQueue.BlockMode.ACTIONS);
        this.myCurrentDragIsSubstantial = true;
    }

    void updateCaretCursor() {
        this.myUpdateCursor = true;
        if (this.myCaretCursor.myIsShown) {
            this.myCaretCursor.myStartTime = System.currentTimeMillis();
        } else {
            this.myCaretCursor.myIsShown = true;
            this.myCaretCursor.repaint();
        }
    }

    private void setCursorPosition() {
        ArrayList<CaretRectangle> caretPoints = new ArrayList<CaretRectangle>();
        for (Caret caret : this.getCaretModel().getAllCarets()) {
            boolean isRtl = caret.isAtRtlLocation();
            VisualPosition caretPosition = caret.getVisualPosition();
            Point2D pos1 = this.visualPositionToPoint2D(caretPosition.leanRight(!isRtl));
            Point2D pos2 = this.visualPositionToPoint2D(new VisualPosition(caretPosition.line, Math.max(0, caretPosition.column + (isRtl ? -1 : 1)), isRtl));
            float width = (float)Math.abs(pos2.getX() - pos1.getX());
            if (!isRtl && this.myInlayModel.hasInlineElementAt(caretPosition)) {
                width = Math.min(width, (float)Math.ceil(this.myView.getPlainSpaceWidth()));
            }
            caretPoints.add(new CaretRectangle(pos1, width, caret, isRtl));
        }
        this.myCaretCursor.setPositions(caretPoints.toArray(new CaretRectangle[0]));
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        boolean old = this.myCaretCursor.isActive();
        if (b) {
            this.myCaretCursor.activate();
        } else {
            this.myCaretCursor.passivate();
        }
        return old;
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        boolean old = this.myCaretCursor.isEnabled();
        this.myCaretCursor.setEnabled(enabled);
        return old;
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(113);
        }
        this.myFocusListeners.add(listener2);
    }

    @Override
    public void addFocusListener(@NotNull FocusChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            EditorImpl.$$$reportNull$$$0(114);
        }
        if (parentDisposable == null) {
            EditorImpl.$$$reportNull$$$0(115);
        }
        ContainerUtil.add((Object)listener2, this.myFocusListeners, (Disposable)parentDisposable);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isOneLineMode() {
        return this.myIsOneLineMode;
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myEmbeddedIntoDialogWrapper;
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        EditorImpl.assertIsDispatchThread();
        this.myEmbeddedIntoDialogWrapper = b;
        this.myScrollPane.setFocusable(!b);
        this.myEditorComponent.setFocusCycleRoot(!b);
        this.myEditorComponent.setFocusable(b);
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        JComponent component2;
        if (isOneLineMode == this.myIsOneLineMode) {
            return;
        }
        this.myIsOneLineMode = isOneLineMode;
        this.getScrollPane().setInputMap(1, null);
        JBScrollPane pane2 = (JBScrollPane)ObjectUtils.tryCast((Object)this.getScrollPane(), JBScrollPane.class);
        JComponent jComponent = component2 = pane2 == null ? null : pane2.getStatusComponent();
        if (component2 != null) {
            component2.setVisible(!this.isOneLineMode());
        }
        this.reinitSettings();
        this.myPropertyChangeSupport.firePropertyChange("oneLineMode", !isOneLineMode, isOneLineMode);
    }

    private static void updateOpaque(JScrollBar bar) {
        if (bar instanceof OpaqueAwareScrollBar) {
            bar.setOpaque(((OpaqueAwareScrollBar)((Object)bar)).myOpaque);
        }
    }

    @NotNull
    private MyEditable getViewer() {
        MyEditable editable = this.myEditable;
        if (editable == null) {
            this.myEditable = editable = new MyEditable();
        }
        MyEditable myEditable = editable;
        if (myEditable == null) {
            EditorImpl.$$$reportNull$$$0(116);
        }
        return myEditable;
    }

    @Override
    @NotNull
    public CopyProvider getCopyProvider() {
        return this.getViewer();
    }

    @Override
    @NotNull
    public CutProvider getCutProvider() {
        return this.getViewer();
    }

    @Override
    @NotNull
    public PasteProvider getPasteProvider() {
        return this.getViewer();
    }

    @Override
    @NotNull
    public DeleteProvider getDeleteProvider() {
        return this.getViewer();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            EditorImpl.$$$reportNull$$$0(117);
        }
        EditorImpl.assertIsDispatchThread();
        this.myScheme = scheme2;
        this.reinitSettings();
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.myScheme;
        if (editorColorsScheme == null) {
            EditorImpl.$$$reportNull$$$0(118);
        }
        return editorColorsScheme;
    }

    static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        EditorImpl.assertIsDispatchThread();
        if (this.myScrollBarOrientation == type) {
            return;
        }
        int currentHorOffset = this.myScrollingModel.getHorizontalScrollOffset();
        this.myScrollBarOrientation = type;
        this.myScrollPane.putClientProperty(JBScrollPane.Flip.class, type == 0 ? JBScrollPane.Flip.HORIZONTAL : null);
        this.myScrollingModel.scrollHorizontally(currentHorOffset);
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        this.myScrollPane.setVerticalScrollBarPolicy(b ? 22 : 21);
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        this.myScrollPane.setHorizontalScrollBarPolicy(b ? 30 : 31);
    }

    @Override
    public int getVerticalScrollbarOrientation() {
        return this.myScrollBarOrientation;
    }

    public boolean isMirrored() {
        return this.myScrollBarOrientation != 1;
    }

    @NotNull
    MyScrollBar getVerticalScrollBar() {
        MyScrollBar myScrollBar = this.myVerticalScrollBar;
        if (myScrollBar == null) {
            EditorImpl.$$$reportNull$$$0(119);
        }
        return myScrollBar;
    }

    @MouseSelectionState
    private int getMouseSelectionState() {
        return this.myMouseSelectionState;
    }

    private void setMouseSelectionState(@MouseSelectionState int mouseSelectionState) {
        if (this.getMouseSelectionState() == mouseSelectionState) {
            return;
        }
        this.myMouseSelectionState = mouseSelectionState;
        this.myMouseSelectionChangeTimestamp = System.currentTimeMillis();
        this.myMouseSelectionStateAlarm.cancelAllRequests();
        if (this.myMouseSelectionState != 0) {
            if (this.myMouseSelectionStateResetRunnable == null) {
                this.myMouseSelectionStateResetRunnable = () -> this.resetMouseSelectionState(null, null);
            }
            this.myMouseSelectionStateAlarm.addRequest(this.myMouseSelectionStateResetRunnable, Registry.intValue((String)"editor.mouseSelectionStateResetTimeout"), ModalityState.stateForComponent((Component)this.myEditorComponent));
        }
    }

    private void resetMouseSelectionState(@Nullable MouseEvent event, @Nullable EditorMouseEvent editorMouseEvent) {
        MouseEvent e;
        this.setMouseSelectionState(0);
        MouseEvent mouseEvent = e = event != null ? event : this.myMouseMovedEvent;
        if (e != null) {
            this.validateMousePointer(e, editorMouseEvent);
        }
    }

    private void cancelAutoResetForMouseSelectionState() {
        this.myMouseSelectionStateAlarm.cancelAllRequests();
    }

    void replaceInputMethodText(@NotNull InputMethodEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(120);
        }
        if (this.isReleased) {
            return;
        }
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.replaceInputMethodText(e);
    }

    void inputMethodCaretPositionChanged(@NotNull InputMethodEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(121);
        }
        if (this.isReleased) {
            return;
        }
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.setInputMethodCaretPosition(e);
    }

    @NotNull
    InputMethodRequests getInputMethodRequests() {
        if (this.myInputMethodRequestsHandler == null) {
            this.myInputMethodRequestsHandler = new MyInputMethodHandler();
            this.myInputMethodRequestsSwingWrapper = new MyInputMethodHandleSwingThreadWrapper(this.myInputMethodRequestsHandler);
        }
        InputMethodRequests inputMethodRequests = this.myInputMethodRequestsSwingWrapper;
        if (inputMethodRequests == null) {
            EditorImpl.$$$reportNull$$$0(122);
        }
        return inputMethodRequests;
    }

    @Override
    public boolean processKeyTyped(@NotNull KeyEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(123);
        }
        this.myLastTypedActionTimestamp = -1L;
        if (e.getID() != 400) {
            return false;
        }
        char c = e.getKeyChar();
        if (UIUtil.isReallyTypedEvent((KeyEvent)e)) {
            this.myLastTypedActionTimestamp = e.getWhen();
            this.myLastTypedAction = Character.toString(c);
            this.processKeyTyped(c);
            return true;
        }
        return false;
    }

    public void recordLatencyAwareAction(@NotNull String actionId, long timestampMs) {
        if (actionId == null) {
            EditorImpl.$$$reportNull$$$0(124);
        }
        this.myLastTypedActionTimestamp = timestampMs;
        this.myLastTypedAction = actionId;
    }

    void measureTypingLatency() {
        if (this.myLastTypedActionTimestamp == -1L) {
            return;
        }
        LatencyListener latencyPublisher = this.myLatencyPublisher;
        if (latencyPublisher == null) {
            this.myLatencyPublisher = latencyPublisher = (LatencyListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LatencyListener.TOPIC);
        }
        latencyPublisher.recordTypingLatency((Editor)this, this.myLastTypedAction, System.currentTimeMillis() - this.myLastTypedActionTimestamp);
        this.myLastTypedActionTimestamp = -1L;
    }

    public boolean isProcessingTypedAction() {
        return this.myLastTypedActionTimestamp != -1L;
    }

    void beforeModalityStateChanged() {
        this.myScrollingModel.beforeModalityStateChanged();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myGutterComponent.resetMousePointer();
            this.resetMousePointer();
        }
    }

    private EditorDropHandler getDropHandler() {
        return this.myDropHandler;
    }

    public void setDropHandler(@NotNull EditorDropHandler dropHandler) {
        if (dropHandler == null) {
            EditorImpl.$$$reportNull$$$0(125);
        }
        this.myDropHandler = dropHandler;
    }

    public void setHighlightingPredicate(@Nullable Predicate<? super RangeHighlighter> filter) {
        if (this.myHighlightingFilter == filter) {
            return;
        }
        Predicate<? super RangeHighlighter> oldFilter = this.myHighlightingFilter;
        this.myHighlightingFilter = filter;
        for (RangeHighlighter highlighter : this.myDocumentMarkupModel.getDelegate().getAllHighlighters()) {
            boolean newAvailable;
            boolean oldAvailable = oldFilter == null || oldFilter.test((RangeHighlighter)highlighter);
            boolean bl = newAvailable = filter == null || filter.test((RangeHighlighter)highlighter);
            if (oldAvailable == newAvailable) continue;
            TextAttributes attributes2 = highlighter.getTextAttributes(this.getColorsScheme());
            this.myMarkupModelListener.attributesChanged((RangeHighlighterEx)highlighter, true, EditorUtil.attributesImpactFontStyle(attributes2), EditorUtil.attributesImpactForegroundColor(attributes2));
            this.myMarkupModel.getErrorStripeMarkersModel().attributesChanged((RangeHighlighterEx)highlighter, true);
        }
    }

    boolean isHighlighterAvailable(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            EditorImpl.$$$reportNull$$$0(126);
        }
        return this.myHighlightingFilter == null || this.myHighlightingFilter.test((RangeHighlighter)highlighter);
    }

    private boolean hasBlockInlay(@NotNull Point point) {
        Inlay inlay;
        if (point == null) {
            EditorImpl.$$$reportNull$$$0(127);
        }
        return (inlay = this.myInlayModel.getElementAt(point)) != null && (inlay.getPlacement() == Inlay.Placement.ABOVE_LINE || inlay.getPlacement() == Inlay.Placement.BELOW_LINE);
    }

    private static boolean isColumnSelectionDragEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(128);
        }
        return EditorImpl.isMouseActionEvent(e, "EditorCreateRectangularSelectionOnMouseDrag");
    }

    private static boolean isToggleCaretEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(129);
        }
        return EditorImpl.isMouseActionEvent(e, "EditorAddOrRemoveCaret") || EditorImpl.isAddRectangularSelectionEvent(e);
    }

    private static boolean isAddRectangularSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(130);
        }
        return EditorImpl.isMouseActionEvent(e, "EditorAddRectangularSelectionOnMouseDrag");
    }

    private static boolean isCreateRectangularSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(131);
        }
        return EditorImpl.isMouseActionEvent(e, "EditorCreateRectangularSelection");
    }

    private static boolean isMouseActionEvent(@NotNull MouseEvent e, @NotNull String actionId) {
        MouseShortcut mouseShortcut;
        KeymapManager keymapManager2;
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(132);
        }
        if (actionId == null) {
            EditorImpl.$$$reportNull$$$0(133);
        }
        if ((keymapManager2 = KeymapManager.getInstance()) == null) {
            return false;
        }
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        List mappedActions = keymap2.getActionIds(mouseShortcut = KeymapUtil.createMouseShortcut((MouseEvent)e));
        if (!mappedActions.contains(actionId)) {
            return false;
        }
        if (mappedActions.size() < 2 || e.getID() == 506) {
            return true;
        }
        ActionManager actionManager = ActionManager.getInstance();
        for (String mappedActionId : mappedActions) {
            AnActionEvent actionEvent;
            AnAction action2;
            if (actionId.equals(mappedActionId) || !ActionUtil.lastUpdateAndCheckDumb((AnAction)(action2 = actionManager.getAction(mappedActionId)), (AnActionEvent)(actionEvent = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)e, (String)"MainMenu", (DataContext)DataManager.getInstance().getDataContext(e.getComponent()))), (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private void selectWordAtCaret(boolean honorCamelCase) {
        CaretImpl caret = this.getCaretModel().getCurrentCaret();
        caret.selectWordAtCaret(honorCamelCase);
        this.setMouseSelectionState(1);
        this.mySavedSelectionStart = caret.getSelectionStart();
        this.mySavedSelectionEnd = caret.getSelectionEnd();
        caret.moveToOffset(this.mySavedSelectionEnd);
    }

    private void selectLineAtCaret(boolean moveToEnd) {
        CaretImpl caret = this.getCaretModel().getCurrentCaret();
        caret.selectLineAtCaret();
        this.setMouseSelectionState(2);
        this.mySavedSelectionStart = caret.getSelectionStart();
        this.mySavedSelectionEnd = caret.getSelectionEnd();
        if (moveToEnd) {
            caret.moveToOffset(this.mySavedSelectionEnd);
        }
    }

    private boolean tweakSelectionEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(134);
        }
        return this.getSelectionModel().hasSelection() && e.getButton() == 1 && e.isShiftDown() && this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA;
    }

    private boolean tweakSelectionIfNecessary(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(135);
        }
        if (!this.tweakSelectionEvent(e)) {
            return false;
        }
        int startSelectionOffset = this.getSelectionModel().getSelectionStart();
        int startVisLine = this.offsetToVisualLine(startSelectionOffset);
        int endSelectionOffset = this.getSelectionModel().getSelectionEnd();
        int endVisLine = this.offsetToVisualLine(endSelectionOffset - 1);
        int clickVisLine = this.yToVisualLine(e.getPoint().y);
        if (clickVisLine < startVisLine) {
            int startOffset = this.visualPositionToOffset(new VisualPosition(clickVisLine, 0));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else if (clickVisLine > endVisLine) {
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(this.getSelectionModel().getSelectionStart(), endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset, true);
        } else if (startVisLine == endVisLine) {
            this.getSelectionModel().removeSelection();
        } else if (this.getSelectionModel().getLeadSelectionOffset() == endSelectionOffset) {
            if (clickVisLine == startVisLine) {
                ++clickVisLine;
            }
            int startOffset = this.visualPositionToOffset(new VisualPosition(clickVisLine, 0));
            this.getSelectionModel().setSelection(startOffset, endSelectionOffset);
            this.getCaretModel().moveToOffset(startOffset);
        } else {
            if (clickVisLine == endVisLine) {
                --clickVisLine;
            }
            int endLineOffset = EditorUtil.getVisualLineEndOffset(this, clickVisLine);
            this.getSelectionModel().setSelection(startSelectionOffset, endLineOffset);
            this.getCaretModel().moveToOffset(endLineOffset);
        }
        e.consume();
        return true;
    }

    boolean useEditorAntialiasing() {
        return this.myUseEditorAntialiasing;
    }

    public void setUseEditorAntialiasing(boolean value2) {
        this.myUseEditorAntialiasing = value2;
    }

    @NotNull
    private EditorMouseEvent createEditorMouseEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorImpl.$$$reportNull$$$0(136);
        }
        Point point = e.getPoint();
        EditorMouseEventArea area = this.getMouseEventArea(e);
        boolean inEditingArea = area == EditorMouseEventArea.EDITING_AREA;
        EditorLocation location = new EditorLocation(this, inEditingArea ? point : new Point(0, point.y));
        VisualPosition visualPosition = location.getVisualPosition();
        LogicalPosition logicalPosition = location.getLogicalPosition();
        int offset = location.getOffset();
        int relX = point.x - this.myEditorComponent.getInsets().left;
        Inlay inlayCandidate = inEditingArea ? this.myInlayModel.getElementAt(location, true) : null;
        Inlay inlay = inlayCandidate == null || (inlayCandidate.getPlacement() == Inlay.Placement.BELOW_LINE || inlayCandidate.getPlacement() == Inlay.Placement.ABOVE_LINE) && inlayCandidate.getWidthInPixels() <= relX ? null : inlayCandidate;
        FoldRegion foldRegionCandidate = inEditingArea ? this.myFoldingModel.getFoldingPlaceholderAt(location, true) : null;
        FoldRegion foldRegion = foldRegionCandidate instanceof CustomFoldRegion && ((CustomFoldRegion)foldRegionCandidate).getWidthInPixels() <= relX ? null : foldRegionCandidate;
        GutterIconRenderer gutterIconRenderer = inEditingArea ? null : this.myGutterComponent.getGutterRenderer(point);
        boolean overText = inlayCandidate == null && (foldRegionCandidate == null || foldRegion != null) && this.offsetToLogicalPosition(offset).equals((Object)logicalPosition);
        return new EditorMouseEvent((Editor)this, e, area, offset, logicalPosition, visualPosition, overText, foldRegion, inlay, gutterIconRenderer);
    }

    static boolean handleDrop(@NotNull EditorImpl editor2, @NotNull Transferable t, int dropAction) {
        if (editor2 == null) {
            EditorImpl.$$$reportNull$$$0(137);
        }
        if (t == null) {
            EditorImpl.$$$reportNull$$$0(138);
        }
        EditorDropHandler dropHandler = editor2.getDropHandler();
        if (Registry.is((String)"debugger.click.disable.breakpoints")) {
            try {
                GutterDraggableObject object;
                Object attachedObject;
                if (t.isDataFlavorSupported(GutterDraggableObject.flavor) && (attachedObject = t.getTransferData(GutterDraggableObject.flavor)) instanceof GutterIconRenderer && (object = ((GutterIconRenderer)attachedObject).getDraggableObject()) != null) {
                    object.remove();
                    Point mouseLocationOnScreen = MouseInfo.getPointerInfo().getLocation();
                    JComponent editorComponent = editor2.getComponent();
                    Point editorComponentLocationOnScreen = editorComponent.getLocationOnScreen();
                    Disposable painterListenersDisposable = Disposer.newDisposable((String)"PainterListenersDisposable");
                    Disposer.register((Disposable)editor2.getDisposable(), (Disposable)painterListenersDisposable);
                    GutterIconDropAnimator painter = new GutterIconDropAnimator(new Point(mouseLocationOnScreen.x - editorComponentLocationOnScreen.x, mouseLocationOnScreen.y - editorComponentLocationOnScreen.y), editor2.getGutterComponentEx().getDragImage((GutterMark)((GutterIconRenderer)attachedObject)), painterListenersDisposable);
                    IdeGlassPaneUtil.installPainter((JComponent)editorComponent, (Painter)painter, (Disposable)painterListenersDisposable);
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        if (dropHandler != null && dropHandler.canHandleDrop(t.getTransferDataFlavors())) {
            dropHandler.handleDrop(t, editor2.getProject(), null, dropAction);
            return true;
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        if (editor2.myDraggedRange != null && editor2.myDraggedRange.getStartOffset() <= caretOffset && caretOffset < editor2.myDraggedRange.getEndOffset()) {
            return false;
        }
        if (editor2.myDraggedRange != null) {
            editor2.getCaretModel().moveToOffset(editor2.mySavedCaretOffsetForDNDUndoHack);
        }
        CommandProcessor.getInstance().executeCommand(editor2.myProject, () -> {
            try {
                int offset;
                editor2.getSelectionModel().removeSelection();
                if (editor2.myDraggedRange != null) {
                    editor2.getCaretModel().moveToOffset(caretOffset);
                    offset = caretOffset;
                } else {
                    offset = editor2.getCaretModel().getOffset();
                }
                if (editor2.getDocument().getRangeGuard(offset, offset) != null) {
                    return;
                }
                editor2.putUserData(LAST_PASTED_REGION, null);
                AnAction pasteAction = ActionManager.getInstance().getAction("EditorPaste");
                if (pasteAction instanceof EditorAction) {
                    EditorTextInsertHandler handler2 = (EditorTextInsertHandler)((EditorAction)pasteAction).getHandlerOfType(EditorTextInsertHandler.class);
                    if (handler2 == null) {
                        LOG.error("No suitable paste handler found");
                    } else {
                        handler2.execute((Editor)editor2, editor2.getDataContext(), () -> t);
                    }
                } else {
                    LOG.error("Couldn't find paste action: " + pasteAction);
                }
                TextRange range2 = (TextRange)editor2.getUserData(LAST_PASTED_REGION);
                if (range2 != null) {
                    editor2.getCaretModel().moveToOffset(range2.getStartOffset());
                    editor2.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
                }
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
            }
        }, EditorBundle.message((String)"paste.command.name", (Object[])new Object[0]), DND_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)editor2.getDocument());
        return true;
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutterComponentImpl editorGutterComponentImpl = this.getGutterComponentEx();
        if (editorGutterComponentImpl == null) {
            EditorImpl.$$$reportNull$$$0(139);
        }
        return editorGutterComponentImpl;
    }

    public boolean isInDistractionFreeMode() {
        return EditorUtil.isRealFileEditor(this) && (Registry.is((String)"editor.distraction.free.mode") || this.isInPresentationMode());
    }

    boolean isInPresentationMode() {
        return UISettings.getInstance().getPresentationMode() && EditorUtil.isRealFileEditor(this);
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info2) {
        if (info2 == null) {
            EditorImpl.$$$reportNull$$$0(140);
        }
        VisualPosition visual = this.getCaretModel().getVisualPosition();
        info2.put("caret", visual.getLine() + ":" + visual.getColumn());
    }

    private void invokePopupIfNeeded(@NotNull EditorMouseEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(141);
        }
        if (event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().isPopupTrigger() && !event.isConsumed()) {
            for (int i2 = this.myPopupHandlers.size() - 1; i2 >= 0 && !this.myPopupHandlers.get(i2).handlePopup(event); --i2) {
            }
        }
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        if (event == null) {
            EditorImpl.$$$reportNull$$$0(142);
        }
        if (this.myProject != null) {
            PsiFile editorFile;
            if (event.getPsiFile() != null && (editorFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile((Document)this.getDocument())) != event.getPsiFile()) {
                return;
            }
            int oldTabSize = EditorUtil.getTabSize(this);
            this.mySettings.reinitSettings();
            int newTabSize = EditorUtil.getTabSize(this);
            if (oldTabSize != newTabSize) {
                this.reinitSettings(false);
            } else {
                this.myEditorComponent.repaint();
            }
        }
    }

    public void bidiTextFound() {
        if (this.myProject != null && this.myVirtualFile != null && this.replace(CONTAINS_BIDI_TEXT, null, Boolean.TRUE)) {
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        }
    }

    @TestOnly
    void validateState() {
        this.myView.validateState();
        this.mySoftWrapModel.validateState();
        this.myFoldingModel.validateState();
        this.myCaretModel.validateState();
        this.myInlayModel.validateState();
    }

    public String toString() {
        return "EditorImpl[" + FileDocumentManager.getInstance().getFile((Document)this.myDocument) + "]";
    }

    private /* synthetic */ void lambda$initComponent$9(JLayeredPane layeredPane2) {
        layeredPane2.add((Component)new EditorFloatingToolbar(this), JLayeredPane.POPUP_LAYER);
    }

    static {
        Cursor emptyCursor = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                emptyCursor = Toolkit.getDefaultToolkit().createCustomCursor(ImageUtil.createImage((int)1, (int)1, (int)2), new Point(), "Empty cursor");
            }
            catch (Exception e) {
                LOG.warn("Couldn't create an empty cursor", (Throwable)e);
            }
        }
        EMPTY_CURSOR = emptyCursor;
        ourCaretBlinkingCommand = new RepaintCursorCommand();
        ourCaretBlinkingCommand.start();
        decrButtonField = ReflectionUtil.getDeclaredField(BasicScrollBarUI.class, (String)"decrButton");
        incrButtonField = ReflectionUtil.getDeclaredField(BasicScrollBarUI.class, (String)"incrButton");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 91: 
            case 93: 
            case 94: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 139: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 91: 
            case 93: 
            case 94: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 139: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 91: 
            case 93: 
            case 94: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorImpl";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 66: 
            case 67: 
            case 95: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 120: 
            case 121: 
            case 123: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 38: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineExtensionPainter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupHandler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 36: 
            case 37: 
            case 141: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 64: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 113: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 44: 
            case 65: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 46: 
            case 48: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 58: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visible";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPos";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePos";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPosition";
                break;
            }
            case 108: 
            case 109: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseDragEvent";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPosition";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endPosition";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 124: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropHandler";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusModeModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustThumbColor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDocumentMarkupModel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollingModel";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWrapModel";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlayModel";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorKind";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentComponent";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutterComponentEx";
                break;
            }
            case 47: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "xyToVisualPosition";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToPoint2D";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToVisualPosition";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLogicalPosition";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "xyToLogicalPosition";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalPositionToXY";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "visualPositionToPoint2D";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "visualLineToYRange";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentsModel";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getForegroundColor";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextDrawingCallback";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundIgnoreForced";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontMetrics";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSize";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalToVisualPosition";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "visualToLogicalPosition";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPosition";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCursor";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadCaret";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewer";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerticalScrollBar";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputMethodRequests";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "getGutter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInFocusMode";
                break;
            }
            case 3: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 91: 
            case 93: 
            case 94: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 139: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "focusGained";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "focusLost";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canImpactGutterSize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "errorStripeMarkerChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onHighlighterChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onInlayUpdated";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretIntoViewIfCoveredByToolWindowBelow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "adjustThumbColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "repaintCaretRegion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerLineExtensionPainter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processLineExtensions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPopupHandler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setCustomCursor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "throwDisposalError";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processKeyTypedImmediately";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processKeyTypedNormally";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fireFocusLost";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "fireFocusGained";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setHighlighter";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "xyToVisualPosition";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "offsetToVisualColumnInFoldRegion";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visualColumnToOffsetInFoldRegion";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "xyToLogicalPosition";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToXY";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToXY";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToPoint2D";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighterListener";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "beforeChangedUpdate";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdate";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "countLineFeeds";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseListener";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorMouseListener";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseMotionListener";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorMouseMotionListener";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualPosition";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "visualToLogicalPosition";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "checkIgnore";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "processMouseReleased";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isInsideGutterWhitespaceArea";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getMouseEventArea";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "validateMousePointer";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCursor";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "runMouseDraggedCommand";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "processMouseDragged";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "createSelectionTill";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionAndBlockActions";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "blockActionsIfNeeded";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "onSubstantialDrag";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "addFocusListener";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "setColorsScheme";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "replaceInputMethodText";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "inputMethodCaretPositionChanged";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "processKeyTyped";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "recordLatencyAwareAction";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "setDropHandler";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterAvailable";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "hasBlockInlay";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "isColumnSelectionDragEvent";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "isToggleCaretEvent";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "isAddRectangularSelectionEvent";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "isCreateRectangularSelectionEvent";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "isMouseActionEvent";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "tweakSelectionEvent";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "tweakSelectionIfNecessary";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "createEditorMouseEvent";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "handleDrop";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "invokePopupIfNeeded";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 63: 
            case 68: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 91: 
            case 93: 
            case 94: 
            case 97: 
            case 102: 
            case 106: 
            case 107: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 139: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullEditorHighlighter
    extends EmptyEditorHighlighter {
        private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();

        NullEditorHighlighter() {
            super(NULL_ATTRIBUTES);
        }

        public void setAttributes(TextAttributes attributes2) {
        }

        public void setColorScheme(@NotNull EditorColorsScheme scheme2) {
            if (scheme2 == null) {
                NullEditorHighlighter.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/impl/EditorImpl$NullEditorHighlighter", "setColorScheme"));
        }
    }

    private class MyTextDrawingCallback
    implements TextDrawingCallback {
        private MyTextDrawingCallback() {
        }

        @Override
        public void drawChars(@NotNull Graphics g, char @NotNull [] data2, int start2, int end, int x, int y, @NotNull Color color, @NotNull FontInfo fontInfo) {
            if (g == null) {
                MyTextDrawingCallback.$$$reportNull$$$0(0);
            }
            if (color == null) {
                MyTextDrawingCallback.$$$reportNull$$$0(1);
            }
            if (fontInfo == null) {
                MyTextDrawingCallback.$$$reportNull$$$0(2);
            }
            if (data2 == null) {
                MyTextDrawingCallback.$$$reportNull$$$0(3);
            }
            EditorImpl.this.myView.drawChars(g, data2, start2, end, x, y, color, fontInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "color";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fontInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyTextDrawingCallback";
            objectArray[2] = "drawChars";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyHeaderPanel
    extends JPanel {
        private int myOldHeight;

        private MyHeaderPanel() {
            super(new BorderLayout());
        }

        @Override
        public void revalidate() {
            this.myOldHeight = this.getHeight();
            super.revalidate();
        }

        @Override
        protected void validateTree() {
            int height = this.myOldHeight;
            super.validateTree();
            if ((height -= this.getHeight()) != 0 && (this.myOldHeight != 0 || this.getComponentCount() <= 0 || EditorImpl.this.getPermanentHeaderComponent() != this.getComponent(0))) {
                EditorImpl.this.myVerticalScrollBar.setValue(EditorImpl.this.myVerticalScrollBar.getValue() - height);
            }
            this.myOldHeight = this.getHeight();
        }
    }

    private final class TablessBorder
    extends SideBorder {
        private TablessBorder() {
            super(JBColor.border(), 15);
        }

        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                TablessBorder.$$$reportNull$$$0(0);
            }
            if (g == null) {
                TablessBorder.$$$reportNull$$$0(1);
            }
            if (c instanceof JComponent) {
                Insets insets = ((JComponent)c).getInsets();
                if (insets.left > 0) {
                    super.paintBorder(c, g, x, y, width, height);
                } else {
                    g.setColor(UIUtil.getPanelBackground());
                    g.fillRect(x, y, width, 1);
                    g.setColor(Gray._50.withAlpha(90));
                    g.fillRect(x, y, width, 1);
                }
            }
        }

        @NotNull
        public Insets getBorderInsets(Component c) {
            boolean paintTop;
            Container splitters = SwingUtilities.getAncestorOfClass(EditorsSplitters.class, c);
            boolean thereIsSomethingAbove = !SystemInfo.isMac || UISettings.getInstance().getShowMainToolbar() || UISettings.getInstance().getShowNavigationBar() || this.toolWindowIsNotEmpty();
            Component header2 = EditorImpl.this.myHeaderPanel == null ? null : (Component)ArrayUtil.getFirstElement((Object[])EditorImpl.this.myHeaderPanel.getComponents());
            boolean bl = paintTop = thereIsSomethingAbove && header2 == null && UISettings.getInstance().getEditorTabPlacement() != 1;
            Insets insets = splitters == null ? super.getBorderInsets(c) : JBUI.insetsTop((int)(paintTop ? 1 : 0));
            if (insets == null) {
                TablessBorder.$$$reportNull$$$0(2);
            }
            return insets;
        }

        private boolean toolWindowIsNotEmpty() {
            if (EditorImpl.this.myProject == null) {
                return false;
            }
            return !ToolWindowManagerEx.getInstanceEx(EditorImpl.this.myProject).getIdsOn(ToolWindowAnchor.TOP).isEmpty();
        }

        public boolean isBorderOpaque() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorImpl$TablessBorder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$TablessBorder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBorderInsets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paintBorder";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @DirtyUI
    private final class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setupCorners();
        }

        public void setUI(ScrollPaneUI ui2) {
            super.setUI(ui2);
            this.setInputMap(1, null);
        }

        public void layout() {
            if (EditorImpl.this.isInDistractionFreeMode()) {
                EditorImpl.this.myGutterComponent.updateSize(true, true);
            }
            super.layout();
        }

        protected void processMouseWheelEvent(@NotNull MouseWheelEvent e) {
            if (e == null) {
                MyScrollPane.$$$reportNull$$$0(0);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            if (EditorImpl.this.mySettings.isWheelFontChangeEnabled() && EditorUtil.isChangeFontSize(e)) {
                int size = EditorImpl.this.myScheme.getEditorFontSize() - e.getWheelRotation();
                if (size >= 8) {
                    EditorImpl.this.setFontSize(size, SwingUtilities.convertPoint((Component)((Object)this), e.getPoint(), this.getViewport()));
                    if (EditorSettingsExternalizable.getInstance().isWheelFontChangePersistent()) {
                        EditorColorsManager.getInstance().getGlobalScheme().setEditorFontSize(size);
                        if (EditorImpl.this.myScheme instanceof MyColorSchemeDelegate) {
                            ((MyColorSchemeDelegate)EditorImpl.this.myScheme).resetEditorFontSize();
                        }
                        ((EditorColorsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorColorsManager.TOPIC)).globalSchemeChange(null);
                    }
                }
                return;
            }
            super.processMouseWheelEvent(e);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return new OpaqueAwareScrollBar(0);
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return new MyScrollBar(1);
        }

        protected void setupCorners() {
            super.setupCorners();
            this.setBorder((Border)((Object)new TablessBorder()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollPane", "processMouseWheelEvent"));
        }
    }

    private class DefaultPopupHandler
    extends ContextMenuPopupHandler {
        private DefaultPopupHandler() {
        }

        @Override
        @Nullable
        public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
            if (event == null) {
                DefaultPopupHandler.$$$reportNull$$$0(0);
            }
            String contextMenuGroupId = EditorImpl.this.myContextMenuGroupId;
            Inlay inlay = event.getInlay();
            if (inlay != null) {
                ActionGroup group2 = inlay.getRenderer().getContextMenuGroup(inlay);
                if (group2 != null) {
                    return group2;
                }
                String inlayContextMenuGroupId = inlay.getRenderer().getContextMenuGroupId(inlay);
                if (inlayContextMenuGroupId != null) {
                    contextMenuGroupId = inlayContextMenuGroupId;
                }
            } else {
                CustomFoldRegion customFoldRegion;
                ActionGroup group3;
                FoldRegion foldRegion = event.getCollapsedFoldRegion();
                if (foldRegion instanceof CustomFoldRegion && (group3 = (customFoldRegion = (CustomFoldRegion)foldRegion).getRenderer().getContextMenuGroup(customFoldRegion)) != null) {
                    return group3;
                }
            }
            return ContextMenuPopupHandler.getGroupForId(contextMenuGroupId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorImpl$DefaultPopupHandler", "getActionGroup"));
        }
    }

    private class EditorDocumentAdapter
    implements PrioritizedDocumentListener {
        private EditorDocumentAdapter() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                EditorDocumentAdapter.$$$reportNull$$$0(0);
            }
            EditorImpl.this.beforeChangedUpdate(e);
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                EditorDocumentAdapter.$$$reportNull$$$0(1);
            }
            EditorImpl.this.changedUpdate(e);
        }

        public void bulkUpdateStarting(@NotNull Document document) {
            if (document == null) {
                EditorDocumentAdapter.$$$reportNull$$$0(2);
            }
            EditorImpl.this.bulkUpdateStarted();
        }

        public void bulkUpdateFinished(@NotNull Document document) {
            if (document == null) {
                EditorDocumentAdapter.$$$reportNull$$$0(3);
            }
            EditorImpl.this.bulkUpdateFinished();
        }

        public int getPriority() {
            return 160;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$EditorDocumentAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bulkUpdateStarting";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bulkUpdateFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        private static EditorImpl getEditor(@NotNull JComponent comp) {
            if (comp == null) {
                MyTransferHandler.$$$reportNull$$$0(0);
            }
            EditorComponentImpl editorComponent = (EditorComponentImpl)comp;
            return editorComponent.getEditor();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Component comp = support.getComponent();
            return comp instanceof JComponent && EditorImpl.handleDrop(MyTransferHandler.getEditor((JComponent)comp), support.getTransferable(), support.getDropAction());
        }

        @Override
        public boolean canImport(@NotNull JComponent comp, DataFlavor @NotNull [] transferFlavors) {
            EditorImpl editor2;
            EditorDropHandler dropHandler;
            if (comp == null) {
                MyTransferHandler.$$$reportNull$$$0(1);
            }
            if (transferFlavors == null) {
                MyTransferHandler.$$$reportNull$$$0(2);
            }
            if ((dropHandler = (editor2 = MyTransferHandler.getEditor(comp)).getDropHandler()) != null && dropHandler.canHandleDrop(transferFlavors)) {
                return true;
            }
            if (Registry.is((String)"debugger.click.disable.breakpoints") && ArrayUtil.contains((Object)GutterDraggableObject.flavor, (Object[])transferFlavors)) {
                return true;
            }
            if (editor2.isViewer()) {
                return false;
            }
            int offset = editor2.getCaretModel().getOffset();
            if (editor2.getDocument().getRangeGuard(offset, offset) != null) {
                return false;
            }
            return ArrayUtil.contains((Object)DataFlavor.stringFlavor, (Object[])transferFlavors);
        }

        @Override
        @Nullable
        protected Transferable createTransferable(JComponent c) {
            EditorImpl editor2 = MyTransferHandler.getEditor(c);
            String s = editor2.getSelectionModel().getSelectedText();
            if (s == null) {
                return null;
            }
            int selectionStart = editor2.getSelectionModel().getSelectionStart();
            int selectionEnd = editor2.getSelectionModel().getSelectionEnd();
            editor2.myDraggedRange = editor2.getDocument().createRangeMarker(selectionStart, selectionEnd);
            Transferable transferable = CopyAction.getSelection(editor2);
            return transferable == null ? new StringSelection(s) : transferable;
        }

        @Override
        public int getSourceActions(@NotNull JComponent c) {
            if (c == null) {
                MyTransferHandler.$$$reportNull$$$0(3);
            }
            return 3;
        }

        @Override
        protected void exportDone(@NotNull JComponent source, @Nullable Transferable data2, int action2) {
            if (source == null) {
                MyTransferHandler.$$$reportNull$$$0(4);
            }
            if (data2 == null) {
                return;
            }
            Component last = DnDManager.getInstance().getLastDropHandler();
            if (last != null && !(last instanceof EditorComponentImpl) && !(last instanceof EditorGutterComponentImpl)) {
                return;
            }
            EditorImpl editor2 = MyTransferHandler.getEditor(source);
            if (action2 == 2 && !editor2.isViewer() && editor2.myDraggedRange != null) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> MyTransferHandler.removeDraggedOutFragment(editor2));
            }
            editor2.clearDnDContext();
        }

        private static void removeDraggedOutFragment(@NotNull EditorImpl editor2) {
            if (editor2 == null) {
                MyTransferHandler.$$$reportNull$$$0(5);
            }
            if (!FileDocumentManager.getInstance().requestWriting((Document)editor2.getDocument(), editor2.getProject())) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(editor2.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                DocumentEx doc = editor2.getDocument();
                doc.startGuardedBlockChecking();
                try {
                    doc.deleteString(editor2.myDraggedRange.getStartOffset(), editor2.myDraggedRange.getEndOffset());
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler((Document)doc).handle(e);
                }
                finally {
                    doc.stopGuardedBlockChecking();
                }
            }), EditorBundle.message((String)"move.selection.command.name", (Object[])new Object[0]), DND_COMMAND_GROUP, UndoConfirmationPolicy.DEFAULT, (Document)editor2.getDocument());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comp";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transferFlavors";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyTransferHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEditor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canImport";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSourceActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportDone";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeDraggedOutFragment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyColorSchemeDelegate
    extends DelegateColorScheme {
        private final FontPreferencesImpl myFontPreferences;
        private final FontPreferencesImpl myConsoleFontPreferences;
        private final Map<TextAttributesKey, TextAttributes> myOwnAttributes;
        private final Map<ColorKey, Color> myOwnColors;
        private final EditorColorsScheme myCustomGlobalScheme;
        private Map<EditorFontType, Font> myFontsMap;
        private int myMaxFontSize;
        private int myFontSize;
        private int myConsoleFontSize;
        private String myFaceName;
        private Float myLineSpacing;
        private boolean myFontPreferencesAreSetExplicitly;

        private MyColorSchemeDelegate(EditorColorsScheme globalScheme) {
            super(globalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : globalScheme);
            this.myFontPreferences = new FontPreferencesImpl();
            this.myConsoleFontPreferences = new FontPreferencesImpl();
            this.myOwnAttributes = new HashMap<TextAttributesKey, TextAttributes>();
            this.myOwnColors = new HashMap<ColorKey, Color>();
            this.myMaxFontSize = EditorFontsConstants.getMaxEditorFontSize();
            this.myFontSize = -1;
            this.myConsoleFontSize = -1;
            this.myCustomGlobalScheme = globalScheme;
            this.updateGlobalScheme();
        }

        private void reinitFonts() {
            EditorColorsScheme delegate2 = this.getDelegate();
            String editorFontName = this.getEditorFontName();
            int editorFontSize = this.getEditorFontSize();
            if (!this.myFontPreferencesAreSetExplicitly) {
                this.updatePreferences(this.myFontPreferences, editorFontName, editorFontSize, delegate2 == null ? null : delegate2.getFontPreferences());
            }
            String consoleFontName = this.getConsoleFontName();
            int consoleFontSize = this.getConsoleFontSize();
            this.updatePreferences(this.myConsoleFontPreferences, consoleFontName, consoleFontSize, delegate2 == null ? null : delegate2.getConsoleFontPreferences());
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            this.setFont(EditorFontType.PLAIN, editorFontName, 0, editorFontSize, (FontPreferences)this.myFontPreferences);
            this.setFont(EditorFontType.BOLD, editorFontName, 1, editorFontSize, (FontPreferences)this.myFontPreferences);
            this.setFont(EditorFontType.ITALIC, editorFontName, 2, editorFontSize, (FontPreferences)this.myFontPreferences);
            this.setFont(EditorFontType.BOLD_ITALIC, editorFontName, 3, editorFontSize, (FontPreferences)this.myFontPreferences);
            this.setFont(EditorFontType.CONSOLE_PLAIN, consoleFontName, 0, consoleFontSize, (FontPreferences)this.myConsoleFontPreferences);
            this.setFont(EditorFontType.CONSOLE_BOLD, consoleFontName, 1, consoleFontSize, (FontPreferences)this.myConsoleFontPreferences);
            this.setFont(EditorFontType.CONSOLE_ITALIC, consoleFontName, 2, consoleFontSize, (FontPreferences)this.myConsoleFontPreferences);
            this.setFont(EditorFontType.CONSOLE_BOLD_ITALIC, consoleFontName, 3, consoleFontSize, (FontPreferences)this.myConsoleFontPreferences);
        }

        private void setFont(@NotNull EditorFontType fontType, @NotNull String familyName, int style, int fontSize, @NotNull FontPreferences fontPreferences) {
            if (fontType == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(0);
            }
            if (familyName == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(1);
            }
            if (fontPreferences == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(2);
            }
            Font baseFont = FontFamilyService.getFont(familyName, fontPreferences.getRegularSubFamily(), fontPreferences.getBoldSubFamily(), style, fontSize);
            this.myFontsMap.put(fontType, EditorFontCacheImpl.deriveFontWithLigatures(baseFont, fontPreferences.useLigatures()));
        }

        private void updatePreferences(@NotNull FontPreferencesImpl preferences, @NotNull String fontName, int fontSize, @Nullable FontPreferences delegatePreferences) {
            if (preferences == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(3);
            }
            if (fontName == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(4);
            }
            preferences.clear();
            preferences.register(fontName, fontSize);
            if (delegatePreferences != null) {
                boolean first = true;
                for (String font : delegatePreferences.getRealFontFamilies()) {
                    if (!first) {
                        preferences.register(font, fontSize);
                    }
                    first = false;
                }
            }
            preferences.setUseLigatures(delegatePreferences != null && delegatePreferences.useLigatures());
            preferences.setRegularSubFamily(delegatePreferences == null ? null : delegatePreferences.getRegularSubFamily());
            preferences.setBoldSubFamily(delegatePreferences == null ? null : delegatePreferences.getBoldSubFamily());
        }

        private void reinitFontsAndSettings() {
            this.reinitFonts();
            EditorImpl.this.reinitSettings();
        }

        @Override
        public TextAttributes getAttributes(TextAttributesKey key) {
            if (this.myOwnAttributes.containsKey(key)) {
                return this.myOwnAttributes.get(key);
            }
            return this.getDelegate().getAttributes(key);
        }

        @Override
        public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes2) {
            if (key == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(5);
            }
            this.myOwnAttributes.put(key, attributes2);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key) {
            if (this.myOwnColors.containsKey(key)) {
                return this.myOwnColors.get(key);
            }
            return this.getDelegate().getColor(key);
        }

        @Override
        public void setColor(ColorKey key, Color color) {
            if (color == AbstractColorsScheme.INHERITED_COLOR_MARKER) {
                this.myOwnColors.remove(key);
            } else {
                this.myOwnColors.put(key, color);
            }
            EditorImpl.this.myCaretModel.reinitSettings();
            EditorImpl.this.mySelectionModel.reinitSettings();
        }

        @Override
        public int getEditorFontSize() {
            if (this.myFontPreferencesAreSetExplicitly) {
                return this.myFontPreferences.getSize(this.myFontPreferences.getFontFamily());
            }
            if (this.myFontSize == -1) {
                return this.getDelegate().getEditorFontSize();
            }
            return this.myFontSize;
        }

        @Override
        public void setEditorFontSize(int fontSize) {
            if (fontSize < 8) {
                fontSize = 8;
            }
            if (fontSize > this.myMaxFontSize) {
                fontSize = this.myMaxFontSize;
            }
            if (fontSize == this.myFontSize) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Font size overridden for " + EditorImpl.this, new Throwable());
            }
            this.myFontPreferencesAreSetExplicitly = false;
            this.myFontSize = fontSize;
            this.reinitFontsAndSettings();
        }

        void resetEditorFontSize() {
            this.myFontSize = -1;
            this.reinitFonts();
        }

        @Override
        @NotNull
        public FontPreferences getFontPreferences() {
            FontPreferencesImpl fontPreferencesImpl = !this.myFontPreferencesAreSetExplicitly && this.myFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getFontPreferences() : this.myFontPreferences;
            if (fontPreferencesImpl == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(6);
            }
            return fontPreferencesImpl;
        }

        @Override
        public void setFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(7);
            }
            if (this.myFontPreferencesAreSetExplicitly && Comparing.equal((Object)preferences, (Object)((Object)this.myFontPreferences))) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Font preferences overridden for " + EditorImpl.this, new Throwable());
            }
            this.myFontPreferencesAreSetExplicitly = true;
            this.myFaceName = null;
            this.myFontSize = -1;
            preferences.copyTo((FontPreferences)this.myFontPreferences);
            this.reinitFontsAndSettings();
        }

        @Override
        @NotNull
        public FontPreferences getConsoleFontPreferences() {
            FontPreferencesImpl fontPreferencesImpl = this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty() ? this.getDelegate().getConsoleFontPreferences() : this.myConsoleFontPreferences;
            if (fontPreferencesImpl == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(8);
            }
            return fontPreferencesImpl;
        }

        @Override
        public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(9);
            }
            if (Comparing.equal((Object)preferences, (Object)((Object)this.myConsoleFontPreferences))) {
                return;
            }
            preferences.copyTo((FontPreferences)this.myConsoleFontPreferences);
            this.reinitFontsAndSettings();
        }

        @Override
        public String getEditorFontName() {
            if (this.myFontPreferencesAreSetExplicitly) {
                return this.myFontPreferences.getFontFamily();
            }
            if (this.myFaceName == null) {
                return this.getDelegate().getEditorFontName();
            }
            return this.myFaceName;
        }

        @Override
        public void setEditorFontName(String fontName) {
            if (Objects.equals(fontName, this.myFaceName)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Font name overridden for " + EditorImpl.this, new Throwable());
            }
            this.myFontPreferencesAreSetExplicitly = false;
            this.myFaceName = fontName;
            this.reinitFontsAndSettings();
        }

        @Override
        @NotNull
        public Font getFont(EditorFontType key) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key)) != null) {
                Font font2 = font;
                if (font2 == null) {
                    MyColorSchemeDelegate.$$$reportNull$$$0(10);
                }
                return font2;
            }
            Font font3 = this.getDelegate().getFont(key);
            if (font3 == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(11);
            }
            return font3;
        }

        @Override
        public void setFont(EditorFontType key, Font font) {
            if (this.myFontsMap == null) {
                this.reinitFontsAndSettings();
            }
            this.myFontsMap.put(key, font);
            EditorImpl.this.reinitSettings();
        }

        @Override
        @Nullable
        public Object clone() {
            return null;
        }

        private void updateGlobalScheme() {
            this.setDelegate(this.myCustomGlobalScheme == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.myCustomGlobalScheme);
        }

        @Override
        public void setDelegate(@NotNull EditorColorsScheme delegate2) {
            if (delegate2 == null) {
                MyColorSchemeDelegate.$$$reportNull$$$0(12);
            }
            super.setDelegate(delegate2);
            int globalFontSize = this.getDelegate().getEditorFontSize();
            this.myMaxFontSize = Math.max(EditorFontsConstants.getMaxEditorFontSize(), globalFontSize);
            this.reinitFonts();
        }

        @Override
        public void setConsoleFontSize(int fontSize) {
            this.myConsoleFontSize = fontSize;
            this.reinitFontsAndSettings();
        }

        @Override
        public int getConsoleFontSize() {
            return this.myConsoleFontSize == -1 ? super.getConsoleFontSize() : this.myConsoleFontSize;
        }

        @Override
        public float getLineSpacing() {
            return this.myLineSpacing == null ? super.getLineSpacing() : this.myLineSpacing.floatValue();
        }

        @Override
        public void setLineSpacing(float lineSpacing) {
            float oldLineSpacing = this.getLineSpacing();
            float newLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
            this.myLineSpacing = Float.valueOf(newLineSpacing);
            if (oldLineSpacing != newLineSpacing) {
                EditorImpl.this.reinitSettings();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fontType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fontPreferences";
                    break;
                }
                case 3: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferences";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fontName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyColorSchemeDelegate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFontPreferences";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConsoleFontPreferences";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFont";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setFont";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePreferences";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setAttributes";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setFontPreferences";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setConsoleFontPreferences";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setDelegate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        @DirtyUI
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseMotionListener.$$$reportNull$$$0(0);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            if (EditorImpl.this.myDraggedRange != null || EditorImpl.this.myGutterComponent.myDnDInProgress) {
                return;
            }
            EditorImpl.this.validateMousePointer(e, null);
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            for (EditorMouseMotionListener listener2 : EditorImpl.this.myMouseMotionListeners) {
                listener2.mouseDragged(event);
                if (!EditorImpl.this.isReleased) continue;
                return;
            }
            ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> EditorImpl.this.runMouseDraggedCommand(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseDragged(e);
            }
        }

        @Override
        @DirtyUI
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseMotionListener.$$$reportNull$$$0(1);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            if (EditorImpl.this.getMouseSelectionState() != 0) {
                if (EditorImpl.this.myMousePressedEvent != null && EditorImpl.this.myMousePressedEvent.getComponent() == e.getComponent()) {
                    Point lastPoint = EditorImpl.this.myMousePressedEvent.getPoint();
                    Point point = e.getPoint();
                    int deadZone = Registry.intValue((String)"editor.mouseSelectionStateResetDeadZone");
                    if (Math.abs(lastPoint.x - point.x) >= deadZone || Math.abs(lastPoint.y - point.y) >= deadZone) {
                        EditorImpl.this.resetMouseSelectionState(e, event);
                    }
                } else {
                    EditorImpl.this.validateMousePointer(e, event);
                }
            } else {
                EditorImpl.this.validateMousePointer(e, event);
            }
            EditorImpl.this.myMouseMovedEvent = e;
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                EditorImpl.this.myGutterComponent.mouseMoved(e);
            }
            for (EditorMouseMotionListener listener2 : EditorImpl.this.myMouseMotionListeners) {
                listener2.mouseMoved(event);
                if (!EditorImpl.this.isReleased) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyMouseMotionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseDragged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(0);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            EditorImpl.this.requestFocus();
            this.runMousePressedCommand(e);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(1);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            EditorImpl.this.myMousePressArea = null;
            EditorImpl.this.myLastMousePressedLocation = null;
            this.runMouseReleasedCommand(e);
            if (!e.isConsumed() && EditorImpl.this.myMousePressedEvent != null && !EditorImpl.this.myMousePressedEvent.isConsumed() && Math.abs(e.getX() - EditorImpl.this.myMousePressedEvent.getX()) < EditorUtil.getSpaceWidth(0, EditorImpl.this) && Math.abs(e.getY() - EditorImpl.this.myMousePressedEvent.getY()) < EditorImpl.this.getLineHeight()) {
                this.runMouseClickedCommand(e);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(2);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            this.runMouseEnteredCommand(e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(3);
            }
            if (EVENT_LOG.isDebugEnabled()) {
                EVENT_LOG.debug(e.toString());
            }
            this.runMouseExitedCommand(e);
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseExited(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runMousePressedCommand(@NotNull MouseEvent e) {
            InputContext inputContext;
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(4);
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            EditorImpl.this.myLastPressWasAtBlockInlay = false;
            EditorImpl.this.myLastMousePressedLocation = event.getLogicalPosition();
            EditorImpl.this.myCaretStateBeforeLastPress = EditorImpl.isToggleCaretEvent(e) ? EditorImpl.this.myCaretModel.getCaretsAndSelections() : Collections.emptyList();
            EditorImpl.this.myCurrentDragIsSubstantial = false;
            EditorImpl.this.myDragStarted = false;
            EditorImpl.this.clearDnDContext();
            EditorImpl.this.myMousePressedEvent = e;
            EditorImpl.this.myExpectedCaretOffset = event.getOffset();
            try {
                for (EditorMouseListener mouseListener : EditorImpl.this.myMouseListeners) {
                    mouseListener.mousePressed(event);
                    if (!EditorImpl.this.isReleased) continue;
                    return;
                }
            }
            finally {
                EditorImpl.this.myExpectedCaretOffset = -1;
            }
            if (EditorImpl.this.composedTextExists() && (inputContext = EditorImpl.this.myEditorComponent.getInputContext()) != null) {
                inputContext.endComposition();
            }
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA || event.getArea() == EditorMouseEventArea.FOLDING_OUTLINE_AREA && !EditorImpl.this.isInsideGutterWhitespaceArea(e)) {
                EditorImpl.this.myDragOnGutterSelectionStartLine = EditorUtil.yPositionToLogicalLine((Editor)EditorImpl.this, e);
            }
            if (event.isConsumed()) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable2 = () -> {
                    if (this.processMousePressed(e) && EditorImpl.this.myProject != null && !EditorImpl.this.myProject.isDefault()) {
                        IdeDocumentHistory.getInstance(EditorImpl.this.myProject).includeCurrentCommandAsNavigation();
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                this.processMousePressed(e);
            }
            EditorImpl.this.invokePopupIfNeeded(event);
        }

        private void runMouseClickedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(5);
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseClicked(event);
                if (!EditorImpl.this.isReleased && !event.isConsumed()) continue;
                return;
            }
        }

        private void runMouseReleasedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(6);
            }
            EditorImpl.this.myMultiSelectionInProgress = false;
            EditorImpl.this.myDragOnGutterSelectionStartLine = -1;
            EditorImpl.this.myScrollingTimer.stop();
            if (e.isConsumed()) {
                return;
            }
            EditorMouseEvent event = EditorImpl.this.createEditorMouseEvent(e);
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseReleased(event);
                if (!EditorImpl.this.isReleased && !event.isConsumed()) continue;
                return;
            }
            EditorImpl.this.invokePopupIfNeeded(event);
            if (event.isConsumed()) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable2 = () -> EditorImpl.this.processMouseReleased(e);
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable2, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            } else {
                EditorImpl.this.processMouseReleased(e);
            }
        }

        private void runMouseEnteredCommand(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(7);
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseEntered(event);
                if (EditorImpl.this.isReleased) {
                    return;
                }
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseExitedCommand(@NotNull MouseEvent e) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(8);
            }
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener2 : EditorImpl.this.myMouseListeners) {
                listener2.mouseExited(event);
                if (EditorImpl.this.isReleased) {
                    return;
                }
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private boolean processMousePressed(@NotNull MouseEvent e) {
            boolean isNavigation;
            boolean moveCaret;
            FoldRegion range2;
            EditorMouseEventArea eventArea;
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(9);
            }
            EditorImpl.this.myInitialMouseEvent = e;
            if (EditorImpl.this.myMouseSelectionState != 0 && System.currentTimeMillis() - EditorImpl.this.myMouseSelectionChangeTimestamp > (long)Registry.intValue((String)"editor.mouseSelectionStateResetTimeout")) {
                EditorImpl.this.resetMouseSelectionState(e, null);
            }
            int x = e.getX();
            int y = e.getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            EditorImpl.this.myMousePressArea = eventArea = EditorImpl.this.getMouseEventArea(e);
            if (eventArea == EditorMouseEventArea.FOLDING_OUTLINE_AREA && (range2 = EditorImpl.this.myGutterComponent.findFoldingAnchorAt(x, y)) != null) {
                boolean expansion = !range2.isExpanded();
                UIEventLogger.EditorFoldingIconClicked.log((Object)expansion, (Object)e.isAltDown());
                int scrollShift = expansion ? 0 : EditorImpl.this.visualLineToY(EditorImpl.this.yToVisualLine(y)) - EditorImpl.this.getScrollingModel().getVerticalScrollOffset();
                EditorImpl.this.getFoldingModel().runBatchFoldingOperation(() -> {
                    range2.setExpanded(expansion);
                    if (e.isAltDown()) {
                        for (FoldRegion region : EditorImpl.this.myFoldingModel.getAllFoldRegions()) {
                            if (region.getStartOffset() < range2.getStartOffset() || region.getEndOffset() > range2.getEndOffset()) continue;
                            region.setExpanded(expansion);
                        }
                    }
                }, true, false);
                if (!expansion) {
                    int newY = EditorImpl.this.visualLineToY(EditorImpl.this.offsetToVisualLine(range2.getStartOffset()));
                    EditorUtil.runWithAnimationDisabled(EditorImpl.this, () -> EditorImpl.this.myScrollingModel.scrollVertically(newY - scrollShift));
                }
                EditorImpl.this.myGutterComponent.updateSize();
                EditorImpl.this.validateMousePointer(e, null);
                e.consume();
                return false;
            }
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                if (!EditorImpl.this.tweakSelectionIfNecessary(e)) {
                    EditorImpl.this.myGutterComponent.mousePressed(e);
                }
                if (e.isConsumed()) {
                    return false;
                }
                x = 0;
            }
            Caret selectionCaret = null;
            int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
            int oldStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int oldEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            LogicalPosition oldBlockStart = null;
            if (EditorImpl.this.isColumnMode()) {
                @NotNull List<CaretState> caretsAndSelections = EditorImpl.this.getCaretModel().getCaretsAndSelections();
                CaretState originalCaret = caretsAndSelections.get(0);
                oldBlockStart = Objects.equals(originalCaret.getCaretPosition(), originalCaret.getSelectionEnd()) ? originalCaret.getSelectionStart() : originalCaret.getSelectionEnd();
            }
            boolean toggleCaret = e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isToggleCaretEvent(e);
            boolean lastPressCreatedCaret = EditorImpl.this.myLastPressCreatedCaret;
            if (e.getClickCount() == 1) {
                EditorImpl.this.myLastPressCreatedCaret = false;
            }
            EditorImpl.this.myLastPressWasAtBlockInlay = eventArea == EditorMouseEventArea.EDITING_AREA && EditorImpl.this.hasBlockInlay(e.getPoint());
            boolean bl = moveCaret = eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA && !ExperimentalUI.isNewUI() || EditorImpl.this.isInsideGutterWhitespaceArea(e) || eventArea == EditorMouseEventArea.EDITING_AREA && !EditorImpl.this.myLastPressWasAtBlockInlay;
            if (moveCaret) {
                VisualPosition visualPosition = EditorImpl.this.getTargetPosition(x, y, true);
                LogicalPosition pos = EditorImpl.this.visualToLogicalPosition(visualPosition);
                if (toggleCaret) {
                    Caret caret = EditorImpl.this.getCaretModel().getCaretAt(visualPosition);
                    if (e.getClickCount() == 1) {
                        if (caret == null) {
                            EditorImpl.this.myLastPressCreatedCaret = !EditorUtil.checkMaxCarets(EditorImpl.this) && EditorImpl.this.getCaretModel().addCaret(visualPosition) != null;
                        } else {
                            EditorImpl.this.getCaretModel().removeCaret(caret);
                        }
                    } else if (e.getClickCount() == 3 && lastPressCreatedCaret) {
                        EditorImpl.this.getCaretModel().moveToVisualPosition(visualPosition);
                    }
                } else if (e.getSource() != EditorImpl.this.myGutterComponent && EditorImpl.isCreateRectangularSelectionEvent(e)) {
                    LogicalPosition anchor2;
                    CaretState anchorCaretState = EditorImpl.this.myCaretModel.getCaretsAndSelections().get(0);
                    LogicalPosition logicalPosition = anchor2 = Objects.equals(anchorCaretState.getCaretPosition(), anchorCaretState.getSelectionStart()) ? anchorCaretState.getSelectionEnd() : anchorCaretState.getSelectionStart();
                    if (anchor2 == null) {
                        anchor2 = EditorImpl.this.myCaretModel.getLogicalPosition();
                    }
                    EditorImpl.this.mySelectionModel.setBlockSelection(anchor2, pos);
                } else {
                    Caret caret = selectionCaret = eventArea == EditorMouseEventArea.EDITING_AREA && SwingUtilities.isRightMouseButton(e) && EditorImpl.this.getCaretModel().getCaretCount() > 1 ? this.getSelectionCaret(pos) : null;
                    if (selectionCaret == null) {
                        EditorImpl.this.getCaretModel().removeSecondaryCarets();
                        EditorImpl.this.getCaretModel().moveToVisualPosition(visualPosition);
                    } else {
                        selectionCaret.moveToVisualPosition(visualPosition);
                    }
                }
            }
            if (e.isPopupTrigger()) {
                return false;
            }
            EditorImpl.this.requestFocus();
            int caretOffset = EditorImpl.this.getCaretModel().getOffset();
            int newStart = EditorImpl.this.mySelectionModel.getSelectionStart();
            int newEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
            Point p = new Point(x, y);
            EditorImpl.this.myMouseSelectedRegion = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(p);
            EditorImpl.this.myKeepSelectionOnMousePress = selectionCaret != null || EditorImpl.this.mySelectionModel.hasSelection() && caretOffset >= EditorImpl.this.mySelectionModel.getSelectionStart() && caretOffset <= EditorImpl.this.mySelectionModel.getSelectionEnd() && !this.isPointAfterSelectionEnd(p) && (SwingUtilities.isLeftMouseButton(e) && EditorImpl.this.mySettings.isDndEnabled() || SwingUtilities.isRightMouseButton(e));
            boolean bl2 = isNavigation = oldStart == oldEnd && newStart == newEnd && oldStart != newStart;
            if (EditorImpl.this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA && e.getClickCount() == 1) {
                if (ExperimentalUI.isNewUI()) {
                    return false;
                }
                EditorImpl.this.selectLineAtCaret(true);
                return isNavigation;
            }
            if (moveCaret) {
                if (e.isShiftDown() && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown()) {
                    if (oldBlockStart != null) {
                        EditorImpl.this.mySelectionModel.setBlockSelection(oldBlockStart, EditorImpl.this.getCaretModel().getLogicalPosition());
                    } else {
                        int startToUse;
                        if (EditorImpl.this.getMouseSelectionState() != 0) {
                            startToUse = caretOffset < EditorImpl.this.mySavedSelectionStart ? EditorImpl.this.mySavedSelectionEnd : EditorImpl.this.mySavedSelectionStart;
                        } else {
                            startToUse = oldSelectionStart;
                            if (EditorImpl.this.mySelectionModel.isUnknownDirection() && caretOffset > startToUse) {
                                startToUse = Math.min(oldStart, oldEnd);
                            }
                        }
                        EditorImpl.this.mySelectionModel.setSelection(startToUse, caretOffset);
                    }
                } else if (!EditorImpl.this.myKeepSelectionOnMousePress && EditorImpl.this.getSelectionModel().hasSelection() && !EditorImpl.isCreateRectangularSelectionEvent(e) && e.getClickCount() == 1) {
                    if (!toggleCaret) {
                        EditorImpl.this.setMouseSelectionState(0);
                        EditorImpl.this.mySelectionModel.setSelection(caretOffset, caretOffset);
                    }
                } else if (!(e.getButton() != 1 || eventArea != EditorMouseEventArea.EDITING_AREA && eventArea != EditorMouseEventArea.LINE_NUMBERS_AREA || toggleCaret && !lastPressCreatedCaret || EditorImpl.this.myMouseSelectedRegion instanceof CustomFoldRegion)) {
                    switch (e.getClickCount()) {
                        case 2: {
                            EditorImpl.this.selectWordAtCaret(EditorImpl.this.mySettings.isMouseClickSelectionHonorsCamelWords() && EditorImpl.this.mySettings.isCamelWords());
                            break;
                        }
                        case 3: {
                            if (eventArea == EditorMouseEventArea.EDITING_AREA && HONOR_CAMEL_HUMPS_ON_TRIPLE_CLICK && EditorImpl.this.mySettings.isCamelWords()) {
                                EditorImpl.this.selectWordAtCaret(false);
                                break;
                            }
                        }
                        case 4: {
                            EditorImpl.this.selectLineAtCaret(false);
                            EditorImpl.this.mySelectionModel.setUnknownDirection(true);
                        }
                    }
                }
            }
            return isNavigation;
        }

        private boolean isPointAfterSelectionEnd(@NotNull Point p) {
            if (p == null) {
                MyMouseAdapter.$$$reportNull$$$0(10);
            }
            VisualPosition selectionEndPosition = EditorImpl.this.myCaretModel.getCurrentCaret().getSelectionEndPosition();
            Point selectionEnd = EditorImpl.this.visualPositionToXY(selectionEndPosition);
            return p.y >= selectionEnd.y + EditorImpl.this.getLineHeight() || p.y >= selectionEnd.y && p.x > selectionEnd.x && EditorImpl.this.xyToVisualPosition((Point)p).column > selectionEndPosition.column;
        }

        private Caret getSelectionCaret(LogicalPosition logicalPosition) {
            int offset = EditorImpl.this.logicalPositionToOffset(logicalPosition);
            for (Caret caret : EditorImpl.this.getCaretModel().getAllCarets()) {
                if (offset < caret.getSelectionStart() || offset > caret.getSelectionEnd()) continue;
                return caret;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyMouseAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMousePressedCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMouseClickedCommand";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMouseReleasedCommand";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMouseEnteredCommand";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runMouseExitedCommand";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processMousePressed";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPointAfterSelectionEnd";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyInputMethodHandler
    implements InputMethodRequests {
        private String composedText;
        private ProperTextRange composedTextRange;

        private MyInputMethodHandler() {
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(TextHitInfo offset) {
            if (EditorImpl.this.isDisposed()) {
                return new Rectangle();
            }
            Point caret = EditorImpl.this.logicalPositionToXY(EditorImpl.this.getCaretModel().getLogicalPosition());
            Rectangle r = new Rectangle(caret, new Dimension(1, EditorImpl.this.getLineHeight()));
            Point p = this.getLocationOnScreen(EditorImpl.this.getContentComponent());
            r.translate(p.x, p.y);
            Rectangle rectangle = r;
            if (rectangle == null) {
                MyInputMethodHandler.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            if (this.composedText != null) {
                Point p = this.getLocationOnScreen(EditorImpl.this.getContentComponent());
                p.x = x - p.x;
                p.y = y - p.y;
                int pos = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.xyToLogicalPosition(p));
                if (this.composedTextRange.containsOffset(pos)) {
                    return TextHitInfo.leading(pos - this.composedTextRange.getStartOffset());
                }
            }
            return null;
        }

        private Point getLocationOnScreen(Component component2) {
            Point location = new Point();
            SwingUtilities.convertPointToScreen(location, component2);
            if (LOG.isDebugEnabled() && !component2.isShowing()) {
                Container parent;
                Class<?> type = component2.getClass();
                for (parent = component2.getParent(); parent != null && !parent.isShowing(); parent = parent.getParent()) {
                    type = parent.getClass();
                }
                String message2 = type.getName() + " is not showing";
                if (parent != null) {
                    message2 = message2 + " on visible  " + parent.getClass().getName();
                }
                LOG.debug(message2);
            }
            return location;
        }

        @Override
        public int getInsertPositionOffset() {
            int caretIndex;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextRange.getStartOffset();
                composedEndIndex = this.composedTextRange.getEndOffset();
            }
            if ((caretIndex = EditorImpl.this.getCaretModel().getOffset()) < composedStartIndex) {
                return caretIndex;
            }
            if (caretIndex < composedEndIndex) {
                return composedStartIndex;
            }
            return caretIndex - (composedEndIndex - composedStartIndex);
        }

        @NotNull
        private String getText(int startIdx, int endIdx) {
            if (startIdx >= 0 && endIdx > startIdx) {
                CharSequence chars = EditorImpl.this.getDocument().getImmutableCharSequence();
                String string = chars.subSequence(startIdx, endIdx).toString();
                if (string == null) {
                    MyInputMethodHandler.$$$reportNull$$$0(1);
                }
                return string;
            }
            return "";
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes2) {
            Object committed;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextRange.getStartOffset();
                composedEndIndex = this.composedTextRange.getEndOffset();
            }
            if (beginIndex < composedStartIndex) {
                if (endIndex <= composedStartIndex) {
                    committed = this.getText(beginIndex, endIndex - beginIndex);
                } else {
                    int firstPartLength = composedStartIndex - beginIndex;
                    committed = this.getText(beginIndex, firstPartLength) + this.getText(composedEndIndex, endIndex - beginIndex - firstPartLength);
                }
            } else {
                committed = this.getText(beginIndex + composedEndIndex - composedStartIndex, endIndex - beginIndex);
            }
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString((String)committed).getIterator();
            if (attributedCharacterIterator == null) {
                MyInputMethodHandler.$$$reportNull$$$0(2);
            }
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            int length = EditorImpl.this.getDocument().getTextLength();
            if (this.composedText != null) {
                length -= this.composedText.length();
            }
            return length;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes2) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes2) {
            String text2;
            if (EditorImpl.this.myCharKeyPressed) {
                EditorImpl.this.myNeedToSelectPreviousChar = true;
            }
            return (text2 = EditorImpl.this.getSelectionModel().getSelectedText()) == null ? null : new AttributedString(text2).getIterator();
        }

        private String createComposedString(int composedIndex, @NotNull AttributedCharacterIterator text2) {
            if (text2 == null) {
                MyInputMethodHandler.$$$reportNull$$$0(3);
            }
            StringBuilder strBuf = new StringBuilder();
            char c = text2.setIndex(composedIndex);
            while (c != '\uffff') {
                strBuf.append(c);
                c = text2.next();
            }
            return strBuf.toString();
        }

        private void setInputMethodCaretPosition(@NotNull InputMethodEvent e) {
            if (e == null) {
                MyInputMethodHandler.$$$reportNull$$$0(4);
            }
            if (this.composedText != null) {
                int dot = this.composedTextRange.getStartOffset();
                TextHitInfo caretPos = e.getCaret();
                if (caretPos != null) {
                    dot += caretPos.getInsertionIndex();
                }
                EditorImpl.this.getCaretModel().moveToOffset(dot);
                EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private void runUndoTransparent(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                MyInputMethodHandler.$$$reportNull$$$0(5);
            }
            CommandProcessor.getInstance().runUndoTransparentAction(() -> CommandProcessor.getInstance().executeCommand(EditorImpl.this.myProject, () -> ApplicationManager.getApplication().runWriteAction(runnable2), "", (Object)EditorImpl.this.getDocument(), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument()));
        }

        private boolean hasRelevantCommittedText(@NotNull InputMethodEvent e) {
            if (e == null) {
                MyInputMethodHandler.$$$reportNull$$$0(6);
            }
            if (e.getCommittedCharacterCount() <= 0) {
                return false;
            }
            AttributedCharacterIterator text2 = e.getText();
            return text2 == null || text2.first() != '\u00a5';
        }

        private void replaceInputMethodText(@NotNull InputMethodEvent e) {
            if (e == null) {
                MyInputMethodHandler.$$$reportNull$$$0(7);
            }
            if (EditorImpl.this.myNeedToSelectPreviousChar && SystemInfo.isMac && (Registry.is((String)"ide.mac.pressAndHold.brute.workaround") || Registry.is((String)"ide.mac.pressAndHold.workaround") && (this.hasRelevantCommittedText(e) || e.getCaret() == null))) {
                EditorImpl.this.myNeedToSelectPreviousChar = false;
                EditorImpl.this.getCaretModel().runForEachCaret(caret -> {
                    int caretOffset = caret.getOffset();
                    if (caretOffset > 0) {
                        caret.setSelection(caretOffset - 1, caretOffset);
                    }
                });
            }
            boolean isCaretMoved = false;
            int caretPositionToRestore = 0;
            int commitCount = e.getCommittedCharacterCount();
            AttributedCharacterIterator text2 = e.getText();
            DocumentEx doc = EditorImpl.this.getDocument();
            if (this.composedText != null) {
                if (!EditorImpl.this.isViewer() && doc.isWritable()) {
                    this.runUndoTransparent(() -> {
                        int docLength = doc.getTextLength();
                        ProperTextRange range2 = this.composedTextRange.intersection(new TextRange(0, docLength));
                        if (range2 != null) {
                            doc.deleteString(range2.getStartOffset(), range2.getEndOffset());
                        }
                    });
                    boolean bl = isCaretMoved = EditorImpl.this.getCaretModel().getOffset() != this.composedTextRange.getStartOffset();
                    if (isCaretMoved) {
                        caretPositionToRestore = EditorImpl.this.getCaretModel().getCurrentCaret().getOffset();
                        if (caretPositionToRestore > this.composedTextRange.getStartOffset()) {
                            caretPositionToRestore += commitCount;
                        }
                        EditorImpl.this.getCaretModel().moveToOffset(this.composedTextRange.getStartOffset());
                    }
                }
                this.composedText = null;
            }
            if (text2 != null) {
                int composedTextIndex;
                text2.first();
                if (commitCount > 0) {
                    char c = text2.current();
                    while (c != '\uffff' && commitCount > 0) {
                        if (c >= ' ' && c != '\u007f') {
                            EditorImpl.this.processKeyTyped(c);
                        }
                        c = text2.next();
                        --commitCount;
                    }
                }
                if (!EditorImpl.this.isViewer() && doc.isWritable() && (composedTextIndex = text2.getIndex()) < text2.getEndIndex()) {
                    String composedString = this.createComposedString(composedTextIndex, text2);
                    this.runUndoTransparent(() -> EditorModificationUtilEx.insertStringAtCaret((Editor)EditorImpl.this, (String)composedString, (boolean)false, (boolean)false));
                    this.composedText = composedString;
                    this.composedTextRange = ProperTextRange.from((int)EditorImpl.this.getCaretModel().getOffset(), (int)composedString.length());
                }
            }
            if (isCaretMoved) {
                EditorImpl.this.getCaretModel().moveToOffset(caretPositionToRestore);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextLocation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommittedText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createComposedString";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setInputMethodCaretPosition";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "runUndoTransparent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "hasRelevantCommittedText";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceInputMethodText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyInputMethodHandleSwingThreadWrapper
    implements InputMethodRequests {
        private final InputMethodRequests myDelegate;

        private MyInputMethodHandleSwingThreadWrapper(InputMethodRequests delegate2) {
            this.myDelegate = delegate2;
        }

        @Override
        @NotNull
        public Rectangle getTextLocation(TextHitInfo offset) {
            Rectangle rectangle = (Rectangle)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getTextLocation(offset));
            if (rectangle == null) {
                MyInputMethodHandleSwingThreadWrapper.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        @Override
        public TextHitInfo getLocationOffset(int x, int y) {
            return (TextHitInfo)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getLocationOffset(x, y));
        }

        @Override
        public int getInsertPositionOffset() {
            return (Integer)MyInputMethodHandleSwingThreadWrapper.execute(this.myDelegate::getInsertPositionOffset);
        }

        @Override
        @NotNull
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes2) {
            AttributedCharacterIterator attributedCharacterIterator = (AttributedCharacterIterator)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getCommittedText(beginIndex, endIndex, attributes2));
            if (attributedCharacterIterator == null) {
                MyInputMethodHandleSwingThreadWrapper.$$$reportNull$$$0(1);
            }
            return attributedCharacterIterator;
        }

        @Override
        public int getCommittedTextLength() {
            return (Integer)MyInputMethodHandleSwingThreadWrapper.execute(this.myDelegate::getCommittedTextLength);
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes2) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes2) {
            return (AttributedCharacterIterator)MyInputMethodHandleSwingThreadWrapper.execute(() -> this.myDelegate.getSelectedText(attributes2));
        }

        private static <T> T execute(@NotNull Computable<T> computable) {
            if (computable == null) {
                MyInputMethodHandleSwingThreadWrapper.$$$reportNull$$$0(2);
            }
            return (T)UIUtil.invokeAndWaitIfNeeded(computable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandleSwingThreadWrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextLocation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommittedText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyInputMethodHandleSwingThreadWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider,
    DeleteProvider,
    DumbAware {
        private MyEditable() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(0);
            }
            this.executeAction("EditorCopy", dataContext);
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(1);
            }
            return true;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(2);
            }
            Caret caret = (Caret)dataContext.getData(CommonDataKeys.CARET);
            return PlatformUtils.isDataGrip() && caret != null ? EditorUtil.isCaretInsideSelection(caret) : EditorImpl.this.getSelectionModel().hasSelection(true);
        }

        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(3);
            }
            this.executeAction("EditorCut", dataContext);
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(4);
            }
            return !EditorImpl.this.isViewer();
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(5);
            }
            Caret caret = (Caret)dataContext.getData(CommonDataKeys.CARET);
            return this.isCutEnabled(dataContext) && (PlatformUtils.isDataGrip() && caret != null ? EditorUtil.isCaretInsideSelection(caret) : EditorImpl.this.getSelectionModel().hasSelection(true));
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(6);
            }
            this.executeAction("EditorPaste", dataContext);
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(7);
            }
            return !EditorImpl.this.isViewer();
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(8);
            }
            return !EditorImpl.this.isViewer();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(9);
            }
            this.executeAction("EditorDelete", dataContext);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(10);
            }
            return !EditorImpl.this.isViewer();
        }

        private void executeAction(@NotNull String actionId, @NotNull DataContext dataContext) {
            EditorAction action2;
            if (actionId == null) {
                MyEditable.$$$reportNull$$$0(11);
            }
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(12);
            }
            if ((action2 = (EditorAction)ActionManager.getInstance().getAction(actionId)) != null) {
                action2.actionPerformed((Editor)EditorImpl.this, dataContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorImpl$MyEditable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutEnabled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutVisible";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performPaste";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPastePossible";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPasteEnabled";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    final class MyScrollBar
    extends OpaqueAwareScrollBar {
        @NonNls
        private static final String APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS = "apple.laf.AquaScrollBarUI";
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(int orientation) {
            super(orientation);
        }

        void setPersistentUI(@NotNull ScrollBarUI ui2) {
            if (ui2 == null) {
                MyScrollBar.$$$reportNull$$$0(0);
            }
            this.myPersistentUI = ui2;
            this.setUI(ui2);
        }

        public void setUI(ScrollBarUI ui2) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui2;
            }
            super.setUI(this.myPersistentUI);
        }

        int getDecScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            int top = Math.max(0, insets.top);
            if (barUI instanceof ButtonlessScrollBarUI) {
                return top + ((ButtonlessScrollBarUI)barUI).getDecrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton decrButtonValue = (JButton)decrButtonField.get(barUI);
                    LOG.assertTrue(decrButtonValue != null);
                    return top + decrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            return top + 15;
        }

        int getIncScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            if (barUI instanceof ButtonlessScrollBarUI) {
                return insets.top + ((ButtonlessScrollBarUI)barUI).getIncrementButtonHeight();
            }
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    JButton incrButtonValue = (JButton)incrButtonField.get(barUI);
                    LOG.assertTrue(incrButtonValue != null);
                    return insets.bottom + incrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc);
                }
            }
            if (barUI != null && APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS.equals(barUI.getClass().getName())) {
                return insets.bottom + 30;
            }
            return insets.bottom + 15;
        }

        public int getUnitIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableUnitIncrement(vr, 1, direction);
        }

        public int getBlockIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableBlockIncrement(vr, 1, direction);
        }

        private void registerRepaintCallback(@Nullable ButtonlessScrollBarUI.ScrollbarRepaintCallback callback2) {
            if (this.myPersistentUI instanceof ButtonlessScrollBarUI) {
                ((ButtonlessScrollBarUI)this.myPersistentUI).registerRepaintCallback(callback2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/openapi/editor/impl/EditorImpl$MyScrollBar", "setPersistentUI"));
        }
    }

    private class OpaqueAwareScrollBar
    extends JBScrollBar {
        private boolean myOpaque;

        private OpaqueAwareScrollBar(int orientation) {
            super(orientation);
            ComponentUtil.putClientProperty((JComponent)((Object)this), (Key)ColorKey.FUNCTION_KEY, key -> EditorImpl.this.getColorsScheme().getColor(key));
            this.addPropertyChangeListener("opaque", event -> {
                this.revalidate();
                this.repaint();
            });
        }

        public void setOpaque(boolean opaque) {
            this.myOpaque = opaque;
            super.setOpaque(opaque || EditorImpl.this.shouldScrollBarBeOpaque());
        }

        public boolean isOptimizedDrawingEnabled() {
            return !EditorImpl.this.myBackgroundImageSet;
        }
    }

    private class ScrollingTimer {
        private Timer myTimer;
        private static final int CYCLE_SIZE = 20;
        private int myXCycles;
        private int myYCycles;
        private int myDx;
        private int myDy;
        private int xPassedCycles;
        private int yPassedCycles;

        private ScrollingTimer() {
        }

        private void start(int dx, int dy) {
            this.myDx = 0;
            this.myDy = 0;
            if (dx > 0) {
                this.myXCycles = 20 / dx + 1;
                this.myDx = 1 + dx / 20;
            } else if (dx < 0) {
                this.myXCycles = -20 / dx + 1;
                this.myDx = -1 + dx / 20;
            }
            if (dy > 0) {
                this.myYCycles = 20 / dy + 1;
                this.myDy = 1 + dy / 20;
            } else if (dy < 0) {
                this.myYCycles = -20 / dy + 1;
                this.myDy = -1 + dy / 20;
            }
            if (this.myTimer != null) {
                return;
            }
            this.myTimer = TimerUtil.createNamedTimer((String)"Editor scroll timer", (int)Registry.intValue((String)"editor.scrolling.animation.interval.ms"), e -> {
                if (EditorImpl.this.isDisposed()) {
                    this.stop();
                    return;
                }
                DocumentRunnable command = new DocumentRunnable(EditorImpl.this.myDocument, EditorImpl.this.myProject){

                    public void run() {
                        int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
                        VisualPosition caretPosition = EditorImpl.this.myMultiSelectionInProgress ? EditorImpl.this.myTargetMultiSelectionPosition : EditorImpl.this.getCaretModel().getVisualPosition();
                        int column2 = caretPosition.column;
                        ++ScrollingTimer.this.xPassedCycles;
                        if (ScrollingTimer.this.xPassedCycles >= ScrollingTimer.this.myXCycles) {
                            ScrollingTimer.this.xPassedCycles = 0;
                            column2 += ScrollingTimer.this.myDx;
                        }
                        int line = caretPosition.line;
                        ++ScrollingTimer.this.yPassedCycles;
                        if (ScrollingTimer.this.yPassedCycles >= ScrollingTimer.this.myYCycles) {
                            ScrollingTimer.this.yPassedCycles = 0;
                            line += ScrollingTimer.this.myDy;
                        }
                        line = Math.max(0, line);
                        column2 = Math.max(0, column2);
                        VisualPosition pos = new VisualPosition(line, column2);
                        if (!EditorImpl.this.myMultiSelectionInProgress) {
                            EditorImpl.this.getCaretModel().moveToVisualPosition(pos);
                            EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        }
                        int newCaretOffset = EditorImpl.this.getCaretModel().getOffset();
                        int caretShift = newCaretOffset - EditorImpl.this.mySavedSelectionStart;
                        if (EditorImpl.this.getMouseSelectionState() != 0) {
                            EditorImpl.this.setupSpecialSelectionOnMouseDrag(newCaretOffset, caretShift);
                            return;
                        }
                        if (EditorImpl.this.myMultiSelectionInProgress && EditorImpl.this.myLastMousePressedLocation != null) {
                            EditorImpl.this.myTargetMultiSelectionPosition = pos;
                            LogicalPosition newLogicalPosition = EditorImpl.this.visualToLogicalPosition(pos);
                            EditorImpl.this.getScrollingModel().scrollTo(newLogicalPosition, ScrollType.RELATIVE);
                            EditorImpl.this.createSelectionTill(newLogicalPosition);
                        } else {
                            EditorImpl.this.mySelectionModel.setSelection(oldSelectionStart, EditorImpl.this.getCaretModel().getOffset());
                        }
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, (Runnable)command, EditorBundle.message((String)"move.cursor.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, (Document)EditorImpl.this.getDocument());
            });
            this.myTimer.start();
        }

        private void stop() {
            if (this.myTimer != null) {
                this.myTimer.stop();
                this.myTimer = null;
            }
        }
    }

    final class CaretCursor {
        private CaretRectangle[] myLocations = new CaretRectangle[]{new CaretRectangle(new Point(0, 0), 0.0f, null, false)};
        private boolean myEnabled;
        private boolean myIsShown;
        private long myStartTime;

        private CaretCursor() {
            this.setEnabled(true);
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            boolean blink = EditorImpl.this.mySettings.isBlinkCaret();
            int blinkPeriod = EditorImpl.this.mySettings.getCaretBlinkPeriod();
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                EditorImpl.ourCaretBlinkingCommand.myEditor = EditorImpl.this;
                ourCaretBlinkingCommand.setBlinkCaret(blink);
                ourCaretBlinkingCommand.setBlinkPeriod(blinkPeriod);
                this.myIsShown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                return this.myIsShown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void passivate() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                this.myIsShown = false;
            }
        }

        private void setPositions(CaretRectangle @NotNull [] locations) {
            if (locations == null) {
                CaretCursor.$$$reportNull$$$0(0);
            }
            this.myStartTime = System.currentTimeMillis();
            this.myLocations = locations;
        }

        private void repaint() {
            EditorImpl.this.myView.repaintCarets();
        }

        CaretRectangle @Nullable [] getCaretLocations(boolean onlyIfShown) {
            if (!(!onlyIfShown || this.isEnabled() && this.myIsShown && !EditorImpl.this.isRendererMode() && IJSwingUtilities.hasFocus(EditorImpl.this.getContentComponent()))) {
                return null;
            }
            return this.myLocations;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locations", "com/intellij/openapi/editor/impl/EditorImpl$CaretCursor", "setPositions"));
        }
    }

    public static final class CaretRectangle {
        public final Point2D myPoint;
        public final float myWidth;
        public final Caret myCaret;
        public final boolean myIsRtl;

        private CaretRectangle(@NotNull Point2D point, float width, Caret caret, boolean isRtl) {
            if (point == null) {
                CaretRectangle.$$$reportNull$$$0(0);
            }
            this.myPoint = point;
            this.myWidth = Math.max(width, 2.0f);
            this.myCaret = caret;
            this.myIsRtl = isRtl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/openapi/editor/impl/EditorImpl$CaretRectangle", "<init>"));
        }
    }

    private static class RepaintCursorCommand
    implements Runnable {
        private long mySleepTime = 500L;
        private boolean myIsBlinkCaret = true;
        @Nullable
        private EditorImpl myEditor;
        private ScheduledFuture<?> mySchedulerHandle;

        private RepaintCursorCommand() {
        }

        public void start() {
            if (this.mySchedulerHandle != null) {
                this.mySchedulerHandle.cancel(false);
            }
            this.mySchedulerHandle = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this, this.mySleepTime, this.mySleepTime, TimeUnit.MILLISECONDS);
        }

        private void setBlinkPeriod(int blinkPeriod) {
            this.mySleepTime = Math.max(blinkPeriod, 10);
            this.start();
        }

        private void setBlinkCaret(boolean value2) {
            this.myIsBlinkCaret = value2;
        }

        @Override
        public void run() {
            if (this.myEditor != null) {
                CaretCursor activeCursor = this.myEditor.myCaretCursor;
                long time = System.currentTimeMillis();
                if ((time -= activeCursor.myStartTime) > this.mySleepTime) {
                    boolean toRepaint = true;
                    if (this.myIsBlinkCaret) {
                        activeCursor.myIsShown = !activeCursor.myIsShown;
                    } else {
                        toRepaint = !activeCursor.myIsShown;
                        activeCursor.myIsShown = true;
                    }
                    if (toRepaint) {
                        activeCursor.repaint();
                    }
                }
            }
        }
    }

    private static @interface MouseSelectionState {
    }
}

