/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.DocumentFragmentTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class FoldingPopupManager
implements EditorMouseListener,
EditorMouseMotionListener {
    private static final Key<Boolean> DISABLED = Key.create((String)"FoldingPopupManager.disabled");
    private static final TooltipGroup FOLDING_TOOLTIP_GROUP = new TooltipGroup("FOLDING_TOOLTIP_GROUP", 10);
    private static final int TOOLTIP_DELAY_MS = 300;
    private final Alarm myAlarm;

    public static void disableForEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            FoldingPopupManager.$$$reportNull$$$0(0);
        }
        editor2.putUserData(DISABLED, (Object)Boolean.TRUE);
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, null, true);
    }

    public static void enableForEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            FoldingPopupManager.$$$reportNull$$$0(1);
        }
        editor2.putUserData(DISABLED, null);
    }

    FoldingPopupManager(EditorImpl editor2) {
        this.myAlarm = new Alarm(editor2.getDisposable());
        editor2.addEditorMouseListener(this);
        editor2.addEditorMouseMotionListener(this);
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(2);
        }
        this.myAlarm.cancelAllRequests();
        Editor editor2 = e.getEditor();
        if (editor2.getUserData(DISABLED) != null) {
            return;
        }
        if (e.getArea() == EditorMouseEventArea.EDITING_AREA) {
            MouseEvent mouseEvent = e.getMouseEvent();
            Point point = mouseEvent.getPoint();
            FoldRegion fold2 = e.getCollapsedFoldRegion();
            TooltipController controller = TooltipController.getInstance();
            if (fold2 != null && !fold2.shouldNeverExpand()) {
                this.myAlarm.addRequest(() -> {
                    if (editor2.getUserData(DISABLED) != null || !editor2.getComponent().isShowing() || !fold2.isValid() || fold2.isExpanded()) {
                        return;
                    }
                    DocumentFragment range2 = FoldingPopupManager.createDocumentFragment(fold2);
                    Point p = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, editor2.getComponent().getRootPane().getLayeredPane());
                    controller.showTooltip(editor2, p, new DocumentFragmentTooltipRenderer(range2), false, FOLDING_TOOLTIP_GROUP);
                }, 300);
            } else {
                controller.cancelTooltip(FOLDING_TOOLTIP_GROUP, mouseEvent, true);
            }
        }
    }

    @NotNull
    private static DocumentFragment createDocumentFragment(@NotNull FoldRegion fold2) {
        int groupEndOffset;
        if (fold2 == null) {
            FoldingPopupManager.$$$reportNull$$$0(3);
        }
        EditorImpl editor2 = (EditorImpl)fold2.getEditor();
        DocumentEx document = editor2.getDocument();
        FoldingGroup group2 = fold2.getGroup();
        int startOffset = fold2.getStartOffset();
        int endOffset = fold2.getEndOffset();
        if (group2 != null && editor2.offsetToVisualLine(groupEndOffset = editor2.getFoldingModel().getEndOffset(group2)) == editor2.offsetToVisualLine(startOffset)) {
            endOffset = groupEndOffset;
        }
        return new DocumentFragment((Document)document, startOffset, endOffset);
    }

    public void mouseExited(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingPopupManager.$$$reportNull$$$0(4);
        }
        this.myAlarm.cancelAllRequests();
        if (e.getEditor().getUserData(DISABLED) != null) {
            return;
        }
        TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP, e.getMouseEvent(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fold";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingPopupManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "disableForEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enableForEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDocumentFragment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

