/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorActionPlan;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import sun.awt.image.SunVolatileImage;

class ImmediatePainter {
    private static final Logger LOG = Logger.getInstance(ImmediatePainter.class);
    private static final int DEBUG_PAUSE_DURATION = 1000;
    static final RegistryValue ENABLED = Registry.get((String)"editor.zero.latency.rendering");
    static final RegistryValue DOUBLE_BUFFERING = Registry.get((String)"editor.zero.latency.rendering.double.buffering");
    private static final RegistryValue PIPELINE_FLUSH = Registry.get((String)"editor.zero.latency.rendering.pipeline.flush");
    private static final RegistryValue DEBUG = Registry.get((String)"editor.zero.latency.rendering.debug");
    private final EditorImpl myEditor;
    private Image myImage;

    ImmediatePainter(EditorImpl editor2) {
        this.myEditor = editor2;
        Disposer.register((Disposable)editor2.getDisposable(), () -> {
            if (this.myImage != null) {
                this.myImage.flush();
            }
        });
    }

    boolean paint(Graphics g, EditorActionPlan plan) {
        if (ENABLED.asBoolean() && ImmediatePainter.canPaintImmediately(this.myEditor)) {
            if (plan.getCaretShift() != 1) {
                return false;
            }
            List<EditorActionPlan.Replacement> replacements = plan.getReplacements();
            if (replacements.size() != 1) {
                return false;
            }
            EditorActionPlan.Replacement replacement = replacements.get(0);
            if (replacement.getText().length() != 1) {
                return false;
            }
            int caretOffset = replacement.getBegin();
            char c = replacement.getText().charAt(0);
            try {
                this.paintImmediately((Graphics2D)g, caretOffset, c);
                return true;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    private static boolean canPaintImmediately(EditorImpl editor2) {
        CaretModelImpl caretModel = editor2.getCaretModel();
        Caret caret = caretModel.getPrimaryCaret();
        DocumentEx document = editor2.getDocument();
        return document instanceof DocumentImpl && editor2.getHighlighter() instanceof LexerEditorHighlighter && !(editor2.getComponent().getParent() instanceof EditorTextField) && editor2.myView.getTopOverhang() <= 0 && editor2.myView.getBottomOverhang() <= 0 && !editor2.getSelectionModel().hasSelection() && caretModel.getCaretCount() == 1 && !ImmediatePainter.isInVirtualSpace(editor2, caret) && !ImmediatePainter.isInsertion(document, caret.getOffset()) && !caret.isAtRtlLocation() && !caret.isAtBidiRunBoundary() && ImmediatePainter.noBorderEffectPainted(editor2, caret);
    }

    private static boolean isInVirtualSpace(Editor editor2, Caret caret) {
        return caret.getLogicalPosition().compareTo(editor2.offsetToLogicalPosition(caret.getOffset())) != 0;
    }

    private static boolean isInsertion(Document document, int offset) {
        return offset < document.getTextLength() && document.getCharsSequence().charAt(offset) != '\n';
    }

    private static boolean noBorderEffectPainted(EditorEx editor2, Caret caret) {
        int offset = caret.getOffset();
        EditorColorsScheme colorsScheme = editor2.getColorsScheme();
        return editor2.getMarkupModel().processRangeHighlightersOverlappingWith(offset, offset, (Processor<? super RangeHighlighterEx>)((Processor)h -> {
            TextAttributes attrs = h.getTextAttributes(colorsScheme);
            return attrs == null || !attrs.hasEffects() || TextAttributesEffectsBuilder.create((TextAttributes)attrs).getEffectDescriptor(TextAttributesEffectsBuilder.EffectSlot.FRAME_SLOT) == null;
        }));
    }

    private void paintImmediately(Graphics2D g, int offset, char c2) {
        float caretWidth;
        List<TextAttributes> attributes2;
        EditorImpl editor2 = this.myEditor;
        DocumentEx document = editor2.getDocument();
        LexerEditorHighlighter highlighter = (LexerEditorHighlighter)this.myEditor.getHighlighter();
        EditorSettings settings = editor2.getSettings();
        boolean isBlockCursor = editor2.isInsertMode() == settings.isBlockCursor();
        int lineHeight = editor2.getLineHeight();
        int ascent = editor2.getAscent();
        int topOverhang = editor2.myView.getTopOverhang();
        int bottomOverhang = editor2.myView.getBottomOverhang();
        char c1 = offset == 0 ? (char)' ' : (char)document.getCharsSequence().charAt(offset - 1);
        try {
            attributes2 = highlighter.getAttributesForPreviousAndTypedChars(document, offset, c2);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculating attributes, highlighter: " + highlighter + ", offset: " + offset + ", document length" + document.getTextLength() + ", highlighter's last offset:" + highlighter.getSegments().getLastValidOffset(), e);
        }
        ImmediatePainter.updateAttributes(editor2, offset, attributes2);
        TextAttributes attributes1 = attributes2.get(0);
        TextAttributes attributes22 = attributes2.get(1);
        if (!ImmediatePainter.canRender(attributes1) || !ImmediatePainter.canRender(attributes22)) {
            return;
        }
        FontLayoutService fontLayoutService = FontLayoutService.getInstance();
        float width1 = fontLayoutService.charWidth2D(editor2.getFontMetrics(attributes1.getFontType()), c1);
        float width2 = fontLayoutService.charWidth2D(editor2.getFontMetrics(attributes22.getFontType()), c2);
        Font font1 = EditorUtil.fontForChar(c1, attributes1.getFontType(), editor2).getFont();
        Font font2 = EditorUtil.fontForChar(c1, attributes22.getFontType(), editor2).getFont();
        Point2D p2 = editor2.offsetToPoint2D(offset);
        float p2x = (float)p2.getX();
        int p2y = (int)p2.getY();
        CaretImpl caret = editor2.getCaretModel().getPrimaryCaret();
        float f = caretWidth = isBlockCursor ? editor2.getCaretLocations((boolean)false)[0].myWidth : (float)JBUIScale.scale((int)caret.getVisualAttributes().getWidth(settings.getLineCursorWidth()));
        float caretShift = isBlockCursor ? 0.0f : (caretWidth <= 1.0f ? 0.0f : 1.0f / JBUIScale.sysScale((Graphics2D)g));
        Rectangle2D.Float caretRectangle = new Rectangle2D.Float(p2x + width2 - caretShift, p2y - topOverhang, caretWidth, lineHeight + topOverhang + bottomOverhang);
        float rectangle2Start = (float)PaintUtil.alignToInt((double)p2x, (Graphics2D)g, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
        float rectangle2End = (float)PaintUtil.alignToInt((double)(p2x + width2 + caretWidth - caretShift), (Graphics2D)g, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL);
        Rectangle2D.Float rectangle1 = new Rectangle2D.Float(p2x - width1, p2y, width1, lineHeight);
        Rectangle2D.Float rectangle2 = new Rectangle2D.Float(rectangle2Start, p2y, rectangle2End - rectangle2Start, lineHeight);
        Consumer painter = graphics -> {
            EditorUIUtil.setupAntialiasing(graphics);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, UISettings.getEditorFractionalMetricsHint());
            ImmediatePainter.fillRect(graphics, rectangle2, attributes22.getBackgroundColor());
            ImmediatePainter.drawChar(graphics, c2, p2x, p2y + ascent, font2, attributes22.getForegroundColor());
            ImmediatePainter.fillRect(graphics, caretRectangle, ImmediatePainter.getCaretColor(editor2));
            ImmediatePainter.fillRect(graphics, rectangle1, attributes1.getBackgroundColor());
            ImmediatePainter.drawChar(graphics, c1, p2x - width1, p2y + ascent, font1, attributes1.getForegroundColor());
        };
        Shape originalClip = g.getClip();
        float clipStartX = (float)PaintUtil.alignToInt((double)(p2x > (float)editor2.getContentComponent().getInsets().left ? (double)(p2x - caretShift) : (double)p2x), (Graphics2D)g, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
        float clipEndX = (float)PaintUtil.alignToInt((double)(p2x + width2 - caretShift + caretWidth), (Graphics2D)g, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL);
        if (clipEndX > (float)editor2.getContentComponent().getWidth()) {
            return;
        }
        g.setClip(new Rectangle2D.Float(clipStartX, p2y, clipEndX - clipStartX, lineHeight));
        if (DOUBLE_BUFFERING.asBoolean() && !PaintUtil.isFractionalScale((AffineTransform)g.getTransform())) {
            this.paintWithDoubleBuffering(g, (Consumer<? super Graphics2D>)painter);
        } else {
            painter.consume((Object)g);
        }
        g.setClip(originalClip);
        if (PIPELINE_FLUSH.asBoolean()) {
            Toolkit.getDefaultToolkit().sync();
        }
        if (DEBUG.asBoolean()) {
            ImmediatePainter.pause();
        }
    }

    private static boolean canRender(TextAttributes attributes2) {
        return attributes2.getEffectType() != EffectType.BOXED || attributes2.getEffectColor() == null;
    }

    private void paintWithDoubleBuffering(Graphics2D graphics, Consumer<? super Graphics2D> painter) {
        Rectangle bounds2 = graphics.getClipBounds();
        this.createOrUpdateImageBuffer(this.myEditor.getComponent(), graphics, bounds2.getSize());
        UIUtil.useSafely((Graphics)this.myImage.getGraphics(), imageGraphics -> {
            imageGraphics.translate(-bounds2.x, -bounds2.y);
            painter.consume(imageGraphics);
        });
        StartupUiUtil.drawImage((Graphics)graphics, (Image)this.myImage, (int)bounds2.x, (int)bounds2.y, null);
    }

    private void createOrUpdateImageBuffer(JComponent component2, Graphics2D graphics, Dimension size) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myImage == null || !ImmediatePainter.isLargeEnough(this.myImage, size)) {
                int width = (int)Math.ceil(PaintUtil.alignToInt((double)size.width, (Graphics2D)graphics, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL));
                int height = (int)Math.ceil(PaintUtil.alignToInt((double)size.height, (Graphics2D)graphics, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL));
                this.myImage = ImageUtil.createImage((int)width, (int)height, (int)1);
            }
        } else if (this.myImage == null) {
            this.myImage = component2.createVolatileImage(size.width, size.height);
        } else if (!ImmediatePainter.isLargeEnough(this.myImage, size) || !ImmediatePainter.isImageValid((VolatileImage)this.myImage, component2)) {
            this.myImage.flush();
            this.myImage = component2.createVolatileImage(size.width, size.height);
        }
    }

    private static boolean isLargeEnough(Image image, Dimension size) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width == -1 || height == -1) {
            throw new IllegalArgumentException("Image size is undefined");
        }
        return width >= size.width && height >= size.height;
    }

    private static boolean isImageValid(VolatileImage image, Component component2) {
        GraphicsConfiguration imageConfig;
        GraphicsConfiguration componentConfig = component2.getGraphicsConfiguration();
        if (SystemInfo.isWindows && image instanceof SunVolatileImage && (imageConfig = ((SunVolatileImage)image).getGraphicsConfig()) != null && componentConfig != null && imageConfig.getDevice() != componentConfig.getDevice()) {
            return false;
        }
        return image.validate(componentConfig) != 2;
    }

    private static void fillRect(Graphics2D g, Rectangle2D r, Color color) {
        g.setColor(color);
        g.fill(r);
    }

    private static void drawChar(Graphics2D g, char c, float x, float y, Font font, Color color) {
        g.setFont(font);
        g.setColor(color);
        g.drawString(String.valueOf(c), x, y);
    }

    private static Color getCaretColor(Editor editor2) {
        Color overriddenColor = editor2.getCaretModel().getPrimaryCaret().getVisualAttributes().getColor();
        if (overriddenColor != null) {
            return overriddenColor;
        }
        Color caretColor = editor2.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        return caretColor == null ? new JBColor((Color)Gray._0, (Color)Gray._255) : caretColor;
    }

    private static void updateAttributes(EditorImpl editor2, int offset, List<? extends TextAttributes> attributes2) {
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        Processor processor2 = highlighter -> {
            boolean isLineHighlighter;
            if (!highlighter.isValid()) {
                return true;
            }
            boolean bl = isLineHighlighter = highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE;
            if (isLineHighlighter || highlighter.getStartOffset() < offset) {
                list1.add(highlighter);
            }
            if (isLineHighlighter || highlighter.getEndOffset() > offset || highlighter.getEndOffset() == offset && highlighter.isGreedyToRight()) {
                list2.add(highlighter);
            }
            return true;
        };
        editor2.getFilteredDocumentMarkupModel().processRangeHighlightersOverlappingWith(Math.max(0, offset - 1), offset, (Processor<? super RangeHighlighterEx>)processor2);
        editor2.getMarkupModel().processRangeHighlightersOverlappingWith(Math.max(0, offset - 1), offset, (Processor<? super RangeHighlighterEx>)processor2);
        ImmediatePainter.updateAttributes(editor2, attributes2.get(0), list1);
        ImmediatePainter.updateAttributes(editor2, attributes2.get(1), list2);
    }

    private static void updateAttributes(EditorImpl editor2, TextAttributes attributes2, List<? extends RangeHighlighterEx> highlighters) {
        if (highlighters.size() > 1) {
            ContainerUtil.quickSort(highlighters, IterationState.createByLayerThenByAttributesComparator(editor2.getColorsScheme()));
        }
        TextAttributes syntax = attributes2;
        TextAttributes caretRow = editor2.getCaretModel().getTextAttributes();
        int size = highlighters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            RangeHighlighterEx highlighter = highlighters.get(i2);
            if (highlighter.getTextAttributes(editor2.getColorsScheme()) != TextAttributes.ERASE_MARKER) continue;
            syntax = null;
        }
        ArrayList<TextAttributes> cachedAttributes = new ArrayList<TextAttributes>();
        for (int i3 = 0; i3 < size; ++i3) {
            TextAttributes textAttributes;
            RangeHighlighterEx highlighter = highlighters.get(i3);
            if (caretRow != null && highlighter.getLayer() < 2000) {
                cachedAttributes.add(caretRow);
                caretRow = null;
            }
            if (syntax != null && highlighter.getLayer() < 1000) {
                cachedAttributes.add(syntax);
                syntax = null;
            }
            if ((textAttributes = highlighter.getTextAttributes(editor2.getColorsScheme())) == null || textAttributes == TextAttributes.ERASE_MARKER) continue;
            cachedAttributes.add(textAttributes);
        }
        if (caretRow != null) {
            cachedAttributes.add(caretRow);
        }
        if (syntax != null) {
            cachedAttributes.add(syntax);
        }
        Color foreground = null;
        Color background = null;
        Color effect = null;
        EffectType effectType = null;
        int fontType = 0;
        for (int i4 = 0; i4 < cachedAttributes.size(); ++i4) {
            TextAttributes attrs = (TextAttributes)cachedAttributes.get(i4);
            if (foreground == null) {
                foreground = attrs.getForegroundColor();
            }
            if (background == null) {
                background = attrs.getBackgroundColor();
            }
            if (fontType == 0) {
                fontType = attrs.getFontType();
            }
            if (effect != null) continue;
            effect = attrs.getEffectColor();
            effectType = attrs.getEffectType();
        }
        if (foreground == null) {
            foreground = editor2.getForegroundColor();
        }
        if (background == null) {
            background = editor2.getBackgroundColor();
        }
        if (effectType == null) {
            effectType = EffectType.BOXED;
        }
        TextAttributes defaultAttributes = editor2.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        if (fontType == 0) {
            fontType = defaultAttributes == null ? 0 : defaultAttributes.getFontType();
        }
        attributes2.setAttributes(foreground, background, effect, null, effectType, fontType);
    }

    private static void pause() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

