/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DefaultLineMarkerRenderer
implements LineMarkerRendererEx {
    private final TextAttributesKey myAttributesKey;
    private final int myThickness;
    private final int myDepth;
    private final LineMarkerRendererEx.Position myPosition;
    private final Color myColor;

    public DefaultLineMarkerRenderer(@NotNull TextAttributesKey myAttributesKey, int thickness) {
        if (myAttributesKey == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(0);
        }
        this(myAttributesKey, thickness, 0, LineMarkerRendererEx.Position.RIGHT);
    }

    public DefaultLineMarkerRenderer(@NotNull TextAttributesKey attributesKey, int thickness, int depth, @NotNull LineMarkerRendererEx.Position position) {
        if (attributesKey == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(1);
        }
        if (position == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(2);
        }
        this.myAttributesKey = attributesKey;
        this.myThickness = thickness;
        this.myDepth = depth;
        this.myPosition = position;
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes2 = scheme2.getAttributes(this.myAttributesKey);
        Color color = attributes2.getBackgroundColor();
        Color color2 = color = color != null ? color : attributes2.getForegroundColor();
        this.myColor = color != null ? (ColorUtil.isDark((Color)scheme2.getDefaultBackground()) ? ColorUtil.shift((Color)color, (double)1.5) : color.darker()) : null;
    }

    public void paint(@NotNull Editor editor2, @NotNull Graphics g, @NotNull Rectangle r) {
        if (editor2 == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(3);
        }
        if (g == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(4);
        }
        if (r == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(5);
        }
        if (this.myColor == null) {
            return;
        }
        g.setColor(this.myColor);
        g.fillRect(r.x, r.y, this.myThickness, r.height);
        g.fillRect(r.x + this.myThickness, r.y, this.myDepth, this.myThickness);
        g.fillRect(r.x + this.myThickness, r.y + r.height - this.myThickness, this.myDepth, this.myThickness);
    }

    @NotNull
    public TextAttributesKey getAttributesKey() {
        TextAttributesKey textAttributesKey = this.myAttributesKey;
        if (textAttributesKey == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(6);
        }
        return textAttributesKey;
    }

    public int getDepth() {
        return this.myDepth;
    }

    public int getThickness() {
        return this.myThickness;
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = this.myPosition;
        if (position == null) {
            DefaultLineMarkerRenderer.$$$reportNull$$$0(7);
        }
        return position;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myAttributesKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/DefaultLineMarkerRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/DefaultLineMarkerRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesKey";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

