/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefreshAllExternalProjectsAction
extends DumbAwareAction {
    public RefreshAllExternalProjectsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.description", (Object[])new Object[]{"external"}));
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String name2 = StringUtil.join(systemIds, projectSystemId -> projectSystemId.getReadableName(), (String)",");
        e.getPresentation().setText(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.text", (Object[])new Object[]{name2}));
        e.getPresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.description", (Object[])new Object[]{name2}));
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ApplicationManager.getApplication().getService(ExternalSystemProcessingManager.class);
        e.getPresentation().setEnabled(!processingManager.hasTaskOfTypeInProgress(ExternalSystemTaskType.RESOLVE_PROJECT, project));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (ExternalSystemUtil.confirmLoadingUntrustedProject(project, systemIds)) {
            for (ProjectSystemId externalSystemId2 : systemIds) {
                ExternalSystemActionsCollector.trigger(project, externalSystemId2, (AnAction)this, e);
                ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project, externalSystemId2));
            }
        }
    }

    @NotNull
    private static List<ProjectSystemId> getSystemIds(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(2);
        }
        ArrayList<ProjectSystemId> systemIds = new ArrayList<ProjectSystemId>();
        ProjectSystemId externalSystemId2 = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        if (externalSystemId2 == null) {
            ExternalSystemManager.EP_NAME.forEachExtensionSafe(manager2 -> systemIds.add(manager2.getSystemId()));
        } else {
            systemIds.add(externalSystemId2);
        }
        ArrayList<ProjectSystemId> arrayList = systemIds;
        if (arrayList == null) {
            RefreshAllExternalProjectsAction.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/RefreshAllExternalProjectsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/RefreshAllExternalProjectsAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSystemIds";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

