/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH$J\b\u0010\t\u001a\u00020\bH$J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J\u001a\u0010\u0019\u001a\u00020\b*\u00020\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AsyncFileChangeListenerBase;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "()V", "processRecursively", "", "getProcessRecursively", "()Z", "apply", "", "init", "isRelevant", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "path", "", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "process", "f", "processFile", "updateFile", "processChangeEvents", "Lcom/intellij/openapi/externalSystem/autoimport/AsyncFileChangeListenerBase$ChangeSeparator;", "ChangeSeparator", "intellij.platform.externalSystem.impl"})
public abstract class AsyncFileChangeListenerBase
implements AsyncFileListener {
    private final boolean processRecursively;

    protected boolean getProcessRecursively() {
        return this.processRecursively;
    }

    protected abstract void init();

    protected abstract void apply();

    protected boolean isRelevant(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return false;
    }

    protected boolean isRelevant(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return false;
    }

    protected abstract void updateFile(@NotNull VirtualFile var1, @NotNull VFileEvent var2);

    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ChangeSeparator separator2 = new ChangeSeparator();
        this.processChangeEvents(separator2, events);
        return new AsyncFileListener.ChangeApplier(this, separator2){
            final /* synthetic */ AsyncFileChangeListenerBase this$0;
            final /* synthetic */ ChangeSeparator $separator;

            public void beforeVfsChange() {
                this.this$0.init();
                this.$separator.applyBefore();
            }

            public void afterVfsChange() {
                this.$separator.applyAfter();
                this.this$0.apply();
            }
            {
                this.this$0 = this$0;
                this.$separator = $captured_local_variable$1;
            }
        };
    }

    private final void process(VirtualFile f, VFileEvent event) {
        boolean bl = this.getProcessRecursively();
        if (bl) {
            this.processRecursively(f, event);
        } else {
            this.processFile(f, event);
        }
    }

    private final void processFile(VirtualFile f, VFileEvent event) {
        String string = f.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.path");
        if (this.isRelevant(string) || this.isRelevant(f, event)) {
            this.updateFile(f, event);
        }
    }

    private final void processRecursively(VirtualFile f, VFileEvent event) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(this, event, new VirtualFileVisitor.Option[0]){
            final /* synthetic */ AsyncFileChangeListenerBase this$0;
            final /* synthetic */ VFileEvent $event;

            public boolean visitFile(@NotNull VirtualFile f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                String string = f.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.path");
                if (this.this$0.isRelevant(string) || this.this$0.isRelevant(f, this.$event)) {
                    this.this$0.updateFile(f, this.$event);
                }
                return true;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                return f.isDirectory() && f instanceof NewVirtualFile ? ((NewVirtualFile)f).iterInDbChildren() : null;
            }
            {
                this.this$0 = this$0;
                this.$event = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }));
    }

    private final void processChangeEvents(ChangeSeparator $this$processChangeEvents, List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            ProgressManager.checkCanceled();
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                if (!((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
                $this$processChangeEvents.before((Function0<Unit>)((Function0)new Function0<Unit>(this, vFileEvent){
                    final /* synthetic */ AsyncFileChangeListenerBase this$0;
                    final /* synthetic */ VFileEvent $each;

                    public final void invoke() {
                        VirtualFile virtualFile2 = ((VFilePropertyChangeEvent)this.$each).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"each.file");
                        AsyncFileChangeListenerBase.access$process(this.this$0, virtualFile2, this.$each);
                    }
                    {
                        this.this$0 = asyncFileChangeListenerBase;
                        this.$each = vFileEvent;
                        super(0);
                    }
                }));
                $this$processChangeEvents.after((Function0<Unit>)((Function0)new Function0<Unit>(this, vFileEvent){
                    final /* synthetic */ AsyncFileChangeListenerBase this$0;
                    final /* synthetic */ VFileEvent $each;

                    public final void invoke() {
                        VirtualFile virtualFile2 = ((VFilePropertyChangeEvent)this.$each).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"each.file");
                        AsyncFileChangeListenerBase.access$process(this.this$0, virtualFile2, this.$each);
                    }
                    {
                        this.this$0 = asyncFileChangeListenerBase;
                        this.$each = vFileEvent;
                        super(0);
                    }
                }));
                continue;
            }
            if (vFileEvent2 instanceof VFileMoveEvent) {
                $this$processChangeEvents.before((Function0<Unit>)((Function0)new Function0<Unit>(this, vFileEvent){
                    final /* synthetic */ AsyncFileChangeListenerBase this$0;
                    final /* synthetic */ VFileEvent $each;

                    public final void invoke() {
                        VirtualFile virtualFile2 = ((VFileMoveEvent)this.$each).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"each.file");
                        AsyncFileChangeListenerBase.access$process(this.this$0, virtualFile2, this.$each);
                    }
                    {
                        this.this$0 = asyncFileChangeListenerBase;
                        this.$each = vFileEvent;
                        super(0);
                    }
                }));
                $this$processChangeEvents.after((Function0<Unit>)((Function0)new Function0<Unit>(this, vFileEvent){
                    final /* synthetic */ AsyncFileChangeListenerBase this$0;
                    final /* synthetic */ VFileEvent $each;

                    public final void invoke() {
                        VirtualFile virtualFile2 = ((VFileMoveEvent)this.$each).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"each.file");
                        AsyncFileChangeListenerBase.access$process(this.this$0, virtualFile2, this.$each);
                    }
                    {
                        this.this$0 = asyncFileChangeListenerBase;
                        this.$each = vFileEvent;
                        super(0);
                    }
                }));
                continue;
            }
            if (vFileEvent2 instanceof VFileCopyEvent) {
                $this$processChangeEvents.after((Function0<Unit>)((Function0)new Function0<Unit>(this, vFileEvent){
                    final /* synthetic */ AsyncFileChangeListenerBase this$0;
                    final /* synthetic */ VFileEvent $each;

                    public final void invoke() {
                        VirtualFile newFile = ((VFileCopyEvent)this.$each).getNewParent().findChild(((VFileCopyEvent)this.$each).getNewChildName());
                        if (newFile != null) {
                            AsyncFileChangeListenerBase.access$process(this.this$0, newFile, this.$each);
                        }
                    }
                    {
                        this.this$0 = asyncFileChangeListenerBase;
                        this.$each = vFileEvent;
                        super(0);
                    }
                }));
                continue;
            }
            if (vFileEvent2 instanceof VFileCreateEvent) {
                $this$processChangeEvents.after((Function0<Unit>)((Function0)new Function0<Unit>(this, vFileEvent){
                    final /* synthetic */ AsyncFileChangeListenerBase this$0;
                    final /* synthetic */ VFileEvent $each;

                    public final void invoke() {
                        VirtualFile file2 = ((VFileCreateEvent)this.$each).getFile();
                        if (file2 != null) {
                            AsyncFileChangeListenerBase.access$process(this.this$0, file2, this.$each);
                        }
                    }
                    {
                        this.this$0 = asyncFileChangeListenerBase;
                        this.$each = vFileEvent;
                        super(0);
                    }
                }));
                continue;
            }
            if (!(vFileEvent2 instanceof VFileDeleteEvent) && !(vFileEvent2 instanceof VFileContentChangeEvent)) continue;
            $this$processChangeEvents.before((Function0<Unit>)((Function0)new Function0<Unit>(this, vFileEvent){
                final /* synthetic */ AsyncFileChangeListenerBase this$0;
                final /* synthetic */ VFileEvent $each;

                public final void invoke() {
                    VirtualFile file2 = this.$each.getFile();
                    if (file2 != null) {
                        AsyncFileChangeListenerBase.access$process(this.this$0, file2, this.$each);
                    }
                }
                {
                    this.this$0 = asyncFileChangeListenerBase;
                    this.$each = vFileEvent;
                    super(0);
                }
            }));
        }
    }

    public AsyncFileChangeListenerBase() {
        this.processRecursively = true;
    }

    public static final /* synthetic */ void access$process(AsyncFileChangeListenerBase $this, VirtualFile f, VFileEvent event) {
        $this.process(f, event);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0006J\u0014\u0010\u000e\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R*\u0010\u0003\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/AsyncFileChangeListenerBase$ChangeSeparator;", "", "()V", "afterAppliers", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "beforeAppliers", "after", "", "action", "applyAfter", "applyBefore", "before", "intellij.platform.externalSystem.impl"})
    private static final class ChangeSeparator {
        private final ArrayList<Function0<Unit>> beforeAppliers = new ArrayList();
        private final ArrayList<Function0<Unit>> afterAppliers = new ArrayList();

        public final boolean before(@NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            return this.beforeAppliers.add(action2);
        }

        public final boolean after(@NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            return this.afterAppliers.add(action2);
        }

        public final void applyBefore() {
            Iterable $this$forEach$iv = this.beforeAppliers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }

        public final void applyAfter() {
            Iterable $this$forEach$iv = this.afterAppliers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
    }
}

