/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.autoimport.ProjectNotificationAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/HideProjectRefreshAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.externalSystem.impl"})
public final class HideProjectRefreshAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(project2);
        notificationAware.hideNotification();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(project2);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(notificationAware.isNotificationVisible());
    }

    public HideProjectRefreshAction() {
        Presentation presentation2 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setText(ExternalSystemBundle.message((String)"external.system.reload.notification.action.hide.text", (Object[])new Object[0]));
        Presentation presentation3 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"templatePresentation");
        presentation3.setIcon(AllIcons.Actions.Close);
        Presentation presentation4 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"templatePresentation");
        presentation4.setHoveredIcon(AllIcons.Actions.CloseHovered);
    }
}

