/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSettingsCollector;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemSettingsCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final EventId1<ExternalSystemProjectTrackerSettings.AutoReloadType> AUTO_RELOAD_TYPE;
    private static final StringEventField EXTERNAL_SYSTEM_ID;
    private static final EventId2<Integer, String> NUMBER_OF_LINKED_PROJECT;
    private static final EventId2<Boolean, String> USE_QUALIFIED_MODULE_NAMES;
    private static final EventId2<Integer, String> MODULES_COUNT;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = false;
        Set usages = new LinkedHashSet();
        ExternalSystemProjectTrackerSettings trackerSettings = ExternalSystemProjectTrackerSettings.Companion.getInstance(project);
        usages.add(AUTO_RELOAD_TYPE.metric((Object)trackerSettings.getAutoReloadType()));
        Iterator iterator2 = ExternalSystemApiUtil.getAllManagers().iterator();
        while (iterator2.hasNext()) {
            Collection projects;
            ExternalSystemManager manager2;
            ExternalSystemManager externalSystemManager = manager2 = (ExternalSystemManager)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemManager, (String)"manager");
            ProjectSystemId projectSystemId = externalSystemManager.getSystemId();
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"manager.systemId");
            String systemId2 = ExternalSystemStatUtilKt.getAnonymizedSystemId(projectSystemId);
            Object object = manager2.getSettingsProvider().fun((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"manager.settingsProvider.`fun`(project)");
            Intrinsics.checkNotNullExpressionValue((Object)((AbstractExternalSystemSettings)object).getLinkedProjectsSettings(), (String)"manager.settingsProvider\u2026t).linkedProjectsSettings");
            usages.add(NUMBER_OF_LINKED_PROJECT.metric((Object)projects.size(), (Object)systemId2));
            Iterator iterator3 = projects.iterator();
            while (iterator3.hasNext()) {
                ExternalProjectSettings projectsSetting;
                ExternalProjectSettings externalProjectSettings = projectsSetting = (ExternalProjectSettings)iterator3.next();
                Intrinsics.checkNotNullExpressionValue((Object)externalProjectSettings, (String)"projectsSetting");
                usages.add(USE_QUALIFIED_MODULE_NAMES.metric((Object)externalProjectSettings.isUseQualifiedModuleNames(), (Object)systemId2));
                usages.add(MODULES_COUNT.metric((Object)projectsSetting.getModules().size(), (Object)systemId2));
            }
        }
        return usages;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("build.tools.state", 3);
        AUTO_RELOAD_TYPE = GROUP.registerEvent("autoReloadType", (EventField)EventFields.Enum((String)"value", ExternalSystemProjectTrackerSettings.AutoReloadType.class, (Function1)Companion.AUTO_RELOAD_TYPE.1.INSTANCE));
        EXTERNAL_SYSTEM_ID = EventFields.StringValidatedByEnum((String)"externalSystemId", (String)"build_tools");
        NUMBER_OF_LINKED_PROJECT = GROUP.registerEvent("numberOfLinkedProject", (EventField)EventFields.Count, (EventField)EXTERNAL_SYSTEM_ID);
        USE_QUALIFIED_MODULE_NAMES = GROUP.registerEvent("useQualifiedModuleNames", (EventField)EventFields.Enabled, (EventField)EXTERNAL_SYSTEM_ID);
        MODULES_COUNT = GROUP.registerEvent("modules.count", (EventField)EventFields.RoundedInt((String)"count_rounded"), (EventField)EXTERNAL_SYSTEM_ID);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector$Companion;", "", "()V", "AUTO_RELOAD_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectTrackerSettings$AutoReloadType;", "EXTERNAL_SYSTEM_ID", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "MODULES_COUNT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "", "NUMBER_OF_LINKED_PROJECT", "USE_QUALIFIED_MODULE_NAMES", "", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

