/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.featureStatistics.fusCollectors.EventsRateThrottle;
import com.intellij.featureStatistics.fusCollectors.ThrowableDescription;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSyncActionsCollector$$special$;
import com.intellij.openapi.externalSystem.statistics.Phase;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSyncActionsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ExternalSystemSyncActionsCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    @NotNull
    private static final LongEventField activityIdField;
    @NotNull
    private static final EnumEventField<Phase> importPhaseField;
    private static final EventId1<Long> syncStartedEvent;
    private static final EventId2<Long, Boolean> syncFinishedEvent;
    private static final EventId2<Long, Phase> phaseStartedEvent;
    private static final VarargEventId phaseFinishedEvent;
    @NotNull
    private static final StringEventField errorField;
    @NotNull
    private static final StringEventField severityField;
    @NotNull
    private static final IntEventField errorHashField;
    @NotNull
    private static final BooleanEventField tooManyErrorsField;
    private static final VarargEventId errorEvent;
    private static final EventsRateThrottle ourErrorsRateThrottle;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("build.gradle.import", 4);
        activityIdField = EventFields.Long((String)"ide_activity_id");
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "phase";
        Function1 transform$iv = $special$$inlined$Enum$1.INSTANCE;
        boolean $i$f$Enum = false;
        importPhaseField = new EnumEventField(name$iv, Phase.class, transform$iv);
        syncStartedEvent = GROUP.registerEvent("gradle.sync.started", (EventField)activityIdField);
        syncFinishedEvent = GROUP.registerEvent("gradle.sync.finished", (EventField)activityIdField, (EventField)EventFields.Boolean((String)"sync_successful"));
        phaseStartedEvent = GROUP.registerEvent("phase.started", (EventField)activityIdField, (EventField)importPhaseField);
        phaseFinishedEvent = GROUP.registerVarargEvent("phase.finished", new EventField[]{(EventField)activityIdField, (EventField)importPhaseField, (EventField)EventFields.DurationMs, (EventField)EventFields.Int((String)"error_count")});
        errorField = EventFields.StringValidatedByCustomRule((String)"error", (String)"class_name");
        severityField = EventFields.String((String)"severity", (List)CollectionsKt.listOf((Object[])new String[]{"fatal", "warning"}));
        errorHashField = EventFields.Int((String)"error_hash");
        tooManyErrorsField = EventFields.Boolean((String)"too_many_errors");
        errorEvent = GROUP.registerVarargEvent("error", new EventField[]{(EventField)activityIdField, (EventField)errorField, (EventField)severityField, (EventField)errorHashField, (EventField)EventFields.PluginInfo, (EventField)tooManyErrorsField});
        ourErrorsRateThrottle = new EventsRateThrottle(100, 300000L);
    }

    @JvmStatic
    public static final void logSyncStarted(@Nullable Project project, long activityId) {
        Companion.logSyncStarted(project, activityId);
    }

    @JvmStatic
    public static final void logSyncFinished(@Nullable Project project, long activityId, boolean success2) {
        Companion.logSyncFinished(project, activityId, success2);
    }

    @JvmStatic
    public static final void logPhaseStarted(@Nullable Project project, long activityId, @NotNull Phase phase) {
        Companion.logPhaseStarted(project, activityId, phase);
    }

    @JvmStatic
    public static final void logPhaseFinished(@Nullable Project project, long activityId, @NotNull Phase phase, long durationMs, int errorCount) {
        Companion.logPhaseFinished(project, activityId, phase, durationMs, errorCount);
    }

    @JvmStatic
    public static final void logError(@Nullable Project project, long activityId, @NotNull Throwable throwable) {
        Companion.logError(project, activityId, throwable);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.H\u0007J4\u0010/\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u001d2\b\b\u0002\u00102\u001a\u000203H\u0007J\"\u00104\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0015H\u0007J\"\u00105\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001d2\u0006\u00106\u001a\u00020!H\u0007J\u001a\u00107\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001dH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00150\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000eR\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020!0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00068"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSyncActionsCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "activityIdField", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "getActivityIdField", "()Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "errorEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "errorField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getErrorField", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "errorHashField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getErrorHashField", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "importPhaseField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/openapi/externalSystem/statistics/Phase;", "getImportPhaseField", "()Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "ourErrorsRateThrottle", "Lcom/intellij/featureStatistics/fusCollectors/EventsRateThrottle;", "phaseFinishedEvent", "phaseStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "severityField", "getSeverityField", "syncFinishedEvent", "", "syncStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "tooManyErrorsField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getTooManyErrorsField", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "logError", "", "project", "Lcom/intellij/openapi/project/Project;", "activityId", "throwable", "", "logPhaseFinished", "phase", "durationMs", "errorCount", "", "logPhaseStarted", "logSyncFinished", "success", "logSyncStarted", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final LongEventField getActivityIdField() {
            return activityIdField;
        }

        @NotNull
        public final EnumEventField<Phase> getImportPhaseField() {
            return importPhaseField;
        }

        @NotNull
        public final StringEventField getErrorField() {
            return errorField;
        }

        @NotNull
        public final StringEventField getSeverityField() {
            return severityField;
        }

        @NotNull
        public final IntEventField getErrorHashField() {
            return errorHashField;
        }

        @NotNull
        public final BooleanEventField getTooManyErrorsField() {
            return tooManyErrorsField;
        }

        @JvmStatic
        public final void logSyncStarted(@Nullable Project project, long activityId) {
            syncStartedEvent.log(project, (Object)activityId);
        }

        @JvmStatic
        public final void logSyncFinished(@Nullable Project project, long activityId, boolean success2) {
            syncFinishedEvent.log(project, (Object)activityId, (Object)success2);
        }

        @JvmStatic
        public final void logPhaseStarted(@Nullable Project project, long activityId, @NotNull Phase phase) {
            Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
            phaseStartedEvent.log(project, (Object)activityId, (Object)phase);
        }

        @JvmStatic
        public final void logPhaseFinished(@Nullable Project project, long activityId, @NotNull Phase phase, long durationMs, int errorCount) {
            Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
            phaseFinishedEvent.log(project, new EventPair[]{this.getActivityIdField().with((Object)activityId), this.getImportPhaseField().with((Object)phase), EventFields.DurationMs.with((Object)durationMs), new EventPair((EventField)EventFields.Int((String)"error_count"), (Object)errorCount)});
        }

        public static /* synthetic */ void logPhaseFinished$default(Companion companion, Project project, long l, Phase phase, long l2, int n, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            companion.logPhaseFinished(project, l, phase, l2, n);
        }

        @JvmStatic
        public final void logError(@Nullable Project project, long activityId, @NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            ThrowableDescription description = new ThrowableDescription(throwable);
            int framesHash = throwable instanceof ExternalSystemException ? ((ExternalSystemException)throwable).getOriginalReason().hashCode() : ((Object)description.getLastFrames(50)).hashCode();
            ArrayList<EventPair> data2 = new ArrayList<EventPair>();
            data2.add(this.getActivityIdField().with((Object)activityId));
            data2.add(this.getSeverityField().with((Object)"fatal"));
            PluginId pluginId = PluginUtil.getInstance().findPluginId(throwable);
            data2.add(EventFields.PluginInfo.with((Object)(pluginId == null ? PluginInfoDetectorKt.getPlatformPlugin() : PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId))));
            data2.add(this.getErrorField().with((Object)description.getClassName()));
            if (ourErrorsRateThrottle.tryPass(System.currentTimeMillis())) {
                data2.add(this.getErrorHashField().with((Object)framesHash));
            } else {
                data2.add(this.getTooManyErrorsField().with((Object)true));
            }
            Collection $this$toTypedArray$iv = data2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            EventPair[] eventPairArray = thisCollection$iv.toArray(new EventPair[0]);
            if (eventPairArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            errorEvent.log(project, Arrays.copyOf(eventPairArray, eventPairArray.length));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

