/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.lang.reflect.Field;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ExternalSystemUiUtil {
    public static final int INSETS = 5;
    private static final int BALLOON_FADEOUT_TIME = 5000;

    private ExternalSystemUiUtil() {
    }

    public static void showBalloon(@NotNull JComponent component2, @NotNull MessageType messageType, @NotNull @Nls String message2) {
        Balloon.Position position;
        int x;
        int y;
        if (component2 == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(0);
        }
        if (messageType == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(1);
        }
        if (message2 == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(2);
        }
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, messageType, null).setDisposable((Disposable)ApplicationManager.getApplication()).setFadeoutTime(5000L);
        Balloon balloon2 = builder2.createBalloon();
        Dimension size = component2.getSize();
        if (size == null) {
            y = 0;
            x = 0;
            position = Balloon.Position.above;
        } else {
            x = Math.min(10, size.width / 2);
            y = size.height;
            position = Balloon.Position.below;
        }
        balloon2.show(new RelativePoint((Component)component2, new Point(x, y)), position);
    }

    @NotNull
    public static GridBag getLabelConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)5, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        GridBag gridBag = new GridBag().anchor(17).weightx(0.0).insets((Insets)insets);
        if (gridBag == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(3);
        }
        return gridBag;
    }

    @NotNull
    public static GridBag getFillLineConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)5, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        GridBag gridBag = new GridBag().weightx(1.0).coverLine().fillCellHorizontally().anchor(17).insets((Insets)insets);
        if (gridBag == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(4);
        }
        return gridBag;
    }

    public static void fillBottom(@NotNull JComponent component2) {
        if (component2 == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(5);
        }
        component2.add(Box.createVerticalGlue(), new GridBag().weightx(1.0).weighty(1.0).fillCell().coverLine());
    }

    public static void showUi(@NotNull Object o, boolean show2) {
        if (o == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(6);
        }
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object v = field.get(o);
                    if (!(v instanceof JComponent)) continue;
                    ((JComponent)v).setVisible(show2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public static void disposeUi(@NotNull Object o) {
        if (o == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(7);
        }
        for (Class<?> clazz = o.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object v = field.get(o);
                    if (!(v instanceof JComponent)) continue;
                    field.set(o, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    public static ExternalSystemUiAware getUiAware(@NotNull ProjectSystemId externalSystemId2) {
        ExternalSystemManager manager2;
        if (externalSystemId2 == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(8);
        }
        DefaultExternalSystemUiAware defaultExternalSystemUiAware = (manager2 = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId2)) instanceof ExternalSystemUiAware ? (ExternalSystemUiAware)manager2 : DefaultExternalSystemUiAware.INSTANCE;
        if (defaultExternalSystemUiAware == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(9);
        }
        return defaultExternalSystemUiAware;
    }

    public static void executeAction(@NotNull String actionId, @NotNull InputEvent e) {
        ActionManager actionManager;
        AnAction action2;
        if (actionId == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(10);
        }
        if (e == null) {
            ExternalSystemUiUtil.$$$reportNull$$$0(11);
        }
        if ((action2 = (actionManager = ActionManager.getInstance()).getAction(actionId)) == null) {
            return;
        }
        Presentation presentation2 = new Presentation();
        DataContext context2 = DataManager.getInstance().getDataContext(e.getComponent());
        AnActionEvent event = new AnActionEvent(e, context2, "", presentation2, actionManager, 0);
        action2.update(event);
        if (presentation2.isEnabled()) {
            action2.actionPerformed(event);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUiUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelConstraints";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFillLineConstraints";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiAware";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showBalloon";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillBottom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showUi";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disposeUi";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUiAware";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

