/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.FileSystems;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class RootFileElement
extends FileElement {
    private static final Logger LOG = Logger.getInstance(RootFileElement.class);
    private List<VirtualFile> myFiles;
    private Object[] myChildren;

    public RootFileElement(@NotNull List<VirtualFile> files2, String name2, boolean showFileSystemRoots) {
        if (files2 == null) {
            RootFileElement.$$$reportNull$$$0(0);
        }
        super(files2.size() == 1 ? files2.get(0) : null, name2);
        this.myFiles = files2.size() == 0 && showFileSystemRoots ? null : files2;
    }

    public Object[] getChildren() {
        if (this.myChildren == null) {
            if (this.myFiles == null) {
                this.myFiles = RootFileElement.getFileSystemRoots();
            }
            this.myChildren = this.myFiles.stream().filter(Objects::nonNull).map(file2 -> new FileElement(file2, file2.getPresentableUrl())).toArray();
        }
        return this.myChildren;
    }

    private static List<VirtualFile> getFileSystemRoots() {
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        StreamEx paths2 = StreamEx.of(FileSystems.getDefault().getRootDirectories().spliterator());
        if (WSLUtil.isSystemCompatible() && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser")) {
            CompletableFuture<List<WSLDistribution>> future2 = WslDistributionManager.getInstance().getInstalledDistributionsFuture();
            try {
                List<WSLDistribution> distributions = future2.get(200L, TimeUnit.MILLISECONDS);
                paths2 = (StreamEx)paths2.append((Stream)StreamEx.of(distributions).map(WSLDistribution::getUNCRootPath));
            }
            catch (Exception e) {
                LOG.info("Cannot fetch WSL distributions", (Throwable)e);
            }
        }
        return paths2.map(path2 -> localFileSystem2.findFileByNioFile(path2)).nonNull().toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileChooser/ex/RootFileElement", "<init>"));
    }
}

