/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.actions.DragEditorTabsFusEventFields;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockableEditorTabbedContainer
implements DockContainer.Persistent,
Activatable,
Disposable {
    private final EditorsSplitters mySplitters;
    private final Project myProject;
    private final CopyOnWriteArraySet<DockContainer.Listener> myListeners;
    private JBTabs myCurrentOver;
    private Image myCurrentOverImg;
    private TabInfo myCurrentOverInfo;
    private AbstractPainter myCurrentPainter;
    private Disposable myGlassPaneListenersDisposable;
    private final boolean myDisposeWhenEmpty;
    private boolean myWasEverShown;

    DockableEditorTabbedContainer(Project project, @NotNull EditorsSplitters splitters, boolean disposeWhenEmpty) {
        if (splitters == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(0);
        }
        this.myListeners = new CopyOnWriteArraySet();
        this.myGlassPaneListenersDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.mySplitters = splitters;
        this.myDisposeWhenEmpty = disposeWhenEmpty;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.mySplitters);
    }

    public String getDockContainerType() {
        return "file-editors";
    }

    public Element getState() {
        Element editors2 = new Element("state");
        this.mySplitters.writeExternal(editors2);
        return editors2;
    }

    void fireContentClosed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(1);
        }
        for (DockContainer.Listener each : this.myListeners) {
            each.contentRemoved((Object)file2);
        }
    }

    void fireContentOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(2);
        }
        for (DockContainer.Listener each : this.myListeners) {
            each.contentAdded((Object)file2);
        }
    }

    @NotNull
    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle((JComponent)((Object)this.mySplitters));
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content2, RelativePoint point) {
        JBTabs tabs;
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(3);
        }
        DockContainer.ContentResponse contentResponse = (tabs = this.getTabsAt(content2, point)) != null && !tabs.getPresentation().isHideTabs() ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        if (contentResponse == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(4);
        }
        return contentResponse;
    }

    @Nullable
    private JBTabs getTabsAt(DockableContent<?> content2, RelativePoint point) {
        EditorWindow[] windows;
        if (!(content2 instanceof EditorTabbedContainer.DockableEditor)) {
            return null;
        }
        JBTabs targetTabs = this.mySplitters.getTabsAt(point);
        if (targetTabs != null) {
            return targetTabs;
        }
        EditorWindow window = this.mySplitters.getCurrentWindow();
        if (window != null) {
            return window.getTabbedPane().getTabs();
        }
        for (EditorWindow each : windows = this.mySplitters.getWindows()) {
            if (each.getTabbedPane().getTabs() == null) continue;
            return each.getTabbedPane().getTabs();
        }
        return null;
    }

    public void add(@NotNull DockableContent content2, RelativePoint dropTarget) {
        int index2;
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(5);
        }
        EditorWindow window = null;
        EditorTabbedContainer.DockableEditor dockableEditor = (EditorTabbedContainer.DockableEditor)content2;
        VirtualFile file2 = dockableEditor.getFile();
        Integer dragStartLocation = (Integer)file2.getUserData(EditorWindow.DRAG_START_LOCATION_HASH_KEY);
        boolean sameWindow = this.myCurrentOver != null && dragStartLocation != null && dragStartLocation == System.identityHashCode(this.myCurrentOver);
        int dropSide = this.getCurrentDropSide();
        if (this.myCurrentOver != null) {
            DataProvider provider2 = this.myCurrentOver.getDataProvider();
            if (provider2 != null) {
                window = EditorWindow.DATA_KEY.getData(provider2);
            }
            if (window != null && dropSide != -1 && dropSide != 0) {
                window.split(dropSide == 3 || dropSide == 1 ? 0 : 1, true, file2, true, dropSide != 2 && dropSide != 1);
                this.recordDragStats(dropSide, false);
                return;
            }
        }
        boolean dropIntoNewlyCreatedWindow = false;
        if (window == null || window.isDisposed()) {
            dropIntoNewlyCreatedWindow = true;
            window = this.mySplitters.getOrCreateCurrentWindow(file2);
        }
        Boolean dropInBetweenPinnedTabs = null;
        boolean dropInPinnedRow = false;
        if (this.myCurrentOver != null) {
            Integer dragStartIndex;
            boolean isDroppedToOriginalPlace;
            index2 = ((JBTabsEx)this.myCurrentOver).getDropInfoIndex();
            if (index2 >= 0 && index2 <= this.myCurrentOver.getTabCount()) {
                boolean previousIsPinned;
                TabInfo tabInfo = index2 == this.myCurrentOver.getTabCount() ? null : this.myCurrentOver.getTabAt(index2);
                TabInfo previousInfo = index2 > 0 ? this.myCurrentOver.getTabAt(index2 - 1) : null;
                boolean bl = previousIsPinned = previousInfo != null && previousInfo.isPinned();
                if (file2.getUserData(EditorWindow.DRAG_START_PINNED_KEY) == Boolean.TRUE) {
                    dropInBetweenPinnedTabs = index2 == 0 || tabInfo != null && tabInfo.isPinned() || previousIsPinned;
                } else {
                    Boolean bl2 = dropInBetweenPinnedTabs = tabInfo != null ? Boolean.valueOf(tabInfo.isPinned()) : null;
                }
                if (index2 > 0 && previousIsPinned) {
                    Component previousLabel = this.myCurrentOver.getTabLabel(previousInfo);
                    Rectangle bounds2 = previousLabel.getBounds();
                    Point dropPoint = dropTarget.getPoint(previousLabel);
                    dropInPinnedRow = this.myCurrentOver instanceof JBTabsImpl && UISettings.getInstance().getState().getShowPinnedTabsInASeparateRow() && ((JBTabsImpl)this.myCurrentOver).getTabsPosition() == JBTabsPosition.top && bounds2.y < dropPoint.y && bounds2.getMaxY() > (double)dropPoint.y;
                }
            }
            boolean bl = isDroppedToOriginalPlace = (dragStartIndex = (Integer)file2.getUserData(EditorWindow.DRAG_START_INDEX_KEY)) != null && dragStartIndex == index2 && sameWindow;
            if (!isDroppedToOriginalPlace) {
                file2.putUserData(EditorWindow.DRAG_START_PINNED_KEY, dropInBetweenPinnedTabs);
            }
            if (dropInPinnedRow) {
                file2.putUserData(EditorWindow.DRAG_START_INDEX_KEY, (Object)(index2 + 1));
                file2.putUserData(EditorWindow.DRAG_START_PINNED_KEY, (Object)Boolean.TRUE);
                dropInBetweenPinnedTabs = true;
            }
        } else {
            index2 = -1;
        }
        this.recordDragStats(dropIntoNewlyCreatedWindow ? -1 : 0, sameWindow);
        FileEditorOpenOptions openOptions = new FileEditorOpenOptions().withIndex(index2).withRequestFocus();
        ((FileEditorManagerImpl)FileEditorManagerEx.getInstanceEx(this.myProject)).openFileImpl2(window, file2, openOptions);
        window.setFilePinned(file2, Objects.requireNonNullElseGet(dropInBetweenPinnedTabs, dockableEditor::isPinned));
    }

    private void recordDragStats(int dropSide, boolean sameWindow) {
        String actionId = null;
        switch (dropSide) {
            case -1: {
                actionId = "OpenElementInNewWindow";
                break;
            }
            case 1: {
                actionId = "SplitVertically";
                break;
            }
            case 2: {
                actionId = "SplitHorizontally";
                break;
            }
            case 3: {
                actionId = "MoveTabDown";
                break;
            }
            case 4: {
                actionId = "MoveTabRight";
                break;
            }
            case 0: {
                return;
            }
        }
        if (actionId != null) {
            AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)new MouseEvent((Component)((Object)this.mySplitters), 506, System.currentTimeMillis(), 0, 0, 0, 0, false, 1), (String)"EditorTab", null, (DataContext)DataContext.EMPTY_CONTEXT);
            ActionsCollectorImpl.recordActionInvoked(this.myProject, ActionManager.getInstance().getAction(actionId), event, Collections.singletonList(ActionsEventLogGroup.ADDITIONAL.with((Object)new ObjectEventData(new EventPair[]{DragEditorTabsFusEventFields.SAME_WINDOW.with((Object)sameWindow)}))));
        }
    }

    public int getCurrentDropSide() {
        return this.myCurrentOver instanceof JBTabsEx ? ((JBTabsEx)this.myCurrentOver).getDropSide() : -1;
    }

    public Image processDropOver(@NotNull DockableContent content2, RelativePoint point) {
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(6);
        }
        JBTabs current2 = this.getTabsAt(content2, point);
        if (this.myCurrentOver != null && this.myCurrentOver != current2) {
            this.resetDropOver(content2);
        }
        if (this.myCurrentOver == null && current2 != null) {
            this.myCurrentOver = current2;
            Presentation presentation2 = content2.getPresentation();
            this.myCurrentOverInfo = new TabInfo((JComponent)new JLabel("")).setText(presentation2.getText()).setIcon(presentation2.getIcon());
            this.myCurrentOverImg = this.myCurrentOver.startDropOver(this.myCurrentOverInfo, point);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.processDropOver(this.myCurrentOverInfo, point);
        }
        if (this.myCurrentPainter == null) {
            this.myCurrentPainter = new MyDropAreaPainter();
            this.myGlassPaneListenersDisposable = Disposer.newDisposable((String)"GlassPaneListeners");
            Disposer.register((Disposable)this, (Disposable)this.myGlassPaneListenersDisposable);
            IdeGlassPaneUtil.find((Component)this.myCurrentOver.getComponent()).addPainter((Component)this.myCurrentOver.getComponent(), (Painter)this.myCurrentPainter, this.myGlassPaneListenersDisposable);
        }
        if (this.myCurrentPainter instanceof MyDropAreaPainter) {
            ((MyDropAreaPainter)this.myCurrentPainter).processDropOver();
        }
        return this.myCurrentOverImg;
    }

    public void resetDropOver(@NotNull DockableContent content2) {
        if (content2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(7);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.resetDropOver(this.myCurrentOverInfo);
            this.myCurrentOver = null;
            this.myCurrentOverInfo = null;
            this.myCurrentOverImg = null;
            Disposer.dispose((Disposable)this.myGlassPaneListenersDisposable);
            this.myGlassPaneListenersDisposable = Disposer.newDisposable();
            this.myCurrentPainter = null;
        }
    }

    public JComponent getContainerComponent() {
        return this.mySplitters;
    }

    public EditorsSplitters getSplitters() {
        return this.mySplitters;
    }

    public void close(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(8);
        }
        this.mySplitters.closeFile(file2, false);
    }

    public void closeAll() {
        for (VirtualFile each : this.mySplitters.getOpenFileList()) {
            this.close(each);
        }
    }

    public void addListener(final @NotNull DockContainer.Listener listener2, Disposable parent) {
        if (listener2 == null) {
            DockableEditorTabbedContainer.$$$reportNull$$$0(9);
        }
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DockableEditorTabbedContainer.this.myListeners.remove(listener2);
            }
        });
    }

    public boolean isEmpty() {
        return this.mySplitters.isEmptyVisible();
    }

    public boolean isDisposeWhenEmpty() {
        return this.myDisposeWhenEmpty;
    }

    public void showNotify() {
        if (!this.myWasEverShown) {
            this.myWasEverShown = true;
            this.getSplitters().openFiles();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitters";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fireContentClosed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fireContentOpen";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContentResponse";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDropOver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetDropOver";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDropAreaPainter
    extends AbstractPainter {
        private Shape myBoundingBox;

        private MyDropAreaPainter() {
        }

        public boolean needsRepaint() {
            return this.myBoundingBox != null;
        }

        public void executePaint(Component component2, Graphics2D g) {
            if (this.myBoundingBox == null) {
                return;
            }
            GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
            g.fill(this.myBoundingBox);
        }

        private void processDropOver() {
            this.myBoundingBox = null;
            this.setNeedsRepaint(true);
            Rectangle r = DockableEditorTabbedContainer.this.myCurrentOver.getDropArea();
            int currentDropSide = DockableEditorTabbedContainer.this.getCurrentDropSide();
            if (currentDropSide == -1) {
                return;
            }
            TabsUtil.updateBoundsWithDropSide((Rectangle)r, (int)currentDropSide);
            this.myBoundingBox = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
        }
    }
}

