/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class OpenFilesActivity
implements StartupActivity {
    OpenFilesActivity() {
    }

    public void runActivity(@NotNull Project project) {
        FileEditorManager fileEditorManager;
        if (project == null) {
            OpenFilesActivity.$$$reportNull$$$0(0);
        }
        if (!((fileEditorManager = FileEditorManager.getInstance((Project)project)) instanceof FileEditorManagerImpl)) {
            return;
        }
        ProgressIndicator indicator2 = ProgressManager.getInstance().getProgressIndicator();
        if (indicator2 != null) {
            indicator2.setText(IdeBundle.message((String)"progress.text.reopening.files", (Object[])new Object[0]));
        }
        FileEditorManagerImpl manager2 = (FileEditorManagerImpl)fileEditorManager;
        EditorsSplitters editorSplitters = manager2.getMainSplitters();
        Ref<JPanel> panelRef = editorSplitters.restoreEditors();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (panelRef != null) {
                editorSplitters.doOpenFiles((JPanel)panelRef.get());
            }
            manager2.initDockableContentFactory();
            EditorsSplitters.stopOpenFilesActivity(project);
            if (!manager2.hasOpenFiles() && !ProjectUtil.isNotificationSilentMode((Project)project)) {
                project.putUserData(FileEditorManagerImpl.NOTHING_WAS_OPENED_ON_START, (Object)true);
                if (AdvancedSettings.getBoolean((String)"ide.open.readme.md.on.startup")) {
                    RunOnceUtil.runOnceForProject((Project)project, (String)"ShowReadmeOnStart", () -> OpenFilesActivity.findAndOpenReadme(project));
                }
            }
        }, project.getDisposed());
    }

    private static void findAndOpenReadme(Project project) {
        VirtualFile readme;
        VirtualFile dir = ProjectUtil.guessProjectDir((Project)project);
        if (dir != null && (readme = dir.findChild("README.md")) != null && !readme.isDirectory()) {
            ApplicationManager.getApplication().invokeLater(() -> TextEditorWithPreview.openPreviewForFile(project, readme), project.getDisposed());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/OpenFilesActivity", "runActivity"));
    }
}

