/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class UniqueNameEditorTabTitleProvider
implements EditorTabTitleProvider {
    @Override
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        UISettings uiSettings;
        if (project == null) {
            UniqueNameEditorTabTitleProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            UniqueNameEditorTabTitleProvider.$$$reportNull$$$0(1);
        }
        if ((uiSettings = UISettings.getInstanceOrNull()) == null || !uiSettings.getShowDirectoryForNonUniqueFilenames() || DumbService.isDumb((Project)project)) {
            return null;
        }
        String uniqueName = uiSettings.getEditorTabPlacement() == 0 ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file2) : UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePathWithinOpenedFileEditors(project, file2);
        uniqueName = UniqueNameEditorTabTitleProvider.getEditorTabText(uniqueName, File.separator, uiSettings.getHideKnownExtensionInTabs());
        return uniqueName.equals(file2.getName()) ? null : uniqueName;
    }

    @NlsSafe
    public static String getEditorTabText(String result2, String separator2, boolean hideKnownExtensionInTabs) {
        String withoutExtension;
        if (hideKnownExtensionInTabs && StringUtil.isNotEmpty((String)(withoutExtension = FileUtilRt.getNameWithoutExtension((String)result2))) && !withoutExtension.endsWith(separator2)) {
            return withoutExtension;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/fileEditor/impl/UniqueNameEditorTabTitleProvider";
        objectArray[2] = "getEditorTabTitle";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

