/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.advanced;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.advanced.AdvancedSettingBean;
import com.intellij.openapi.options.advanced.AdvancedSettingType;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.serialization.MutableAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@State(name="AdvancedSettings", storages={@Storage(value="advancedSettings.xml"), @Storage(deprecated=true, value="ide.general.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\bH\u0014J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J \u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0004H\u0007J \u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0018H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/options/advanced/AdvancedSettingsImpl;", "Lcom/intellij/openapi/options/advanced/AdvancedSettings;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/intellij/openapi/options/advanced/AdvancedSettingsImpl$AdvancedSettingsState;", "Lcom/intellij/openapi/Disposable;", "()V", "defaultValueCache", "", "", "", "epCollector", "Lcom/intellij/openapi/util/KeyedExtensionCollector;", "Lcom/intellij/openapi/options/advanced/AdvancedSettingBean;", "modificationCount", "", "state", "dispose", "", "getOption", "id", "getOptionOrNull", "getSetting", "getSettingAndType", "Lkotlin/Pair;", "Lcom/intellij/openapi/options/advanced/AdvancedSettingType;", "getState", "getStateModificationCount", "isNonDefault", "", "loadState", "setSetting", "value", "revertOnDispose", "expectType", "AdvancedSettingsState", "intellij.platform.ide.impl"})
public final class AdvancedSettingsImpl
extends AdvancedSettings
implements PersistentStateComponentWithModificationTracker<AdvancedSettingsState>,
Disposable {
    private final KeyedExtensionCollector<AdvancedSettingBean, String> epCollector = new KeyedExtensionCollector(AdvancedSettingBean.EP_NAME.getName());
    private Map<String, Object> state;
    private Map<String, Object> defaultValueCache;
    private long modificationCount;

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AdvancedSettingsState getState() {
        void $this$mapTo$iv$iv;
        AdvancedSettingsState advancedSettingsState = new AdvancedSettingsState();
        boolean bl = false;
        boolean bl2 = false;
        AdvancedSettingsState it = advancedSettingsState;
        boolean bl3 = false;
        Map<String, Object> $this$map$iv = this.state;
        boolean $i$f$map = false;
        Map<String, Object> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var11_11 = $this$mapTo$iv$iv;
        boolean bl4 = false;
        Iterator iterator2 = var11_11.entrySet().iterator();
        while (iterator2.hasNext()) {
            void k;
            void $dstr$k$v;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            void var18_18 = $dstr$k$v;
            boolean bl6 = false;
            String string = (String)var18_18.getKey();
            var18_18 = $dstr$k$v;
            bl6 = false;
            Object v = var18_18.getValue();
            Pair pair = TuplesKt.to((Object)k, (Object)this.getOption((String)k).valueToString(v));
            collection.add(pair);
        }
        MapsKt.toMap((Iterable)((List)destination$iv$iv), it.getSettings());
        return advancedSettingsState;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull AdvancedSettingsState state) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state.clear();
        Map<String, String> $this$mapNotNull$iv = state.getSettings();
        boolean $i$f$mapNotNull = false;
        Map<String, String> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var9_9.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            void k;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry $dstr$k$v = element$iv$iv;
            boolean bl3 = false;
            Object object = $dstr$k$v;
            boolean bl4 = false;
            String string = (String)object.getKey();
            object = $dstr$k$v;
            bl4 = false;
            String v = (String)object.getValue();
            AdvancedSettingBean advancedSettingBean = this.getOptionOrNull((String)k);
            if (advancedSettingBean != null) {
                object = advancedSettingBean;
                bl4 = false;
                boolean bl5 = false;
                Object option2 = object;
                boolean bl6 = false;
                pair = TuplesKt.to((Object)k, (Object)((AdvancedSettingBean)option2).valueFromString(v));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl7 = false;
            boolean bl8 = false;
            Pair it$iv$iv = pair2;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        MapsKt.toMap((Iterable)((List)destination$iv$iv), this.state);
    }

    public long getStateModificationCount() {
        return this.modificationCount;
    }

    public void setSetting(@NotNull String id2, @NotNull Object value2, @NotNull AdvancedSettingType expectType) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)expectType, (String)"expectType");
        AdvancedSettingBean option2 = this.getOption(id2);
        if (option2.type() != expectType) {
            throw (Throwable)new IllegalArgumentException("Setting type " + option2.type() + " does not match parameter type " + expectType);
        }
        Object instance2 = option2.getServiceInstance();
        if (instance2 != null) {
            MutableAccessor mutableAccessor = option2.getAccessor();
            if (mutableAccessor != null) {
                MutableAccessor mutableAccessor2 = mutableAccessor;
                boolean bl = false;
                boolean bl2 = false;
                MutableAccessor it = mutableAccessor2;
                boolean bl3 = false;
                it.set(instance2, value2);
                return;
            }
        }
        Object oldValue = this.getSetting(id2);
        if (Intrinsics.areEqual((Object)option2.getDefaultValueObject(), (Object)value2)) {
            this.state.remove(id2);
        } else {
            this.state.put(id2, value2);
        }
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ((AdvancedSettingsChangeListener)application.getMessageBus().syncPublisher(AdvancedSettingsChangeListener.TOPIC)).advancedSettingChanged(id2, oldValue, value2);
    }

    @NotNull
    protected Object getSetting(@NotNull String id2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        AdvancedSettingBean option2 = this.getOption(id2);
        Object instance2 = option2.getServiceInstance();
        if (instance2 != null) {
            MutableAccessor mutableAccessor = option2.getAccessor();
            if (mutableAccessor != null) {
                MutableAccessor mutableAccessor2 = mutableAccessor;
                boolean bl = false;
                boolean bl2 = false;
                MutableAccessor it = mutableAccessor2;
                boolean bl3 = false;
                Object object2 = it.read(instance2);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.read(instance)");
                return object2;
            }
        }
        if ((object = this.state.get(id2)) == null) {
            Map<String, Object> $this$getOrPut$iv = this.defaultValueCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(id2);
            if (value$iv == null) {
                boolean bl = false;
                Object answer$iv = this.getOption(id2).getDefaultValueObject();
                $this$getOrPut$iv.put(id2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
        }
        return object;
    }

    private final AdvancedSettingBean getOption(String id2) {
        AdvancedSettingBean advancedSettingBean = this.getOptionOrNull(id2);
        if (advancedSettingBean == null) {
            throw (Throwable)new IllegalArgumentException("Can't find advanced setting " + id2);
        }
        return advancedSettingBean;
    }

    private final AdvancedSettingBean getOptionOrNull(String id2) {
        return (AdvancedSettingBean)this.epCollector.findSingle((Object)id2);
    }

    private final Pair<Object, AdvancedSettingType> getSettingAndType(String id2) {
        AdvancedSettingBean option2 = this.getOption(id2);
        return TuplesKt.to((Object)this.getSetting(id2), (Object)option2.type());
    }

    public final boolean isNonDefault(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Map<String, Object> map2 = this.state;
        boolean bl = false;
        Map<String, Object> map3 = map2;
        boolean bl2 = false;
        return map3.containsKey(id2);
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void setSetting(@NotNull String id2, @NotNull Object value2, @NotNull Disposable revertOnDispose) {
        void oldValue;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)revertOnDispose, (String)"revertOnDispose");
        Pair<Object, AdvancedSettingType> pair = this.getSettingAndType(id2);
        Object object = pair.component1();
        AdvancedSettingType type = (AdvancedSettingType)pair.component2();
        this.setSetting(id2, value2, type);
        Disposer.register((Disposable)revertOnDispose, (Disposable)new Disposable(this, id2, oldValue, type){
            final /* synthetic */ AdvancedSettingsImpl this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ Object $oldValue;
            final /* synthetic */ AdvancedSettingType $type;

            public final void dispose() {
                this.this$0.setSetting(this.$id, this.$oldValue, this.$type);
            }
            {
                this.this$0 = advancedSettingsImpl;
                this.$id = string;
                this.$oldValue = object;
                this.$type = advancedSettingType;
            }
        });
    }

    public AdvancedSettingsImpl() {
        boolean bl = false;
        this.state = new LinkedHashMap();
        bl = false;
        this.defaultValueCache = new LinkedHashMap();
        AdvancedSettingBean.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<AdvancedSettingBean>(){

            public void extensionRemoved(@NotNull AdvancedSettingBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                defaultValueCache.remove(extension2.id);
            }
        }, (Disposable)this);
    }

    public static final /* synthetic */ void access$setDefaultValueCache$p(AdvancedSettingsImpl $this, Map map2) {
        $this.defaultValueCache = map2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/options/advanced/AdvancedSettingsImpl$AdvancedSettingsState;", "", "()V", "settings", "", "", "getSettings", "()Ljava/util/Map;", "setSettings", "(Ljava/util/Map;)V", "intellij.platform.ide.impl"})
    public static final class AdvancedSettingsState {
        @NotNull
        private Map<String, String> settings;

        @NotNull
        public final Map<String, String> getSettings() {
            return this.settings;
        }

        public final void setSettings(@NotNull Map<String, String> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.settings = map2;
        }

        public AdvancedSettingsState() {
            boolean bl = false;
            this.settings = new LinkedHashMap();
        }
    }
}

