/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.MutableConfigurableGroup;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.Banner;
import com.intellij.openapi.options.newEditor.ConfigurableController;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.ISettingsTreeViewFactory;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsSearch;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

final class SettingsEditor
extends AbstractEditor
implements DataProvider,
Place.Navigator {
    private static final String SELECTED_CONFIGURABLE = "settings.editor.selected.configurable";
    private static final String SPLITTER_PROPORTION = "settings.editor.splitter.proportion";
    private static final float SPLITTER_PROPORTION_DEFAULT_VALUE = 0.2f;
    private final PropertiesComponent myProperties;
    private final Settings mySettings;
    private final SettingsSearch mySearch;
    private final SettingsFilter myFilter;
    private final SettingsTreeView myTreeView;
    private final ConfigurableEditor myEditor;
    private final OnePixelSplitter mySplitter;
    private final SpotlightPainter mySpotlightPainter;
    private final LoadingDecorator myLoadingDecorator;
    @NotNull
    private final Banner myBanner;
    private final History myHistory;
    private final Map<Configurable, ConfigurableController> myControllers;
    private ConfigurableController myLastController;

    SettingsEditor(@NotNull Disposable parent, @NotNull Project project, @NotNull List<? extends ConfigurableGroup> groups2, @Nullable Configurable configurable2, String filter, @NotNull ISettingsTreeViewFactory factory2) {
        String id2;
        if (parent == null) {
            SettingsEditor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SettingsEditor.$$$reportNull$$$0(1);
        }
        if (groups2 == null) {
            SettingsEditor.$$$reportNull$$$0(2);
        }
        if (factory2 == null) {
            SettingsEditor.$$$reportNull$$$0(3);
        }
        super(parent);
        this.myHistory = new History((Place.Navigator)this);
        this.myControllers = new HashMap<Configurable, ConfigurableController>();
        this.myProperties = PropertiesComponent.getInstance((Project)project);
        this.mySettings = new Settings(groups2){

            @Override
            @NotNull
            protected Promise<? super Object> selectImpl(Configurable configurable2) {
                SettingsEditor.this.myFilter.update(null);
                Promise<? super Object> promise = SettingsEditor.this.myTreeView.select(configurable2);
                if (promise == null) {
                    1.$$$reportNull$$$0(0);
                }
                return promise;
            }

            @Override
            @Nullable
            protected Configurable getConfigurableWithInitializedUiComponentImpl(@Nullable Configurable configurable2, boolean initializeUiComponentIfNotYet) {
                JComponent content2 = SettingsEditor.this.myEditor.getContent(configurable2);
                if (!initializeUiComponentIfNotYet || content2 != null) {
                    return content2 == null ? null : configurable2;
                }
                SettingsEditor.this.myEditor.readContent(configurable2);
                return configurable2;
            }

            @Override
            protected void checkModifiedImpl(@NotNull Configurable configurable2) {
                if (configurable2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                SettingsEditor.this.checkModified(configurable2);
            }

            @Override
            protected void setSearchText(String search2) {
                SettingsEditor.this.myFilter.update(search2);
            }

            @Override
            public void revalidate() {
                SettingsEditor.this.myEditor.requestUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsEditor$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configurable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectImpl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "checkModifiedImpl";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.mySearch = new SettingsSearch(){

            @Override
            void onTextKeyEvent(KeyEvent event) {
                SettingsEditor.this.myTreeView.myTree.processKeyEvent(event);
            }
        };
        JPanel searchPanel2 = new JPanel((LayoutManager)new VerticalLayout(0));
        searchPanel2.add("CENTER", (Component)((Object)this.mySearch));
        this.myFilter = new SettingsFilter(project, groups2, this.mySearch){

            @Override
            Configurable getConfigurable(SimpleNode node2) {
                return SettingsTreeView.getConfigurable(node2);
            }

            @Override
            SimpleNode findNode(Configurable configurable2) {
                return SettingsEditor.this.myTreeView.findNode(configurable2);
            }

            @Override
            void updateSpotlight(boolean now) {
                if (!SettingsEditor.this.myDisposed && SettingsEditor.this.mySpotlightPainter != null) {
                    if (!now) {
                        SettingsEditor.this.mySpotlightPainter.updateLater();
                    } else {
                        SettingsEditor.this.mySpotlightPainter.updateNow();
                    }
                }
            }
        };
        this.myFilter.myContext.addColleague(new OptionsEditorColleague(){

            @Override
            @NotNull
            public Promise<? super Object> onSelected(@Nullable Configurable configurable2, Configurable oldConfigurable) {
                if (configurable2 != null) {
                    SettingsEditor.this.myProperties.setValue(SettingsEditor.SELECTED_CONFIGURABLE, ConfigurableVisitor.getId(configurable2));
                    SettingsEditor.this.myHistory.pushQueryPlace();
                    SettingsEditor.this.myLoadingDecorator.startLoading(false);
                }
                SettingsEditor.this.checkModified(oldConfigurable);
                Promise<? super Object> result2 = SettingsEditor.this.myEditor.select(configurable2);
                result2.onSuccess(it -> {
                    SettingsEditor.this.updateController(configurable2);
                    SettingsEditor.this.myLoadingDecorator.stopLoading();
                });
                Promise<? super Object> promise = result2;
                if (promise == null) {
                    4.$$$reportNull$$$0(0);
                }
                return promise;
            }

            @Override
            @NotNull
            public Promise<? super Object> onModifiedAdded(Configurable configurable2) {
                return this.updateIfCurrent(configurable2);
            }

            @Override
            @NotNull
            public Promise<? super Object> onModifiedRemoved(Configurable configurable2) {
                return this.updateIfCurrent(configurable2);
            }

            @Override
            @NotNull
            public Promise<? super Object> onErrorsChanged() {
                return this.updateIfCurrent(SettingsEditor.this.myFilter.myContext.getCurrentConfigurable());
            }

            @NotNull
            private Promise<? super Object> updateIfCurrent(@Nullable Configurable configurable2) {
                if (configurable2 != null && configurable2 == SettingsEditor.this.myFilter.myContext.getCurrentConfigurable()) {
                    SettingsEditor.this.updateStatus(configurable2);
                    Promise promise = Promises.resolvedPromise();
                    if (promise == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return promise;
                }
                Promise promise = Promises.cancelledPromise();
                if (promise == null) {
                    4.$$$reportNull$$$0(2);
                }
                return promise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/options/newEditor/SettingsEditor$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "onSelected";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "updateIfCurrent";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        this.myTreeView = factory2.createTreeView(this.myFilter, groups2);
        this.myTreeView.myTree.addKeyListener((KeyListener)this.mySearch);
        this.myEditor = new ConfigurableEditor(this, null){

            @Override
            boolean apply() {
                SettingsEditor.this.checkModified(SettingsEditor.this.myFilter.myContext.getCurrentConfigurable());
                if (SettingsEditor.this.myFilter.myContext.getModified().isEmpty()) {
                    return true;
                }
                LinkedHashMap<Configurable, ConfigurationException> map2 = new LinkedHashMap<Configurable, ConfigurationException>();
                for (Configurable configurable2 : SettingsEditor.this.myFilter.myContext.getModified()) {
                    ConfigurationException exception = ConfigurableEditor.apply(configurable2);
                    if (exception != null) {
                        map2.put(configurable2, exception);
                        continue;
                    }
                    if (configurable2.isModified()) continue;
                    SettingsEditor.this.myFilter.myContext.fireModifiedRemoved(configurable2, null);
                }
                SettingsEditor.this.mySearch.updateToolTipText();
                SettingsEditor.this.myFilter.myContext.fireErrorsChanged(map2, null);
                if (!map2.isEmpty()) {
                    Configurable targetConfigurable = (Configurable)map2.keySet().iterator().next();
                    ConfigurationException exception = (ConfigurationException)((Object)map2.get(targetConfigurable));
                    Configurable originator = exception.getOriginator();
                    if (originator != null) {
                        targetConfigurable = originator;
                    }
                    SettingsEditor.this.myTreeView.select(targetConfigurable);
                    return false;
                }
                SettingsEditor.this.updateStatus(SettingsEditor.this.myFilter.myContext.getCurrentConfigurable());
                return true;
            }

            @Override
            void updateCurrent(Configurable configurable2, boolean reset2) {
                if (reset2 && configurable2 != null) {
                    SettingsEditor.this.myFilter.myContext.fireReset(configurable2);
                }
                SettingsEditor.this.checkModified(configurable2);
            }

            @Override
            void openLink(Configurable configurable2) {
                SettingsEditor.this.mySettings.select(configurable2);
            }
        };
        this.myEditor.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myEditor, (Disposable)this, 10, true);
        this.myLoadingDecorator.setOverlayBackground(LoadingDecorator.OVERLAY_BACKGROUND);
        this.myBanner = new Banner(this.myEditor.getResetAction());
        searchPanel2.setBorder((Border)JBUI.Borders.empty((int)7, (int)5, (int)6, (int)5));
        this.myBanner.setBorder((Border)JBUI.Borders.empty((int)11, (int)6, (int)0, (int)10));
        this.mySearch.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        searchPanel2.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        JPanel left = new JPanel(new BorderLayout());
        left.add("North", searchPanel2);
        left.add("Center", this.myTreeView);
        JPanel right = new JPanel(new BorderLayout());
        right.add("North", this.withHistoryToolbar(this.myBanner));
        right.add("Center", this.myLoadingDecorator.getComponent());
        this.mySplitter = new OnePixelSplitter(false, this.myProperties.getFloat(SPLITTER_PROPORTION, 0.2f));
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)left);
        this.mySplitter.setSecondComponent((JComponent)right);
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            this.mySplitter.getDivider().setOpaque(false);
        }
        this.mySpotlightPainter = new SpotlightPainter(this.myEditor, this){

            @Override
            void updateNow() {
                Configurable configurable2 = SettingsEditor.this.myFilter.myContext.getCurrentConfigurable();
                if (SettingsEditor.this.myTreeView.myTree.hasFocus() || SettingsEditor.this.mySearch.getTextEditor().hasFocus()) {
                    this.update(SettingsEditor.this.myFilter, configurable2, SettingsEditor.this.myEditor.getContent(configurable2));
                }
            }
        };
        this.add("Center", (Component)this.mySplitter);
        if (configurable2 == null && (configurable2 = ConfigurableVisitor.findById((id2 = this.myProperties.getValue(SELECTED_CONFIGURABLE)) != null ? id2 : "preferences.lookFeel", groups2)) == null) {
            configurable2 = ConfigurableVisitor.find(ConfigurableVisitor.ALL, groups2);
        }
        this.myTreeView.select(configurable2).onSuccess(it -> this.myFilter.update(filter));
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
        this.installSpotlightRemover();
        this.mySearch.getTextEditor().addActionListener(event -> this.myTreeView.select(this.myFilter.myContext.getCurrentConfigurable()).onSuccess(o -> this.requestFocusToEditor()));
        for (ConfigurableGroup configurableGroup : groups2) {
            if (!(configurableGroup instanceof MutableConfigurableGroup)) continue;
            MutableConfigurableGroup mutable = (MutableConfigurableGroup)configurableGroup;
            Disposer.register((Disposable)this, (Disposable)mutable);
            mutable.addListener(this.createReloadListener(groups2));
        }
    }

    @NotNull
    private MutableConfigurableGroup.Listener createReloadListener(final List<? extends ConfigurableGroup> groups2) {
        return new MutableConfigurableGroup.Listener(){

            @Override
            public void handleUpdate() {
                Configurable candidate;
                Configurable selected2 = SettingsEditor.this.myEditor.getConfigurable();
                String id2 = selected2 instanceof SearchableConfigurable ? ((SearchableConfigurable)selected2).getId() : null;
                SettingsEditor.this.myEditor.reload();
                SettingsEditor.this.myFilter.reload();
                SettingsEditor.this.myControllers.clear();
                SettingsEditor.this.myLastController = null;
                Configurable configurable2 = candidate = id2 == null ? null : ConfigurableVisitor.findById(id2, groups2);
                if (candidate == null) {
                    candidate = ConfigurableVisitor.findById("preferences.pluginManager", groups2);
                }
                SettingsEditor.this.myEditor.init(candidate, false);
                SettingsEditor.this.myTreeView.reloadWithSelection(candidate);
                SettingsEditor.this.mySettings.reload();
                SettingsEditor.this.invalidate();
                SettingsEditor.this.repaint();
            }
        };
    }

    private void requestFocusToEditor() {
        JComponent component2 = this.myEditor.getPreferredFocusedComponent();
        if (component2 != null) {
            IdeFocusManager.findInstanceByComponent((Component)component2).requestFocus((Component)component2, true);
        }
    }

    private void installSpotlightRemover() {
        FocusAdapter spotlightRemover = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component comp = e.getOppositeComponent();
                if (comp == SettingsEditor.this.mySearch.getTextEditor() || comp == SettingsEditor.this.myTreeView.myTree) {
                    return;
                }
                SettingsEditor.this.mySpotlightPainter.update(null, null, null);
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!StringUtil.isEmpty((String)SettingsEditor.this.mySearch.getText())) {
                    SettingsEditor.this.mySpotlightPainter.updateNow();
                }
            }
        };
        this.myTreeView.myTree.addFocusListener((FocusListener)spotlightRemover);
        this.mySearch.getTextEditor().addFocusListener((FocusListener)spotlightRemover);
    }

    private JComponent withHistoryToolbar(JComponent component2) {
        ActionGroup group2 = ActionUtil.getActionGroup((String[])new String[]{"Back", "Forward"});
        if (group2 == null) {
            return component2;
        }
        JComponent toolbar = ActionUtil.createToolbarComponent((JComponent)this, (String)"SettingsHistory", (ActionGroup)group2, (boolean)true);
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        panel2.add((Component)component2, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets = JBUI.insets((int)8, (int)2, (int)0, (int)0);
        panel2.add((Component)toolbar, gbc);
        return panel2;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            SettingsEditor.$$$reportNull$$$0(4);
        }
        place.putPath(SELECTED_CONFIGURABLE, (Object)this.myProperties.getValue(SELECTED_CONFIGURABLE));
    }

    @NotNull
    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Object path2 = place == null ? null : place.getPath(SELECTED_CONFIGURABLE);
        String id2 = path2 instanceof String ? (String)path2 : null;
        ActionCallback actionCallback = this.mySettings.select(id2 == null ? null : this.mySettings.find(id2));
        if (actionCallback == null) {
            SettingsEditor.$$$reportNull$$$0(5);
        }
        return actionCallback;
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            SettingsEditor.$$$reportNull$$$0(6);
        }
        return History.KEY.is(dataId) ? this.myHistory : (Settings.KEY.is(dataId) ? this.mySettings : (SearchTextField.KEY.is(dataId) ? this.mySearch : null));
    }

    @Override
    void disposeOnce() {
        if (this.myProperties == null || this.mySplitter == null) {
            return;
        }
        this.myProperties.setValue(SPLITTER_PROPORTION, this.mySplitter.getProportion(), 0.2f);
    }

    @Override
    Action getApplyAction() {
        return this.myEditor.getApplyAction();
    }

    @Override
    Action getResetAction() {
        return null;
    }

    @Override
    String getHelpTopic() {
        Configurable configurable2 = this.myFilter.myContext.getCurrentConfigurable();
        while (configurable2 != null) {
            String topic = configurable2.getHelpTopic();
            if (topic != null) {
                return topic;
            }
            configurable2 = this.myFilter.myContext.getParentConfigurable(configurable2);
        }
        return "preferences";
    }

    @Override
    boolean apply() {
        return this.myEditor.apply();
    }

    @Override
    boolean cancel(AWTEvent source) {
        if (source instanceof KeyEvent && this.myFilter.myContext.isHoldingFilter()) {
            this.mySearch.setText("");
            return false;
        }
        for (Configurable configurable2 : this.myFilter.myContext.getModified()) {
            configurable2.cancel();
        }
        return super.cancel(source);
    }

    @Override
    JComponent getPreferredFocusedComponent() {
        return this.myTreeView != null ? this.myTreeView.myTree : this.myEditor;
    }

    @Nullable Collection<@NlsContexts.ConfigurableName String> getPathNames() {
        return this.myTreeView == null ? null : this.myTreeView.getPathNames(this.myFilter.myContext.getCurrentConfigurable());
    }

    public void addOptionsListener(OptionsEditorColleague colleague) {
        this.myFilter.myContext.addColleague(colleague);
    }

    void updateStatus(Configurable configurable2) {
        this.myFilter.updateSpotlight(configurable2 == null);
        if (this.myEditor != null) {
            ConfigurationException exception = this.myFilter.myContext.getErrors().get(configurable2);
            this.myEditor.getApplyAction().setEnabled(!this.myFilter.myContext.getModified().isEmpty());
            this.myEditor.getResetAction().setEnabled(this.myFilter.myContext.isModified(configurable2) || exception != null);
            this.myEditor.setError(exception);
            this.myEditor.revalidate();
        }
        if (configurable2 != null) {
            new Alarm().addRequest(() -> {
                if (!this.myDisposed && this.mySpotlightPainter != null) {
                    this.mySpotlightPainter.updateNow();
                }
            }, 300);
        }
    }

    private void updateController(@Nullable Configurable configurable2) {
        ConfigurableController controller;
        Project project = this.myTreeView.findConfigurableProject(configurable2);
        this.myBanner.setProjectText(project != null ? SettingsEditor.getProjectText(project) : null);
        this.myBanner.setText(this.myTreeView.getPathNames(configurable2));
        if (this.myLastController != null) {
            this.myLastController.setBanner(null);
            this.myLastController = null;
        }
        if ((controller = ConfigurableController.getOrCreate(configurable2, this.myControllers)) != null) {
            this.myLastController = controller;
            controller.setBanner(this.myBanner);
        }
    }

    void checkModified(Configurable configurable2) {
        Configurable parent = this.myFilter.myContext.getParentConfigurable(configurable2);
        if (ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)parent)) {
            this.checkModifiedForItem(parent);
            for (Configurable child2 : this.myFilter.myContext.getChildren(parent)) {
                this.checkModifiedForItem(child2);
            }
        } else if (configurable2 != null) {
            this.checkModifiedForItem(configurable2);
        }
        this.updateStatus(configurable2);
    }

    private void checkModifiedForItem(Configurable configurable2) {
        if (configurable2 != null) {
            JComponent component2 = this.myEditor.getContent(configurable2);
            if (component2 == null && ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)configurable2)) {
                component2 = this.myEditor.readContent(configurable2);
            }
            if (component2 != null) {
                this.checkModifiedInternal(configurable2);
            }
        }
    }

    private void checkModifiedInternal(Configurable configurable2) {
        if (configurable2.isModified()) {
            this.myFilter.myContext.fireModifiedAdded(configurable2, null);
        } else if (!this.myFilter.myContext.getErrors().containsKey(configurable2)) {
            this.myFilter.myContext.fireModifiedRemoved(configurable2, null);
        }
    }

    @NotNull
    @Nls
    private static String getProjectText(@NotNull Project project) {
        if (project == null) {
            SettingsEditor.$$$reportNull$$$0(7);
        }
        IdeUICustomization customization = IdeUICustomization.getInstance();
        String string = project.isDefault() ? customization.projectMessage("configurable.default.project.tooltip", new Object[0]) : customization.projectMessage("configurable.current.project.tooltip", new Object[0]);
        if (string == null) {
            SettingsEditor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "navigateTo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProjectText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

