/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableTreeRenderer;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.options.newEditor.ConfigurableMarkerProvider;
import com.intellij.openapi.options.newEditor.ConfigurableProjectProvider;
import com.intellij.openapi.options.newEditor.CopySettingsPathAction;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.tree.ui.DefaultControl;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SettingsTreeView
extends JComponent
implements Accessible,
Disposable,
OptionsEditorColleague {
    private static final int ICON_GAP = 5;
    private static final String NODE_ICON = "settings.tree.view.icon";
    private static final Color WRONG_CONTENT = JBColor.namedColor((String)"Tree.errorForeground", (Color)JBColor.RED);
    private static final Color MODIFIED_CONTENT = JBColor.namedColor((String)"Tree.modifiedItemForeground", (Color)JBColor.BLUE);
    final SimpleTree myTree;
    private final MyBuilder myBuilder;
    private final SettingsFilter myFilter;
    private final JScrollPane myScroller;
    private final Map<Configurable, MyNode> myConfigurableToNodeMap;
    private final MergingUpdateQueue myQueue;
    private final MyRoot myRoot;
    private Configurable myQueuedConfigurable;
    private MyControl myControl;

    public SettingsTreeView(@NotNull SettingsFilter filter, @NotNull List<? extends ConfigurableGroup> groups2) {
        if (filter == null) {
            SettingsTreeView.$$$reportNull$$$0(0);
        }
        if (groups2 == null) {
            SettingsTreeView.$$$reportNull$$$0(1);
        }
        this.myConfigurableToNodeMap = new IdentityHashMap<Configurable, MyNode>();
        this.myQueue = new MergingUpdateQueue("SettingsTreeView", 150, false, (JComponent)this, (Disposable)this, (JComponent)this).setRestartTimerOnAdd(true);
        this.myFilter = filter;
        this.myTree = new MyTree();
        this.myTree.putClientProperty((Object)RenderingUtil.ALWAYS_PAINT_SELECTION_AS_FOCUSED, (Object)true);
        this.myTree.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myTree.getInputMap().clear();
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setOpaque(true);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new MyRenderer());
        this.myTree.setRootVisible(false);
        this.myTree.setExpandableItemsEnabled(false);
        RelativeFont.BOLD.install((Component)this.myTree);
        SettingsTreeView.setComponentPopupMenuTo((JTree)this.myTree);
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                return SettingsTreeView.createTransferable(SettingsTreeView.this.myTree.getSelectionPath());
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this.myScroller = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        this.myScroller.setViewport((JViewport)((Object)new GradientViewport((Component)this.myTree, (Insets)JBUI.insetsTop((int)5), true){
            private JLabel myHeader;

            @Override
            protected Component getHeader() {
                if (0 == SettingsTreeView.this.myTree.getY()) {
                    return null;
                }
                if (this.myHeader == null) {
                    this.myHeader = new JLabel();
                    this.myHeader.setForeground(UIUtil.getTreeForeground());
                    this.myHeader.setIconTextGap(JBUIScale.scale((int)5));
                    this.myHeader.setBorder((Border)JBUI.Borders.empty((int)2, (int)(10 + SettingsTreeView.getLeftMargin(0)), (int)0, (int)0));
                }
                this.myHeader.setFont(SettingsTreeView.this.myTree.getFont());
                this.myHeader.setIcon(SettingsTreeView.this.getIcon(null, false));
                int height = this.myHeader.getPreferredSize().height;
                String group2 = SettingsTreeView.this.findGroupNameAt(0, height + 3);
                if (group2 == null || !group2.equals(SettingsTreeView.this.findGroupNameAt(0, 0))) {
                    return null;
                }
                this.myHeader.setText(group2);
                return this.myHeader;
            }
        }));
        this.myScroller.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myScroller.getViewport().setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myScroller.getVerticalScrollBar().setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myScroller.setHorizontalScrollBarPolicy(31);
        this.add(this.myScroller);
        this.myTree.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(event -> {
            MyNode node2 = SettingsTreeView.extractNode(event.getNewLeadSelectionPath());
            this.select(node2 == null ? null : node2.myConfigurable);
        });
        this.myRoot = new MyRoot(groups2);
        this.myBuilder = new MyBuilder((SimpleTreeStructure)new SimpleTreeStructure.Impl((SimpleNode)this.myRoot));
        this.myBuilder.setFilteringMerge(300, null);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myTree.getAccessibleContext().setAccessibleName(UIBundle.message((String)"settings.tree.settings.categories.accessible.name", (Object[])new Object[0]));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.myControl = null;
    }

    private Icon getIcon(@Nullable DefaultMutableTreeNode node2, boolean selected2) {
        if (this.myControl == null) {
            this.myControl = new MyControl();
        }
        if (node2 == null || 0 == node2.getChildCount()) {
            return this.myControl.empty;
        }
        return this.myTree.isExpanded(new TreePath(node2.getPath())) ? this.myControl.expanded.apply(selected2) : this.myControl.collapsed.apply(selected2);
    }

    private static void setComponentPopupMenuTo(final JTree tree) {
        tree.setComponentPopupMenu(new JPopupMenu(){
            @Nullable
            private Collection<String> names;
            {
                for (Action action2 : CopySettingsPathAction.createSwingActions(() -> this.names)) {
                    this.add(action2);
                }
            }

            @Override
            public void show(Component invoker, int x, int y) {
                this.names = null;
                if (invoker != tree) {
                    return;
                }
                TreePath path2 = tree.getClosestPathForLocation(x, y);
                this.names = SettingsTreeView.getPathNames(SettingsTreeView.extractNode(path2));
                if (this.names.isEmpty()) {
                    return;
                }
                Rectangle bounds2 = tree.getPathBounds(path2);
                if (bounds2 == null || bounds2.y > y) {
                    return;
                }
                bounds2.y += bounds2.height;
                if (bounds2.y < y) {
                    return;
                }
                super.show(invoker, x, bounds2.y);
            }
        });
    }

    @Nullable
    Transferable createTransferable(@Nullable InputEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent mouse = (MouseEvent)event;
            Point location = mouse.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(location, (Component)this.myTree);
            return SettingsTreeView.createTransferable(this.myTree.getClosestPathForLocation(location.x, location.y));
        }
        return SettingsTreeView.createTransferable(this.myTree.getSelectionPath());
    }

    @Nullable
    private static Transferable createTransferable(@Nullable TreePath path2) {
        return CopySettingsPathAction.createTransferable(SettingsTreeView.getPathNames(SettingsTreeView.extractNode(path2)));
    }

    @NotNull Collection<@NlsContexts.ConfigurableName String> getPathNames(Configurable configurable2) {
        return SettingsTreeView.getPathNames(this.findNode(configurable2));
    }

    private static @NotNull Collection<@NlsContexts.ConfigurableName String> getPathNames(@Nullable MyNode node2) {
        if (node2 == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                SettingsTreeView.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ArrayDeque<String> path2 = new ArrayDeque<String>();
        while (node2 != null) {
            path2.push(node2.myDisplayName);
            SimpleNode parent = node2.getParent();
            node2 = parent instanceof MyNode ? (MyNode)parent : null;
        }
        ArrayDeque<String> arrayDeque = path2;
        if (arrayDeque == null) {
            SettingsTreeView.$$$reportNull$$$0(3);
        }
        return arrayDeque;
    }

    static Configurable getConfigurable(SimpleNode node2) {
        return node2 instanceof MyNode ? ((MyNode)node2).myConfigurable : null;
    }

    @Nullable
    MyNode findNode(Configurable configurable2) {
        return this.myConfigurableToNodeMap.get(configurable2);
    }

    @Nullable
    Project findConfigurableProject(@Nullable Configurable configurable2) {
        MyNode node2 = this.findNode(configurable2);
        return node2 == null ? null : SettingsTreeView.findConfigurableProject(node2);
    }

    @Nullable
    private static Project findConfigurableProject(@NotNull MyNode node2) {
        if (node2 == null) {
            SettingsTreeView.$$$reportNull$$$0(4);
        }
        Configurable configurable2 = node2.myConfigurable;
        Project project = node2.getProject();
        Configurable.VariableProjectAppLevel wrapped = ConfigurableWrapper.cast(Configurable.VariableProjectAppLevel.class, (UnnamedConfigurable)configurable2);
        if (wrapped != null) {
            return wrapped.isProjectLevel() ? project : null;
        }
        if (configurable2 instanceof ConfigurableWrapper) {
            return project;
        }
        if (configurable2 instanceof SortedConfigurableGroup) {
            return project;
        }
        SimpleNode parent = node2.getParent();
        return parent instanceof MyNode ? SettingsTreeView.findConfigurableProject((MyNode)parent) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static Project prepareProject(@Nullable CachingSimpleNode parent, @Nullable Configurable configurable2) {
        SortedConfigurableGroup group2;
        Configurable[] configurables;
        if (configurable2 instanceof ConfigurableWrapper) {
            ConfigurableWrapper wrapper2 = (ConfigurableWrapper)configurable2;
            return wrapper2.getExtensionPoint().getProject();
        }
        if (configurable2 instanceof SortedConfigurableGroup && (configurables = (group2 = (SortedConfigurableGroup)configurable2).getConfigurables()).length != 0) {
            Project project = SettingsTreeView.prepareProject(parent, configurables[0]);
            if (project != null) {
                for (int i2 = 1; i2 < configurables.length; ++i2) {
                    if (project == SettingsTreeView.prepareProject(parent, configurables[i2])) continue;
                    return null;
                }
            }
            return project;
        }
        if (configurable2 instanceof ConfigurableProjectProvider) {
            return ((ConfigurableProjectProvider)configurable2).getProject();
        }
        return parent == null ? null : parent.getProject();
    }

    private static int getLeftMargin(int level) {
        return 3 + level * 16;
    }

    @Nullable
    @NlsContexts.ConfigurableName
    private String findGroupNameAt(int x, int y) {
        for (TreePath path2 = this.myTree.getClosestPathForLocation(x - this.myTree.getX(), y - this.myTree.getY()); path2 != null; path2 = path2.getParentPath()) {
            MyNode node2 = SettingsTreeView.extractNode(path2);
            if (node2 == null) {
                return null;
            }
            if (!(node2.getParent() instanceof MyRoot)) continue;
            return node2.myDisplayName;
        }
        return null;
    }

    @Nullable
    private static MyNode extractNode(@Nullable Object object) {
        DefaultMutableTreeNode node2;
        if (object instanceof TreePath) {
            TreePath path2 = (TreePath)object;
            object = path2.getLastPathComponent();
        }
        if (object instanceof DefaultMutableTreeNode) {
            node2 = (DefaultMutableTreeNode)object;
            object = node2.getUserObject();
        }
        if (object instanceof FilteringTreeStructure.FilteringNode) {
            node2 = (FilteringTreeStructure.FilteringNode)object;
            object = node2.getDelegate();
        }
        return object instanceof MyNode ? (MyNode)((Object)object) : null;
    }

    @Override
    public void doLayout() {
        this.myScroller.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    @NotNull
    Promise<? super Object> select(final @Nullable Configurable configurable2) {
        if (this.myBuilder.isSelectionBeingAdjusted()) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                SettingsTreeView.$$$reportNull$$$0(5);
            }
            return promise;
        }
        final AsyncPromise promise = new AsyncPromise();
        this.myQueuedConfigurable = configurable2;
        this.myQueue.queue(new Update(this){

            public void run() {
                if (configurable2 != SettingsTreeView.this.myQueuedConfigurable) {
                    return;
                }
                if (configurable2 == null) {
                    SettingsTreeView.this.fireSelected(null).processed((Promise)promise);
                } else {
                    SettingsTreeView.this.myBuilder.getReady((Object)this).doWhenDone(() -> {
                        if (configurable2 != SettingsTreeView.this.myQueuedConfigurable) {
                            return;
                        }
                        MyNode editorNode = SettingsTreeView.this.findNode(configurable2);
                        FilteringTreeStructure.FilteringNode editorUiNode = SettingsTreeView.this.myBuilder.getVisibleNodeFor((Object)editorNode);
                        if (editorUiNode == null) {
                            return;
                        }
                        Runnable handler2 = () -> SettingsTreeView.this.fireSelected(configurable2).processed((Promise)promise);
                        if (SettingsTreeView.this.myBuilder.getSelectedElements().contains(editorUiNode)) {
                            SettingsTreeView.this.myBuilder.scrollSelectionToVisible(handler2, false);
                        } else {
                            SettingsTreeView.this.myBuilder.select(editorUiNode, handler2);
                        }
                    });
                }
            }

            public void setRejected() {
                super.setRejected();
                promise.cancel();
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            SettingsTreeView.$$$reportNull$$$0(6);
        }
        return asyncPromise;
    }

    @NotNull
    private Promise<? super Object> fireSelected(Configurable configurable2) {
        Promise<? super Object> promise = this.myFilter.myContext.fireSelected(configurable2, this);
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(7);
        }
        return promise;
    }

    public void dispose() {
        this.myQueuedConfigurable = null;
        this.myConfigurableToNodeMap.clear();
    }

    @Override
    @NotNull
    public Promise<? super Object> onSelected(@Nullable Configurable configurable2, Configurable oldConfigurable) {
        Promise<? super Object> promise = this.select(configurable2);
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<? super Object> onModifiedAdded(Configurable configurable2) {
        this.myTree.repaint();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(9);
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<? super Object> onModifiedRemoved(Configurable configurable2) {
        this.myTree.repaint();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(10);
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<? super Object> onErrorsChanged() {
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            SettingsTreeView.$$$reportNull$$$0(11);
        }
        return promise;
    }

    protected void setProjectIcon(JLabel projectIcon, Configurable configurable2, @Nullable Project project, boolean selected2) {
        if (project != null) {
            projectIcon.setIcon(AllIcons.General.ProjectConfigurable);
            projectIcon.setToolTipText(project.isDefault() ? IdeUICustomization.getInstance().projectMessage("configurable.default.project.tooltip", new Object[0]) : IdeUICustomization.getInstance().projectMessage("configurable.current.project.tooltip", new Object[0]));
            projectIcon.setVisible(true);
        } else {
            projectIcon.setVisible(false);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSettingsTreeView();
        }
        return this.accessibleContext;
    }

    void reloadWithSelection(@Nullable Configurable toSelect2) {
        this.myRoot.cleanUpCache();
        this.myQueuedConfigurable = null;
        this.myQueue.cancelAllUpdates();
        this.myConfigurableToNodeMap.clear();
        AbstractTreeUi ui2 = this.myBuilder.getUi();
        if (ui2 == null) {
            return;
        }
        this.myTree.getSelectionModel().clearSelection();
        this.myTree.collapsePath(new TreePath(this.myTree.getModel().getRoot()));
        this.myBuilder.cleanUp();
        ui2.getUpdater().reset();
        AbstractTreeStructure structure = ui2.getTreeStructure();
        if (structure instanceof FilteringTreeStructure) {
            ((FilteringTreeStructure)structure).rebuild();
        }
        MyNode node2 = this.findNode(toSelect2);
        this.myBuilder.refilterNow((Object)node2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsTreeView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsTreeView";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fireSelected";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "onSelected";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "onModifiedAdded";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "onModifiedRemoved";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "onErrorsChanged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurableProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleSettingsTreeView
    extends JComponent.AccessibleJComponent {
        protected AccessibleSettingsTreeView() {
            super(SettingsTreeView.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private final class MyBuilder
    extends FilteringTreeBuilder {
        List<Object> myToExpandOnResetFilter;
        boolean myRefilteringNow;
        boolean myWasHoldingFilter;

        MyBuilder(SimpleTreeStructure structure) {
            super((Tree)SettingsTreeView.this.myTree, (ElementFilter)SettingsTreeView.this.myFilter, (AbstractTreeStructure)structure, null);
            SettingsTreeView.this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    MyBuilder.this.invalidateExpansions();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    MyBuilder.this.invalidateExpansions();
                }
            });
        }

        private void invalidateExpansions() {
            if (!this.myRefilteringNow) {
                this.myToExpandOnResetFilter = null;
            }
        }

        protected boolean isSelectable(Object object) {
            return object instanceof MyNode;
        }

        public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
            return SettingsTreeView.this.myFilter.myContext.isHoldingFilter();
        }

        public boolean isToEnsureSelectionOnFocusGained() {
            return false;
        }

        @NotNull
        protected Promise<?> refilterNow(Object preferredSelection, boolean adjustSelection) {
            ArrayList<Object> toRestore = new ArrayList<Object>();
            if (SettingsTreeView.this.myFilter.myContext.isHoldingFilter() && !this.myWasHoldingFilter && this.myToExpandOnResetFilter == null) {
                AbstractTreeUi ui2 = SettingsTreeView.this.myBuilder.getUi();
                this.myToExpandOnResetFilter = ui2 == null ? null : ui2.getExpandedElements();
            } else if (!SettingsTreeView.this.myFilter.myContext.isHoldingFilter() && this.myWasHoldingFilter && this.myToExpandOnResetFilter != null) {
                toRestore.addAll(this.myToExpandOnResetFilter);
                this.myToExpandOnResetFilter = null;
            }
            this.myWasHoldingFilter = SettingsTreeView.this.myFilter.myContext.isHoldingFilter();
            this.myRefilteringNow = true;
            Promise promise = super.refilterNow(preferredSelection, adjustSelection).onSuccess(o -> {
                this.myRefilteringNow = false;
                if (!SettingsTreeView.this.myFilter.myContext.isHoldingFilter() && this.getSelectedElements().isEmpty()) {
                    this.restoreExpandedState(toRestore);
                }
            });
            if (promise == null) {
                MyBuilder.$$$reportNull$$$0(0);
            }
            return promise;
        }

        private void restoreExpandedState(List<Object> toRestore) {
            List selected2 = TreeUtil.collectSelectedPaths((JTree)SettingsTreeView.this.myTree);
            ArrayList<TreePath> toCollapse = new ArrayList<TreePath>();
            for (int eachRow = 0; eachRow < SettingsTreeView.this.myTree.getRowCount(); ++eachRow) {
                Object eachElement;
                TreePath eachVisiblePath;
                if (!SettingsTreeView.this.myTree.isExpanded(eachRow) || (eachVisiblePath = SettingsTreeView.this.myTree.getPathForRow(eachRow)) == null || toRestore.contains(eachElement = SettingsTreeView.this.myBuilder.getElementFor(eachVisiblePath.getLastPathComponent()))) continue;
                for (TreePath eachSelected : selected2) {
                    if (eachVisiblePath.isDescendant(eachSelected)) continue;
                    toCollapse.add(eachVisiblePath);
                }
            }
            for (TreePath each : toCollapse) {
                SettingsTreeView.this.myTree.collapsePath(each);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/SettingsTreeView$MyBuilder", "refilterNow"));
        }
    }

    private static final class MyTreeUi
    extends WideSelectionTreeUI {
        private MyTreeUi() {
        }

        public Rectangle getPathBounds(JTree tree, TreePath path2) {
            Rectangle bounds2 = super.getPathBounds(tree, path2);
            if (bounds2 != null) {
                bounds2.width = Math.max(bounds2.width, tree.getWidth() - bounds2.x);
            }
            return bounds2;
        }

        boolean processMouseEvent(MouseEvent event) {
            if (this.tree instanceof SimpleTree) {
                Component component2;
                boolean toggleNow;
                SimpleTree tree = (SimpleTree)this.tree;
                boolean bl = toggleNow = 502 == event.getID() && UIUtil.isActionClick((MouseEvent)event, (int)502) && !this.isToggleEvent(event);
                if ((toggleNow || 501 == event.getID()) && (component2 = tree.getDeepestRendererComponentAt(event.getX(), event.getY())) instanceof JLabel && SettingsTreeView.NODE_ICON.equals(component2.getName())) {
                    MyControl.MyIcon icon2 = (MyControl.MyIcon)ObjectUtils.tryCast((Object)((JLabel)component2).getIcon(), MyControl.MyIcon.class);
                    if (icon2 == null || icon2.expanded == null) {
                        return false;
                    }
                    if (toggleNow) {
                        this.toggleExpandState(tree.getPathForLocation(event.getX(), event.getY()));
                    }
                    event.consume();
                    return true;
                }
            }
            return false;
        }

        protected boolean shouldPaintExpandControl(TreePath path2, int row2, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            return false;
        }

        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds2, TreePath path2, int row2, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path2) {
        }

        public void paint(Graphics g, JComponent c) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
            super.paint(g, c);
        }

        protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds2, TreePath path2, int row2, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            if (this.tree != null) {
                bounds2.width = this.tree.getWidth();
                JViewport viewport = ComponentUtil.getViewport((Component)this.tree);
                if (viewport != null) {
                    bounds2.width = viewport.getWidth() - viewport.getViewPosition().x - insets.right / 2;
                }
                bounds2.width -= bounds2.x;
            }
            super.paintRow(g, clipBounds, insets, bounds2, path2, row2, isExpanded, hasBeenExpanded, isLeaf);
        }

        protected int getRowX(int row2, int depth) {
            return JBUIScale.scale((int)SettingsTreeView.getLeftMargin(depth - 1));
        }
    }

    private final class MyTree
    extends SimpleTree {
        private MyTree() {
        }

        public String getToolTipText(MouseEvent event) {
            String text2;
            JLabel label2;
            Component component2;
            if (event != null && (component2 = this.getDeepestRendererComponentAt(event.getX(), event.getY())) instanceof JLabel && (label2 = (JLabel)component2).getIcon() != null && (text2 = label2.getToolTipText()) != null) {
                return text2;
            }
            return super.getToolTipText(event);
        }

        protected boolean paintNodes() {
            return false;
        }

        protected boolean highlightSingleNode() {
            return false;
        }

        public void setUI(TreeUI ui2) {
            super.setUI((TreeUI)(ui2 instanceof MyTreeUi ? ui2 : new MyTreeUi()));
            this.setRowHeight(UIManager.getInt("SettingsTree.rowHeight"));
        }

        protected void configureUiHelper(TreeUIHelper helper2) {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        protected void processMouseEvent(MouseEvent event) {
            MyTreeUi ui2 = (MyTreeUi)((Object)SettingsTreeView.this.myTree.getUI());
            if (!ui2.processMouseEvent(event)) {
                super.processMouseEvent(event);
            }
        }
    }

    private final class MyRenderer
    extends CellRendererPanel
    implements TreeCellRenderer {
        final SimpleColoredComponent myTextLabel = new SimpleColoredComponent();
        final JLabel myNodeIcon = new JLabel();
        final JLabel myProjectIcon = new JLabel();
        Pair<Component, ConfigurableTreeRenderer.Layout> myRenderInfo;

        MyRenderer() {
            this.setLayout(new BorderLayout(JBUIScale.scale((int)4), 0));
            this.myNodeIcon.setName(SettingsTreeView.NODE_ICON);
            this.myTextLabel.setOpaque(false);
            this.myTextLabel.setIpad((Insets)JBInsets.create((int)1, (int)0));
            this.add("Center", (Component)this.myTextLabel);
            this.add("West", this.myNodeIcon);
            this.add("East", this.myProjectIcon);
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)3, (int)10));
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new MyAccessibleContext();
            }
            return this.accessibleContext;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean focused) {
            String label2;
            Configurable configurable2;
            this.myTextLabel.clear();
            this.setPreferredSize(null);
            MyNode node2 = SettingsTreeView.extractNode(value2);
            boolean isGroup = node2 != null && node2.getParent() instanceof MyRoot;
            String name2 = node2 != null ? node2.myDisplayName : String.valueOf(value2);
            this.myTextLabel.append(name2, isGroup ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.myTextLabel.setFont(isGroup ? SettingsTreeView.this.myTree.getFont() : StartupUiUtil.getLabelFont());
            this.myTextLabel.setForeground(selected2 ? UIUtil.getTreeSelectionForeground((boolean)true) : UIUtil.getTreeForeground());
            if (!selected2 && node2 != null && (configurable2 = node2.myConfigurable) != null) {
                if (SettingsTreeView.this.myFilter.myContext.getErrors().containsKey(configurable2)) {
                    this.myTextLabel.setForeground(WRONG_CONTENT);
                } else if (SettingsTreeView.this.myFilter.myContext.getModified().contains(configurable2)) {
                    this.myTextLabel.setForeground(MODIFIED_CONTENT);
                }
            }
            Project project = node2 != null ? SettingsTreeView.findConfigurableProject(node2) : null;
            Configurable configurable3 = node2 != null ? node2.myConfigurable : null;
            SettingsTreeView.this.setProjectIcon(this.myProjectIcon, configurable3, project, selected2);
            this.prepareRenderer(node2 != null, node2, (UnnamedConfigurable)configurable3, selected2);
            Icon nodeIcon = value2 instanceof DefaultMutableTreeNode ? SettingsTreeView.this.getIcon((DefaultMutableTreeNode)value2, selected2) : null;
            this.myNodeIcon.setIcon(nodeIcon);
            if (configurable3 instanceof ConfigurableMarkerProvider && (label2 = ((ConfigurableMarkerProvider)configurable3).getMarkerText()) != null) {
                this.myTextLabel.append("   ", SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
                this.myTextLabel.append(label2, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES, false);
            }
            if (node2 != null && UISettings.getInstance().getShowInplaceCommentsInternal()) {
                ConfigurableWrapper wrapper2;
                ConfigurableWrapper configurableWrapper = wrapper2 = configurable3 instanceof ConfigurableWrapper ? (ConfigurableWrapper)configurable3 : null;
                @NonNls String id2 = wrapper2 != null ? wrapper2.getId() : (configurable3 instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable3).getId() : configurable3.getClass().getSimpleName());
                PluginDescriptor plugin2 = wrapper2 != null ? wrapper2.getExtensionPoint().getPluginDescriptor() : null;
                PluginId pluginId = plugin2 == null ? null : plugin2.getPluginId();
                String pluginName = pluginId == null || PluginManagerCore.CORE_ID.equals((Object)pluginId) ? null : plugin2.getName();
                this.myTextLabel.append("   ", SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
                this.myTextLabel.append((String)(pluginName == null ? id2 : id2 + " (" + pluginName + ")"), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES, false);
            }
            if (node2 != null && tree.isVisible()) {
                JScrollBar bar;
                int width = SettingsTreeView.getLeftMargin(node2.myLevel) + this.getPreferredSize().width;
                Insets insets = tree.getInsets();
                if (insets != null) {
                    width += insets.left + insets.right;
                }
                if ((bar = SettingsTreeView.this.myScroller.getVerticalScrollBar()) != null && bar.isVisible()) {
                    width += bar.getWidth();
                }
                width = Math.min(width, 300);
                SettingsTreeView view = SettingsTreeView.this;
                Dimension size = view.getMinimumSize();
                if (size.width < width) {
                    size.width = width;
                    view.setMinimumSize(size);
                    view.revalidate();
                    view.repaint();
                }
            }
            return this;
        }

        private void prepareRenderer(boolean visible, MyNode node2, @Nullable UnnamedConfigurable configurable2, boolean selected2) {
            ConfigurableTreeRenderer renderer2;
            this.myRenderInfo = null;
            if (visible && (renderer2 = node2.getRenderer()) != null) {
                if (configurable2 instanceof ConfigurableWrapper) {
                    configurable2 = ((ConfigurableWrapper)configurable2).getRawConfigurable();
                }
                this.myRenderInfo = renderer2.getDecorator((JComponent)SettingsTreeView.this.myTree, configurable2, selected2);
            }
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            if (this.myRenderInfo != null) {
                Rectangle bounds2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)bounds2, (Insets)this.getInsets());
                Rectangle text2 = this.myTextLabel.getBounds();
                int baseline = this.myTextLabel.getBaseline(text2.width, text2.height);
                if (this.myProjectIcon.getIcon() == null) {
                    this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurable);
                }
                Dimension icon2 = this.myProjectIcon.getPreferredSize();
                Rectangle right = new Rectangle(bounds2.x + bounds2.width - icon2.width, bounds2.y, icon2.width, icon2.height);
                ((ConfigurableTreeRenderer.Layout)this.myRenderInfo.second).layoutBeforePaint((Component)this.myRenderInfo.first, bounds2, text2, right, baseline);
                Rectangle paintBounds = ((Component)this.myRenderInfo.first).getBounds();
                Graphics2D g2 = (Graphics2D)g.create(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                ((Component)this.myRenderInfo.first).paint(g2);
                g2.dispose();
                this.myRenderInfo = null;
            }
        }

        private class MyAccessibleContext
        extends JPanel.AccessibleJPanel {
            private MyAccessibleContext() {
                super((JPanel)((Object)MyRenderer.this));
            }

            @Override
            public String getAccessibleName() {
                return MyRenderer.this.myTextLabel.getCharSequence(true).toString();
            }
        }
    }

    private final class MyNode
    extends CachingSimpleNode {
        private final Configurable.Composite myComposite;
        private final Configurable myConfigurable;
        private final @NlsContexts.ConfigurableName String myDisplayName;
        private final int myLevel;
        private ConfigurableTreeRenderer myRenderer;
        private boolean myPrepareRenderer;

        private MyNode(CachingSimpleNode parent, Configurable configurable2, int level) {
            super(SettingsTreeView.prepareProject(parent, configurable2), (NodeDescriptor)parent);
            this.myPrepareRenderer = true;
            this.myComposite = configurable2 instanceof Configurable.Composite ? (Configurable.Composite)configurable2 : null;
            this.myConfigurable = configurable2;
            String name2 = configurable2.getDisplayName();
            this.myDisplayName = name2 != null ? name2.replace("\n", " ") : "{ " + configurable2.getClass().getSimpleName() + " }";
            this.myLevel = level;
        }

        @Nullable
        public ConfigurableTreeRenderer getRenderer() {
            if (this.myPrepareRenderer) {
                this.myPrepareRenderer = false;
                if (this.myConfigurable instanceof ConfigurableTreeRenderer) {
                    this.myRenderer = (ConfigurableTreeRenderer)this.myConfigurable;
                } else if (this.myConfigurable instanceof ConfigurableWrapper) {
                    ConfigurableWrapper wrapper2 = (ConfigurableWrapper)this.myConfigurable;
                    UnnamedConfigurable configurable2 = wrapper2.getRawConfigurable();
                    this.myRenderer = configurable2 instanceof ConfigurableTreeRenderer ? (ConfigurableTreeRenderer)configurable2 : wrapper2.getExtensionPoint().createTreeRenderer();
                }
            }
            return this.myRenderer;
        }

        protected SimpleNode[] buildChildren() {
            if (this.myConfigurable != null) {
                SettingsTreeView.this.myConfigurableToNodeMap.put(this.myConfigurable, this);
            }
            if (this.myComposite == null) {
                return NO_CHILDREN;
            }
            Configurable[] configurables = this.myComposite.getConfigurables();
            if (configurables.length == 0) {
                return NO_CHILDREN;
            }
            SimpleNode[] result2 = new SimpleNode[configurables.length];
            for (int i2 = 0; i2 < configurables.length; ++i2) {
                result2[i2] = new MyNode(this, configurables[i2], this.myLevel + 1);
                if (this.myConfigurable == null) continue;
                SettingsTreeView.this.myFilter.myContext.registerKid(this.myConfigurable, configurables[i2]);
            }
            return result2;
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            super.update(presentation2);
            presentation2.addText(this.myDisplayName, this.getPlainAttributes());
        }

        public boolean isAlwaysLeaf() {
            return this.myComposite == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/options/newEditor/SettingsTreeView$MyNode", "update"));
        }
    }

    private final class MyRoot
    extends CachingSimpleNode {
        private final List<? extends ConfigurableGroup> myGroups;

        private MyRoot(List<? extends ConfigurableGroup> groups2) {
            if (groups2 == null) {
                MyRoot.$$$reportNull$$$0(0);
            }
            super(null);
            this.myGroups = groups2;
        }

        protected SimpleNode[] buildChildren() {
            if (this.myGroups == null || this.myGroups.isEmpty()) {
                return NO_CHILDREN;
            }
            ArrayList<MyNode> list2 = new ArrayList<MyNode>();
            for (ConfigurableGroup configurableGroup : this.myGroups) {
                for (Configurable configurable2 : configurableGroup.getConfigurables()) {
                    list2.add(new MyNode(this, configurable2, 0));
                }
            }
            return list2.toArray(new SimpleNode[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/openapi/options/newEditor/SettingsTreeView$MyRoot", "<init>"));
        }
    }

    private static final class MyControl {
        private final Control control = new DefaultControl();
        private final Function<Boolean, Icon> collapsed = selected2 -> new MyIcon(false, () -> selected2);
        private final Function<Boolean, Icon> expanded = selected2 -> new MyIcon(true, () -> selected2);
        private final Icon empty = new MyIcon(null, () -> false);

        private MyControl() {
        }

        private final class MyIcon
        implements Icon {
            private final Boolean expanded;
            private final Supplier<Boolean> selected;

            private MyIcon(Boolean expanded2, Supplier<Boolean> selected2) {
                this.expanded = expanded2;
                this.selected = selected2;
            }

            @Override
            public int getIconWidth() {
                return MyControl.this.control.getWidth();
            }

            @Override
            public int getIconHeight() {
                return MyControl.this.control.getHeight();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.expanded != null) {
                    MyControl.this.control.paint(c, g, x, y, this.getIconWidth(), this.getIconHeight(), this.expanded, this.selected.get());
                }
            }
        }
    }
}

