/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.QueueProcessor;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class BackgroundTaskQueue {
    protected final @NlsContexts.ProgressTitle @NotNull String myTitle;
    @NotNull
    protected final QueueProcessor<TaskData> myProcessor;
    private final Object TEST_TASK_LOCK;
    private volatile boolean myForceAsyncInTests;

    public BackgroundTaskQueue(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title2) {
        if (title2 == null) {
            BackgroundTaskQueue.$$$reportNull$$$0(0);
        }
        this.TEST_TASK_LOCK = new Object();
        this.myTitle = title2;
        this.myProcessor = new QueueProcessor(Consumer::accept, true, QueueProcessor.ThreadToUse.AWT, project != null ? project.getDisposed() : ApplicationManager.getApplication().getDisposed());
    }

    public void clear() {
        this.myProcessor.clear();
    }

    public boolean isEmpty() {
        return this.myProcessor.isEmpty();
    }

    public void waitForTasksToFinish() {
        this.myProcessor.waitFor();
    }

    public void run(@NotNull Task.Backgroundable task2) {
        if (task2 == null) {
            BackgroundTaskQueue.$$$reportNull$$$0(1);
        }
        this.run(task2, ModalityState.NON_MODAL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Task.Backgroundable task2, @NotNull ModalityState modalityState, @Nullable ProgressIndicator indicator2) {
        if (task2 == null) {
            BackgroundTaskQueue.$$$reportNull$$$0(2);
        }
        if (modalityState == null) {
            BackgroundTaskQueue.$$$reportNull$$$0(3);
        }
        if (!this.myForceAsyncInTests && ApplicationManager.getApplication().isUnitTestMode()) {
            Object object = this.TEST_TASK_LOCK;
            synchronized (object) {
                BackgroundTaskQueue.getProgressManager().runProcessWithProgressInCurrentThread((Task)task2, (ProgressIndicator)(indicator2 != null ? indicator2 : new EmptyProgressIndicator()), modalityState);
            }
        } else {
            BackgroundableTaskData taskData = new BackgroundableTaskData(task2, modalityState, indicator2);
            this.myProcessor.add((Object)taskData, modalityState);
        }
    }

    @TestOnly
    public void setForceAsyncInTests(boolean value2, @NotNull Disposable disposable2) {
        if (disposable2 == null) {
            BackgroundTaskQueue.$$$reportNull$$$0(4);
        }
        this.myForceAsyncInTests = value2;
        Disposer.register((Disposable)disposable2, () -> {
            this.myForceAsyncInTests = false;
        });
    }

    @NotNull
    private static ProgressManagerImpl getProgressManager() {
        ProgressManagerImpl progressManagerImpl = (ProgressManagerImpl)ProgressManager.getInstance();
        if (progressManagerImpl == null) {
            BackgroundTaskQueue.$$$reportNull$$$0(5);
        }
        return progressManagerImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/BackgroundTaskQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/BackgroundTaskQueue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setForceAsyncInTests";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class BackgroundableTaskData
    implements TaskData {
        @NotNull
        private final Task.Backgroundable myTask;
        @NotNull
        private final ModalityState myModalityState;
        @Nullable
        private final ProgressIndicator myIndicator;

        BackgroundableTaskData(@NotNull Task.Backgroundable task2, @Nullable ModalityState modalityState, ProgressIndicator indicator2) {
            if (task2 == null) {
                BackgroundableTaskData.$$$reportNull$$$0(0);
            }
            if (modalityState == null) {
                BackgroundableTaskData.$$$reportNull$$$0(1);
            }
            this.myTask = task2;
            this.myModalityState = modalityState;
            this.myIndicator = indicator2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NotNull Runnable continuation) {
            boolean synchronous;
            Project taskProject;
            if (continuation == null) {
                BackgroundableTaskData.$$$reportNull$$$0(2);
            }
            if ((taskProject = this.myTask.getProject()) != null && taskProject.isDisposed()) {
                continuation.run();
                return;
            }
            if (StringUtil.isEmptyOrSpaces((String)this.myTask.getTitle())) {
                this.myTask.setTitle(BackgroundTaskQueue.this.myTitle);
            }
            boolean bl = synchronous = this.myTask.isHeadless() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode() && !BackgroundTaskQueue.this.myForceAsyncInTests || this.myTask.isConditionalModal() && !this.myTask.shouldStartInBackground();
            if (synchronous) {
                try {
                    BackgroundTaskQueue.getProgressManager().runProcessWithProgressSynchronously((Task)this.myTask);
                }
                finally {
                    continuation.run();
                }
            } else {
                BackgroundTaskQueue.getProgressManager().runProcessWithProgressAsynchronously(this.myTask, this.getIndicator(), continuation, this.myModalityState);
            }
        }

        @NotNull
        private ProgressIndicator getIndicator() {
            return this.myIndicator != null ? this.myIndicator : (ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(this.myTask));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modalityState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "continuation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/progress/BackgroundTaskQueue$BackgroundableTaskData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    protected static interface TaskData
    extends Consumer<Runnable> {
    }
}

