/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;

public final class DispatchThreadProgressWindow
extends ProgressWindow {
    private long myLastPumpEventsTime;
    private static final int PUMP_INTERVAL = SystemInfo.isWindows ? 100 : 500;
    private Runnable myRunnable;

    public DispatchThreadProgressWindow(boolean shouldShowCancel, Project project) {
        super(shouldShowCancel, project);
    }

    @Override
    public void setText(String text2) {
        super.setText(text2);
        this.pumpEvents();
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.pumpEvents();
    }

    @Override
    public void setText2(String text2) {
        super.setText2(text2);
        this.pumpEvents();
    }

    private void pumpEvents() {
        long time = System.currentTimeMillis();
        if (time - this.myLastPumpEventsTime < (long)PUMP_INTERVAL) {
            return;
        }
        this.myLastPumpEventsTime = time;
        IdeEventQueue.getInstance().flushQueue();
    }

    @Override
    protected void prepareShowDialog() {
        if (this.myRunnable != null) {
            ApplicationManager.getApplication().invokeLater(this.myRunnable, this.getModalityState());
        }
        this.showDialog();
    }

    public void setRunnable(Runnable runnable2) {
        this.myRunnable = runnable2;
    }
}

