/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.impl.ProjectFrameAllocator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.platform.ProjectSelfieUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.ScaleContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.EOFException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0001\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"createNewProjectFrame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "forceDisableAutoRequestFocus", "", "frameInfo", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "readProjectSelfie", "Ljava/awt/Image;", "projectWorkspaceId", "", "frame", "restoreFrameState", "", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "intellij.platform.ide.impl"})
public final class ProjectFrameAllocatorKt {
    private static final void restoreFrameState(ProjectFrameHelper frameHelper, FrameInfo frameInfo) {
        Rectangle rectangle;
        Rectangle rectangle2 = frameInfo.getBounds();
        if (rectangle2 != null) {
            Rectangle rectangle3 = rectangle2;
            boolean bl = false;
            boolean bl2 = false;
            Rectangle it = rectangle3;
            boolean bl3 = false;
            rectangle = FrameBoundsConverter.convertFromDeviceSpaceAndFitToScreen(it);
        } else {
            rectangle = null;
        }
        Rectangle bounds2 = rectangle;
        IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
        Intrinsics.checkNotNull((Object)ideFrameImpl);
        Intrinsics.checkNotNullExpressionValue((Object)ideFrameImpl, (String)"frameHelper.frame!!");
        IdeFrameImpl frame = ideFrameImpl;
        if (bounds2 != null && FrameInfoHelper.Companion.isMaximized(frameInfo.getExtendedState()) && frame.getExtendedState() == 0) {
            frame.getRootPane().putClientProperty("normalBounds", bounds2);
        }
        if (bounds2 != null) {
            frame.setBounds(bounds2);
        }
        frame.setExtendedState(frameInfo.getExtendedState());
        if (frameInfo.getFullScreen() && FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs()) {
            frameHelper.toggleFullScreen(true);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final IdeFrameImpl createNewProjectFrame(boolean forceDisableAutoRequestFocus, @Nullable FrameInfo frameInfo) {
        IdeFrameImpl frame;
        block7: {
            block6: {
                Rectangle deviceBounds;
                frame = new IdeFrameImpl();
                SplashManager.hideBeforeShow(frame);
                FrameInfo frameInfo2 = frameInfo;
                Rectangle rectangle = deviceBounds = frameInfo2 != null ? frameInfo2.getBounds() : null;
                if (deviceBounds == null) {
                    Rectangle rectangle2 = ScreenUtil.getMainScreenBounds();
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"ScreenUtil.getMainScreenBounds()");
                    Dimension size = rectangle2.getSize();
                    int n = 1400;
                    int n2 = size.width - 20;
                    boolean bl = false;
                    size.width = Math.min(n, n2);
                    n = 1000;
                    n2 = size.height - 40;
                    bl = false;
                    size.height = Math.min(n, n2);
                    frame.setSize(size);
                    frame.setLocationRelativeTo(null);
                } else {
                    Rectangle rectangle3 = FrameBoundsConverter.convertFromDeviceSpaceAndFitToScreen(deviceBounds);
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle3, (String)"FrameBoundsConverter.con\u2026FitToScreen(deviceBounds)");
                    Rectangle bounds2 = rectangle3;
                    int state = frameInfo.getExtendedState();
                    boolean isMaximized = FrameInfoHelper.Companion.isMaximized(state);
                    if (isMaximized && frame.getExtendedState() == 0) {
                        frame.getRootPane().putClientProperty("normalBounds", bounds2);
                    }
                    frame.setBounds(bounds2);
                    frame.setExtendedState(state);
                }
                if (forceDisableAutoRequestFocus) break block6;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isActive() || !ComponentUtil.isDisableAutoRequestFocus()) break block7;
            }
            frame.setAutoRequestFocus(false);
        }
        frame.setMinimumSize(new Dimension(340, frame.getMinimumSize().height));
        return frame;
    }

    private static final Image readProjectSelfie(String projectWorkspaceId, IdeFrameImpl frame) {
        block3: {
            if (projectWorkspaceId != null && Registry.is((String)"ide.project.loading.show.last.state", (boolean)false)) {
                try {
                    return ProjectSelfieUtil.readProjectSelfie(projectWorkspaceId, ScaleContext.create((Component)frame));
                }
                catch (Throwable e) {
                    if (e.getCause() instanceof EOFException) break block3;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ProjectFrameAllocator.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn(e);
                }
            }
        }
        return null;
    }

    public static final /* synthetic */ Image access$readProjectSelfie(String projectWorkspaceId, IdeFrameImpl frame) {
        return ProjectFrameAllocatorKt.readProjectSelfie(projectWorkspaceId, frame);
    }

    public static final /* synthetic */ void access$restoreFrameState(ProjectFrameHelper frameHelper, FrameInfo frameInfo) {
        ProjectFrameAllocatorKt.restoreFrameState(frameHelper, frameInfo);
    }
}

