/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressRunner;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.DefaultProjectUiFrameManager;
import com.intellij.openapi.project.impl.ProjectFrameAllocator;
import com.intellij.openapi.project.impl.ProjectFrameAllocatorKt;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.ProjectUiFrameAllocator;
import com.intellij.openapi.project.impl.ProjectUiFrameManager;
import com.intellij.openapi.project.impl.SingleProjectUiFrameManager;
import com.intellij.openapi.project.impl.SplashProjectUiFrameManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.ui.IdeUICustomization;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016JA\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H#0\"\"\b\b\u0000\u0010#*\u00020$2%\u0010%\u001a!\u0012\u0015\u0012\u0013\u0018\u00010'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0006\u0012\u0004\u0018\u0001H#0&H\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/project/impl/ProjectUiFrameAllocator;", "Lcom/intellij/openapi/project/impl/ProjectFrameAllocator;", "options", "Lcom/intellij/ide/impl/OpenProjectTask;", "projectStoreBaseDir", "Ljava/nio/file/Path;", "(Lcom/intellij/ide/impl/OpenProjectTask;Ljava/nio/file/Path;)V", "<set-?>", "", "cancelled", "getCancelled", "()Z", "frameManager", "Lcom/intellij/openapi/project/impl/ProjectUiFrameManager;", "getFrameManager", "()Lcom/intellij/openapi/project/impl/ProjectUiFrameManager;", "setFrameManager", "(Lcom/intellij/openapi/project/impl/ProjectUiFrameManager;)V", "getOptions", "()Lcom/intellij/ide/impl/OpenProjectTask;", "getProjectStoreBaseDir", "()Ljava/nio/file/Path;", "createFrameManager", "getProgressTitle", "", "projectLoaded", "", "project", "Lcom/intellij/openapi/project/Project;", "projectNotLoaded", "error", "Lcom/intellij/conversion/CannotConvertException;", "projectOpened", "run", "Ljava/util/concurrent/CompletableFuture;", "T", "", "task", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lkotlin/ParameterName;", "name", "indicator", "intellij.platform.ide.impl"})
public final class ProjectUiFrameAllocator
extends ProjectFrameAllocator {
    @Nullable
    private ProjectUiFrameManager frameManager;
    private volatile boolean cancelled;
    @NotNull
    private final OpenProjectTask options;
    @NotNull
    private final Path projectStoreBaseDir;

    @Nullable
    public final ProjectUiFrameManager getFrameManager() {
        return this.frameManager;
    }

    public final void setFrameManager(@Nullable ProjectUiFrameManager projectUiFrameManager) {
        this.frameManager = projectUiFrameManager;
    }

    public final boolean getCancelled() {
        return this.cancelled;
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> run(@NotNull Function1<? super ProgressIndicator, ? extends T> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        if (this.options.isNewProject() && this.options.getUseDefaultProjectAsTemplate() && this.options.getProject() == null) {
            ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)run.1.INSTANCE, (int)1, null);
        }
        this.frameManager = this.createFrameManager();
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ApplicationImpl applicationImpl = (ApplicationImpl)application;
        String string = this.getProgressTitle();
        ProjectUiFrameManager projectUiFrameManager = this.frameManager;
        Intrinsics.checkNotNull((Object)projectUiFrameManager);
        CompletableFuture<ProgressWindow> completableFuture = applicationImpl.createProgressWindowAsyncIfNeeded(string, true, true, null, projectUiFrameManager.getComponent(), null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"(ApplicationManager.getA\u2026r!!.getComponent(), null)");
        CompletableFuture<ProgressWindow> progress2 = completableFuture;
        ProgressRunner progressRunner2 = new ProgressRunner(new Function(this, task2){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ Function1 $task;

            @Nullable
            public final T apply(@NotNull ProgressIndicator indicator2) {
                Object object;
                ProjectUiFrameManager projectUiFrameManager = this.this$0.getFrameManager();
                Intrinsics.checkNotNull((Object)projectUiFrameManager);
                projectUiFrameManager.init(this.this$0);
                try {
                    object = this.$task.invoke((Object)indicator2);
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Exception e) {
                    if (e instanceof StartupAbortedException || e instanceof PluginException) {
                        StartupAbortedException.logAndExit(e, null);
                    } else {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(ProjectFrameAllocator.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.error((Throwable)e);
                        Exception exception = e;
                        if (!(exception instanceof CannotConvertException)) {
                            exception = null;
                        }
                        this.this$0.projectNotLoaded((CannotConvertException)exception);
                    }
                    object = null;
                }
                return (T)object;
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$task = function1;
            }
        }).onThread(ProgressRunner.ThreadToUse.FJ).modal().withProgress(progress2);
        Intrinsics.checkNotNullExpressionValue(progressRunner2, (String)"ProgressRunner<T?>(Funct\u2026  .withProgress(progress)");
        ProgressRunner progressRunner3 = progressRunner2;
        CompletableFuture progressResultFuture = null;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (application2.isDispatchThread()) {
            CompletableFuture completableFuture2 = CompletableFuture.completedFuture(progressRunner3.submitAndGet());
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.comple\u2026essRunner.submitAndGet())");
            progressResultFuture = completableFuture2;
        } else {
            CompletableFuture completableFuture3 = progressRunner3.submit();
            Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"progressRunner.submit()");
            progressResultFuture = completableFuture3;
        }
        CompletionStage completionStage = progressResultFuture.thenCompose((Function)run.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"progressResultFuture.the\u2026.throwable)\n      }\n    }");
        return completionStage;
    }

    @NlsContexts.ProgressTitle
    private final String getProgressTitle() {
        String string = this.options.getProjectName();
        if (string == null) {
            Path path2 = this.projectStoreBaseDir.getFileName();
            if (path2 == null) {
                path2 = this.projectStoreBaseDir;
            }
            string = ((Object)path2).toString();
        }
        String projectName = string;
        String string2 = IdeUICustomization.getInstance().projectMessage("progress.title.project.loading.name", new Object[]{projectName});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IdeUICustomization.getIn\u2026ading.name\", projectName)");
        return string2;
    }

    private final ProjectUiFrameManager createFrameManager() {
        if (this.options.getFrameManager() instanceof ProjectUiFrameManager) {
            Object object = this.options.getFrameManager();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.project.impl.ProjectUiFrameManager");
            }
            return (ProjectUiFrameManager)object;
        }
        return (ProjectUiFrameManager)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<ProjectUiFrameManager>(this){
            final /* synthetic */ ProjectUiFrameAllocator this$0;

            @NotNull
            public final ProjectUiFrameManager invoke() {
                ProjectUiFrameManager projectUiFrameManager;
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
                }
                ProjectFrameHelper freeRootFrame = ((WindowManagerImpl)windowManager).removeAndGetRootFrame$intellij_platform_ide_impl();
                if (freeRootFrame != null) {
                    IdeFrameImpl ideFrameImpl = freeRootFrame.getFrame();
                    Intrinsics.checkNotNull((Object)ideFrameImpl);
                    Intrinsics.checkNotNullExpressionValue((Object)ideFrameImpl, (String)"freeRootFrame.frame!!");
                    return new DefaultProjectUiFrameManager(ideFrameImpl, freeRootFrame);
                }
                String name$iv = "create a frame";
                ActivityCategory category$iv = ActivityCategory.DEFAULT;
                boolean $i$f$runActivity = false;
                Activity activity = StartUpMeasurer.startActivity((String)name$iv, (ActivityCategory)category$iv);
                Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startActivity(name, category)");
                Activity activity$iv = activity;
                boolean bl = false;
                IdeFrameImpl preAllocated = (IdeFrameImpl)SplashManager.getAndUnsetProjectFrame();
                if (preAllocated == null) {
                    if (this.this$0.getOptions().getFrameManager() instanceof FrameInfo) {
                        Object object = this.this$0.getOptions().getFrameManager();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.FrameInfo");
                        }
                        Object object2 = this.this$0.getOptions().getFrameManager();
                        if (object2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.FrameInfo");
                        }
                        projectUiFrameManager = new SingleProjectUiFrameManager((FrameInfo)((Object)object), ProjectFrameAllocatorKt.createNewProjectFrame(false, (FrameInfo)((Object)object2)));
                    } else {
                        projectUiFrameManager = new DefaultProjectUiFrameManager(ProjectFrameAllocatorKt.createNewProjectFrame(false, null), null);
                    }
                } else {
                    projectUiFrameManager = new SplashProjectUiFrameManager(preAllocated);
                }
                ProjectUiFrameManager result$iv = projectUiFrameManager;
                activity$iv.end();
                return result$iv;
            }
            {
                this.this$0 = projectUiFrameAllocator;
                super(0);
            }
        }), (int)1, null);
    }

    @Override
    public void projectLoaded(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().invokeLater(new Runnable(this, project){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                Object object = this.this$0.getFrameManager();
                if (object == null || (object = object.getFrameHelper()) == null) {
                    return;
                }
                Object frameHelper = object;
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
                }
                WindowManagerImpl windowManager2 = (WindowManagerImpl)windowManager;
                String name$iv = "project frame assigning";
                ActivityCategory category$iv = ActivityCategory.DEFAULT;
                boolean $i$f$runActivity = false;
                Activity activity = StartUpMeasurer.startActivity((String)name$iv, (ActivityCategory)category$iv);
                Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startActivity(name, category)");
                Activity activity$iv = activity;
                boolean bl = false;
                windowManager2.assignFrame((ProjectFrameHelper)frameHelper, this.$project);
                Unit result$iv = Unit.INSTANCE;
                activity$iv.end();
                name$iv = "tool window pane creation";
                category$iv = ActivityCategory.DEFAULT;
                $i$f$runActivity = false;
                Activity activity2 = StartUpMeasurer.startActivity((String)name$iv, (ActivityCategory)category$iv);
                Intrinsics.checkNotNullExpressionValue((Object)activity2, (String)"StartUpMeasurer.startActivity(name, category)");
                activity$iv = activity2;
                boolean bl2 = false;
                ToolWindowManagerEx.getInstanceEx(this.$project).init((ProjectFrameHelper)frameHelper);
                result$iv = Unit.INSTANCE;
                activity$iv.end();
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$project = project;
            }
        }, project.getDisposed());
    }

    @Override
    public void projectNotLoaded(@Nullable CannotConvertException error) {
        this.cancelled = true;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, error){
            final /* synthetic */ ProjectUiFrameAllocator this$0;
            final /* synthetic */ CannotConvertException $error;

            public final void run() {
                ProjectUiFrameManager projectUiFrameManager = this.this$0.getFrameManager();
                ProjectFrameHelper frameHelper = projectUiFrameManager != null ? projectUiFrameManager.getFrameHelper() : null;
                this.this$0.setFrameManager(null);
                if (this.$error != null) {
                    ProjectFrameHelper projectFrameHelper = frameHelper;
                    ProjectManagerImpl.showCannotConvertMessage(this.$error, projectFrameHelper != null ? projectFrameHelper.getFrame() : null);
                }
                if (frameHelper != null) {
                    if (frameHelper.getProject() == null) {
                        Disposer.dispose((Disposable)frameHelper);
                    } else {
                        WindowManagerEx.getInstanceEx().releaseFrame(frameHelper);
                    }
                }
            }
            {
                this.this$0 = projectUiFrameAllocator;
                this.$error = cannotConvertException;
            }
        });
    }

    @Override
    public void projectOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectUiFrameManager projectUiFrameManager = this.frameManager;
        Intrinsics.checkNotNull((Object)projectUiFrameManager);
        projectUiFrameManager.projectOpened(project);
    }

    @NotNull
    public final OpenProjectTask getOptions() {
        return this.options;
    }

    @NotNull
    public final Path getProjectStoreBaseDir() {
        return this.projectStoreBaseDir;
    }

    public ProjectUiFrameAllocator(@NotNull OpenProjectTask options2, @NotNull Path projectStoreBaseDir) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
        super(options2);
        this.options = options2;
        this.projectStoreBaseDir = projectStoreBaseDir;
    }
}

