/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWsl;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerStore;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHomeFinderBasic {
    private final Logger log = Logger.getInstance(this.getClass());
    private final List<Supplier<Set<String>>> myFinders = new ArrayList<Supplier<Set<String>>>();

    JavaHomeFinderBasic(boolean forceEmbeddedJava, String ... paths2) {
        this(true, forceEmbeddedJava, paths2);
    }

    JavaHomeFinderBasic(boolean checkDefaults, boolean forceEmbeddedJava, String ... paths2) {
        if (checkDefaults) {
            this.myFinders.add(this::checkDefaultLocations);
        }
        this.myFinders.add(this::findInPATH);
        this.myFinders.add(() -> this.findInSpecifiedPaths(paths2));
        this.myFinders.add(this::findJavaInstalledBySdkMan);
        this.myFinders.add(this::findJavaInstalledByAsdfJava);
        this.myFinders.add(this::findJavaInstalledByGradle);
        if (!(this instanceof JavaHomeFinderWsl) && (forceEmbeddedJava || Registry.is((String)"java.detector.include.embedded", (boolean)false))) {
            this.myFinders.add(() -> this.scanAll(JavaHomeFinderBasic.getJavaHome(), false));
        }
    }

    @NotNull
    private Set<String> findInSpecifiedPaths(String[] paths2) {
        Set<String> set2 = this.scanAll(ContainerUtil.map((Object[])paths2, x$0 -> Paths.get(x$0, new String[0])), true);
        if (set2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(0);
        }
        return set2;
    }

    protected void registerFinder(@NotNull Supplier<Set<String>> finder) {
        if (finder == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(1);
        }
        this.myFinders.add(finder);
    }

    @NotNull
    public final Set<String> findExistingJdks() {
        TreeSet<String> result2 = new TreeSet<String>();
        for (Supplier<Set<String>> action2 : this.myFinders) {
            try {
                result2.addAll((Collection<String>)action2.get());
            }
            catch (Exception e) {
                this.log.warn("Failed to find Java Home. " + e.getMessage(), (Throwable)e);
            }
        }
        TreeSet<String> treeSet = result2;
        if (treeSet == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(2);
        }
        return treeSet;
    }

    @NotNull
    private Set<String> findInPATH() {
        Set<String> set2;
        String pathVarString;
        block7: {
            pathVarString = this.getEnvironmentVariable("PATH");
            if (pathVarString != null && !pathVarString.isEmpty()) break block7;
            Set<String> set3 = Collections.emptySet();
            if (set3 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(3);
            }
            return set3;
        }
        try {
            HashSet<Path> dirsToCheck = new HashSet<Path>();
            for (String p : pathVarString.split(File.pathSeparator)) {
                Path parentFile;
                Path dir = Paths.get(p, new String[0]);
                if (!StringUtilRt.equal((CharSequence)dir.getFileName().toString(), (CharSequence)"bin", (boolean)SystemInfoRt.isFileSystemCaseSensitive) || (parentFile = dir.getParent()) == null) continue;
                dirsToCheck.addAll(this.listPossibleJdkInstallRootsFromHomes(parentFile));
            }
            set2 = this.scanAll(dirsToCheck, false);
        }
        catch (Exception e) {
            this.log.warn("Failed to scan PATH for JDKs. " + e.getMessage(), (Throwable)e);
            Set<String> set4 = Collections.emptySet();
            if (set4 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(5);
            }
            return set4;
        }
        if (set2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @Nullable
    protected String getEnvironmentVariable(@NotNull String name2) {
        if (name2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(6);
        }
        return EnvironmentUtil.getValue((String)name2);
    }

    @NotNull
    private Set<String> checkDefaultLocations() {
        if (ApplicationManager.getApplication() == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(7);
            }
            return set2;
        }
        HashSet<Path> paths2 = new HashSet<Path>();
        paths2.add(JdkInstaller.getInstance().defaultInstallDir());
        paths2.addAll(JdkInstallerStore.getInstance().listJdkInstallHomes());
        for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
            String homePath;
            if (!(jdk.getSdkType() instanceof JavaSdkType) || jdk.getSdkType() instanceof DependentSdkType || (homePath = jdk.getHomePath()) == null) continue;
            paths2.addAll(this.listPossibleJdkInstallRootsFromHomes(Paths.get(homePath, new String[0])));
        }
        Set<String> set3 = this.scanAll(paths2, true);
        if (set3 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(8);
        }
        return set3;
    }

    @NotNull
    protected Set<String> scanAll(@Nullable Path file2, boolean includeNestDirs) {
        if (file2 == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(9);
            }
            return set2;
        }
        Set<String> set3 = this.scanAll(Collections.singleton(file2), includeNestDirs);
        if (set3 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(10);
        }
        return set3;
    }

    @NotNull
    protected Set<String> scanAll(@NotNull Collection<? extends Path> files2, boolean includeNestDirs) {
        if (files2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(11);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (Path path2 : new HashSet<Path>(files2)) {
            this.scanFolder(path2, includeNestDirs, result2);
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    protected void scanFolder(@NotNull Path folder, boolean includeNestDirs, @NotNull Collection<? super String> result2) {
        if (folder == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(14);
        }
        if (JdkUtil.checkForJdk((Path)folder)) {
            result2.add(folder.toAbsolutePath().toString());
            return;
        }
        if (!includeNestDirs) {
            return;
        }
        File[] files2 = folder.toFile().listFiles();
        if (files2 == null) {
            return;
        }
        for (File candidate : files2) {
            for (File adjusted : this.listPossibleJdkHomesFromInstallRoot(candidate)) {
                this.scanFolder(adjusted.toPath(), false, result2);
            }
        }
    }

    @NotNull
    protected List<File> listPossibleJdkHomesFromInstallRoot(@NotNull File file2) {
        if (file2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(15);
        }
        List<File> list2 = Collections.singletonList(file2);
        if (list2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    protected List<Path> listPossibleJdkInstallRootsFromHomes(@NotNull Path file2) {
        if (file2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(17);
        }
        List<Path> list2 = Collections.singletonList(file2);
        if (list2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @Nullable
    private static Path getJavaHome() {
        Path javaHome = Path.of(SystemProperties.getJavaHome(), new String[0]);
        return Files.isDirectory(javaHome, new LinkOption[0]) ? javaHome : null;
    }

    @NotNull
    private @NotNull Set<@NotNull String> findJavaInstalledBySdkMan() {
        Set<String> homes;
        Path javasDir;
        block9: {
            Path candidatesDir;
            block8: {
                Set<String> set2;
                try {
                    candidatesDir = this.findSdkManCandidatesDir();
                    if (candidatesDir != null) break block8;
                    set2 = Collections.emptySet();
                }
                catch (Exception e) {
                    this.log.warn("Unexpected exception while looking for Sdkman directory: " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
                    Set<String> set3 = Collections.emptySet();
                    if (set3 == null) {
                        JavaHomeFinderBasic.$$$reportNull$$$0(22);
                    }
                    return set3;
                }
                if (set2 == null) {
                    JavaHomeFinderBasic.$$$reportNull$$$0(19);
                }
                return set2;
            }
            javasDir = candidatesDir.resolve("java");
            if (Files.isDirectory(javasDir, new LinkOption[0])) break block9;
            Set<String> set4 = Collections.emptySet();
            if (set4 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(20);
            }
            return set4;
        }
        Set<String> set5 = homes = this.listJavaHomeDirsInstalledBySdkMan(javasDir);
        if (set5 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(21);
        }
        return set5;
    }

    @NotNull
    private Set<String> findJavaInstalledByGradle() {
        Path jdks = this.getPathInUserHome(".gradle/jdks");
        Set<String> set2 = jdks != null && Files.isDirectory(jdks, new LinkOption[0]) ? this.scanAll(jdks, true) : Collections.emptySet();
        if (set2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(23);
        }
        return set2;
    }

    @Nullable
    private Path findSdkManCandidatesDir() {
        Path candidates;
        Path candidatesDir;
        Path candidatesDir2;
        String candidatesPath = this.getEnvironmentVariable("SDKMAN_CANDIDATES_DIR");
        if (candidatesPath != null && Files.isDirectory(candidatesDir2 = Path.of(candidatesPath, new String[0]), new LinkOption[0])) {
            return candidatesDir2;
        }
        String primaryPath = this.getEnvironmentVariable("SDKMAN_DIR");
        if (primaryPath != null && Files.isDirectory(candidatesDir = Path.of(primaryPath, "candidates"), new LinkOption[0])) {
            return candidatesDir;
        }
        if ((!SystemInfo.isWindows || this instanceof JavaHomeFinderWsl) && (candidates = this.getPathInUserHome(".sdkman/candidates")) != null && Files.isDirectory(candidates, new LinkOption[0])) {
            return candidates;
        }
        return null;
    }

    @Nullable
    protected Path getPathInUserHome(@NotNull String relativePath) {
        String homePath;
        if (relativePath == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(24);
        }
        return (homePath = System.getProperty("user.home")) != null ? Path.of(homePath, relativePath) : null;
    }

    @NotNull
    private @NotNull Set<@NotNull String> listJavaHomeDirsInstalledBySdkMan(@NotNull Path javasDir) {
        if (javasDir == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(25);
        }
        boolean mac = SystemInfo.isMac;
        HashSet<String> result2 = new HashSet<String>();
        try (Stream<Path> stream = Files.list(javasDir);){
            List innerDirectories = stream.filter(d -> Files.isDirectory(d, new LinkOption[0])).collect(Collectors.toList());
            for (Path innerDir : innerDirectories) {
                Path home2;
                block20: {
                    home2 = innerDir;
                    Path releaseFile = home2.resolve("release");
                    if (!this.safeExists(releaseFile)) continue;
                    if (mac) {
                        try {
                            if (!Files.isSymbolicLink(releaseFile)) break block20;
                            Path realReleaseFile = releaseFile.toRealPath(new LinkOption[0]);
                            if (!this.safeExists(realReleaseFile)) {
                                this.log.warn("Failed to resolve the target file (it doesn't exist) for: " + releaseFile);
                                continue;
                            }
                            Path realHome = realReleaseFile.getParent();
                            if (realHome == null) {
                                this.log.warn("Failed to resolve the target file (it has no parent dir) for: " + releaseFile);
                                continue;
                            }
                            home2 = realHome;
                        }
                        catch (IOException ioe) {
                            this.log.warn("Failed to resolve the target file for: " + releaseFile + ": " + ioe.getMessage());
                            continue;
                        }
                        catch (Exception e) {
                            this.log.warn("Failed to resolve the target file for: " + releaseFile + ": Unexpected exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
                            continue;
                        }
                    }
                }
                result2.add(home2.toString());
            }
        }
        catch (IOException ioe) {
            this.log.warn("I/O exception while listing Java home directories installed by Sdkman: " + ioe.getMessage(), (Throwable)ioe);
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(26);
            }
            return set2;
        }
        catch (Exception e) {
            this.log.warn("Unexpected exception while listing Java home directories installed by Sdkman: " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            Set<String> set3 = Collections.emptySet();
            if (set3 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(27);
            }
            return set3;
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    @NotNull
    private Set<String> findJavaInstalledByAsdfJava() {
        File installsDir = this.findAsdfInstallsDir();
        if (installsDir == null) {
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                JavaHomeFinderBasic.$$$reportNull$$$0(29);
            }
            return set2;
        }
        File javasDir = new File(installsDir, "java");
        Set<String> set3 = this.safeIsDirectory(javasDir) ? this.scanAll(javasDir.toPath(), true) : Collections.emptySet();
        if (set3 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(30);
        }
        return set3;
    }

    @Nullable
    private File findAsdfInstallsDir() {
        File homeDir;
        File installsDir;
        String homePath;
        File installsDir2;
        File primaryDir;
        String dataDir = EnvironmentUtil.getValue((String)"ASDF_DATA_DIR");
        if (dataDir != null && (primaryDir = new File(dataDir)).isDirectory() && this.safeIsDirectory(installsDir2 = primaryDir.toPath().resolve("installs").toFile())) {
            return installsDir2;
        }
        if (!SystemInfo.isWindows && (homePath = System.getProperty("user.home")) != null && this.safeIsDirectory(installsDir = (homeDir = new File(homePath)).toPath().resolve(".asdf").resolve("installs").toFile())) {
            return installsDir;
        }
        return null;
    }

    private boolean safeIsDirectory(@NotNull File dir) {
        if (dir == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(31);
        }
        try {
            return dir.isDirectory();
        }
        catch (SecurityException se) {
            return false;
        }
        catch (Exception e) {
            this.log.debug("Failed to check directory existence: unexpected exception " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean safeExists(@NotNull Path path2) {
        if (path2 == null) {
            JavaHomeFinderBasic.$$$reportNull$$$0(32);
        }
        try {
            return Files.exists(path2, new LinkOption[0]);
        }
        catch (Exception e) {
            this.log.debug("Failed to check file existence: unexpected exception " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderBasic";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javasDir";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findInSpecifiedPaths";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaHomeFinderBasic";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findExistingJdks";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInPATH";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDefaultLocations";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "scanAll";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaInstalledBySdkMan";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaInstalledByGradle";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "listJavaHomeDirsInstalledBySdkMan";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaInstalledByAsdfJava";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFinder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentVariable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scanAll";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scanFolder";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkHomesFromInstallRoot";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleJdkInstallRootsFromHomes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPathInUserHome";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "listJavaHomeDirsInstalledBySdkMan";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "safeIsDirectory";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "safeExists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

