/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerWSL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerWSL$WhenMappings;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerWSLKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPackageType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.WSLDistributionForJdkInstaller;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J.\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerWSL;", "", "()V", "moveUnpackedJdkPrefixOnWsl", "", "wslDistribution", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/WSLDistributionForJdkInstaller;", "unpackDir", "Ljava/nio/file/Path;", "targetDir", "packageRootPrefixRaw", "", "unpackJdkArchiveOnWsl", "packageType", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPackageType;", "downloadFile", "unpackJdkOnWsl", "intellij.platform.lang.impl"})
public final class JdkInstallerWSL {
    @NotNull
    public static final JdkInstallerWSL INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpackJdkOnWsl(@NotNull WSLDistributionForJdkInstaller wslDistribution, @NotNull JdkPackageType packageType, @NotNull Path downloadFile, @NotNull Path targetDir, @NotNull String packageRootPrefixRaw) {
        Intrinsics.checkNotNullParameter((Object)wslDistribution, (String)"wslDistribution");
        Intrinsics.checkNotNullParameter((Object)((Object)packageType), (String)"packageType");
        Intrinsics.checkNotNullParameter((Object)downloadFile, (String)"downloadFile");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter((Object)packageRootPrefixRaw, (String)"packageRootPrefixRaw");
        Path unpackDir = targetDir.resolveSibling("" + '.' + targetDir.getFileName() + "-downloading-" + System.currentTimeMillis());
        try {
            Path path2 = unpackDir;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"unpackDir");
            this.unpackJdkArchiveOnWsl(wslDistribution, packageType, downloadFile, path2);
            this.moveUnpackedJdkPrefixOnWsl(wslDistribution, unpackDir, targetDir, packageRootPrefixRaw);
        }
        catch (Throwable e) {
            FileUtil.delete((Path)targetDir);
            throw e;
        }
        finally {
            FileUtil.delete((Path)unpackDir);
        }
    }

    private final void unpackJdkArchiveOnWsl(WSLDistributionForJdkInstaller wslDistribution, JdkPackageType packageType, Path downloadFile, Path targetDir) {
        List list2;
        String downloadFileWslPath = wslDistribution.getWslPath(downloadFile);
        String targetWslPath = wslDistribution.getWslPath(targetDir);
        FileUtil.createDirectory((File)targetDir.toFile());
        switch (JdkInstallerWSL$WhenMappings.$EnumSwitchMapping$0[packageType.ordinal()]) {
            case 1: {
                list2 = CollectionsKt.listOf((Object[])new String[]{"unzip", downloadFileWslPath});
                break;
            }
            case 2: {
                list2 = CollectionsKt.listOf((Object[])new String[]{"tar", "xzf", downloadFileWslPath});
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List command = list2;
        ProcessOutput processOutput = wslDistribution.executeOnWsl(command, targetWslPath, 300000);
        if (processOutput.getExitCode() != 0) {
            String message2 = "Failed to unpack " + downloadFile + " to " + targetDir;
            Logger logger = JdkInstallerWSLKt.access$getLOG$p();
            StringBuilder stringBuilder = new StringBuilder().append(message2).append(": ");
            List list3 = processOutput.getStderrLines();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"processOutput.stderrLines");
            logger.warn(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)list3, (int)10), (CharSequence)"", null, null, (int)0, null, (Function1)unpackJdkArchiveOnWsl.1.INSTANCE, (int)30, null)).toString());
            throw (Throwable)new RuntimeException(message2);
        }
    }

    private final void moveUnpackedJdkPrefixOnWsl(WSLDistributionForJdkInstaller wslDistribution, Path unpackDir, Path targetDir, String packageRootPrefixRaw) {
        Path packageRootDir;
        String packageRootPrefix = StringsKt.trim((String)StringsKt.removePrefix((String)packageRootPrefixRaw, (CharSequence)"./"), (char[])new char[]{'/'});
        Path path2 = packageRootDir = StringsKt.isBlank((CharSequence)packageRootPrefix) ? unpackDir : unpackDir.resolve(packageRootPrefixRaw).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"packageRootDir");
        if (!PathKt.isAncestor((Path)unpackDir, (Path)path2)) {
            String string = "Failed to move JDK contents from " + unpackDir + " to " + packageRootDir + ". Invalid metadata is detected";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (!Files.isDirectory(packageRootDir, new LinkOption[0])) {
            String string = "Invalid package. Directory is expected under '" + packageRootPrefixRaw + "' path on the JDK package";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String wslTarget = wslDistribution.getWslPath(targetDir);
        String wslUnpack = wslDistribution.getWslPath(unpackDir);
        String wslSource = wslDistribution.getWslPath(packageRootDir);
        FileUtil.delete((Path)targetDir);
        List command = CollectionsKt.listOf((Object[])new String[]{"mv", wslSource, wslTarget});
        ProcessOutput processOutput = wslDistribution.executeOnWsl(command, wslUnpack, 300000);
        if (processOutput.getExitCode() != 0) {
            String message2 = "Failed to strip package root prefix " + packageRootPrefix;
            Logger logger = JdkInstallerWSLKt.access$getLOG$p();
            StringBuilder stringBuilder = new StringBuilder().append(message2).append(": ");
            List list2 = processOutput.getStderrLines();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"processOutput.stderrLines");
            logger.warn(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)list2, (int)10), (CharSequence)"", null, null, (int)0, null, (Function1)moveUnpackedJdkPrefixOnWsl.1.INSTANCE, (int)30, null)).toString());
            throw (Throwable)new RuntimeException(message2);
        }
    }

    private JdkInstallerWSL() {
    }

    static {
        JdkInstallerWSL jdkInstallerWSL;
        INSTANCE = jdkInstallerWSL = new JdkInstallerWSL();
    }
}

