/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.CachedValueWithTTL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.EmptyRawJdkList;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListParser;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RawJdkList;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RawJdkListImpl;
import com.intellij.util.io.HttpRequests;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListDownloaderBase;", "", "()V", "feedUrl", "", "getFeedUrl", "()Ljava/lang/String;", "jdksListCache", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/CachedValueWithTTL;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RawJdkList;", "downloadForUI", "", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "predicate", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "downloadJdkList", "", "kotlin.jvm.PlatformType", "downloadJdksListNoCache", "downloadJdksListWithCache", "downloadModelForJdkInstaller", "intellij.platform.lang.impl"})
public abstract class JdkListDownloaderBase {
    private final CachedValueWithTTL<RawJdkList> jdksListCache = new CachedValueWithTTL((Pair<Integer, ? extends TimeUnit>)TuplesKt.to((Object)15, (Object)((Object)TimeUnit.MINUTES)));

    @NotNull
    protected abstract String getFeedUrl();

    private final byte[] downloadJdkList(String feedUrl, ProgressIndicator progress2) {
        return HttpRequests.request((String)feedUrl).productNameAsUserAgent().readBytes(progress2);
    }

    @NotNull
    public final List<JdkItem> downloadModelForJdkInstaller(@Nullable ProgressIndicator progress2) {
        return this.downloadModelForJdkInstaller(progress2, JdkPredicate.Companion.default());
    }

    @NotNull
    public final List<JdkItem> downloadModelForJdkInstaller(@Nullable ProgressIndicator progress2, @NotNull JdkPredicate predicate2) {
        Intrinsics.checkNotNullParameter((Object)predicate2, (String)"predicate");
        return this.downloadJdksListWithCache(predicate2, this.getFeedUrl(), progress2);
    }

    @NotNull
    public final List<JdkItem> downloadForUI(@Nullable ProgressIndicator progress2, @Nullable String feedUrl) {
        return this.downloadForUI(progress2, feedUrl, JdkPredicate.Companion.default());
    }

    public static /* synthetic */ List downloadForUI$default(JdkListDownloaderBase jdkListDownloaderBase, ProgressIndicator progressIndicator, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: downloadForUI");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return jdkListDownloaderBase.downloadForUI(progressIndicator, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> downloadForUI(@Nullable ProgressIndicator progress2, @Nullable String feedUrl, @NotNull JdkPredicate predicate2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)predicate2, (String)"predicate");
        String string = feedUrl;
        if (string == null) {
            string = this.getFeedUrl();
        }
        String url = string;
        RawJdkList raw = this.downloadJdksListNoCache(url, progress2);
        this.jdksListCache.setValue(url, raw);
        List<JdkItem> list2 = raw.getJdks(predicate2);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isInternal()) {
            return list2;
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JdkItem it = (JdkItem)element$iv$iv;
            boolean bl = false;
            if (!it.isVisibleOnUI()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List downloadForUI$default(JdkListDownloaderBase jdkListDownloaderBase, ProgressIndicator progressIndicator, String string, JdkPredicate jdkPredicate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: downloadForUI");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return jdkListDownloaderBase.downloadForUI(progressIndicator, string, jdkPredicate);
    }

    private final List<JdkItem> downloadJdksListWithCache(JdkPredicate predicate2, String feedUrl, ProgressIndicator progress2) {
        String feedUrl2;
        String string = feedUrl;
        if (string == null) {
            string = feedUrl2 = this.getFeedUrl();
        }
        if (Intrinsics.areEqual((Object)predicate2, (Object)JdkPredicate.Companion.none())) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        return this.jdksListCache.getOrCompute(feedUrl2, EmptyRawJdkList.INSTANCE, (Function0<RawJdkList>)((Function0)new Function0<RawJdkList>(this, feedUrl2, progress2){
            final /* synthetic */ JdkListDownloaderBase this$0;
            final /* synthetic */ String $feedUrl;
            final /* synthetic */ ProgressIndicator $progress;

            @NotNull
            public final RawJdkList invoke() {
                return JdkListDownloaderBase.access$downloadJdksListNoCache(this.this$0, this.$feedUrl, this.$progress);
            }
            {
                this.this$0 = jdkListDownloaderBase;
                this.$feedUrl = string;
                this.$progress = progressIndicator;
                super(0);
            }
        })).getJdks(predicate2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RawJdkList downloadJdksListNoCache(String feedUrl, ProgressIndicator progress2) {
        ObjectNode objectNode;
        Object t2;
        byte[] byArray;
        try {
            byArray = this.downloadJdkList(feedUrl, progress2);
        }
        catch (IOException t2) {
            Logger.getInstance(this.getClass()).warn("Failed to download the list of available JDKs from " + feedUrl + ". " + t2.getMessage());
            return EmptyRawJdkList.INSTANCE;
        }
        byte[] rawDataXZ = byArray;
        try {
            byte[] byArray2;
            t2 = new ByteArrayInputStream(rawDataXZ);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                byte[] byArray3;
                ByteArrayInputStream input = (ByteArrayInputStream)t2;
                boolean bl3 = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl6 = false;
                    byArray3 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray2 = byArray3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)t2, (Throwable)throwable);
            }
            t2 = byArray2;
        }
        catch (Throwable t3) {
            throw (Throwable)new RuntimeException("Failed to unpack the list of available JDKs from " + feedUrl + ". " + t3.getMessage(), t3);
        }
        Object rawData = t2;
        try {
            objectNode = JdkListParser.INSTANCE.readTree((byte[])rawData);
        }
        catch (Throwable t4) {
            throw (Throwable)new RuntimeException("Failed to parse the downloaded list of available JDKs. " + t4.getMessage(), t4);
        }
        ObjectNode json = objectNode;
        return new RawJdkListImpl(feedUrl, json);
    }

    public static final /* synthetic */ RawJdkList access$downloadJdksListNoCache(JdkListDownloaderBase $this, String feedUrl, ProgressIndicator progress2) {
        return $this.downloadJdksListNoCache(feedUrl, progress2);
    }
}

