/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJbrInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserMessages;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserDownloader;", "", "()V", "downloadAndUse", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "jdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "targetDir", "intellij.platform.lang.impl"})
public final class RuntimeChooserDownloader {
    @Nullable
    public final Path downloadAndUse(@NotNull ProgressIndicator indicator2, @NotNull JdkItem jdk, @NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        try {
            boolean $i$f$service = false;
            Class<RuntimeChooserJbrInstaller> serviceClass$iv = RuntimeChooserJbrInstaller.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            RuntimeChooserJbrInstaller installer = (RuntimeChooserJbrInstaller)object;
            JdkInstallRequest request2 = installer.prepareJdkInstallation(jdk, targetDir);
            installer.installJdk(request2, indicator2, null);
            return request2.getJavaHome();
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            RuntimeChooserDownloader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RuntimeChooserDownloader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Failed to download boot runtime from " + jdk + ". " + t.getMessage());
            String string = LangBundle.message((String)"dialog.message.choose.ide.runtime.download.error", (Object[])new Object[]{jdk.getFullPresentationText(), ((Object)targetDir).toString()});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"dial\u2026xt, targetDir.toString())");
            RuntimeChooserMessages.showErrorMessage$default(RuntimeChooserMessages.INSTANCE, string, null, 2, null);
            return null;
        }
    }
}

