/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.RuntimeChooserJreValidatorCallback;
import com.intellij.openapi.roots.ui.configuration.SdkPopupBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.JavaVersion;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0082\bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0012J7\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00020\t2\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidator;", "", "()V", "minJdkFeatureVersion", "", "getMinJdkFeatureVersion$annotations", "getMinJdkFeatureVersion", "()I", "isSupportedSdkItem", "", "versionString", "Lkotlin/Function0;", "", "homePath", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "item", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/roots/ui/configuration/SdkPopupBuilder$SuggestedSdk;", "testNewJdkUnderProgress", "R", "allowRunProcesses", "computeHomePath", "callback", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidatorCallback;", "(ZLkotlin/jvm/functions/Function0;Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/RuntimeChooserJreValidatorCallback;)Ljava/lang/Object;", "intellij.platform.lang.impl"})
public final class RuntimeChooserJreValidator {
    @NotNull
    public static final RuntimeChooserJreValidator INSTANCE;

    private static /* synthetic */ void getMinJdkFeatureVersion$annotations() {
    }

    private final int getMinJdkFeatureVersion() {
        return 11;
    }

    public final boolean isSupportedSdkItem(@NotNull JdkItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (SystemInfo.isMac && !StringsKt.endsWith$default((String)item.getPackageToBinJavaPrefix(), (String)"Contents/Home", (boolean)false, (int)2, null)) {
            return false;
        }
        return item.getJdkMajorVersion() >= this.getMinJdkFeatureVersion() && Intrinsics.areEqual((Object)item.getOs(), (Object)JdkPredicate.Companion.getCurrentOS()) && Intrinsics.areEqual((Object)item.getArch(), (Object)JdkPredicate.Companion.getCurrentArch());
    }

    public final boolean isSupportedSdkItem(@NotNull Sdk sdk2) {
        boolean bl;
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            RuntimeChooserJreValidator this_$iv = this;
            boolean $i$f$isSupportedSdkItem = false;
            RuntimeChooserJreValidator runtimeChooserJreValidator = this_$iv;
            boolean bl2 = false;
            try {
                object = Result.Companion;
                RuntimeChooserJreValidator $this$runCatching$iv = runtimeChooserJreValidator;
                boolean bl3 = false;
                boolean bl4 = false;
                String string = sdk2.getVersionString();
                if (string == null) {
                    bl = false;
                    break block6;
                }
                String version$iv = string;
                boolean bl5 = false;
                String string2 = sdk2.getHomePath();
                if (string2 == null) {
                    bl = false;
                    break block6;
                }
                String home$iv = string2;
                if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home$iv, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                    bl = false;
                    break block6;
                }
                JavaVersion javaVersion = JavaVersion.tryParse((String)version$iv);
                if (javaVersion == null) {
                    bl = false;
                    break block6;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
                JavaVersion javaVersion$iv = javaVersion;
                Boolean bl6 = javaVersion$iv.feature >= $this$runCatching$iv.getMinJdkFeatureVersion() && !WslDistributionManager.isWslPath(home$iv);
                boolean bl7 = false;
                object = Result.constructor-impl((Object)bl6);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl8 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            runtimeChooserJreValidator = object;
            Boolean bl9 = false;
            boolean bl10 = false;
            bl = (Boolean)(Result.isFailure-impl((Object)runtimeChooserJreValidator) ? bl9 : runtimeChooserJreValidator);
        }
        return bl;
    }

    public final boolean isSupportedSdkItem(@NotNull SdkPopupBuilder.SuggestedSdk sdk2) {
        boolean bl;
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            RuntimeChooserJreValidator this_$iv = this;
            boolean $i$f$isSupportedSdkItem = false;
            RuntimeChooserJreValidator runtimeChooserJreValidator = this_$iv;
            boolean bl2 = false;
            try {
                object = Result.Companion;
                RuntimeChooserJreValidator $this$runCatching$iv = runtimeChooserJreValidator;
                boolean bl3 = false;
                boolean bl4 = false;
                String string = sdk2.getVersionString();
                if (string == null) {
                    bl = false;
                    break block6;
                }
                String version$iv = string;
                boolean bl5 = false;
                String string2 = sdk2.getHomePath();
                if (string2 == null) {
                    bl = false;
                    break block6;
                }
                String home$iv = string2;
                if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home$iv, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                    bl = false;
                    break block6;
                }
                JavaVersion javaVersion = JavaVersion.tryParse((String)version$iv);
                if (javaVersion == null) {
                    bl = false;
                    break block6;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
                JavaVersion javaVersion$iv = javaVersion;
                Boolean bl6 = javaVersion$iv.feature >= $this$runCatching$iv.getMinJdkFeatureVersion() && !WslDistributionManager.isWslPath(home$iv);
                boolean bl7 = false;
                object = Result.constructor-impl((Object)bl6);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl8 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            runtimeChooserJreValidator = object;
            Boolean bl9 = false;
            boolean bl10 = false;
            bl = (Boolean)(Result.isFailure-impl((Object)runtimeChooserJreValidator) ? bl9 : runtimeChooserJreValidator);
        }
        return bl;
    }

    private final boolean isSupportedSdkItem(Function0<String> versionString, Function0<String> homePath) {
        Object object;
        int $i$f$isSupportedSdkItem = 0;
        RuntimeChooserJreValidator runtimeChooserJreValidator = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            RuntimeChooserJreValidator $this$runCatching = runtimeChooserJreValidator;
            boolean bl2 = false;
            String string = (String)versionString.invoke();
            if (string == null) {
                return false;
            }
            String version2 = string;
            String string2 = (String)homePath.invoke();
            if (string2 == null) {
                return false;
            }
            String home2 = string2;
            if (SystemInfo.isMac && !StringsKt.endsWith$default((String)home2, (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                return false;
            }
            JavaVersion javaVersion = JavaVersion.tryParse((String)version2);
            if (javaVersion == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return false");
            JavaVersion javaVersion2 = javaVersion;
            Boolean bl3 = javaVersion2.feature >= $this$runCatching.getMinJdkFeatureVersion() && !WslDistributionManager.isWslPath(home2);
            boolean bl4 = false;
            object = Result.constructor-impl((Object)bl3);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        runtimeChooserJreValidator = object;
        Boolean bl6 = false;
        boolean bl7 = false;
        return (Boolean)(Result.isFailure-impl((Object)runtimeChooserJreValidator) ? bl6 : runtimeChooserJreValidator);
    }

    public final <R> R testNewJdkUnderProgress(boolean allowRunProcesses, @NotNull Function0<String> computeHomePath, @NotNull RuntimeChooserJreValidatorCallback<R> callback2) {
        Object object4;
        Path binJava;
        boolean $this$runCatching2;
        Path homeDir;
        block31: {
            block30: {
                Path path2;
                String string;
                Path path3;
                Object object2;
                Intrinsics.checkNotNullParameter(computeHomePath, (String)"computeHomePath");
                Intrinsics.checkNotNullParameter(callback2, (String)"callback");
                Object object3 = this;
                boolean bl = false;
                try {
                    object2 = Result.Companion;
                    Object $this$runCatching2 = object3;
                    boolean object4 = false;
                    $this$runCatching2 = Path.of((String)computeHomePath.invoke(), new String[0]).toAbsolutePath();
                    object4 = false;
                    object2 = Result.constructor-impl((Object)$this$runCatching2);
                }
                catch (Throwable $this$runCatching2) {
                    Result.Companion object4 = Result.Companion;
                    boolean bl2 = false;
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching2));
                }
                object3 = object2;
                bl = false;
                Path path4 = (Path)(Result.isFailure-impl((Object)object3) ? null : object3);
                if (path4 == null) {
                    String string2 = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.unknown.error", (Object[])new Object[]{LangBundle.message((String)"dialog.message.choose.ide.runtime.no.file.part", (Object[])new Object[0])});
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LangBundle.message(\"dial\u2026e.runtime.no.file.part\"))");
                    return callback2.onError(string2);
                }
                homeDir = path4;
                if (SystemInfo.isMac && StringsKt.endsWith$default((String)((Object)homeDir).toString(), (String)"/Contents/Home", (boolean)false, (int)2, null)) {
                    return this.testNewJdkUnderProgress(allowRunProcesses, (Function0<String>)((Function0)new Function0<String>(homeDir){
                        final /* synthetic */ Path $homeDir;

                        @Nullable
                        public final String invoke() {
                            Path path2 = this.$homeDir.getParent();
                            return path2 != null && (path2 = path2.getParent()) != null ? ((Object)path2).toString() : null;
                        }
                        {
                            this.$homeDir = path2;
                            super(0);
                        }
                    }), callback2);
                }
                if (SystemInfo.isMac && Intrinsics.areEqual((Object)((Object)homeDir.getFileName()).toString(), (Object)"Contents")) {
                    object3 = homeDir;
                    String string3 = "Home";
                    boolean bl3 = false;
                    Path path5 = object3.resolve(string3);
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
                    if (PathKt.isDirectory((Path)path5)) {
                        return this.testNewJdkUnderProgress(allowRunProcesses, (Function0<String>)((Function0)new Function0<String>(homeDir){
                            final /* synthetic */ Path $homeDir;

                            @Nullable
                            public final String invoke() {
                                Path path2 = this.$homeDir.getParent();
                                return path2 != null ? ((Object)path2).toString() : null;
                            }
                            {
                                this.$homeDir = path2;
                                super(0);
                            }
                        }), callback2);
                    }
                }
                if (SystemInfo.isMac) {
                    object3 = homeDir;
                    String string4 = "Contents";
                    boolean bl4 = false;
                    Path path6 = object3.resolve(string4);
                    Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"this.resolve(other)");
                    object3 = path6;
                    string4 = "Home";
                    bl4 = false;
                    Path path7 = object3.resolve(string4);
                    Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"this.resolve(other)");
                    if (!PathKt.isDirectory((Path)path7)) {
                        RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". macOS Bundle layout is expected");
                        String string5 = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.error.mac.bundle", (Object[])new Object[]{homeDir});
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"LangBundle.message(\"dial\u2026ror.mac.bundle\", homeDir)");
                        return callback2.onError(string5);
                    }
                }
                if (SystemInfo.isWindows && WslDistributionManager.isWslPath(((Object)homeDir).toString())) {
                    RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". macOS Bundle layout is expected");
                    String string6 = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.version.error.wsl", (Object[])new Object[]{homeDir});
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"LangBundle.message(\"dial\u2026sion.error.wsl\", homeDir)");
                    callback2.onError(string6);
                }
                if (SystemInfo.isWindows) {
                    path3 = homeDir;
                    string = "bin";
                    $this$runCatching2 = false;
                    Path path8 = path3.resolve(string);
                    Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"this.resolve(other)");
                    path3 = path8;
                    string = "java.exe";
                    $this$runCatching2 = false;
                    Path path9 = path3.resolve(string);
                    path2 = path9;
                    Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"this.resolve(other)");
                } else if (SystemInfo.isMac) {
                    path3 = homeDir;
                    string = "Contents";
                    $this$runCatching2 = false;
                    Path path10 = path3.resolve(string);
                    Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"this.resolve(other)");
                    path3 = path10;
                    string = "Home";
                    $this$runCatching2 = false;
                    Path path11 = path3.resolve(string);
                    Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"this.resolve(other)");
                    path3 = path11;
                    string = "bin";
                    $this$runCatching2 = false;
                    Path path12 = path3.resolve(string);
                    Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"this.resolve(other)");
                    path3 = path12;
                    string = "java";
                    $this$runCatching2 = false;
                    Path path13 = path3.resolve(string);
                    path2 = path13;
                    Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"this.resolve(other)");
                } else {
                    path3 = homeDir;
                    string = "bin";
                    $this$runCatching2 = false;
                    Path path14 = path3.resolve(string);
                    Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"this.resolve(other)");
                    path3 = path14;
                    string = "java";
                    $this$runCatching2 = false;
                    Path path15 = path3.resolve(string);
                    path2 = path15;
                    Intrinsics.checkNotNullExpressionValue((Object)path15, (String)"this.resolve(other)");
                }
                binJava = path2;
                if (!PathKt.isFile((Path)binJava)) break block30;
                if (!SystemInfo.isUnix) break block31;
                path3 = binJava;
                boolean bl5 = false;
                if (Files.isExecutable(path3)) break block31;
            }
            RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". Failed to find bin/java executable at " + binJava);
            String string = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.cannot.start.error", (Object[])new Object[]{homeDir});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"dial\u2026ot.start.error\", homeDir)");
            return callback2.onError(string);
        }
        RuntimeChooserJreValidator runtimeChooserJreValidator = this;
        $this$runCatching2 = false;
        try {
            JdkVersionDetector.JdkVersionInfo jdkVersionInfo;
            object4 = Result.Companion;
            RuntimeChooserJreValidator $this$runCatching3 = runtimeChooserJreValidator;
            boolean bl = false;
            Object object5 = binJava.getParent();
            if (object5 == null || (object5 = object5.getParent()) == null || (object5 = object5.toString()) == null) {
                jdkVersionInfo = null;
            } else {
                Object inferredHome = object5;
                jdkVersionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo((String)inferredHome);
            }
            JdkVersionDetector.JdkVersionInfo jdkVersionInfo2 = jdkVersionInfo;
            boolean bl6 = false;
            object4 = Result.constructor-impl(jdkVersionInfo2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl = false;
            object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        runtimeChooserJreValidator = object4;
        $this$runCatching2 = false;
        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = (JdkVersionDetector.JdkVersionInfo)(Result.isFailure-impl((Object)runtimeChooserJreValidator) ? null : runtimeChooserJreValidator);
        if (jdkVersionInfo == null) {
            String string = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.unknown.error", (Object[])new Object[]{homeDir});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"dial\u2026.unknown.error\", homeDir)");
            return callback2.onError(string);
        }
        Intrinsics.checkNotNullExpressionValue((Object)jdkVersionInfo, (String)"runCatching {\n      //we\u2026unknown.error\", homeDir))");
        JdkVersionDetector.JdkVersionInfo info2 = jdkVersionInfo;
        if (info2.version == null || info2.version.feature < this.getMinJdkFeatureVersion()) {
            RuntimeChooserJreKt.access$getLOG$p().warn("Failed to scan JDK for boot runtime: " + homeDir + ". The version " + info2 + " is less than " + this.getMinJdkFeatureVersion());
            String string = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.version.error", (Object[])new Object[]{homeDir, "11", info2.version.toString()});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"dial\u2026 info.version.toString())");
            return callback2.onError(string);
        }
        String string = RuntimeChooserJreKt.access$tryComputeAdvancedFullVersion(binJava);
        if (string == null) {
            JavaVersion javaVersion = info2.version;
            string = javaVersion != null ? javaVersion.toString() : null;
        }
        if (string == null) {
            String string7 = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.unknown.error", (Object[])new Object[]{homeDir});
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"LangBundle.message(\"dial\u2026.unknown.error\", homeDir)");
            return callback2.onError(string7);
        }
        String jdkVersion = string;
        if (allowRunProcesses) {
            try {
                GeneralCommandLine cmd = new GeneralCommandLine(new String[]{((Object)binJava).toString(), "-version"});
                ProcessOutput processOutput = new CapturingProcessHandler(cmd).runProcess(30000);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(cmd).runProcess(30_000)");
                int exitCode = processOutput.getExitCode();
                if (exitCode != 0) {
                    RuntimeChooserJreKt.access$getLOG$p().warn("Failed to run JDK for boot runtime: " + homeDir + ". Exit code is " + exitCode + " for " + binJava + '.');
                    String string8 = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.cannot.start.error", (Object[])new Object[]{homeDir});
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"LangBundle.message(\"dial\u2026ot.start.error\", homeDir)");
                    return callback2.onError(string8);
                }
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                RuntimeChooserJreKt.access$getLOG$p().warn("Failed to run JDK for boot runtime: " + homeDir + ". " + t.getMessage(), t);
                String string9 = LangBundle.message((String)"dialog.message.choose.ide.runtime.set.cannot.start.error", (Object[])new Object[]{homeDir});
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"LangBundle.message(\"dial\u2026ot.start.error\", homeDir)");
                return callback2.onError(string9);
            }
        }
        return callback2.onSdkResolved(info2.variant.displayName, jdkVersion, homeDir);
    }

    private RuntimeChooserJreValidator() {
    }

    static {
        RuntimeChooserJreValidator runtimeChooserJreValidator;
        INSTANCE = runtimeChooserJreValidator = new RuntimeChooserJreValidator();
    }
}

