/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.RootsChangeIndexingInfo;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.EntityIndexingService;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.roots.AdditionalLibraryRootsContributor;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class ProjectRootManagerComponent
extends ProjectRootManagerImpl
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectRootManagerComponent.class);
    private static final boolean LOG_CACHES_UPDATE = ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode();
    private static final ExtensionPointName<WatchedRootsProvider> WATCHED_ROOTS_PROVIDER_EP_NAME = new ExtensionPointName("com.intellij.roots.watchedRootsProvider");
    private final ExecutorService myExecutor;
    @NotNull
    private Future<?> myCollectWatchRootsFuture;
    private boolean myPointerChangesDetected;
    private int myInsideWriteAction;
    @NotNull
    private Set<LocalFileSystem.WatchRequest> myRootsToWatch;
    private Disposable myRootPointersDisposable;
    private final VirtualFilePointerListener myRootsChangedListener;

    public ProjectRootManagerComponent(@NotNull Project project) {
        if (project == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(0);
        }
        super(project);
        this.myExecutor = ApplicationManager.getApplication().isUnitTestMode() ? ConcurrencyUtil.newSameThreadExecutorService() : AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Project Root Manager", (int)1);
        this.myCollectWatchRootsFuture = CompletableFuture.completedFuture(null);
        this.myRootsToWatch = CollectionFactory.createSmallMemoryFootprintSet();
        this.myRootPointersDisposable = Disposer.newDisposable();
        this.myRootsChangedListener = new VirtualFilePointerListener(){

            @NotNull
            private RootsChangeIndexingInfo getPointersChanges(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                RootsChangeIndexingInfo result2 = null;
                for (VirtualFilePointer pointer : pointers2) {
                    if (pointer.isValid()) {
                        RootsChangeIndexingInfo rootsChangeIndexingInfo = RootsChangeIndexingInfo.TOTAL_REINDEX;
                        if (rootsChangeIndexingInfo == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return rootsChangeIndexingInfo;
                    }
                    if (result2 != null) continue;
                    result2 = RootsChangeIndexingInfo.NO_INDEXING_NEEDED;
                }
                RootsChangeIndexingInfo rootsChangeIndexingInfo = (RootsChangeIndexingInfo)ObjectUtils.notNull(result2, (Object)RootsChangeIndexingInfo.TOTAL_REINDEX);
                if (rootsChangeIndexingInfo == null) {
                    4.$$$reportNull$$$0(2);
                }
                return rootsChangeIndexingInfo;
            }

            public void beforeValidityChanged(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                    return;
                }
                if (!this.isInsideWriteAction() && !ProjectRootManagerComponent.this.myPointerChangesDetected) {
                    ProjectRootManagerComponent.this.myPointerChangesDetected = true;
                    ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                }
                ProjectRootManagerComponent.this.myRootsChanged.beforeRootsChanged();
                if (LOG_CACHES_UPDATE || LOG.isTraceEnabled()) {
                    LOG.trace(new Throwable(pointers2.length > 0 ? pointers2[0].getPresentableUrl() : ""));
                }
            }

            public void validityChanged(VirtualFilePointer @NotNull [] pointers2) {
                if (pointers2 == null) {
                    4.$$$reportNull$$$0(4);
                }
                RootsChangeIndexingInfo changeInfo = this.getPointersChanges(pointers2);
                if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                    return;
                }
                if (this.isInsideWriteAction()) {
                    ProjectRootManagerComponent.this.myRootsChanged.rootsChanged(changeInfo);
                } else {
                    ProjectRootManagerComponent.this.clearScopesCaches();
                }
            }

            private boolean isInsideWriteAction() {
                return ProjectRootManagerComponent.this.myInsideWriteAction == 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pointers";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPointersChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getPointersChanges";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeValidityChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "validityChanged";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (!this.myProject.isDefault()) {
            this.registerListeners();
        }
    }

    @NotNull
    Set<LocalFileSystem.WatchRequest> getRootsToWatch() {
        Set<LocalFileSystem.WatchRequest> set2 = this.myRootsToWatch;
        if (set2 == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(1);
        }
        return set2;
    }

    private void registerListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == ProjectRootManagerComponent.this.myProject) {
                    ProjectRootManagerComponent.this.addRootsToWatch();
                    ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new AppListener(), (Disposable)ProjectRootManagerComponent.this.myProject);
                }
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (project == ProjectRootManagerComponent.this.myProject) {
                    ProjectRootManagerComponent.this.projectClosed();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProjectRootManagerComponent.this.myFileTypesChanged.beforeRootsChanged();
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                ProjectRootManagerComponent.this.myFileTypesChanged.rootsChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileTypesChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        StartupManager.getInstance((Project)this.myProject).registerStartupActivity(() -> {
            this.myStartupActivityPerformed = true;
        });
        connection.subscribe(BatchUpdateListener.TOPIC, (Object)new BatchUpdateListener(){

            @Override
            public void onBatchUpdateStarted() {
                ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelUp();
            }

            @Override
            public void onBatchUpdateFinished() {
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelDown();
            }
        });
        Runnable rootsExtensionPointListener = () -> ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> this.makeRootsChange(EmptyRunnable.getInstance(), false, true)));
        AdditionalLibraryRootsProvider.EP_NAME.addChangeListener(rootsExtensionPointListener, (Disposable)this);
        OrderEnumerationHandler.EP_NAME.addChangeListener(rootsExtensionPointListener, (Disposable)this);
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (presentableLibraryName, oldRoots, newRoots, libraryNameForDebug) -> {
            if (!(FileBasedIndex.getInstance() instanceof FileBasedIndexImpl)) {
                return;
            }
            ArrayList<VirtualFile> rootsToIndex = new ArrayList<VirtualFile>(newRoots.size());
            for (VirtualFile root2 : newRoots) {
                boolean shouldIndex = true;
                for (VirtualFile oldRoot : oldRoots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)oldRoot, (VirtualFile)root2, (boolean)false)) continue;
                    shouldIndex = false;
                    break;
                }
                if (!shouldIndex) continue;
                rootsToIndex.add(root2);
            }
            if (rootsToIndex.isEmpty()) {
                return;
            }
            List<IndexableFilesIterator> indexableFilesIterators = Collections.singletonList(AdditionalLibraryRootsContributor.createIndexingIterator(presentableLibraryName, rootsToIndex, libraryNameForDebug));
            new UnindexedFilesUpdater(this.myProject, indexableFilesIterators, "On updated roots of library '" + presentableLibraryName + "'").queue(this.myProject);
        });
    }

    protected void projectClosed() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
    }

    @RequiresEdt
    private void addRootsToWatch() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        Disposable oldDisposable = this.myRootPointersDisposable;
        Disposable newDisposable = Disposer.newDisposable();
        this.myCollectWatchRootsFuture.cancel(false);
        this.myCollectWatchRootsFuture = this.myExecutor.submit(() -> {
            Pair watchRoots = (Pair)ReadAction.compute(() -> this.myProject.isDisposed() ? null : this.collectWatchRoots(newDisposable));
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.myRootPointersDisposable = newDisposable;
                Disposer.dispose((Disposable)oldDisposable);
                this.myRootsToWatch = LocalFileSystem.getInstance().replaceWatchedRoots(this.myRootsToWatch, (Collection)watchRoots.first, (Collection)watchRoots.second);
            });
        });
    }

    @Override
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    @Override
    protected void fireRootsChangedEvent(boolean fileTypes, @NotNull List<? extends RootsChangeIndexingInfo> indexingInfos) {
        if (indexingInfos == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(2);
        }
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes, indexingInfos));
        }
        finally {
            this.isFiringEvent = false;
        }
        this.synchronizeRoots(indexingInfos);
        this.addRootsToWatch();
    }

    @NotNull
    private Pair<Set<String>, Set<String>> collectWatchRoots(@NotNull Disposable disposable2) {
        Collection toWatch;
        if (disposable2 == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set recursivePathsToWatch = CollectionFactory.createFilePathSet();
        Set flatPaths = CollectionFactory.createFilePathSet();
        IProjectStore store = ProjectKt.getStateStore(this.myProject);
        Path projectFilePath = store.getProjectFilePath();
        if (!".idea".equals(projectFilePath.getParent().getFileName().toString())) {
            flatPaths.add(FileUtil.toSystemIndependentName((String)projectFilePath.toString()));
            flatPaths.add(FileUtil.toSystemIndependentName((String)store.getWorkspacePath().toString()));
        }
        for (Object extension2 : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            toWatch = extension2.getRootsToWatch(this.myProject);
            if (toWatch.isEmpty()) continue;
            for (VirtualFile file2 : toWatch) {
                recursivePathsToWatch.add(file2.getPath());
            }
        }
        for (Object extension2 : WATCHED_ROOTS_PROVIDER_EP_NAME.getExtensionList()) {
            toWatch = extension2.getRootsToWatch(this.myProject);
            if (toWatch.isEmpty()) continue;
            for (String path2 : toWatch) {
                recursivePathsToWatch.add(FileUtil.toSystemIndependentName((String)path2));
            }
        }
        Set excludedUrls = CollectionFactory.createSmallMemoryFootprintSet();
        for (DirectoryIndexExcludePolicy excludePolicy : DirectoryIndexExcludePolicy.EP_NAME.getExtensionList((AreaInstance)this.myProject)) {
            Collections.addAll(excludedUrls, excludePolicy.getExcludeUrlsForProject());
        }
        if (!excludedUrls.isEmpty()) {
            Disposer.register((Disposable)this, (Disposable)disposable2);
            VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer(disposable2, this.getRootsValidityChangedListener());
            ((VirtualFilePointerContainerImpl)container).addAll(excludedUrls);
        }
        this.collectModuleWatchRoots(recursivePathsToWatch, flatPaths);
        return new Pair((Object)recursivePathsToWatch, (Object)flatPaths);
    }

    private void collectModuleWatchRoots(@NotNull Set<? super String> recursivePaths, @NotNull Set<? super String> flatPaths) {
        if (recursivePaths == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(4);
        }
        if (flatPaths == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(5);
        }
        Set urls = CollectionFactory.createFilePathSet();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ContainerUtil.addAll((Collection)urls, (Object[])rootManager.getContentRootUrls());
            rootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().forEach(entry2 -> {
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    ContainerUtil.addAll((Collection)urls, (Object[])entry2.getUrls(type));
                }
                return true;
            });
        }
        for (String url : urls) {
            String protocol = VirtualFileManager.extractProtocol((String)url);
            if (protocol == null || "file".equals(protocol)) {
                recursivePaths.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if ("jar".equals(protocol)) {
                flatPaths.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if (!"jrt".equals(protocol)) continue;
            recursivePaths.add(ProjectRootManagerComponent.extractLocalPath(url));
        }
    }

    private void synchronizeRoots(@NotNull List<? extends RootsChangeIndexingInfo> indexingInfos) {
        if (indexingInfos == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(6);
        }
        if (!this.myStartupActivityPerformed) {
            return;
        }
        EntityIndexingService.getInstance().indexChanges(this.myProject, indexingInfos);
    }

    @Override
    protected void clearScopesCaches() {
        super.clearScopesCaches();
        LibraryScopeCache libraryScopeCache = (LibraryScopeCache)this.myProject.getServiceIfCreated(LibraryScopeCache.class);
        if (libraryScopeCache != null) {
            libraryScopeCache.clear();
        }
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules2;
        super.clearScopesCachesForModules();
        for (Module module : modules2 = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleEx)module).clearScopesCache();
        }
    }

    @Override
    public void markRootsForRefresh() {
        Set paths2 = CollectionFactory.createFilePathSet();
        this.collectModuleWatchRoots(paths2, paths2);
        LocalFileSystem fs = LocalFileSystem.getInstance();
        for (String path2 : paths2) {
            VirtualFile root2 = fs.findFileByPath(path2);
            if (!(root2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)root2).markDirtyRecursively();
        }
    }

    public void dispose() {
        this.myCollectWatchRootsFuture.cancel(false);
        this.myExecutor.shutdownNow();
    }

    @Override
    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        VirtualFilePointerListener virtualFilePointerListener = this.myRootsChangedListener;
        if (virtualFilePointerListener == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(7);
        }
        return virtualFilePointerListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursivePaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToWatch";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsValidityChangedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fireRootsChangedEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectWatchRoots";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleWatchRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AppListener
    implements ApplicationListener {
        private AppListener() {
        }

        public void beforeWriteActionStart(@NotNull Object action2) {
            if (action2 == null) {
                AppListener.$$$reportNull$$$0(0);
            }
            ++ProjectRootManagerComponent.this.myInsideWriteAction;
        }

        public void writeActionFinished(@NotNull Object action2) {
            if (action2 == null) {
                AppListener.$$$reportNull$$$0(1);
            }
            if (--ProjectRootManagerComponent.this.myInsideWriteAction == 0 && ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = false;
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$AppListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeWriteActionStart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeActionFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

