/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.RootsChangeIndexingInfo;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.FilesScanExecutor;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedDiagnostic;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushingStatistics;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.roots.DefaultProjectIndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ProjectIndexableFilesIteratorImpl;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushedFilePropertiesUpdaterImpl
extends PushedFilePropertiesUpdater {
    private static final Logger LOG = Logger.getInstance(PushedFilePropertiesUpdater.class);
    private final Project myProject;
    private final Queue<Runnable> myTasks;

    public PushedFilePropertiesUpdaterImpl(final @NotNull Project project) {
        if (project == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(0);
        }
        this.myTasks = new ConcurrentLinkedQueue<Runnable>();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(new Throwable("Processing roots changed event (caused by file type change: " + event.isCausedByFileTypesChange() + ")"));
                }
                for (FilePropertyPusher pusher : FilePropertyPusher.EP_NAME.getExtensionList()) {
                    pusher.afterRootsChanged(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$1", "rootsChanged"));
            }
        });
        project.getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                PushedFilePropertiesUpdaterImpl.this.myTasks.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$2", "beforePluginLoaded"));
            }
        });
    }

    @ApiStatus.Internal
    public void processAfterVfsChanges(@NotNull List<? extends VFileEvent> events) {
        boolean pushingSomethingSynchronously;
        if (events == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(1);
        }
        ArrayList syncTasks = new ArrayList();
        ArrayList delayedTasks = new ArrayList();
        List filePushers = PushedFilePropertiesUpdaterImpl.getFilePushers();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (vFileEvent instanceof VFileCreateEvent) {
                List pushers;
                boolean isDirectory = ((VFileCreateEvent)vFileEvent).isDirectory();
                List list2 = pushers = isDirectory ? FilePropertyPusher.EP_NAME.getExtensionList() : filePushers;
                if (!vFileEvent.isFromRefresh()) {
                    ContainerUtil.addIfNotNull(syncTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
                    continue;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(((VFileCreateEvent)vFileEvent).getChildName());
                boolean isProjectOrWorkspaceFile = fileType instanceof InternalFileType || VfsUtilCore.findContainingDirectory((VirtualFile)((VFileCreateEvent)vFileEvent).getParent(), (CharSequence)".idea") != null;
                if (isProjectOrWorkspaceFile) continue;
                ContainerUtil.addIfNotNull(delayedTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent) || (file2 = PushedFilePropertiesUpdaterImpl.getFile(vFileEvent)) == null) continue;
            boolean isDirectory = file2.isDirectory();
            List pushers = isDirectory ? FilePropertyPusher.EP_NAME.getExtensionList() : filePushers;
            for (FilePropertyPusher pusher : pushers) {
                file2.putUserData(pusher.getFileDataKey(), null);
            }
            ContainerUtil.addIfNotNull(syncTasks, (Object)this.createRecursivePushTask(vFileEvent, pushers));
        }
        boolean bl = pushingSomethingSynchronously = !syncTasks.isEmpty() && syncTasks.size() < FileBasedIndexProjectHandler.ourMinFilesToStartDumbMode;
        if (pushingSomethingSynchronously) {
            syncTasks.forEach(Runnable::run);
        } else {
            delayedTasks.addAll(syncTasks);
        }
        if (!delayedTasks.isEmpty()) {
            this.queueTasks(delayedTasks, "Push on VFS changes");
        }
        if (pushingSomethingSynchronously) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> this.scheduleDumbModeReindexingIfNeeded());
        }
    }

    private static VirtualFile getFile(@NotNull VFileEvent event) {
        if (event == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(2);
        }
        VirtualFile file2 = event.getFile();
        if (event instanceof VFileCopyEvent) {
            file2 = ((VFileCopyEvent)event).getNewParent().findChild(((VFileCopyEvent)event).getNewChildName());
        }
        return file2;
    }

    public void runConcurrentlyIfPossible(List<? extends Runnable> tasks) {
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public void initializeProperties() {
        FilePropertyPusher.EP_NAME.forEachExtensionSafe(pusher -> pusher.initExtra(this.myProject));
    }

    public static void applyScannersToFile(@NotNull VirtualFile fileOrDir, List<IndexableFileScanner.IndexableFileVisitor> sessions) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(3);
        }
        for (IndexableFileScanner.IndexableFileVisitor session2 : sessions) {
            try {
                session2.visitFile(fileOrDir);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Failed to visit file", (Throwable)e, new Attachment[]{new Attachment("filePath.txt", fileOrDir.getPath())});
            }
        }
    }

    @Nullable
    private Runnable createRecursivePushTask(@NotNull VFileEvent event, @NotNull List<? extends FilePropertyPusher<?>> pushers) {
        if (event == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(4);
        }
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(5);
        }
        List scanners = IndexableFileScanner.EP_NAME.getExtensionList();
        if (pushers.isEmpty() && scanners.isEmpty()) {
            return null;
        }
        return () -> {
            VirtualFile dir = PushedFilePropertiesUpdaterImpl.getFile(event);
            ProjectFileIndex fileIndex = (ProjectFileIndex)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)this.myProject));
            if (dir != null && ((Boolean)ReadAction.compute(() -> fileIndex.isInContent(dir))).booleanValue() && !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)dir)) {
                this.doPushRecursively(pushers, scanners, (IndexableFilesIterator)new ProjectIndexableFilesIteratorImpl(dir));
            }
        };
    }

    private void doPushRecursively(@NotNull List<? extends FilePropertyPusher<?>> pushers, @NotNull List<IndexableFileScanner> scanners, @NotNull IndexableFilesIterator indexableFilesIterator) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(6);
        }
        if (scanners == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(7);
        }
        if (indexableFilesIterator == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(8);
        }
        List sessions = ContainerUtil.mapNotNull(scanners, visitor -> visitor.startSession(this.myProject).createVisitor(indexableFilesIterator.getOrigin()));
        indexableFilesIterator.iterateFiles(this.myProject, fileOrDir -> {
            this.applyPushersToFile(fileOrDir, pushers, null);
            PushedFilePropertiesUpdaterImpl.applyScannersToFile(fileOrDir, sessions);
            return true;
        }, (VirtualFileFilter)IndexableFilesDeduplicateFilter.create());
    }

    private void queueTasks(@NotNull List<? extends Runnable> actions2, final @NotNull @NonNls String reason) {
        if (actions2 == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(9);
        }
        if (reason == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(10);
        }
        actions2.forEach(this.myTasks::offer);
        final DumbModeTask task2 = new DumbModeTask((Object)this){

            public void performInDumbMode(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                indicator2.setIndeterminate(true);
                indicator2.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                ChangedFilesPushingStatistics statistics = !ApplicationManager.getApplication().isUnitTestMode() || IndexDiagnosticDumper.getShouldDumpInUnitTestMode() ? new ChangedFilesPushingStatistics(reason) : null;
                ((GistManagerImpl)GistManager.getInstance()).startMergingDependentCacheInvalidations();
                try {
                    PushedFilePropertiesUpdaterImpl.this.performDelayedPushTasks(statistics);
                }
                finally {
                    ((GistManagerImpl)GistManager.getInstance()).endMergingDependentCacheInvalidations();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$3", "performInDumbMode"));
            }
        };
        this.myProject.getMessageBus().connect((Disposable)task2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (RootsChangeIndexingInfo rootsChangeIndexingInfo : ((ModuleRootEventImpl)event).getInfos()) {
                    if (rootsChangeIndexingInfo != RootsChangeIndexingInfo.TOTAL_REINDEX) continue;
                    DumbService.getInstance((Project)PushedFilePropertiesUpdaterImpl.this.myProject).cancelTask(task2);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl$4", "rootsChanged"));
            }
        });
        task2.queue(this.myProject);
    }

    public void performDelayedPushTasks() {
        this.performDelayedPushTasks(null);
    }

    private void performDelayedPushTasks(@Nullable ChangedFilesPushingStatistics statistics) {
        boolean hadTasks = false;
        while (true) {
            ProgressManager.checkCanceled();
            Runnable task2 = this.myTasks.poll();
            if (task2 == null) break;
            try {
                task2.run();
                hadTasks = true;
            }
            catch (ProcessCanceledException e) {
                if (statistics != null) {
                    statistics.finished(true);
                    ChangedFilesPushedDiagnostic.INSTANCE.addEvent(this.myProject, statistics);
                }
                this.queueTasks(Collections.singletonList(task2), "Rerun pushing tasks after process cancelled");
                throw e;
            }
        }
        if (hadTasks) {
            this.scheduleDumbModeReindexingIfNeeded();
        }
        if (statistics != null) {
            statistics.finished(false);
            ChangedFilesPushedDiagnostic.INSTANCE.addEvent(this.myProject, statistics);
        }
    }

    private void scheduleDumbModeReindexingIfNeeded() {
        FileBasedIndexProjectHandler.scheduleReindexingInDumbMode(this.myProject);
    }

    public void filePropertiesChanged(@NotNull VirtualFile fileOrDir, @NotNull Condition<? super VirtualFile> acceptFileCondition) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(11);
        }
        if (acceptFileCondition == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(12);
        }
        if (fileOrDir.isDirectory()) {
            for (VirtualFile child2 : fileOrDir.getChildren()) {
                if (child2.isDirectory() || !acceptFileCondition.value((Object)child2)) continue;
                this.filePropertiesChanged(child2);
            }
        } else if (acceptFileCondition.value((Object)fileOrDir)) {
            this.filePropertiesChanged(fileOrDir);
        }
    }

    private static <T> T findNewPusherValue(Project project, VirtualFile fileOrDir, FilePropertyPusher<? extends T> pusher, T moduleValue) {
        Object immediateValue = pusher.getImmediateValue(project, fileOrDir);
        if (immediateValue != null) {
            return (T)immediateValue;
        }
        if (moduleValue != null) {
            return moduleValue;
        }
        return PushedFilePropertiesUpdaterImpl.findNewPusherValueFromParent(project, fileOrDir, pusher);
    }

    private static <T> T findNewPusherValueFromParent(Project project, VirtualFile fileOrDir, FilePropertyPusher<? extends T> pusher) {
        VirtualFile parent = fileOrDir.getParent();
        if (parent != null && ProjectFileIndex.getInstance((Project)project).isInContent(parent)) {
            Object userValue = parent.getUserData(pusher.getFileDataKey());
            if (userValue != null) {
                return (T)userValue;
            }
            return PushedFilePropertiesUpdaterImpl.findNewPusherValue(project, parent, pusher, null);
        }
        Object projectValue = pusher.getImmediateValue(project, null);
        return (T)(projectValue != null ? projectValue : pusher.getDefaultValue());
    }

    public void pushAll(FilePropertyPusher<?> ... pushers) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(13);
        }
        this.queueTasks(Collections.singletonList(() -> this.doPushAll(Arrays.asList(pushers))), "Push all on " + Arrays.toString(pushers));
    }

    private void doPushAll(@NotNull List<? extends FilePropertyPusher<?>> pushers) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(14);
        }
        PushedFilePropertiesUpdaterImpl.scanProject(this.myProject, module -> {
            Object[] moduleValues = PushedFilePropertiesUpdaterImpl.getModuleImmediateValues(pushers, module);
            return fileOrDir -> {
                this.applyPushersToFile(fileOrDir, pushers, moduleValues);
                return ContentIteratorEx.Status.CONTINUE;
            };
        });
    }

    public static Object @NotNull [] getModuleImmediateValues(@NotNull List<? extends FilePropertyPusher<?>> pushers, @NotNull Module module) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(15);
        }
        if (module == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(16);
        }
        Object[] moduleValues = new Object[pushers.size()];
        for (int i2 = 0; i2 < moduleValues.length; ++i2) {
            moduleValues[i2] = pushers.get(i2).getImmediateValue(module);
        }
        if (moduleValues == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(17);
        }
        return moduleValues;
    }

    public static void scanProject(@NotNull Project project, @NotNull Function<Module, ? extends ContentIteratorEx> iteratorProducer) {
        Stream tasksStream;
        if (project == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(18);
        }
        if (iteratorProducer == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(19);
        }
        if (DefaultProjectIndexableFilesContributor.indexProjectBasedOnIndexableEntityProviders()) {
            Sequence modulesSequence = (Sequence)ReadAction.compute(() -> WorkspaceModel.getInstance(project).getEntityStorage().getCurrent().entities(ModuleEntity.class));
            List moduleEntities = SequencesKt.toList((Sequence)modulesSequence);
            IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
            tasksStream = moduleEntities.stream().flatMap(moduleEntity -> (Stream)ReadAction.compute(() -> {
                Module module = IndexableEntityProviderMethods.INSTANCE.findModuleForEntity((ModuleEntity)moduleEntity, project);
                if (module == null) {
                    return Stream.empty();
                }
                ProgressManager.checkCanceled();
                return ContainerUtil.map(IndexableEntityProviderMethods.INSTANCE.createIterators((ModuleEntity)moduleEntity, project), it -> new Object((IndexableFilesIterator)it, iteratorProducer, module){
                    final IndexableFilesIterator files;
                    final ContentIteratorEx iterator;
                    final /* synthetic */ IndexableFilesIterator val$it;
                    final /* synthetic */ Function val$iteratorProducer;
                    final /* synthetic */ Module val$module;
                    {
                        this.val$it = indexableFilesIterator;
                        this.val$iteratorProducer = function;
                        this.val$module = module;
                        this.files = this.val$it;
                        this.iterator = (ContentIteratorEx)this.val$iteratorProducer.apply(this.val$module);
                    }
                }).stream().map(pair -> () -> pair.files.iterateFiles(project, (ContentIterator)pair.iterator, (VirtualFileFilter)indexableFilesDeduplicateFilter));
            }));
        } else {
            Module[] modules2 = (Module[])ReadAction.compute(() -> ModuleManager.getInstance((Project)project).getModules());
            IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
            tasksStream = Arrays.stream(modules2).flatMap(module -> (Stream)ReadAction.compute(() -> {
                if (module.isDisposed()) {
                    return Stream.empty();
                }
                ProgressManager.checkCanceled();
                return ContainerUtil.map(ModuleIndexableFilesIteratorImpl.getModuleIterators(module), it -> new Object((ModuleIndexableFilesIteratorImpl)it, iteratorProducer){
                    final IndexableFilesIterator files;
                    final ContentIteratorEx iterator;
                    final /* synthetic */ ModuleIndexableFilesIteratorImpl val$it;
                    final /* synthetic */ Function val$iteratorProducer;
                    {
                        this.val$it = moduleIndexableFilesIteratorImpl;
                        this.val$iteratorProducer = function;
                        this.files = this.val$it;
                        this.iterator = (ContentIteratorEx)this.val$iteratorProducer.apply(this.val$it.getOrigin().getModule());
                    }
                }).stream().map(pair -> () -> pair.files.iterateFiles(project, (ContentIterator)pair.iterator, (VirtualFileFilter)indexableFilesDeduplicateFilter));
            }));
        }
        List tasks = tasksStream.collect(Collectors.toList());
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
    }

    public static void invokeConcurrentlyIfPossible(@NotNull List<? extends Runnable> tasks) {
        if (tasks == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(20);
        }
        if (tasks.isEmpty()) {
            return;
        }
        if (tasks.size() == 1 || ApplicationManager.getApplication().isWriteAccessAllowed()) {
            for (Runnable runnable2 : tasks) {
                runnable2.run();
            }
            return;
        }
        ConcurrentLinkedQueue<? extends Runnable> tasksQueue = new ConcurrentLinkedQueue<Runnable>(tasks);
        FilesScanExecutor.runOnAllThreads(() -> {
            Runnable runnable2;
            while ((runnable2 = (Runnable)tasksQueue.poll()) != null) {
                runnable2.run();
            }
        });
    }

    public void applyPushersToFile(VirtualFile fileOrDir, @NotNull List<? extends FilePropertyPusher<?>> pushers, Object[] moduleValues) {
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(21);
        }
        if (pushers.isEmpty()) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            fileOrDir.getChildren();
        }
        ReadAction.run(() -> {
            if (!fileOrDir.isValid() || !(fileOrDir instanceof VirtualFileWithId)) {
                return;
            }
            this.doApplyPushersToFile(fileOrDir, pushers, moduleValues);
        });
    }

    private void doApplyPushersToFile(@NotNull VirtualFile fileOrDir, @NotNull List<? extends FilePropertyPusher<?>> pushers, Object @Nullable [] moduleValues) {
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(22);
        }
        if (pushers == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(23);
        }
        boolean isDir = fileOrDir.isDirectory();
        for (int i2 = 0; i2 < pushers.size(); ++i2) {
            FilePropertyPusher<?> pusher = pushers.get(i2);
            if (!isDir ? pusher.pushDirectoriesOnly() || !pusher.acceptsFile(fileOrDir, this.myProject) : !pusher.acceptsDirectory(fileOrDir, this.myProject)) continue;
            Object value2 = moduleValues != null ? moduleValues[i2] : null;
            this.findAndUpdateValue(fileOrDir, pusher, value2);
        }
    }

    public <T> void findAndUpdateValue(@NotNull VirtualFile fileOrDir, @NotNull FilePropertyPusher<T> pusher, @Nullable T moduleValue) {
        Object oldValue;
        T newValue2;
        if (fileOrDir == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(24);
        }
        if (pusher == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(25);
        }
        if ((newValue2 = PushedFilePropertiesUpdaterImpl.findNewPusherValue(this.myProject, fileOrDir, pusher, moduleValue)) != (oldValue = fileOrDir.getUserData(pusher.getFileDataKey()))) {
            fileOrDir.putUserData(pusher.getFileDataKey(), newValue2);
            try {
                pusher.persistAttribute(this.myProject, fileOrDir, newValue2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void filePropertiesChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PushedFilePropertiesUpdaterImpl.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex instanceof FileBasedIndexImpl) {
            ((FileBasedIndexImpl)fileBasedIndex).requestReindex(file2, false);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            PushedFilePropertiesUpdaterImpl.reloadPsi(file2, project);
        }
    }

    private static void reloadPsi(VirtualFile file2, Project project) {
        FileManagerImpl fileManager = (FileManagerImpl)PsiManagerEx.getInstanceEx(project).getFileManager();
        if (fileManager.findCachedViewProvider(file2) != null) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Condition)project.getDisposed(), () -> WriteAction.run(() -> fileManager.forceReload(file2)));
        }
    }

    private static List<FilePropertyPusher<?>> getFilePushers() {
        return ContainerUtil.findAll((Collection)FilePropertyPusher.EP_NAME.getExtensionList(), pusher -> !pusher.pushDirectoriesOnly());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 11: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanners";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexableFilesIterator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptFileCondition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteratorProducer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pusher";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/PushedFilePropertiesUpdaterImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleImmediateValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAfterVfsChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyScannersToFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRecursivePushTask";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPushRecursively";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "queueTasks";
                break;
            }
            case 11: 
            case 12: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "filePropertiesChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pushAll";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doPushAll";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModuleImmediateValues";
                break;
            }
            case 17: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "scanProject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invokeConcurrentlyIfPossible";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "applyPushersToFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doApplyPushersToFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findAndUpdateValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

