/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class LibraryTableBase
implements PersistentStateComponent<Element>,
LibraryTable,
Disposable {
    private static final Logger LOG = Logger.getInstance(LibraryTableBase.class);
    private final EventDispatcher<LibraryTable.Listener> myDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
    private LibraryModel myModel = new LibraryModel();
    private boolean myFirstLoad = true;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        return new LibraryModel(this.myModel);
    }

    public Element getState() {
        Element element2 = new Element("state");
        try {
            this.myModel.writeExternal(element2);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element2;
    }

    public void noStateLoaded() {
        this.myFirstLoad = false;
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            LibraryTableBase.$$$reportNull$$$0(0);
        }
        if (this.myFirstLoad) {
            this.myModel.readExternal(element2);
        } else {
            LibraryModel model2 = new LibraryModel(this.myModel);
            WriteAction.run(() -> {
                model2.readExternal(element2);
                model2.commit();
            });
        }
        this.myFirstLoad = false;
    }

    public long getStateModificationCount() {
        return this.myModificationTracker.getModificationCount();
    }

    public Library @NotNull [] getLibraries() {
        Library[] libraryArray = this.myModel.getLibraries();
        if (libraryArray == null) {
            LibraryTableBase.$$$reportNull$$$0(1);
        }
        return libraryArray;
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator<Library> iterator2 = this.myModel.getLibraryIterator();
        if (iterator2 == null) {
            LibraryTableBase.$$$reportNull$$$0(2);
        }
        return iterator2;
    }

    public Library getLibraryByName(@NotNull String name2) {
        if (name2 == null) {
            LibraryTableBase.$$$reportNull$$$0(3);
        }
        return this.myModel.getLibraryByName(name2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            LibraryTableBase.$$$reportNull$$$0(6);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        if (listener2 == null) {
            LibraryTableBase.$$$reportNull$$$0(7);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    private void fireLibraryAdded(@NotNull Library library2) {
        if (library2 == null) {
            LibraryTableBase.$$$reportNull$$$0(8);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireLibraryAdded: " + library2);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryAdded(library2);
    }

    private void fireBeforeLibraryRemoved(@NotNull Library library2) {
        if (library2 == null) {
            LibraryTableBase.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireBeforeLibraryRemoved: " + library2);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).beforeLibraryRemoved(library2);
    }

    public void dispose() {
        for (Library library2 : this.getLibraries()) {
            Disposer.dispose((Disposable)library2);
        }
    }

    @NotNull
    public Library createLibrary() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Library library2 = this.createLibrary(null);
        if (library2 == null) {
            LibraryTableBase.$$$reportNull$$$0(10);
        }
        return library2;
    }

    void fireLibraryRenamed(@NotNull LibraryImpl library2, String oldName) {
        if (library2 == null) {
            LibraryTableBase.$$$reportNull$$$0(11);
        }
        this.incrementModificationCount();
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRenamed((Library)library2, oldName);
    }

    private void incrementModificationCount() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("library");
        }
        this.myModificationTracker.incModificationCount();
    }

    @NotNull
    public Library createLibrary(String name2) {
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        Library library2 = modifiableModel.createLibrary(name2);
        modifiableModel.commit();
        Library library3 = library2;
        if (library3 == null) {
            LibraryTableBase.$$$reportNull$$$0(12);
        }
        return library3;
    }

    public void removeLibrary(@NotNull Library library2) {
        if (library2 == null) {
            LibraryTableBase.$$$reportNull$$$0(13);
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library2);
        modifiableModel.commit();
    }

    private void commit(LibraryModel model2) {
        this.myFirstLoad = false;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!model2.isChanged()) {
            return;
        }
        this.incrementModificationCount();
        Set<Library> removedLibraries = model2.myRemovedLibraries;
        for (Library library2 : removedLibraries) {
            this.fireBeforeLibraryRemoved(library2);
        }
        this.myModel.applyChanges(model2);
        for (Library library2 : removedLibraries) {
            Disposer.dispose((Disposable)library2);
            this.fireAfterLibraryRemoved(library2);
        }
        for (Library library2 : model2.myAddedLibraries) {
            this.fireLibraryAdded(library2);
        }
    }

    private void fireAfterLibraryRemoved(@NotNull Library library2) {
        if (library2 == null) {
            LibraryTableBase.$$$reportNull$$$0(14);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRemoved(library2);
    }

    public void readExternal(Element element2) throws InvalidDataException {
        this.myModel = new LibraryModel();
        this.myModel.readExternal(element2);
    }

    public void writeExternal(Element element2) throws WriteExternalException {
        this.myModel.writeExternal(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIterator";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireLibraryAdded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeLibraryRemoved";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fireLibraryRenamed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterLibraryRemoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    final class LibraryModel
    implements LibraryTable.ModifiableModel,
    JDOMExternalizable,
    LibraryTable.Listener,
    Disposable {
        private final List<Library> myLibraries = new ArrayList<Library>();
        private final Set<Library> myAddedLibraries = new ReferenceOpenHashSet();
        private final Set<Library> myRemovedLibraries = new ReferenceOpenHashSet();
        private volatile Map<String, Library> myLibraryByNameCache;
        private boolean myWritable;

        private LibraryModel() {
            LibraryTableBase.this.myDispatcher.addListener((EventListener)((Object)this));
            this.myWritable = false;
        }

        private LibraryModel(LibraryModel that) {
            LibraryTableBase.this.myDispatcher.addListener((EventListener)((Object)this));
            this.myWritable = true;
            this.myLibraries.addAll(that.myLibraries);
        }

        public void commit() {
            LibraryTableBase.this.commit(this);
            this.myAddedLibraries.clear();
            this.myRemovedLibraries.clear();
            Disposer.dispose((Disposable)this);
            this.myWritable = false;
        }

        public void dispose() {
            LibraryTableBase.this.myDispatcher.removeListener((EventListener)((Object)this));
            for (Library library2 : this.myAddedLibraries) {
                Disposer.dispose((Disposable)library2);
            }
        }

        @NotNull
        public Iterator<Library> getLibraryIterator() {
            Iterator<Library> iterator2 = Collections.unmodifiableList(this.myLibraries).iterator();
            if (iterator2 == null) {
                LibraryModel.$$$reportNull$$$0(0);
            }
            return iterator2;
        }

        @Nullable
        public Library getLibraryByName(@NotNull String name2) {
            Library library2;
            Map<String, Library> cache2;
            if (name2 == null) {
                LibraryModel.$$$reportNull$$$0(1);
            }
            if ((cache2 = this.myLibraryByNameCache) == null) {
                cache2 = new HashMap<String, Library>();
                for (Library library3 : this.myLibraries) {
                    cache2.put(library3.getName(), library3);
                }
                this.myLibraryByNameCache = cache2;
            }
            if ((library2 = cache2.get(name2)) != null) {
                return library2;
            }
            @NonNls String libraryPrefix = "library.";
            String libPath = System.getProperty("library." + name2);
            if (libPath != null) {
                LibraryImpl libraryFromProperty = new LibraryImpl(name2, null, LibraryTableBase.this, null, null);
                libraryFromProperty.addRoot(libPath, OrderRootType.CLASSES);
                return libraryFromProperty;
            }
            return null;
        }

        public Library @NotNull [] getLibraries() {
            Library[] libraryArray = this.myLibraries.toArray(Library.EMPTY_ARRAY);
            if (libraryArray == null) {
                LibraryModel.$$$reportNull$$$0(2);
            }
            return libraryArray;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myWritable);
        }

        @NotNull
        public Library createLibrary(String name2) {
            Library library2 = this.createLibrary(name2, null);
            if (library2 == null) {
                LibraryModel.$$$reportNull$$$0(3);
            }
            return library2;
        }

        @NotNull
        public Library createLibrary(String name2, @Nullable PersistentLibraryKind<?> kind) {
            Library library2 = this.createLibrary(name2, kind, null);
            if (library2 == null) {
                LibraryModel.$$$reportNull$$$0(4);
            }
            return library2;
        }

        @NotNull
        public Library createLibrary(String name2, @Nullable PersistentLibraryKind<?> kind, @Nullable ProjectModelExternalSource externalSource) {
            this.assertWritable();
            LibraryImpl library2 = new LibraryImpl(name2, kind, LibraryTableBase.this, null, externalSource);
            this.myLibraries.add((Library)library2);
            if (this.myWritable) {
                this.myAddedLibraries.add((Library)library2);
            }
            this.myLibraryByNameCache = null;
            LibraryImpl libraryImpl = library2;
            if (libraryImpl == null) {
                LibraryModel.$$$reportNull$$$0(5);
            }
            return libraryImpl;
        }

        public void removeLibrary(@NotNull Library library2) {
            if (library2 == null) {
                LibraryModel.$$$reportNull$$$0(6);
            }
            LibraryTableBase.this.incrementModificationCount();
            this.assertWritable();
            this.myLibraries.remove(library2);
            if (this.myWritable) {
                if (!this.myAddedLibraries.remove(library2)) {
                    this.myRemovedLibraries.add(library2);
                } else {
                    Disposer.dispose((Disposable)library2);
                }
            }
            this.myLibraryByNameCache = null;
        }

        public boolean isChanged() {
            if (!this.myWritable) {
                return false;
            }
            return !this.myAddedLibraries.isEmpty() || !this.myRemovedLibraries.isEmpty();
        }

        public void readExternal(Element element2) {
            if (this.myWritable) {
                this.myRemovedLibraries.addAll(this.myLibraries);
            }
            this.myLibraries.clear();
            List libraryElements = element2.getChildren("library");
            for (Element libraryElement : libraryElements) {
                LibraryImpl library2 = new LibraryImpl(LibraryTableBase.this, libraryElement, null);
                if (library2.getName() != null) {
                    this.myLibraries.add((Library)library2);
                    if (this.myWritable) {
                        this.myAddedLibraries.add((Library)library2);
                    }
                    LibraryTableBase.this.fireLibraryAdded((Library)library2);
                    continue;
                }
                Disposer.dispose((Disposable)library2);
            }
            this.myLibraryByNameCache = null;
        }

        public void afterLibraryRenamed(@NotNull Library library2, @Nullable String oldName) {
            if (library2 == null) {
                LibraryModel.$$$reportNull$$$0(7);
            }
            this.myLibraryByNameCache = null;
        }

        public void writeExternal(Element element2) {
            List libraries2 = ContainerUtil.findAll(this.myLibraries, library2 -> !((LibraryEx)library2).isDisposed());
            ContainerUtil.sort((List)libraries2, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
            for (Library library3 : libraries2) {
                if (library3.getName() == null) continue;
                library3.writeExternal(element2);
            }
        }

        private void applyChanges(LibraryModel model2) {
            this.myLibraries.removeAll(model2.myRemovedLibraries);
            this.myLibraries.addAll(model2.myAddedLibraries);
            this.myLibraryByNameCache = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryIterator";
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraries";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryByName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeLibrary";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "afterLibraryRenamed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

