/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.ui.impl.SuggestedChildRootInfo;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TitlePanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeTable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComboBoxCellEditor;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DetectedRootsChooserDialog
extends DialogWrapper {
    private static final ColumnInfo<?, ?> ROOT_COLUMN = new TreeColumnInfo("");
    private static final ColumnInfo<VirtualFileCheckedTreeNode, String> ROOT_TYPE_COLUMN = new ColumnInfo<VirtualFileCheckedTreeNode, String>(""){

        public String valueOf(VirtualFileCheckedTreeNode node2) {
            SuggestedChildRootInfo rootInfo = node2.getRootInfo();
            return rootInfo != null ? rootInfo.getRootTypeName(rootInfo.getSelectedRootType()) : "";
        }

        public TableCellRenderer getRenderer(VirtualFileCheckedTreeNode node2) {
            SuggestedChildRootInfo rootInfo = node2.getRootInfo();
            if (rootInfo != null && this.isCellEditable(node2)) {
                return new ComboBoxTableRenderer((Object[])rootInfo.getRootTypeNames());
            }
            return new DefaultTableCellRenderer();
        }

        public TableCellEditor getEditor(VirtualFileCheckedTreeNode o) {
            final SuggestedChildRootInfo rootInfo = o.getRootInfo();
            if (rootInfo == null) {
                return null;
            }
            ComboBoxCellEditor editor2 = new ComboBoxCellEditor(){

                protected List<String> getComboBoxItems() {
                    return Arrays.asList(rootInfo.getRootTypeNames());
                }
            };
            editor2.setClickCountToStart(1);
            return editor2;
        }

        public boolean isCellEditable(VirtualFileCheckedTreeNode node2) {
            SuggestedChildRootInfo rootInfo = node2.getRootInfo();
            return rootInfo != null && rootInfo.getDetectedRoot().getTypes().size() > 1;
        }

        public void setValue(VirtualFileCheckedTreeNode node2, String value2) {
            SuggestedChildRootInfo rootInfo = node2.getRootInfo();
            if (rootInfo != null) {
                rootInfo.setSelectedRootType(value2);
            }
        }
    };
    private CheckboxTreeTable myTreeTable;
    private JScrollPane myPane;
    private @NlsContexts.Label String myDescription;

    public DetectedRootsChooserDialog(Component component2, Collection<SuggestedChildRootInfo> suggestedRoots) {
        super(component2, true);
        this.init(suggestedRoots);
    }

    public DetectedRootsChooserDialog(Project project, Collection<SuggestedChildRootInfo> suggestedRoots) {
        super(project, true);
        this.init(suggestedRoots);
    }

    private void init(Collection<SuggestedChildRootInfo> suggestedRoots) {
        this.myDescription = XmlStringUtil.wrapInHtml((CharSequence)LangBundle.message((String)"detected.roots.chooser.description", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), suggestedRoots.size()}));
        this.myTreeTable = DetectedRootsChooserDialog.createTreeTable(suggestedRoots);
        this.myPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeTable));
        this.setTitle(ProjectBundle.message((String)"dialog.title.detected.roots", (Object[])new Object[0]));
        this.init();
    }

    private static CheckboxTreeTable createTreeTable(Collection<SuggestedChildRootInfo> suggestedRoots) {
        CheckedTreeNode root2 = DetectedRootsChooserDialog.createRoot(suggestedRoots);
        CheckboxTreeTable treeTable = new CheckboxTreeTable(root2, new CheckboxTree.CheckboxTreeCellRenderer(true){

            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
                SimpleTextAttributes attributes2;
                String text2;
                if (!(value2 instanceof VirtualFileCheckedTreeNode)) {
                    return;
                }
                VirtualFileCheckedTreeNode node2 = (VirtualFileCheckedTreeNode)((Object)value2);
                VirtualFile file2 = node2.getFile();
                boolean isValid = true;
                if (leaf) {
                    VirtualFile ancestor = ((VirtualFileCheckedTreeNode)((Object)node2.getParent())).getFile();
                    if (ancestor != null) {
                        text2 = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)ancestor, (char)File.separatorChar);
                        if (StringUtil.isEmpty((String)text2)) {
                            text2 = File.separator;
                        }
                    } else {
                        text2 = file2.getPresentableUrl();
                    }
                    if (text2 == null) {
                        isValid = false;
                        text2 = file2.getPresentableUrl();
                    }
                    attributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                } else {
                    text2 = file2.getPresentableUrl();
                    attributes2 = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                }
                ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                textRenderer.setIcon(PlatformIcons.FOLDER_ICON);
                if (!isValid) {
                    textRenderer.append(ProjectBundle.message((String)"invalid.root.label", (Object[])new Object[0]) + " ", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
                textRenderer.append(text2, attributes2);
            }
        }, new ColumnInfo[]{ROOT_COLUMN, ROOT_TYPE_COLUMN});
        int max = 0;
        for (SuggestedChildRootInfo info2 : suggestedRoots) {
            for (String s : info2.getRootTypeNames()) {
                max = Math.max(max, treeTable.getFontMetrics(treeTable.getFont()).stringWidth(s));
            }
        }
        TableColumn column2 = treeTable.getColumnModel().getColumn(1);
        int width = max + 20;
        column2.setPreferredWidth(width);
        column2.setMaxWidth(width);
        treeTable.setRootVisible(false);
        new TreeTableSpeedSearch((TreeTable)treeTable, (Convertor<? super TreePath, String>)((Convertor)o -> {
            Object node2 = o.getLastPathComponent();
            if (!(node2 instanceof VirtualFileCheckedTreeNode)) {
                return "";
            }
            return ((VirtualFileCheckedTreeNode)((Object)((Object)node2))).getFile().getPresentableUrl();
        }));
        TreeUtil.expandAll((JTree)treeTable.getTree());
        return treeTable;
    }

    private static CheckedTreeNode createRoot(Collection<SuggestedChildRootInfo> suggestedRoots) {
        SuggestedChildRootInfo[] sortedRoots = suggestedRoots.toArray(new SuggestedChildRootInfo[0]);
        Arrays.sort(sortedRoots, Comparator.comparing(o -> o.getDetectedRoot().getFile().getPresentableUrl()));
        CheckedTreeNode root2 = new CheckedTreeNode(null);
        HashMap<VirtualFile, CheckedTreeNode> rootCandidateNodes = new HashMap<VirtualFile, CheckedTreeNode>();
        for (SuggestedChildRootInfo rootInfo : sortedRoots) {
            VirtualFile rootCandidate = rootInfo.getRootCandidate();
            CheckedTreeNode parent = (CheckedTreeNode)rootCandidateNodes.get(rootCandidate);
            if (parent == null) {
                parent = new VirtualFileCheckedTreeNode(rootCandidate);
                rootCandidateNodes.put(rootCandidate, parent);
                root2.add((MutableTreeNode)parent);
            }
            parent.add((MutableTreeNode)((Object)new VirtualFileCheckedTreeNode(rootInfo)));
        }
        return root2;
    }

    protected JComponent createTitlePane() {
        return new TitlePanel(ProjectBundle.message((String)"section.title.choose.roots", (Object[])new Object[0]), this.myDescription);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPane;
    }

    public SuggestedChildRootInfo[] getChosenRoots() {
        return this.myTreeTable.getCheckedNodes(SuggestedChildRootInfo.class);
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "DetectedRootsChooserDialog";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTreeTable;
    }

    private static class VirtualFileCheckedTreeNode
    extends CheckedTreeNode {
        private final VirtualFile myFile;

        private VirtualFileCheckedTreeNode(VirtualFile file2) {
            super((Object)file2);
            this.myFile = file2;
        }

        VirtualFileCheckedTreeNode(SuggestedChildRootInfo rootInfo) {
            super((Object)rootInfo);
            this.myFile = rootInfo.getDetectedRoot().getFile();
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        @Nullable
        private SuggestedChildRootInfo getRootInfo() {
            return this.userObject instanceof SuggestedChildRootInfo ? (SuggestedChildRootInfo)this.userObject : null;
        }
    }
}

