/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.application.options.RegistryManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.FrameWrapperKt;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WindowState;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.GlobalMenuLinux;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.LinuxIdeMenuBar;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameDialogContent;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.FrameState;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0002RSB=\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0003\u0010\t\u001a\u00020\u0006\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010-\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020/H\u0002J\u0006\u00100\u001a\u00020.J\u0006\u00101\u001a\u00020.J\u0006\u00102\u001a\u00020.J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002082\u0006\u00105\u001a\u000206H\u0014J\b\u00109\u001a\u00020.H\u0016J\u0014\u0010:\u001a\u0004\u0018\u00010;2\b\b\u0001\u0010<\u001a\u00020\u0006H\u0016J\u0014\u0010=\u001a\u0004\u0018\u00010;2\b\b\u0001\u0010<\u001a\u00020\u0006H\u0002J\u0006\u0010>\u001a\u00020\u0014J\u0014\u0010?\u001a\u0004\u0018\u00010@2\b\u0010A\u001a\u0004\u0018\u00010\u0006H\u0014J\u0012\u0010B\u001a\u00020.2\b\u0010C\u001a\u0004\u0018\u00010DH\u0014J\u0010\u0010E\u001a\u00020.2\b\u0010F\u001a\u0004\u0018\u00010\u0017J\u0016\u0010G\u001a\u00020.2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016J\u000e\u0010H\u001a\u00020.2\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u00020.2\b\u0010#\u001a\u0004\u0018\u00010\u001fJ\u000e\u0010L\u001a\u00020.2\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010M\u001a\u00020.2\b\u0010N\u001a\u0004\u0018\u00010OJ\b\u0010P\u001a\u00020.H\u0016J\u000e\u0010P\u001a\u00020.2\u0006\u0010Q\u001a\u00020\bR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000e\"\u0004\b\"\u0010\u0010R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010%\u001a\u0004\u0018\u00010$2\b\u0010#\u001a\u0004\u0018\u00010$@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0012\"\u0004\b+\u0010,\u00a8\u0006T"}, d2={"Lcom/intellij/openapi/ui/FrameWrapper;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "dimensionKey", "", "isDialog", "", "title", "component", "Ljavax/swing/JComponent;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ZLjava/lang/String;Ljavax/swing/JComponent;)V", "getComponent", "()Ljavax/swing/JComponent;", "setComponent", "(Ljavax/swing/JComponent;)V", "getDimensionKey", "()Ljava/lang/String;", "frame", "Ljava/awt/Window;", "images", "", "Ljava/awt/Image;", "isActive", "()Z", "isCloseOnEsc", "<set-?>", "isDisposed", "isDisposing", "onCloseHandler", "Lcom/intellij/openapi/util/BooleanGetter;", "preferredFocusedComponent", "getPreferredFocusedComponent", "setPreferredFocusedComponent", "value", "Lcom/intellij/openapi/wm/StatusBar;", "statusBar", "getStatusBar", "()Lcom/intellij/openapi/wm/StatusBar;", "setStatusBar", "(Lcom/intellij/openapi/wm/StatusBar;)V", "getTitle", "setTitle", "(Ljava/lang/String;)V", "addCloseOnEsc", "", "Ljavax/swing/RootPaneContainer;", "close", "closeOnEsc", "createContents", "createJDialog", "Ljavax/swing/JDialog;", "parent", "Lcom/intellij/openapi/wm/IdeFrame;", "createJFrame", "Ljavax/swing/JFrame;", "dispose", "getData", "", "dataId", "getDataInner", "getFrame", "getNorthExtension", "Lcom/intellij/openapi/wm/IdeRootPaneNorthExtension;", "key", "loadFrameState", "state", "Lcom/intellij/openapi/util/WindowState;", "setImage", "image", "setImages", "setLocation", "location", "Ljava/awt/Point;", "setOnCloseHandler", "setProject", "setSize", "size", "Ljava/awt/Dimension;", "show", "restoreBounds", "MyJDialog", "MyJFrame", "intellij.platform.ide.impl"})
public class FrameWrapper
implements Disposable,
DataProvider {
    @Nullable
    private JComponent preferredFocusedComponent;
    private List<? extends Image> images;
    private boolean isCloseOnEsc;
    private BooleanGetter onCloseHandler;
    private Window frame;
    private Project project;
    private boolean isDisposing;
    private boolean isDisposed;
    @Nullable
    private StatusBar statusBar;
    @Nullable
    private final String dimensionKey;
    private final boolean isDialog;
    @NotNull
    private String title;
    @Nullable
    private JComponent component;

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.preferredFocusedComponent;
    }

    public void setPreferredFocusedComponent(@Nullable JComponent jComponent) {
        this.preferredFocusedComponent = jComponent;
    }

    public final boolean isDisposed() {
        return this.isDisposed;
    }

    @Nullable
    protected final StatusBar getStatusBar() {
        return this.statusBar;
    }

    protected final void setStatusBar(@Nullable StatusBar value2) {
        StatusBar statusBar2 = this.statusBar;
        if (statusBar2 != null) {
            StatusBar statusBar3 = statusBar2;
            boolean bl = false;
            boolean bl2 = false;
            StatusBar it = statusBar3;
            boolean bl3 = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.statusBar = value2;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(this){
            final /* synthetic */ FrameWrapper this$0;

            public void projectClosing(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (project == FrameWrapper.access$getProject$p(this.this$0)) {
                    this.this$0.close();
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public void show() {
        this.show(true);
    }

    /*
     * WARNING - void declaration
     */
    public final void createContents() {
        JFrame parentFrame;
        Object object;
        Window frame = this.getFrame();
        if (frame instanceof JFrame) {
            ((JFrame)frame).setDefaultCloseOperation(0);
        } else {
            Window window = frame;
            if (window == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.JDialog");
            }
            ((JDialog)window).setDefaultCloseOperation(0);
        }
        frame.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ FrameWrapper this$0;

            public void windowClosing(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.close();
            }
            {
                this.this$0 = this$0;
            }
        });
        UIUtil.decorateWindowHeader((JRootPane)((RootPaneContainer)((Object)frame)).getRootPane());
        if (frame instanceof JFrame) {
            UIUtil.setCustomTitleBar((Window)frame, (JRootPane)((JFrame)frame).getRootPane(), (Consumer)new Consumer(this){
                final /* synthetic */ FrameWrapper this$0;

                public final void accept(Runnable runnable2) {
                    Disposer.register((Disposable)this.this$0, (Disposable)new Disposable(runnable2){
                        final /* synthetic */ Runnable $runnable;

                        public final void dispose() {
                            this.$runnable.run();
                        }
                        {
                            this.$runnable = runnable2;
                        }
                    });
                }
                {
                    this.this$0 = frameWrapper;
                }
            });
        }
        WindowAdapter focusListener2 = new WindowAdapter(this){
            final /* synthetic */ FrameWrapper this$0;

            public void windowOpened(@NotNull WindowEvent e) {
                Component toFocus;
                Component component2;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)FrameWrapper.access$getProject$p(this.this$0));
                Component component3 = focusManager.getLastFocusedFor(e.getWindow());
                if (component3 == null) {
                    component3 = component2 = (Component)this.this$0.getPreferredFocusedComponent();
                }
                if (component3 == null) {
                    JComponent jComponent = this.this$0.getComponent();
                    Intrinsics.checkNotNull((Object)jComponent);
                    component2 = toFocus = (Component)focusManager.getFocusTargetFor(jComponent);
                }
                if (toFocus != null) {
                    focusManager.requestFocus(toFocus, true);
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        frame.addWindowListener(focusListener2);
        if (RegistryManager.getInstance().is("ide.perProjectModality")) {
            frame.setAlwaysOnTop(true);
        }
        Disposer.register((Disposable)this, (Disposable)new Disposable(frame, focusListener2){
            final /* synthetic */ Window $frame;
            final /* synthetic */ createContents.focusListener.1 $focusListener;

            public final void dispose() {
                this.$frame.removeWindowListener(this.$focusListener);
            }
            {
                this.$frame = window;
                this.$focusListener = var2_2;
            }
        });
        if (this.isCloseOnEsc) {
            this.addCloseOnEsc((RootPaneContainer)((Object)frame));
        }
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            JComponent jComponent = this.getComponent();
            if (jComponent != null) {
                object = jComponent;
                boolean bl = false;
                boolean bl2 = false;
                JComponent it = object;
                boolean bl3 = false;
                this.setComponent(CustomFrameDialogContent.Companion.getCustomContentHolder(frame, it));
            }
        }
        Container container = ((RootPaneContainer)((Object)frame)).getContentPane();
        JComponent jComponent = this.getComponent();
        Intrinsics.checkNotNull((Object)jComponent);
        container.add((Component)jComponent, "Center");
        if (frame instanceof JFrame) {
            ((JFrame)frame).setTitle(this.title);
        } else {
            ((JDialog)frame).setTitle(this.title);
        }
        if (this.images.isEmpty()) {
            AppUIUtil.updateWindowIcon(frame);
        } else {
            Collection<BufferedImage> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = this.images;
            Window window = frame;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Image image = (Image)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)it);
                collection.add(bufferedImage);
            }
            collection = (List)destination$iv$iv;
            window.setIconImages((List<? extends Image>)collection);
        }
        if (SystemInfo.isLinux && frame instanceof JFrame && GlobalMenuLinux.isAvailable() && (parentFrame = WindowManager.getInstance().getFrame(this.project)) != null) {
            LinuxIdeMenuBar.Companion.doBindAppMenuOfParent((JFrame)frame, parentFrame);
        }
    }

    public final void show(boolean restoreBounds) {
        WindowState state;
        WindowState windowState;
        this.createContents();
        Window frame = this.getFrame();
        String string = this.getDimensionKey();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            windowState = FrameWrapperKt.access$getWindowStateService(this.project).getState(it, frame);
        } else {
            windowState = state = null;
        }
        if (restoreBounds) {
            this.loadFrameState(state);
        }
        if (SystemInfo.isMac) {
            TouchbarSupport.showWindowActions(this, frame);
        }
        frame.setVisible(true);
    }

    public final void close() {
        block5: {
            block4: {
                if (this.isDisposed) break block4;
                if (this.onCloseHandler == null) break block5;
                BooleanGetter booleanGetter = this.onCloseHandler;
                Intrinsics.checkNotNull((Object)booleanGetter);
                if (booleanGetter.get()) break block5;
            }
            return;
        }
        Window window = this.frame;
        if (window != null) {
            window.setVisible(false);
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        Window frame = this.frame;
        StatusBar statusBar2 = this.statusBar;
        this.frame = null;
        this.setPreferredFocusedComponent(null);
        this.project = null;
        this.setComponent(null);
        this.images = CollectionsKt.emptyList();
        this.isDisposed = true;
        if (statusBar2 != null) {
            Disposer.dispose((Disposable)((Disposable)statusBar2));
        }
        if (frame != null) {
            frame.setVisible(false);
            JRootPane rootPane = ((RootPaneContainer)((Object)frame)).getRootPane();
            frame.removeAll();
            DialogWrapper.cleanupRootPane((JRootPane)rootPane);
            if (frame instanceof IdeFrame) {
                MouseGestureManager.getInstance().remove((IdeFrame)frame);
            }
            frame.dispose();
            DialogWrapper.cleanupWindowListeners((Window)frame);
        }
    }

    private final void addCloseOnEsc(RootPaneContainer frame) {
        JRootPane rootPane = frame.getRootPane();
        ActionListener closeAction2 = new ActionListener(this){
            final /* synthetic */ FrameWrapper this$0;

            public final void actionPerformed(ActionEvent it) {
                if (!PopupUtil.handleEscKeyEvent()) {
                    this.this$0.close();
                }
            }
            {
                this.this$0 = frameWrapper;
            }
        };
        rootPane.registerKeyboardAction(closeAction2, KeyStroke.getKeyStroke(27, 0), 2);
        ActionUtil.registerForEveryKeyboardShortcut((JComponent)rootPane, (ActionListener)closeAction2, (ShortcutSet)CommonShortcuts.getCloseActiveWindow());
    }

    @NotNull
    public final Window getFrame() {
        boolean bl = !this.isDisposed;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Already disposed!";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Window result2 = this.frame;
        if (result2 == null) {
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.project);
            Intrinsics.checkNotNull((Object)ideFrame);
            Intrinsics.checkNotNullExpressionValue((Object)ideFrame, (String)"WindowManager.getInstance().getIdeFrame(project)!!");
            IdeFrame parent = ideFrame;
            this.frame = result2 = this.isDialog ? (Window)this.createJDialog(parent) : (Window)this.createJFrame(parent);
        }
        return result2;
    }

    public final boolean isActive() {
        Window window = this.frame;
        return window != null && window.isActive();
    }

    @NotNull
    protected JFrame createJFrame(@NotNull IdeFrame parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new MyJFrame(this, parent);
    }

    @NotNull
    protected JDialog createJDialog(@NotNull IdeFrame parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new MyJDialog(this, parent);
    }

    @Nullable
    protected IdeRootPaneNorthExtension getNorthExtension(@Nullable String key) {
        return null;
    }

    @Override
    @Nullable
    public Object getData(@NonNls @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return CommonDataKeys.PROJECT.is(dataId) ? this.project : null;
    }

    private final Object getDataInner(@NonNls String dataId) {
        return CommonDataKeys.PROJECT.is(dataId) ? this.project : this.getData(dataId);
    }

    public final void closeOnEsc() {
        this.isCloseOnEsc = true;
    }

    public final void setImage(@Nullable Image image) {
        this.setImages(CollectionsKt.listOfNotNull((Object)image));
    }

    public final void setImages(@Nullable List<? extends Image> value2) {
        List list2 = value2;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.images = list2;
    }

    public final void setOnCloseHandler(@Nullable BooleanGetter value2) {
        this.onCloseHandler = value2;
    }

    protected void loadFrameState(@Nullable WindowState state) {
        Window frame = this.getFrame();
        if (state == null) {
            IdeFrame ideFrame = WindowManagerEx.getInstanceEx().getIdeFrame(this.project);
            if (ideFrame != null) {
                frame.setBounds(ideFrame.suggestChildFrameBounds());
            }
        } else {
            state.applyTo(frame);
        }
        Window window = frame;
        if (window == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.RootPaneContainer");
        }
        ((RootPaneContainer)((Object)window)).getRootPane().revalidate();
    }

    public final void setLocation(@NotNull Point location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.getFrame().setLocation(location);
    }

    public final void setSize(@Nullable Dimension size) {
        this.getFrame().setSize(size);
    }

    @Nullable
    protected String getDimensionKey() {
        return this.dimensionKey;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.title = string;
    }

    @Nullable
    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(@Nullable JComponent jComponent) {
        this.component = jComponent;
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project, @NonNls @Nullable String dimensionKey, boolean isDialog, @NlsContexts.DialogTitle @NotNull String title2, @Nullable JComponent component2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            this.dimensionKey = dimensionKey;
            this.isDialog = isDialog;
            this.title = title2;
            this.component = component2;
            this.images = CollectionsKt.emptyList();
            Project project2 = project;
            if (project2 == null) break block0;
            Project project3 = project2;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project3;
            boolean bl3 = false;
            this.setProject(it);
        }
    }

    public /* synthetic */ FrameWrapper(Project project, String string, boolean bl, String string2, JComponent jComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            jComponent = null;
        }
        this(project, string, bl, string2, jComponent);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project, @NonNls @Nullable String dimensionKey, boolean isDialog, @NlsContexts.DialogTitle @NotNull String title2) {
        this(project, dimensionKey, isDialog, title2, null, 16, null);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project, @NonNls @Nullable String dimensionKey, boolean isDialog) {
        this(project, dimensionKey, isDialog, null, null, 24, null);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project, @NonNls @Nullable String dimensionKey) {
        this(project, dimensionKey, false, null, null, 28, null);
    }

    @JvmOverloads
    public FrameWrapper(@Nullable Project project) {
        this(project, null, false, null, null, 30, null);
    }

    public static final /* synthetic */ Project access$getProject$p(FrameWrapper $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$setProject$p(FrameWrapper $this, Project project) {
        $this.project = project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u000f\u0010\u001c\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\b\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010'\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0014\u0010,\u001a\u0006\u0012\u0002\b\u00030-2\u0006\u0010.\u001a\u00020\"H\u0016J\b\u0010/\u001a\u00020\u0010H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/openapi/ui/FrameWrapper$MyJFrame;", "Ljavax/swing/JFrame;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/wm/IdeFrame$Child;", "Lcom/intellij/openapi/wm/ex/IdeFrameEx;", "owner", "Lcom/intellij/openapi/ui/FrameWrapper;", "parent", "Lcom/intellij/openapi/wm/IdeFrame;", "(Lcom/intellij/openapi/ui/FrameWrapper;Lcom/intellij/openapi/wm/IdeFrame;)V", "file", "Ljava/nio/file/Path;", "fileTitle", "", "frameTitle", "addNotify", "", "dispose", "getBalloonLayout", "Lcom/intellij/ui/BalloonLayout;", "getComponent", "Ljavax/swing/JComponent;", "getData", "", "dataId", "getNorthExtension", "Lcom/intellij/openapi/wm/IdeRootPaneNorthExtension;", "key", "getProject", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "getStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "isInFullScreen", "", "paint", "g", "Ljava/awt/Graphics;", "setFileTitle", "ioFile", "setFrameTitle", "title", "suggestChildFrameBounds", "Ljava/awt/Rectangle;", "toggleFullScreen", "Lorg/jetbrains/concurrency/Promise;", "state", "updateTitle", "intellij.platform.ide.impl"})
    private static final class MyJFrame
    extends JFrame
    implements DataProvider,
    IdeFrame.Child,
    IdeFrameEx {
        private String frameTitle;
        private String fileTitle;
        private Path file;
        private FrameWrapper owner;
        private final IdeFrame parent;

        public boolean isInFullScreen() {
            return false;
        }

        @Override
        @NotNull
        public Promise<?> toggleFullScreen(boolean state) {
            return Promises.resolvedPromise();
        }

        @Override
        public void addNotify() {
            if (IdeFrameDecorator.isCustomDecorationActive()) {
                JdkEx.setHasCustomDecoration(this);
            }
            super.addNotify();
        }

        @NotNull
        public JComponent getComponent() {
            JRootPane jRootPane = this.getRootPane();
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane()");
            return jRootPane;
        }

        @Nullable
        public StatusBar getStatusBar() {
            StatusBar statusBar2 = this.owner.isDisposing ? null : this.owner.getStatusBar();
            if (statusBar2 == null) {
                statusBar2 = this.parent.getStatusBar();
            }
            return statusBar2;
        }

        @NotNull
        public Rectangle suggestChildFrameBounds() {
            Rectangle rectangle = this.parent.suggestChildFrameBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"parent.suggestChildFrameBounds()");
            return rectangle;
        }

        @Nullable
        public Project getProject() {
            return this.parent.getProject();
        }

        public void setFrameTitle(@NotNull String title2) {
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            this.frameTitle = title2;
            this.updateTitle();
        }

        @Override
        public void setFileTitle(@Nullable String fileTitle, @Nullable Path ioFile) {
            this.fileTitle = fileTitle;
            this.file = ioFile;
            this.updateTitle();
        }

        @Override
        @Nullable
        public IdeRootPaneNorthExtension getNorthExtension(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.owner.getNorthExtension(key);
        }

        @Nullable
        public BalloonLayout getBalloonLayout() {
            return null;
        }

        private final void updateTitle() {
            if (AdvancedSettings.Companion.getBoolean("ide.show.fileType.icon.in.titleBar")) {
                Path path2 = this.file;
                this.rootPane.putClientProperty("Window.documentFile", path2 != null ? path2.toFile() : null);
            }
            StringBuilder builder2 = new StringBuilder();
            ProjectFrameHelper.appendTitlePart(builder2, this.frameTitle);
            ProjectFrameHelper.appendTitlePart(builder2, this.fileTitle);
            this.setTitle(builder2.toString());
        }

        @Override
        public void dispose() {
            FrameWrapper owner = this.owner;
            if (owner.isDisposing) {
                return;
            }
            owner.isDisposing = true;
            Disposer.dispose((Disposable)owner);
            super.dispose();
            this.rootPane = null;
            this.setMenuBar(null);
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            return IdeFrame.KEY.is(dataId) ? this : (this.owner.isDisposing ? null : this.owner.getDataInner(dataId));
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            UISettings.Companion.setupAntialiasing(g);
            super.paint(g);
        }

        public MyJFrame(@NotNull FrameWrapper owner, @NotNull IdeFrame parent) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.owner = owner;
            this.parent = parent;
            FrameState.setFrameStateListener(this);
            this.setGlassPane(new IdeGlassPaneImpl(this.getRootPane(), true));
            if (!(!SystemInfo.isMac || SystemInfo.isMacSystemMenu && Boolean.getBoolean("mac.system.menu.singleton"))) {
                this.setJMenuBar(IdeMenuBar.createMenuBar().setFrame(this));
            }
            MouseGestureManager.getInstance().add(this);
            this.setFocusTraversalPolicy(new IdeFocusTraversalPolicy());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/ui/FrameWrapper$MyJDialog;", "Ljavax/swing/JDialog;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/wm/IdeFrame$Child;", "owner", "Lcom/intellij/openapi/ui/FrameWrapper;", "parent", "Lcom/intellij/openapi/wm/IdeFrame;", "(Lcom/intellij/openapi/ui/FrameWrapper;Lcom/intellij/openapi/wm/IdeFrame;)V", "dispose", "", "getBalloonLayout", "Lcom/intellij/ui/BalloonLayout;", "getComponent", "Ljavax/swing/JComponent;", "getData", "", "dataId", "", "getProject", "Lcom/intellij/openapi/project/Project;", "getStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "paint", "g", "Ljava/awt/Graphics;", "setFrameTitle", "title", "suggestChildFrameBounds", "Ljava/awt/Rectangle;", "intellij.platform.ide.impl"})
    private static final class MyJDialog
    extends JDialog
    implements DataProvider,
    IdeFrame.Child {
        private final FrameWrapper owner;
        private final IdeFrame parent;

        @NotNull
        public JComponent getComponent() {
            JRootPane jRootPane = this.getRootPane();
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane()");
            return jRootPane;
        }

        @Nullable
        public StatusBar getStatusBar() {
            return null;
        }

        @Nullable
        public BalloonLayout getBalloonLayout() {
            return null;
        }

        @NotNull
        public Rectangle suggestChildFrameBounds() {
            Rectangle rectangle = this.parent.suggestChildFrameBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"parent.suggestChildFrameBounds()");
            return rectangle;
        }

        @Nullable
        public Project getProject() {
            return this.parent.getProject();
        }

        public void setFrameTitle(@NotNull String title2) {
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            this.setTitle(title2);
        }

        @Override
        public void dispose() {
            if (this.owner.isDisposing) {
                return;
            }
            this.owner.isDisposing = true;
            Disposer.dispose((Disposable)this.owner);
            super.dispose();
            this.rootPane = null;
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            return IdeFrame.KEY.is(dataId) ? this : (this.owner.isDisposing ? null : this.owner.getDataInner(dataId));
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            UISettings.Companion.setupAntialiasing(g);
            super.paint(g);
        }

        public MyJDialog(@NotNull FrameWrapper owner, @NotNull IdeFrame parent) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(ComponentUtil.getWindow((Component)parent.getComponent()));
            this.owner = owner;
            this.parent = parent;
            this.setGlassPane(new IdeGlassPaneImpl(this.getRootPane()));
            this.getRootPane().putClientProperty("Window.style", "small");
            this.setBackground(UIUtil.getPanelBackground());
            MouseGestureManager.getInstance().add((IdeFrame)this);
            this.setFocusTraversalPolicy(new IdeFocusTraversalPolicy());
        }
    }
}

