/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.impl.AbstractDialog;
import com.intellij.openapi.ui.impl.HeadlessDialog;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameDialogContent;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.OwnerOptional;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogWrapperPeerImpl
extends DialogWrapperPeer {
    private static final Logger LOG = Logger.getInstance(DialogWrapper.class);
    private final DialogWrapper myWrapper;
    private final AbstractDialog myDialog;
    private final boolean myCanBeParent;
    private final List<Runnable> myDisposeActions;
    private Project myProject;

    public static boolean isHeadlessEnv() {
        Application app2 = ApplicationManager.getApplication();
        return app2 == null ? GraphicsEnvironment.isHeadless() : app2.isUnitTestMode() || app2.isHeadlessEnvironment();
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @Nullable Project project, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(0);
        }
        if (ideModalityType == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(1);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        WindowManagerEx windowManager = DialogWrapperPeerImpl.getWindowManager();
        Object window = null;
        if (windowManager != null) {
            Object focusedWindow;
            if (project == null) {
                project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            }
            this.myProject = project;
            window = windowManager.suggestParentWindow(project);
            if (window == null && (focusedWindow = windowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
                window = focusedWindow;
            }
            if (window == null) {
                for (ProjectFrameHelper frameHelper : windowManager.getProjectFrameHelpers()) {
                    IdeFrameImpl frame = frameHelper.getFrame();
                    if (frame == null || !frame.isActive()) continue;
                    window = frameHelper.getFrame();
                    break;
                }
            }
        }
        Object owner = window != null ? window : (!headless ? JOptionPane.getRootFrame() : null);
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, (Window)owner, wrapper2, this.myProject, ideModalityType);
        this.myCanBeParent = headless || canBeParent;
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @Nullable Project project, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(2);
        }
        this(wrapper2, project, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(3);
        }
        this(wrapper2, (Project)null, canBeParent);
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, @NotNull Component parent, boolean canBeParent) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(5);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, OwnerOptional.fromComponent(parent).get(), wrapper2, null, DialogWrapper.IdeModalityType.IDE);
        this.myCanBeParent = headless || canBeParent;
    }

    protected DialogWrapperPeerImpl(@NotNull DialogWrapper wrapper2, Window owner, boolean canBeParent, DialogWrapper.IdeModalityType ideModalityType) {
        if (wrapper2 == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(6);
        }
        this.myDisposeActions = new ArrayList<Runnable>();
        boolean headless = DialogWrapperPeerImpl.isHeadlessEnv();
        this.myWrapper = wrapper2;
        this.myDialog = DialogWrapperPeerImpl.createDialog(headless, owner, wrapper2, null, DialogWrapper.IdeModalityType.IDE);
        boolean bl = this.myCanBeParent = headless || canBeParent;
        if (!headless) {
            Dialog.ModalityType modalityType = DialogWrapper.IdeModalityType.IDE.toAwtModality();
            if (Registry.is((String)"ide.perProjectModality", (boolean)false)) {
                modalityType = ideModalityType.toAwtModality();
            }
            this.myDialog.setModalityType(modalityType);
        }
    }

    private static WindowManagerEx getWindowManager() {
        WindowManagerEx windowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            windowManager = WindowManagerEx.getInstanceEx();
        }
        return windowManager;
    }

    private static AbstractDialog createDialog(boolean headless, Window owner, DialogWrapper wrapper2, Project project, DialogWrapper.IdeModalityType ideModalityType) {
        if (headless) {
            return new HeadlessDialog(wrapper2);
        }
        ActionCallback focused = new ActionCallback("DialogFocusedCallback");
        MyDialog dialog2 = new MyDialog(OwnerOptional.fromComponent(owner).get(), wrapper2, project, focused);
        dialog2.setModalityType(ideModalityType.toAwtModality());
        return dialog2;
    }

    public boolean isHeadless() {
        return this.myDialog instanceof HeadlessDialog;
    }

    public Object[] getCurrentModalEntities() {
        return LaterInvocator.getCurrentModalEntities();
    }

    public void setUndecorated(boolean undecorated) {
        this.myDialog.setUndecorated(undecorated);
    }

    public void addMouseListener(MouseListener listener2) {
        this.myDialog.addMouseListener(listener2);
    }

    public void addMouseListener(MouseMotionListener listener2) {
        this.myDialog.addMouseMotionListener(listener2);
    }

    public void addKeyListener(KeyListener listener2) {
        this.myDialog.addKeyListener(listener2);
    }

    public void toFront() {
        this.myDialog.toFront();
    }

    public void toBack() {
        this.myDialog.toBack();
    }

    protected void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        for (Runnable runnable2 : this.myDisposeActions) {
            runnable2.run();
        }
        this.myDisposeActions.clear();
        Runnable disposer2 = () -> {
            Disposer.dispose((Disposable)this.myDialog);
            this.myProject = null;
            SwingUtilities.invokeLater(() -> {
                if (this.myDialog.getRootPane() != null) {
                    this.myDialog.remove(this.myDialog.getRootPane());
                }
            });
        };
        EdtInvocationManager.invokeLaterIfNeeded((Runnable)disposer2);
    }

    private boolean isProgressDialog() {
        return this.myWrapper.isModalProgress();
    }

    @Nullable
    public Container getContentPane() {
        return this.getRootPane() != null ? this.myDialog.getContentPane() : null;
    }

    public void validate() {
        this.myDialog.validate();
    }

    public void repaint() {
        this.myDialog.repaint();
    }

    public Window getOwner() {
        return this.myDialog.getOwner();
    }

    public Window getWindow() {
        return this.myDialog.getWindow();
    }

    public JRootPane getRootPane() {
        return this.myDialog.getRootPane();
    }

    public Dimension getSize() {
        return this.myDialog.getSize();
    }

    public String getTitle() {
        return this.myDialog.getTitle();
    }

    public void pack() {
        this.myDialog.pack();
    }

    public void setAppIcons() {
        AppUIUtil.updateWindowIcon(this.getWindow());
    }

    public Dimension getPreferredSize() {
        return this.myDialog.getPreferredSize();
    }

    public void setModal(boolean modal) {
        this.myDialog.setModal(modal);
    }

    public boolean isModal() {
        return this.myDialog.isModal();
    }

    public boolean isVisible() {
        return this.myDialog.isVisible();
    }

    public boolean isShowing() {
        return this.myDialog.isShowing();
    }

    public void setSize(int width, int height) {
        this.myDialog.setSize(width, height);
    }

    public void setTitle(String title2) {
        this.myDialog.setTitle(title2);
    }

    public boolean isResizable() {
        return this.myDialog.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myDialog.setResizable(resizable);
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myDialog.getLocation();
        if (point == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(7);
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            DialogWrapperPeerImpl.$$$reportNull$$$0(8);
        }
        this.myDialog.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myDialog.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionCallback show() {
        Disposable tb;
        WindowManagerEx windowManager;
        Container contentPane;
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        ActionCallback result2 = new ActionCallback();
        AnCancelAction anCancelAction = new AnCancelAction();
        JRootPane rootPane = this.getRootPane();
        UIUtil.decorateWindowHeader((JRootPane)rootPane);
        Window window = this.getWindow();
        if (window instanceof JDialog && !((JDialog)window).isUndecorated() && rootPane != null) {
            UIUtil.setCustomTitleBar((Window)window, (JRootPane)rootPane, runnable2 -> Disposer.register((Disposable)this.myWrapper.getDisposable(), () -> runnable2.run()));
        }
        if ((contentPane = this.getContentPane()) instanceof CustomFrameDialogContent) {
            ((CustomFrameDialogContent)contentPane).updateLayout();
        }
        anCancelAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, rootPane);
        this.myDisposeActions.add(() -> anCancelAction.unregisterCustomShortcutSet(rootPane));
        if (!this.myCanBeParent && (windowManager = DialogWrapperPeerImpl.getWindowManager()) != null) {
            windowManager.doNotSuggestAsParent(this.myDialog.getWindow());
        }
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean appStarted2 = commandProcessor != null;
        boolean changeModalityState = appStarted2 && this.myDialog.isModal() && !this.isProgressDialog();
        Project project = this.myProject;
        boolean perProjectModality = Registry.is((String)"ide.perProjectModality", (boolean)false);
        if (changeModalityState) {
            commandProcessor.enterModal();
            if (perProjectModality) {
                LaterInvocator.enterModal(project, this.myDialog.getWindow());
            } else {
                LaterInvocator.enterModal(this.myDialog);
            }
        }
        if (appStarted2) {
            this.hidePopupsIfNeeded();
        }
        this.myDialog.getWindow().setAutoRequestFocus(this.getOwner() != null && this.getOwner().isActive() || !ComponentUtil.isDisableAutoRequestFocus());
        if (SystemInfo.isMac && (tb = TouchbarSupport.showWindowActions(this.myDialog.getContentPane())) != null) {
            this.myDisposeActions.add(() -> Disposer.dispose((Disposable)tb));
        }
        try (AccessToken ignore = SlowOperations.allowSlowOperations((String)"  reset  ");){
            this.myDialog.show();
        }
        finally {
            if (changeModalityState) {
                commandProcessor.leaveModal();
                if (perProjectModality) {
                    LaterInvocator.leaveModal(project, this.myDialog.getWindow());
                } else {
                    LaterInvocator.leaveModal(this.myDialog);
                }
            }
            this.myDialog.getFocusManager().doWhenFocusSettlesDown(result2.createSetDoneRunnable());
        }
        return result2;
    }

    private void hidePopupsIfNeeded() {
        if (!SystemInfo.isMac) {
            return;
        }
        StackingPopupDispatcher.getInstance().hidePersistentPopups();
        this.myDisposeActions.add(() -> StackingPopupDispatcher.getInstance().restorePersistentPopups());
    }

    private static void setupSelectionOnPreferredComponent(JComponent component2) {
        if (component2 instanceof JTextField) {
            JTextField field = (JTextField)component2;
            String text2 = field.getText();
            if (text2 != null && field.getClientProperty(HAVE_INITIAL_SELECTION) == null) {
                field.setSelectionStart(0);
                field.setSelectionEnd(text2.length());
            }
        } else if (component2 instanceof JComboBox) {
            JComboBox combobox = (JComboBox)component2;
            combobox.getEditor().selectAll();
        }
    }

    public void setContentPane(JComponent content2) {
        JComponent wrappedContent = IdeFrameDecorator.isCustomDecorationActive() && !DialogWrapperPeerImpl.isHeadlessEnv() ? CustomFrameDialogContent.getCustomContentHolder(this.getWindow(), content2) : content2;
        this.myDialog.setContentPane(wrappedContent);
    }

    public void centerInParent() {
        this.myDialog.centerInParent();
    }

    public void setAutoRequestFocus(boolean b) {
        UIUtil.setAutoRequestFocus((Window)((JDialog)((Object)this.myDialog)), (boolean)b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyDialog
    extends JDialog
    implements DialogWrapperDialog,
    DataProvider,
    Queryable,
    AbstractDialog {
        private final WeakReference<DialogWrapper> myDialogWrapper;
        private Dimension myInitialSize;
        private String myDimensionServiceKey;
        private boolean myOpened;
        private boolean myActivated;
        private MyWindowListener myWindowListener;
        private final WeakReference<Project> myProject;
        private final ActionCallback myFocusedCallback;

        MyDialog(Window owner, DialogWrapper dialogWrapper2, Project project, @NotNull ActionCallback focused) {
            if (focused == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            super(owner);
            this.myOpened = false;
            this.myActivated = false;
            UIUtil.markAsTypeAheadAware((Window)this);
            this.myDialogWrapper = new WeakReference<DialogWrapper>(dialogWrapper2);
            this.myProject = project != null ? new WeakReference<Project>(project) : null;
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                public boolean accept(Component aComponent) {
                    if (UIUtil.isFocusProxy((Component)aComponent)) {
                        return false;
                    }
                    return super.accept(aComponent);
                }
            });
            this.myFocusedCallback = focused;
            this.setDefaultCloseOperation(0);
            this.myWindowListener = new MyWindowListener();
            this.addWindowListener(this.myWindowListener);
            UIUtil.setAutoRequestFocus((Window)this, (owner != null && owner.isActive() || !ComponentUtil.isDisableAutoRequestFocus() ? 1 : 0) != 0);
        }

        @Override
        public JDialog getWindow() {
            return this;
        }

        public void putInfo(@NotNull Map<? super String, ? super String> info2) {
            if (info2 == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            info2.put("dialog", this.getTitle());
        }

        public DialogWrapper getDialogWrapper() {
            return (DialogWrapper)this.myDialogWrapper.get();
        }

        @Override
        public void centerInParent() {
            this.setLocationRelativeTo(this.getOwner());
        }

        @Override
        public Object getData(@NotNull String dataId) {
            DialogWrapper wrapper2;
            if (dataId == null) {
                MyDialog.$$$reportNull$$$0(2);
            }
            if ((wrapper2 = (DialogWrapper)this.myDialogWrapper.get()) instanceof DataProvider) {
                return ((DataProvider)wrapper2).getData(dataId);
            }
            if (wrapper2 instanceof TypeSafeDataProvider) {
                TypeSafeDataProviderAdapter adapter = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)wrapper2);
                return adapter.getData(dataId);
            }
            return null;
        }

        private void fitToScreen(Rectangle rect) {
            if (this.myDialogWrapper == null) {
                return;
            }
            DialogWrapper wrapper2 = (DialogWrapper)this.myDialogWrapper.get();
            if (wrapper2 != null) {
                wrapper2.fitToScreen(rect);
            }
        }

        @Override
        public void setSize(int width, int height) {
            this._setSizeForLocation(width, height, null);
        }

        private void _setSizeForLocation(int width, int height, @Nullable Point initial) {
            Point location = initial != null ? initial : this.getLocation();
            Rectangle rect = new Rectangle(location.x, location.y, width, height);
            this.fitToScreen(rect);
            if (initial != null || location.x != rect.x || location.y != rect.y) {
                this.setLocation(rect.x, rect.y);
            }
            super.setSize(rect.width, rect.height);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            Rectangle rect = new Rectangle(x, y, width, height);
            this.fitToScreen(rect);
            super.setBounds(rect.x, rect.y, rect.width, rect.height);
        }

        @Override
        public void setBounds(Rectangle r) {
            this.fitToScreen(r);
            super.setBounds(r);
        }

        @Override
        @NotNull
        protected JRootPane createRootPane() {
            return new DialogRootPane();
        }

        @Override
        public void addNotify() {
            if (IdeFrameDecorator.isCustomDecorationActive()) {
                JdkEx.setHasCustomDecoration(this);
            }
            super.addNotify();
        }

        @Override
        public void show() {
            DialogWrapper dialogWrapper2 = this.getDialogWrapper();
            boolean isAutoAdjustable = dialogWrapper2.isAutoAdjustable();
            Point location = null;
            if (isAutoAdjustable) {
                this.pack();
                Dimension initial = dialogWrapper2.getInitialSize();
                if (initial == null) {
                    initial = new Dimension();
                }
                if (initial.width <= 0 || initial.height <= 0) {
                    MyDialog.maximize(initial, this.getSize());
                    if (!SystemInfo.isLinux && Registry.is((String)"ide.dialog.wrapper.resize.by.tables")) {
                        MyDialog.maximize(initial, MyDialog.getSizeForTableContainer(this.getContentPane()));
                    }
                }
                MyDialog.maximize(initial, this.getMinimumSize());
                initial.width = (int)((float)initial.width * dialogWrapper2.getHorizontalStretch());
                initial.height = (int)((float)initial.height * dialogWrapper2.getVerticalStretch());
                this.setSize(initial);
                this.myDimensionServiceKey = dialogWrapper2.getDimensionKey();
                if (this.myDimensionServiceKey != null) {
                    Project projectGuess = this.guessProjectDependingOnKey(this.myDimensionServiceKey);
                    location = MyDialog.getWindowStateService(projectGuess).getLocation(this.myDimensionServiceKey);
                    Dimension size = MyDialog.getWindowStateService(projectGuess).getSize(this.myDimensionServiceKey);
                    if (size != null) {
                        this.myInitialSize = new Dimension(size);
                        this._setSizeForLocation(this.myInitialSize.width, this.myInitialSize.height, location);
                    }
                }
                if (this.myInitialSize == null) {
                    Dimension initialSize = dialogWrapper2.getInitialSize();
                    Dimension dimension = this.myInitialSize = initialSize != null ? initialSize : this.getSize();
                }
            }
            if (location == null) {
                location = dialogWrapper2.getInitialLocation();
            }
            if (location != null) {
                this.setLocation(location);
            } else {
                this.setLocationRelativeTo(this.getOwner());
            }
            if (isAutoAdjustable) {
                Rectangle bounds2 = this.getBounds();
                this.fitToScreen(bounds2);
                this.setBounds(bounds2);
            }
            if (SystemInfo.isMac && this.myProject != null && Registry.is((String)"ide.mac.fix.dialog.showing", (boolean)false) && !dialogWrapper2.isModalProgress()) {
                IdeFrame frame = WindowManager.getInstance().getIdeFrame((Project)this.myProject.get());
                AppIcon.getInstance().requestFocus(frame);
            }
            this.setBackground(UIUtil.getPanelBackground());
            super.show();
        }

        @Nullable
        private Project guessProjectDependingOnKey(String key) {
            return !key.startsWith("APPLICATION_WIDE_STORE_") ? (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this)) : null;
        }

        private static void maximize(@NotNull Dimension size, @Nullable Dimension alternativeSize) {
            if (size == null) {
                MyDialog.$$$reportNull$$$0(3);
            }
            if (alternativeSize != null) {
                size.width = Math.max(size.width, alternativeSize.width);
                size.height = Math.max(size.height, alternativeSize.height);
            }
        }

        @Nullable
        private static Dimension getSizeForTableContainer(@Nullable Component component2) {
            if (component2 == null) {
                return null;
            }
            JBIterable tables = UIUtil.uiTraverser((Component)component2).filter(JTable.class);
            if (!tables.isNotEmpty()) {
                return null;
            }
            Dimension size = component2.getPreferredSize();
            for (JTable table : tables) {
                Dimension tableSize = table.getPreferredSize();
                size.width = Math.max(size.width, tableSize.width);
                size.height = Math.max(size.height, tableSize.height + size.height - table.getParent().getHeight());
            }
            size.width = Math.min(1000, Math.max(600, size.width));
            size.height = Math.min(800, size.height);
            return size;
        }

        @Nullable
        private Project getProject() {
            return (Project)SoftReference.dereference(this.myProject);
        }

        @Override
        @NotNull
        public IdeFocusManager getFocusManager() {
            Project project = this.getProject();
            if (project != null && !project.isDisposed()) {
                IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)project);
                if (ideFocusManager == null) {
                    MyDialog.$$$reportNull$$$0(4);
                }
                return ideFocusManager;
            }
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstance();
            if (ideFocusManager == null) {
                MyDialog.$$$reportNull$$$0(5);
            }
            return ideFocusManager;
        }

        @Override
        public void hide() {
            super.hide();
        }

        @Override
        public void dispose() {
            BufferStrategy strategy;
            DialogWrapper wrapper2;
            if (this.isShowing()) {
                this.hide();
            }
            if (this.myWindowListener != null) {
                this.myWindowListener.saveSize();
                this.removeWindowListener(this.myWindowListener);
                this.myWindowListener = null;
            }
            if ((wrapper2 = this.getDialogWrapper()) != null) {
                wrapper2.disposeIfNeeded();
            }
            if ((strategy = this.getBufferStrategy()) != null) {
                strategy.dispose();
            }
            super.dispose();
            this.removeAll();
            DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
            DialogWrapper.cleanupWindowListeners((Window)this);
            this.rootPane = null;
        }

        @Override
        public Component getMostRecentFocusOwner() {
            JComponent toFocus;
            DialogWrapper wrapper2;
            if (!this.myOpened && (wrapper2 = this.getDialogWrapper()) != null && (toFocus = wrapper2.getPreferredFocusedComponent()) != null) {
                return toFocus;
            }
            return super.getMostRecentFocusOwner();
        }

        @Override
        public void paint(Graphics g) {
            if (!SystemInfo.isMac) {
                UISettings.setupAntialiasing((Graphics)g);
            }
            super.paint(g);
        }

        @NotNull
        private static WindowStateService getWindowStateService(@Nullable Project project) {
            WindowStateService windowStateService = project == null ? WindowStateService.getInstance() : WindowStateService.getInstance((Project)project);
            if (windowStateService == null) {
                MyDialog.$$$reportNull$$$0(6);
            }
            return windowStateService;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focused";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFocusManager";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindowStateService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "putInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "maximize";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private final class DialogRootPane
        extends JRootPane
        implements DataProvider {
            private final boolean myGlassPaneIsSet;
            private Dimension myLastMinimumSize;

            private DialogRootPane() {
                this.setGlassPane(new IdeGlassPaneImpl(this));
                this.myGlassPaneIsSet = true;
                this.putClientProperty("DIALOG_ROOT_PANE", true);
                this.setBorder(UIManager.getBorder("Window.border"));
            }

            @Override
            @NotNull
            protected JLayeredPane createLayeredPane() {
                JBLayeredPane p = new JBLayeredPane();
                p.setName(this.getName() + ".layeredPane");
                JBLayeredPane jBLayeredPane = p;
                if (jBLayeredPane == null) {
                    DialogRootPane.$$$reportNull$$$0(0);
                }
                return jBLayeredPane;
            }

            @Override
            public void validate() {
                Dimension size;
                Window window;
                super.validate();
                DialogWrapper wrapper2 = (DialogWrapper)MyDialog.this.myDialogWrapper.get();
                if (wrapper2 != null && wrapper2.isAutoAdjustable() && (window = wrapper2.getWindow()) != null && !((size = this.getMinimumSize()) != null ? size.equals(this.myLastMinimumSize) : this.myLastMinimumSize == null)) {
                    if (size == null) {
                        this.myLastMinimumSize = null;
                    } else {
                        this.myLastMinimumSize = new Dimension(size);
                        JBInsets.addTo((Dimension)size, (Insets)window.getInsets());
                        Rectangle screen = ScreenUtil.getScreenRectangle((Component)window);
                        if (size.width > screen.width || size.height > screen.height) {
                            Application application = ApplicationManager.getApplication();
                            if (application != null && application.isInternal()) {
                                StringBuilder sb = new StringBuilder("dialog minimum size is bigger than screen: ");
                                sb.append(size.width).append("x").append(size.height);
                                IJSwingUtilities.appendComponentClassNames(sb, this);
                                LOG.warn(sb.toString());
                            }
                            if (size.width > screen.width) {
                                size.width = screen.width;
                            }
                            if (size.height > screen.height) {
                                size.height = screen.height;
                            }
                        }
                    }
                    window.setMinimumSize(size);
                }
            }

            @Override
            public void setGlassPane(Component glass) {
                if (this.myGlassPaneIsSet) {
                    LOG.warn("Setting of glass pane for DialogWrapper is prohibited", (Throwable)new Exception());
                    return;
                }
                super.setGlassPane(glass);
            }

            @Override
            public void setContentPane(Container contentPane) {
                super.setContentPane(contentPane);
                if (contentPane != null) {
                    contentPane.addMouseMotionListener(new MouseMotionAdapter(){});
                }
            }

            @Override
            public Object getData(@NotNull @NonNls String dataId) {
                DialogWrapper wrapper2;
                if (dataId == null) {
                    DialogRootPane.$$$reportNull$$$0(1);
                }
                return (wrapper2 = (DialogWrapper)MyDialog.this.myDialogWrapper.get()) != null && PlatformDataKeys.UI_DISPOSABLE.is(dataId) ? wrapper2.getDisposable() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog$DialogRootPane";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createLayeredPane";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$MyDialog$DialogRootPane";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyWindowListener
        extends WindowAdapter {
            private MyWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DialogWrapper dialogWrapper2 = MyDialog.this.getDialogWrapper();
                if (dialogWrapper2.shouldCloseOnCross()) {
                    dialogWrapper2.doCancelAction((AWTEvent)e);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.saveSize();
            }

            public void saveSize() {
                if (MyDialog.this.myDimensionServiceKey != null && MyDialog.this.myInitialSize != null && MyDialog.this.myOpened) {
                    Project projectGuess = MyDialog.this.guessProjectDependingOnKey(MyDialog.this.myDimensionServiceKey);
                    Point location = MyDialog.this.getLocation();
                    MyDialog.getWindowStateService(projectGuess).putLocation(MyDialog.this.myDimensionServiceKey, location);
                    Dimension size = MyDialog.this.getSize();
                    if (!MyDialog.this.myInitialSize.equals(size)) {
                        MyDialog.getWindowStateService(projectGuess).putSize(MyDialog.this.myDimensionServiceKey, size);
                    }
                    MyDialog.this.myOpened = false;
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(() -> {
                    JComponent toFocus;
                    DialogWrapper wrapper2;
                    MyDialog.this.myOpened = true;
                    DialogWrapper activeWrapper = this.getActiveWrapper();
                    UIUtil.uiTraverser((Component)e.getWindow()).filter(JComponent.class).consumeEach(c -> {
                        GraphicsUtil.setAntialiasingType((JComponent)c, (Object)AntialiasingType.getAAHintForSwingComponent());
                        c.invalidate();
                    });
                    JRootPane rootPane = ((JDialog)e.getComponent()).getRootPane();
                    if (rootPane != null) {
                        rootPane.revalidate();
                    }
                    e.getComponent().repaint();
                    if (activeWrapper == null) {
                        MyDialog.this.myFocusedCallback.setRejected();
                    }
                    if ((wrapper2 = this.getActiveWrapper()) == null && !MyDialog.this.myFocusedCallback.isProcessed()) {
                        MyDialog.this.myFocusedCallback.setRejected();
                        return;
                    }
                    if (MyDialog.this.myActivated) {
                        return;
                    }
                    MyDialog.this.myActivated = true;
                    JComponent jComponent = toFocus = wrapper2 == null ? null : wrapper2.getPreferredFocusedComponent();
                    if (MyDialog.this.getRootPane() != null && toFocus == null) {
                        toFocus = MyDialog.this.getRootPane().getDefaultButton();
                    }
                    if (MyDialog.this.getRootPane() != null) {
                        IJSwingUtilities.moveMousePointerOn(MyDialog.this.getRootPane().getDefaultButton());
                    }
                    DialogWrapperPeerImpl.setupSelectionOnPreferredComponent(toFocus);
                    if (toFocus != null) {
                        if (MyDialog.this.isShowing() && (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isActive())) {
                            toFocus.requestFocus();
                        } else {
                            toFocus.requestFocusInWindow();
                        }
                        this.notifyFocused(wrapper2);
                    } else if (MyDialog.this.isShowing()) {
                        this.notifyFocused(wrapper2);
                    }
                });
            }

            private void notifyFocused(DialogWrapper wrapper2) {
                MyDialog.this.myFocusedCallback.setDone();
            }

            private DialogWrapper getActiveWrapper() {
                DialogWrapper activeWrapper = MyDialog.this.getDialogWrapper();
                if (activeWrapper == null || !activeWrapper.isShowing()) {
                    return null;
                }
                return activeWrapper;
            }
        }
    }

    private final class AnCancelAction
    extends AnAction
    implements DumbAware {
        private AnCancelAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AnCancelAction.$$$reportNull$$$0(0);
            }
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            e.getPresentation().setEnabled(false);
            if (focusOwner instanceof JComponent && SpeedSearchBase.hasActiveSpeedSearch((JComponent)focusOwner)) {
                return;
            }
            if (StackingPopupDispatcher.getInstance().isPopupFocused()) {
                return;
            }
            JTree tree = (JTree)ComponentUtil.getParentOfType(JTree.class, (Component)focusOwner);
            JTable table = (JTable)ComponentUtil.getParentOfType(JTable.class, (Component)focusOwner);
            if ((tree != null || table != null) && this.hasNoEditingTreesOrTablesUpward(focusOwner)) {
                e.getPresentation().setEnabled(true);
            }
        }

        private boolean hasNoEditingTreesOrTablesUpward(Component comp) {
            while (comp != null) {
                if (this.isEditingTreeOrTable(comp)) {
                    return false;
                }
                comp = comp.getParent();
            }
            return true;
        }

        private boolean isEditingTreeOrTable(Component comp) {
            if (comp instanceof JTree) {
                return ((JTree)comp).isEditing();
            }
            if (comp instanceof JTable) {
                return ((JTable)comp).isEditing();
            }
            return false;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AnCancelAction.$$$reportNull$$$0(1);
            }
            DialogWrapperPeerImpl.this.myWrapper.doCancelAction((AWTEvent)e.getInputEvent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/ui/impl/DialogWrapperPeerImpl$AnCancelAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

