/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.org.PluginManagerFilters;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiserDialog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InstallAndEnableTask
extends Task.Modal {
    private final Set<PluginDownloader> myPlugins;
    @NotNull
    private final Set<PluginId> myPluginIds;
    private final boolean myShowDialog;
    private final boolean mySelectAllInDialog;
    @NotNull
    private final Runnable myOnSuccess;
    @Nullable
    private List<PluginNode> myCustomPlugins;

    InstallAndEnableTask(@Nullable Project project, @NotNull Set<PluginId> pluginIds2, boolean showDialog, boolean selectAllInDialog, @NotNull Runnable onSuccess2) {
        if (pluginIds2 == null) {
            InstallAndEnableTask.$$$reportNull$$$0(0);
        }
        if (onSuccess2 == null) {
            InstallAndEnableTask.$$$reportNull$$$0(1);
        }
        super(project, IdeBundle.message((String)"plugins.advertiser.task.searching.for.plugins", (Object[])new Object[0]), true);
        this.myPlugins = new HashSet<PluginDownloader>();
        this.myPluginIds = pluginIds2;
        this.myShowDialog = showDialog;
        this.mySelectAllInDialog = selectAllInDialog;
        this.myOnSuccess = onSuccess2;
    }

    public void run(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            InstallAndEnableTask.$$$reportNull$$$0(2);
        }
        try {
            List<PluginNode> marketplacePlugins = MarketplaceRequests.loadLastCompatiblePluginDescriptors(this.myPluginIds);
            this.myCustomPlugins = PluginsAdvertiser.loadPluginsFromCustomRepositories(indicator2);
            ArrayList<PluginNode> descriptors = new ArrayList<PluginNode>(RepositoryHelper.mergePluginsFromRepositories(marketplacePlugins, this.myCustomPlugins, true));
            PluginManagerFilters org = PluginManagerFilters.getInstance();
            for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                if (descriptor2.isEnabled() || !PluginManagerCore.isCompatible(descriptor2) || !org.allowInstallingPlugin(descriptor2)) continue;
                descriptors.add((PluginNode)descriptor2);
            }
            for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
                if (!this.myPluginIds.contains(ideaPluginDescriptor.getPluginId())) continue;
                this.myPlugins.add(PluginDownloader.createDownloader(ideaPluginDescriptor));
            }
        }
        catch (Exception e) {
            PluginsAdvertiser.getLog().info((Throwable)e);
        }
    }

    public void onSuccess() {
        if (this.myCustomPlugins == null) {
            return;
        }
        new PluginsAdvertiserDialog(this.myProject, this.myPlugins, this.myCustomPlugins, this.mySelectAllInDialog, this::runOnSuccess).doInstallPlugins(this.myShowDialog);
    }

    private void runOnSuccess(boolean onSuccess2) {
        if (onSuccess2) {
            this.myOnSuccess.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/InstallAndEnableTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

