/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyBean;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Property(style=Property.Style.ATTRIBUTE)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/util/registry/RegistryKeyBean;", "", "()V", "defaultValue", "", "description", "key", "restartRequired", "", "Companion", "intellij.platform.ide.impl"})
public final class RegistryKeyBean {
    @RequiredElement
    @Attribute(value="key")
    @JvmField
    @NotNull
    public String key = "";
    @RequiredElement
    @Attribute(value="description")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @JvmField
    @NotNull
    public String description = "";
    @RequiredElement(allowEmpty=true)
    @Attribute(value="defaultValue")
    @JvmField
    @NotNull
    public String defaultValue = "";
    @Attribute(value="restartRequired")
    @JvmField
    public boolean restartRequired;
    @NonNls
    private static final Regex CONSECUTIVE_SPACES_REGEX;
    private static final HashSet<String> pendingRemovalKeys;
    @NotNull
    public static final Companion Companion;

    private RegistryKeyBean() {
    }

    static {
        Companion = new Companion(null);
        String string = "\\s{2,}";
        boolean bl = false;
        CONSECUTIVE_SPACES_REGEX = new Regex(string);
        pendingRemovalKeys = new HashSet();
    }

    public static final /* synthetic */ HashSet access$getPendingRemovalKeys$cp() {
        return pendingRemovalKeys;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/util/registry/RegistryKeyBean$Companion;", "", "()V", "CONSECUTIVE_SPACES_REGEX", "Lkotlin/text/Regex;", "pendingRemovalKeys", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "addKeysFromPlugins", "", "createRegistryKeyDescriptor", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "extension", "Lcom/intellij/openapi/util/registry/RegistryKeyBean;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @ApiStatus.Internal
        public final void addKeysFromPlugins() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ExtensionsArea extensionsArea = application.getExtensionArea();
            if (extensionsArea == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.extensions.impl.ExtensionsAreaImpl");
            }
            ExtensionPointImpl extensionPointImpl = ((ExtensionsAreaImpl)extensionsArea).getExtensionPoint("com.intellij.registryKey");
            Intrinsics.checkNotNullExpressionValue((Object)extensionPointImpl, (String)"(ApplicationManager.getA\u2026om.intellij.registryKey\")");
            ExtensionPointImpl point = extensionPointImpl;
            HashMap contributedKeys = new HashMap(point.size());
            point.processWithPluginDescriptor(false, new BiConsumer(contributedKeys){
                final /* synthetic */ HashMap $contributedKeys;

                public final void accept(RegistryKeyBean bean, PluginDescriptor pluginDescriptor) {
                    RegistryKeyBean registryKeyBean = bean;
                    Intrinsics.checkNotNullExpressionValue((Object)registryKeyBean, (String)"bean");
                    PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                    Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor2, (String)"pluginDescriptor");
                    RegistryKeyDescriptor descriptor2 = com.intellij.openapi.util.registry.RegistryKeyBean$Companion.access$createRegistryKeyDescriptor(RegistryKeyBean.Companion, registryKeyBean, pluginDescriptor2);
                    this.$contributedKeys.put(descriptor2.getName(), descriptor2);
                }
                {
                    this.$contributedKeys = hashMap;
                }
            });
            Registry.setKeys(Map.copyOf(contributedKeys));
            point.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RegistryKeyBean>(){

                public void extensionAdded(@NotNull RegistryKeyBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    RegistryKeyDescriptor descriptor2 = com.intellij.openapi.util.registry.RegistryKeyBean$Companion.access$createRegistryKeyDescriptor(RegistryKeyBean.Companion, extension2, pluginDescriptor);
                    Registry.mutateContributedKeys((Function)new Function(descriptor2){
                        final /* synthetic */ RegistryKeyDescriptor $descriptor;

                        public final Map<String, RegistryKeyDescriptor> apply(Map<String, RegistryKeyDescriptor> oldMap) {
                            HashMap<String, RegistryKeyDescriptor> newMap = new HashMap<String, RegistryKeyDescriptor>(oldMap.size() + 1);
                            newMap.putAll(oldMap);
                            newMap.put(this.$descriptor.getName(), this.$descriptor);
                            return Map.copyOf((Map)newMap);
                        }
                        {
                            this.$descriptor = registryKeyDescriptor;
                        }
                    });
                }
            }, false, null);
            point.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RegistryKeyBean>(){

                public void extensionRemoved(@NotNull RegistryKeyBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    RegistryKeyBean.access$getPendingRemovalKeys$cp().add(extension2.key);
                }
            }, false, null);
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
            application2.getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

                public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    Registry.mutateContributedKeys((Function)addKeysFromPlugins.pluginUnloaded.1.INSTANCE);
                    RegistryKeyBean.access$getPendingRemovalKeys$cp().clear();
                }
            });
        }

        private final RegistryKeyDescriptor createRegistryKeyDescriptor(RegistryKeyBean extension2, PluginDescriptor pluginDescriptor) {
            PluginId pluginId = pluginDescriptor.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginDescriptor.pluginId");
            String string = pluginId.getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginDescriptor.pluginId.idString");
            String pluginId2 = string;
            CharSequence charSequence = extension2.description;
            Regex regex = CONSECUTIVE_SPACES_REGEX;
            String string2 = " ";
            boolean bl = false;
            return new RegistryKeyDescriptor(extension2.key, StringUtil.unescapeStringCharacters((String)regex.replace(charSequence, string2)), extension2.defaultValue, extension2.restartRequired, pluginId2);
        }

        private Companion() {
        }

        public static final /* synthetic */ RegistryKeyDescriptor access$createRegistryKeyDescriptor(Companion $this, RegistryKeyBean extension2, PluginDescriptor pluginDescriptor) {
            return $this.createRegistryKeyDescriptor(extension2, pluginDescriptor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

