/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.application.options.RegistryManager;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyBean;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@State(name="Registry", storages={@Storage(value="ide.general.xml")}, useLoadedStateAsExisting=false, category=SettingsCategory.SYSTEM)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\r\u0010\f\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u001c\u0010\u0015\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/util/registry/RegistryManagerImpl;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/application/options/RegistryManager;", "()V", "get", "Lcom/intellij/openapi/util/registry/RegistryValue;", "Lorg/jetbrains/annotations/NotNull;", "key", "", "getAll", "", "getState", "intValue", "", "defaultValue", "is", "", "loadState", "", "state", "log", "userProperties", "", "noStateLoaded", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class RegistryManagerImpl
implements PersistentStateComponent<Element>,
RegistryManager {
    public boolean is(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Registry._getWithoutStateCheck((String)key).asBoolean();
    }

    public int intValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Registry._getWithoutStateCheck((String)key).asInteger();
    }

    public int intValue(@NotNull String key, int defaultValue) {
        int n;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            n = Registry._getWithoutStateCheck((String)key).asInteger();
        }
        catch (MissingResourceException ignore) {
            n = defaultValue;
        }
        return n;
    }

    @NotNull
    public RegistryValue get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        RegistryValue registryValue = Registry._getWithoutStateCheck((String)key);
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry._getWithoutStateCheck(key)");
        return registryValue;
    }

    @NotNull
    public Element getState() {
        Registry registry = Registry.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"Registry.getInstance()");
        Element element2 = registry.getState();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"Registry.getInstance().state");
        return element2;
    }

    public void noStateLoaded() {
        Registry.markAsLoaded();
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map map2 = Registry.loadState((Element)state);
        if (map2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"Registry.loadState(state) ?: return");
        this.log(map2);
    }

    private final void log(Map<String, String> userProperties) {
        if (userProperties.size() <= (userProperties.containsKey("ide.firstStartup") ? 1 : 0)) {
            return;
        }
        Object[] objectArray = ArrayUtilRt.toStringArray((Collection)userProperties.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ArrayUtilRt.toStringArray(userProperties.keys)");
        Object[] keys2 = objectArray;
        Arrays.sort(keys2);
        StringBuilder builder2 = new StringBuilder("Registry values changed by user: ");
        for (Object key : keys2) {
            if (Intrinsics.areEqual((Object)"ide.firstStartup", (Object)key)) continue;
            builder2.append((String)key).append(" = ").append(userProperties.get(key)).append(", ");
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RegistryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        logger.info(builder2.substring(0, builder2.length() - 2));
    }

    @NotNull
    public final List<RegistryValue> getAll() {
        List list2 = Registry.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"Registry.getAll()");
        return list2;
    }

    public RegistryManagerImpl() {
        String name$iv = "registry keys adding";
        ActivityCategory category$iv = ActivityCategory.DEFAULT;
        boolean $i$f$runActivity = false;
        Activity activity = StartUpMeasurer.startActivity((String)name$iv, (ActivityCategory)category$iv);
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startActivity(name, category)");
        Activity activity$iv = activity;
        boolean bl = false;
        RegistryKeyBean.Companion.addKeysFromPlugins();
        Unit result$iv = Unit.INSTANCE;
        activity$iv.end();
    }
}

