/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShowChangeMarkerAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Data data2;
        if (e == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(0);
        }
        boolean isEnabled = (data2 = ShowChangeMarkerAction.getDataFromContext(e)) != null && data2.tracker.isValid() && data2.tracker.isAvailableAt(data2.editor) && this.getTargetRange(data2.tracker, data2.editor) != null;
        e.getPresentation().setEnabled(isEnabled);
        e.getPresentation().setVisible(data2 != null || e.isFromActionToolbar());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Data data2;
        if (e == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(1);
        }
        if ((data2 = ShowChangeMarkerAction.getDataFromContext(e)) == null) {
            return;
        }
        Range targetRange = this.getTargetRange(data2.tracker, data2.editor);
        if (targetRange == null) {
            return;
        }
        this.moveToRange(data2.tracker, data2.editor, targetRange);
    }

    @Nullable
    private static Data getDataFromContext(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return null;
        }
        LineStatusTracker<?> tracker2 = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor2.getDocument());
        if (tracker2 == null) {
            return null;
        }
        return new Data(tracker2, editor2);
    }

    protected void moveToRange(@NotNull LineStatusTracker<?> tracker2, @NotNull Editor editor2, @NotNull Range range2) {
        if (tracker2 == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(4);
        }
        if (range2 == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(5);
        }
        tracker2.scrollAndShowHint(range2, editor2);
    }

    @Nullable
    private Range getTargetRange(@NotNull LineStatusTracker<?> tracker2, @NotNull Editor editor2) {
        if (tracker2 == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            ShowChangeMarkerAction.$$$reportNull$$$0(7);
        }
        int line = editor2.getCaretModel().getLogicalPosition().line;
        return this.getTargetRange(tracker2, line);
    }

    @Nullable
    protected abstract Range getTargetRange(@NotNull LineStatusTracker<?> var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "moveToRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Data {
        @NotNull
        private final LineStatusTracker<?> tracker;
        @NotNull
        private final Editor editor;

        Data(@NotNull LineStatusTracker<?> tracker2, @NotNull Editor editor2) {
            if (tracker2 == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.tracker = tracker2;
            this.editor = editor2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tracker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Data";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Current
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker2, int line) {
            if (tracker2 == null) {
                Current.$$$reportNull$$$0(0);
            }
            return tracker2.getRangeForLine(line);
        }

        @Override
        protected void moveToRange(@NotNull LineStatusTracker<?> tracker2, @NotNull Editor editor2, @NotNull Range range2) {
            if (tracker2 == null) {
                Current.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                Current.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                Current.$$$reportNull$$$0(3);
            }
            tracker2.showHint(range2, editor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Current";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTargetRange";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveToRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Prev
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker2, int line) {
            if (tracker2 == null) {
                Prev.$$$reportNull$$$0(0);
            }
            return tracker2.getPrevRange(line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Prev", "getTargetRange"));
        }
    }

    public static class Next
    extends ShowChangeMarkerAction {
        @Override
        protected Range getTargetRange(@NotNull LineStatusTracker<?> tracker2, int line) {
            if (tracker2 == null) {
                Next.$$$reportNull$$$0(0);
            }
            return tracker2.getNextRange(line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/actions/ShowChangeMarkerAction$Next", "getTargetRange"));
        }
    }
}

