/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.StandardVcsGroup;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGroupsWrapper
extends ActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(VcsGroupsWrapper.class);

    public void update(@NotNull AnActionEvent e) {
        DefaultActionGroup vcsGroup;
        if (e == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(0);
        }
        if ((vcsGroup = VcsGroupsWrapper.mergeVcsGroups(e)) == null) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().copyFrom(vcsGroup.getTemplatePresentation());
            vcsGroup.update(e);
        }
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                VcsGroupsWrapper.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        DefaultActionGroup vcsGroup = VcsGroupsWrapper.mergeVcsGroups(e);
        if (vcsGroup == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                VcsGroupsWrapper.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] anActionArray = vcsGroup.getChildren(e);
        if (anActionArray == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    @NotNull
    private static Set<String> collectVcses(@NotNull Project project, @NotNull DataContext dataContext) {
        if (project == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(5);
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        Set set2 = VcsContextUtil.selectedFilePathsIterable(dataContext).filterMap(arg_0 -> ((ProjectLevelVcsManager)vcsManager2).getVcsFor(arg_0)).map(AbstractVcs::getName).unique().take(vcsManager2.getAllActiveVcss().length).toSet();
        if (set2 == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @Nullable
    private static DefaultActionGroup mergeVcsGroups(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(7);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        Set<String> currentVcses = VcsGroupsWrapper.collectVcses(project, e.getDataContext());
        if (currentVcses.isEmpty()) {
            return null;
        }
        ArrayList<StandardVcsGroup> groups2 = new ArrayList<StandardVcsGroup>();
        DefaultActionGroup vcsGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("VcsGroup");
        for (AnAction child2 : vcsGroup.getChildren(e)) {
            StandardVcsGroup standardGroup = (StandardVcsGroup)ObjectUtils.tryCast((Object)child2, StandardVcsGroup.class);
            if (standardGroup == null) {
                LOG.error(MessageFormat.format("Any version control group should extend {0}. Violated by {1}, {2}.", StandardVcsGroup.class, ActionManager.getInstance().getId(child2), child2.getClass()));
                continue;
            }
            String vcsName = standardGroup.getVcsName(project);
            if (!currentVcses.contains(vcsName)) continue;
            groups2.add(standardGroup);
        }
        if (groups2.isEmpty()) {
            return null;
        }
        if (groups2.size() == 1) {
            return (DefaultActionGroup)ContainerUtil.getOnlyItem(groups2);
        }
        DefaultActionGroup result2 = DefaultActionGroup.createPopupGroup((Supplier)VcsBundle.messagePointer((String)"group.name.version.control", (Object[])new Object[0]));
        result2.addAll(groups2);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsGroupsWrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsGroupsWrapper";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVcses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectVcses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeVcsGroups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

