/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.AbstractChangeListAction;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.actions.RemoveChangeListAction$WhenMappings;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0002J,\u0010\u0014\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u001e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RemoveChangeListAction;", "Lcom/intellij/openapi/vcs/changes/actions/AbstractChangeListAction;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "askNewDefaultChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "project", "Lcom/intellij/openapi/project/Project;", "lists", "", "remainingLists", "canRemoveChangeLists", "", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "confirmAllChangeListsRemoval", "pendingLists", "toAsk", "confirmChangeListRemoval", "deleteLists", "", "update", "intellij.platform.vcs.impl"})
public final class RemoveChangeListAction
extends AbstractChangeListAction {
    private final Logger LOG;

    public void update(@NotNull AnActionEvent e) {
        boolean hasChanges;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object[] changeListsArray = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        Object object = changeListsArray;
        if (changeListsArray == null || (object = ArraysKt.asList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object changeLists = object;
        boolean enabled = this.canRemoveChangeLists(e.getProject(), (List<? extends ChangeList>)changeLists);
        AbstractChangeListAction.updateEnabledAndVisible$default(this, e, enabled, false, 4, null);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        Presentation presentation3 = presentation2;
        presentation3.setText(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.text.template", (Object[])new Object[]{changeLists.size()}));
        boolean bl = hasChanges = !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        if (hasChanges) {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = (Iterable)changeLists;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ChangeList it = (ChangeList)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof LocalChangeList && ((LocalChangeList)it).isDefault())) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            boolean containsActiveChangelist = bl2;
            String string = containsActiveChangelist ? VcsBundle.message((String)"changes.another.change.list", (Object[])new Object[0]) : VcsBundle.message((String)"changes.default.change.list", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (containsActiveChange\u2026ges.default.change.list\")");
            String changeListName = string;
            presentation3.setDescription(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.description.template", (Object[])new Object[]{changeLists.size(), changeListName}));
        } else {
            presentation3.setDescription((String)null);
        }
    }

    private final boolean canRemoveChangeLists(Project project, List<? extends ChangeList> lists) {
        if (project == null || lists.isEmpty()) {
            return false;
        }
        for (ChangeList changeList : lists) {
            if (!(changeList instanceof LocalChangeList)) {
                return false;
            }
            if (!((LocalChangeList)changeList).isReadOnly()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        Object object2 = e.getRequiredData(VcsDataKeys.CHANGE_LISTS);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getRequiredData(VcsDataKeys.CHANGE_LISTS)");
        ChangeList[] selectedLists = (ChangeList[])object2;
        List<ChangeList> list2 = Arrays.asList(Arrays.copyOf(selectedLists, selectedLists.length));
        if (list2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<com.intellij.openapi.vcs.changes.LocalChangeList>");
        }
        this.deleteLists(project, (Collection<? extends LocalChangeList>)list2);
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteLists(Project project, Collection<? extends LocalChangeList> lists) {
        boolean activeChangelistSelected;
        List pendingLists;
        List toAsk;
        List toRemove2;
        ChangeListManagerEx manager2;
        block21: {
            boolean bl;
            void $this$mapNotNullTo$iv$iv;
            ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)changeListManagerEx), (String)"ChangeListManagerEx.getInstanceEx(project)");
            manager2 = changeListManagerEx;
            boolean bl2 = false;
            toRemove2 = new ArrayList();
            boolean bl3 = false;
            toAsk = new ArrayList();
            Iterable $this$mapNotNull$iv = lists;
            boolean $i$f$mapNotNull = false;
            Iterator iterator2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                LocalChangeList localChangeList;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl4 = false;
                LocalChangeList it = (LocalChangeList)element$iv$iv;
                boolean bl5 = false;
                if (manager2.getChangeList(it.getId()) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                LocalChangeList it$iv$iv = localChangeList;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterator iterator4 = ((List)destination$iv$iv).iterator();
            while (iterator4.hasNext()) {
                LocalChangeList list2;
                LocalChangeList localChangeList = list2 = (LocalChangeList)iterator4.next();
                Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"list");
                switch (RemoveChangeListAction$WhenMappings.$EnumSwitchMapping$0[ChangeListRemoveConfirmation.INSTANCE.checkCanDeleteChangelist(project, localChangeList, true).ordinal()]) {
                    case 1: {
                        toAsk.add(list2);
                        break;
                    }
                    case 2: {
                        toRemove2.add(list2);
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
            }
            pendingLists = CollectionsKt.plus((Collection)toAsk, (Iterable)toRemove2);
            Iterable $this$any$iv = pendingLists;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl9 = false;
                    if (!it.isDefault()) continue;
                    bl = true;
                    break block21;
                }
                bl = activeChangelistSelected = false;
            }
        }
        if (activeChangelistSelected) {
            List list3 = manager2.getChangeLists();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"manager.changeLists");
            List remainingLists = CollectionsKt.toList((Iterable)CollectionsKt.subtract((Iterable)list3, (Iterable)pendingLists));
            if (remainingLists.isEmpty()) {
                if (!this.confirmAllChangeListsRemoval(project, pendingLists, toAsk)) {
                    return;
                }
                LocalChangeList defaultList = manager2.findChangeList(LocalChangeList.getDefaultName());
                if (defaultList == null) {
                    defaultList = manager2.addChangeList(LocalChangeList.getDefaultName(), null);
                } else {
                    manager2.editComment(defaultList.getName(), null);
                    manager2.editChangeListData(defaultList.getName(), null);
                }
                LocalChangeList localChangeList = defaultList;
                Intrinsics.checkNotNull((Object)localChangeList);
                manager2.setDefaultChangeList(localChangeList);
                toRemove2.addAll(toAsk);
                toRemove2.remove(defaultList);
            } else {
                LocalChangeList localChangeList = this.askNewDefaultChangeList(project, toAsk, remainingLists);
                if (localChangeList == null) {
                    return;
                }
                LocalChangeList newDefault = localChangeList;
                manager2.setDefaultChangeList(newDefault);
                toRemove2.addAll(toAsk);
                if (toRemove2.remove(newDefault)) {
                    this.LOG.error("New default changelist should be selected among remaining");
                }
            }
        } else if (this.confirmChangeListRemoval(project, toAsk)) {
            toRemove2.addAll(toAsk);
        }
        Iterable $this$forEach$iv = toRemove2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalChangeList it = (LocalChangeList)element$iv;
            boolean bl = false;
            manager2.removeChangeList(it.getName());
        }
    }

    private final boolean confirmChangeListRemoval(Project project, List<? extends LocalChangeList> lists) {
        boolean haveNoChanges;
        block4: {
            boolean bl;
            Iterable $this$all$iv = lists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl2 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block4;
                }
                bl = haveNoChanges = true;
            }
        }
        if (haveNoChanges) {
            return true;
        }
        String string = lists.size() == 1 ? VcsBundle.message((String)"changes.removechangelist.warning.text", (Object[])new Object[]{((LocalChangeList)CollectionsKt.single(lists)).getName()}) : VcsBundle.message((String)"changes.removechangelist.multiple.warning.text", (Object[])new Object[]{lists.size()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (lists.size == 1)\n   \u2026arning.text\", lists.size)");
        String message2 = string;
        return Messages.showYesNoDialog((Project)project, (String)message2, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private final boolean confirmAllChangeListsRemoval(Project project, List<? extends LocalChangeList> pendingLists, List<? extends LocalChangeList> toAsk) {
        boolean haveNoChanges;
        block6: {
            boolean bl;
            if (pendingLists.size() == 1) {
                return true;
            }
            if (toAsk.isEmpty()) {
                return true;
            }
            Iterable $this$all$iv = pendingLists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv;
                    boolean bl2 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block6;
                }
                bl = haveNoChanges = true;
            }
        }
        if (haveNoChanges) {
            return true;
        }
        String string = VcsBundle.message((String)"changes.removechangelist.all.lists.warning.text", (Object[])new Object[]{pendingLists.size()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"chang\u2026text\", pendingLists.size)");
        String message2 = string;
        return Messages.showYesNoDialog((Project)project, (String)message2, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final LocalChangeList askNewDefaultChangeList(Project project, List<? extends LocalChangeList> lists, List<? extends LocalChangeList> remainingLists) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        boolean haveNoChanges;
        Object element$iv2;
        block8: {
            boolean bl;
            Collection collection = remainingLists;
            boolean bl2 = false;
            boolean bl3 = !collection.isEmpty();
            bl2 = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl3) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $this$all$iv = lists;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    LocalChangeList it = (LocalChangeList)element$iv2;
                    boolean bl6 = false;
                    if (it.getChanges().isEmpty()) continue;
                    bl = false;
                    break block8;
                }
                bl = haveNoChanges = true;
            }
        }
        if (remainingLists.size() == 1 && haveNoChanges) {
            return (LocalChangeList)CollectionsKt.single(remainingLists);
        }
        Iterable $this$map$iv = remainingLists;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalChangeList localChangeList = (LocalChangeList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] remainingListsNames = objectArray;
        String string = haveNoChanges ? VcsBundle.message((String)"changes.remove.active.empty.prompt", (Object[])new Object[0]) : VcsBundle.message((String)"changes.remove.active.prompt", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (haveNoChanges)\n     \u2026es.remove.active.prompt\")");
        String message2 = string;
        int nameIndex = Messages.showChooseDialog((Project)project, (String)message2, (String)VcsBundle.message((String)"changes.remove.active.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])remainingListsNames, (String)((String)ArraysKt.first((Object[])remainingListsNames)));
        if (nameIndex < 0) {
            return null;
        }
        return remainingLists.get(nameIndex);
    }

    public RemoveChangeListAction() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoveChangeListAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
    }
}

