/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesPreprocess;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RevertCommittedStuffAbstractAction
extends AnAction
implements DumbAware {
    private final boolean myReverse;

    protected RevertCommittedStuffAbstractAction(boolean reverse) {
        this.myReverse = reverse;
    }

    protected abstract Change @Nullable [] getChanges(@NotNull AnActionEvent var1, boolean var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        LocalChangeList targetList;
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(0);
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        Change[] changes = this.getChanges(e, false);
        if (changes == null || changes.length == 0) {
            return;
        }
        final ArrayList changesList = new ArrayList();
        Collections.addAll(changesList, changes);
        FileDocumentManager.getInstance().saveAllDocuments();
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        final String title2 = VcsBundle.message((String)"changes.progress.title.choice.revert.apply.changes", (Object[])new Object[]{this.myReverse ? 0 : 1});
        final String errorPrefix = VcsBundle.message((String)"changes.dialog.message.failed.to.revert.apply.changes", (Object[])new Object[]{this.myReverse ? 0 : 1});
        if (ChangeListManager.getInstance((Project)project).areChangeListsEnabled()) {
            ChangeListChooser chooser2 = new ChangeListChooser(project, VcsBundle.message((String)"revert.changes.changelist.chooser.title", (Object[])new Object[0]));
            if (changeLists != null && changeLists.length > 0) {
                String defaultName = VcsBundle.message((String)"changes.revert.apply.change.list.name", (Object[])new Object[]{this.myReverse ? 0 : 1, changeLists[0].getName()});
                chooser2.setSuggestedName(defaultName);
            }
            if (!chooser2.showAndGet()) {
                return;
            }
            targetList = chooser2.getSelectedList();
        } else {
            targetList = null;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title2, true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    List<Change> preprocessed = ChangesPreprocess.preprocessChangesRemoveDeletedForDuplicateMoved(changesList);
                    List<FilePatch> patches2 = IdeaTextPatchBuilder.buildPatch(project, preprocessed, baseDir.toNioPath(), RevertCommittedStuffAbstractAction.this.myReverse, false);
                    new PatchApplier(project, baseDir, new ArrayList<FilePatch>(patches2), targetList, null).execute();
                }
                catch (VcsException ex) {
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)project, (String)(errorPrefix + ex.getMessage()), (String)title2), null, (Project)project);
                    indicator2.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction$1", "run"));
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isEnabled(e));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = this.getChanges(e, true);
        return project != null && changes != null && changes.length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

