/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffWithLocalAction
extends AnAction
implements DumbAware,
AnActionExtensionProvider {
    private final boolean myUseBeforeVersion;

    public ShowDiffWithLocalAction() {
        this(false);
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
    }

    public ShowDiffWithLocalAction(boolean useBeforeVersion) {
        this.myUseBeforeVersion = useBeforeVersion;
        ActionUtil.copyFrom((AnAction)this, (String)(useBeforeVersion ? "Vcs.ShowDiffWithLocal.Before" : "Vcs.ShowDiffWithLocal"));
    }

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(0);
        }
        return e.getData(VcsDataKeys.CHANGES_SELECTION) != null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(1);
        }
        if (ChangeListManager.getInstance((Project)(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT))).isFreezedWithNotification(null)) {
            return;
        }
        ListSelection selection = (ListSelection)e.getRequiredData(VcsDataKeys.CHANGES_SELECTION);
        ListSelection changesToLocal = selection.map(change -> ShowDiffWithLocalAction.getChangeWithLocal(change, this.myUseBeforeVersion));
        if (!changesToLocal.isEmpty()) {
            ShowDiffAction.showDiffForChange(project, (ListSelection<? extends Change>)changesToLocal);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ListSelection selection = (ListSelection)e.getData(VcsDataKeys.CHANGES_SELECTION);
        boolean isInAir = CommittedChangesBrowserUseCase.IN_AIR.equals(e.getData(CommittedChangesBrowserUseCase.DATA_KEY));
        e.getPresentation().setEnabled(project != null && selection != null && !isInAir && this.canShowDiff(selection.getList()));
    }

    private boolean canShowDiff(@NotNull List<? extends Change> changes) {
        if (changes == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(changes, c -> ShowDiffWithLocalAction.getChangeWithLocal(c, this.myUseBeforeVersion) != null);
    }

    @Nullable
    public static Change getChangeWithLocal(@NotNull Change c, boolean useBeforeVersion) {
        ContentRevision localRevision;
        if (c == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(4);
        }
        ContentRevision revision = useBeforeVersion ? c.getBeforeRevision() : c.getAfterRevision();
        ContentRevision otherRevision = useBeforeVersion ? c.getAfterRevision() : c.getBeforeRevision();
        VirtualFile file2 = ShowDiffWithLocalAction.getLocalVirtualFileFor(revision);
        if (file2 == null) {
            file2 = ShowDiffWithLocalAction.getLocalVirtualFileFor(otherRevision);
        }
        ContentRevision contentRevision = localRevision = file2 != null ? CurrentContentRevision.create((FilePath)VcsUtil.getFilePath((VirtualFile)file2)) : null;
        if (revision == null && localRevision == null) {
            return null;
        }
        return new Change(revision, localRevision);
    }

    @Nullable
    private static VirtualFile getLocalVirtualFileFor(@Nullable ContentRevision revision) {
        if (revision == null) {
            return null;
        }
        FilePath filePath = revision.getFile();
        if (filePath.isNonLocal() || filePath.isDirectory()) {
            return null;
        }
        return filePath.getVirtualFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/ShowDiffWithLocalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowDiff";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getChangeWithLocal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ShowDiffBeforeWithLocalAction
    extends ShowDiffWithLocalAction {
        public ShowDiffBeforeWithLocalAction() {
            super(true);
        }
    }
}

