/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PresentableGoToChangePopupAction<T>
extends GoToChangePopupBuilder.BaseGoToChangePopupAction {
    @NotNull
    protected abstract ListSelection<? extends T> getChanges();

    @Nullable
    protected abstract PresentableChange getPresentation(@NotNull T var1);

    @Override
    protected boolean canNavigate() {
        return this.getChanges().getList().size() > 1;
    }

    @NotNull
    private DefaultTreeModel buildTreeModel(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull List<? extends T> changes) {
        if (project == null) {
            PresentableGoToChangePopupAction.$$$reportNull$$$0(0);
        }
        if (grouping2 == null) {
            PresentableGoToChangePopupAction.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            PresentableGoToChangePopupAction.$$$reportNull$$$0(2);
        }
        MultiMap groups2 = MultiMap.createLinked();
        for (int i2 = 0; i2 < changes.size(); ++i2) {
            PresentableChange change = this.getPresentation(changes.get(i2));
            if (change == null) continue;
            FilePath filePath = change.getFilePath();
            FileStatus fileStatus = change.getFileStatus();
            ChangesBrowserNode.Tag tag2 = change.getTag();
            groups2.putValue((Object)tag2, (Object)new GenericChangesBrowserNode(filePath, fileStatus, i2));
        }
        MyTreeModelBuilder builder2 = new MyTreeModelBuilder(project, grouping2);
        for (ChangesBrowserNode.Tag tag3 : groups2.keySet()) {
            builder2.setGenericNodes(groups2.get((Object)tag3), tag3);
        }
        DefaultTreeModel defaultTreeModel = builder2.build();
        if (defaultTreeModel == null) {
            PresentableGoToChangePopupAction.$$$reportNull$$$0(3);
        }
        return defaultTreeModel;
    }

    protected abstract void onSelected(@NotNull T var1);

    @Override
    @NotNull
    protected JBPopup createPopup(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            PresentableGoToChangePopupAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Ref popup2 = new Ref();
        MyChangesBrowser cb2 = new MyChangesBrowser(project, (Ref<? extends JBPopup>)popup2);
        popup2.set((Object)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)cb2, cb2.getPreferredFocusedComponent()).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(true).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setDimensionServiceKey(project, "Diff.GoToChangePopup", false).createPopup());
        JBPopup jBPopup = (JBPopup)popup2.get();
        if (jBPopup == null) {
            PresentableGoToChangePopupAction.$$$reportNull$$$0(5);
        }
        return jBPopup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTreeModel";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTreeModelBuilder
    extends TreeModelBuilder {
        MyTreeModelBuilder(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
            if (project == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(0);
            }
            if (grouping2 == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(1);
            }
            super(project, grouping2);
        }

        public void setGenericNodes(@NotNull Collection<GenericChangesBrowserNode> nodes, @Nullable ChangesBrowserNode.Tag tag2) {
            if (nodes == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(2);
            }
            ChangesBrowserNode<?> parentNode = this.createTagNode(tag2);
            for (GenericChangesBrowserNode node2 : ContainerUtil.sorted(nodes, Comparator.comparing(data2 -> data2.getFilePath(), PATH_COMPARATOR))) {
                this.insertChangeNode(node2.getFilePath(), parentNode, node2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$MyTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGenericNodes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GenericChangesBrowserNode
    extends ChangesBrowserNode<FilePath>
    implements Comparable<GenericChangesBrowserNode> {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final FileStatus myFileStatus;
        private final int myIndex;

        GenericChangesBrowserNode(@NotNull FilePath filePath, @NotNull FileStatus fileStatus, int index2) {
            if (filePath == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(0);
            }
            if (fileStatus == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(1);
            }
            super(filePath);
            this.myFilePath = filePath;
            this.myFileStatus = fileStatus;
            this.myIndex = index2;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myFileStatus;
            if (fileStatus == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Override
        protected boolean isFile() {
            return !this.isDirectory();
        }

        @Override
        protected boolean isDirectory() {
            return this.myFilePath.isDirectory();
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded2, boolean hasFocus) {
            if (renderer2 == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(4);
            }
            renderer2.appendFileName(this.myFilePath.getVirtualFile(), this.myFilePath.getName(), this.myFileStatus.getColor());
            if (renderer2.isShowFlatten()) {
                this.appendParentPath(renderer2, this.myFilePath.getParentPath());
            }
            if (!renderer2.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
                this.appendCount(renderer2);
            }
            renderer2.setIcon(this.myFilePath, this.myFilePath.isDirectory() || !this.isLeaf());
        }

        @Override
        public String getTextPresentation() {
            return this.myFilePath.getName();
        }

        @Override
        public String toString() {
            return FileUtil.toSystemDependentName((String)this.myFilePath.getPath());
        }

        @Override
        public int compareTo(@NotNull GenericChangesBrowserNode o) {
            if (o == null) {
                GenericChangesBrowserNode.$$$reportNull$$$0(5);
            }
            return GenericChangesBrowserNode.compareFilePaths(this.myFilePath, o.myFilePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileStatus";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$GenericChangesBrowserNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$GenericChangesBrowserNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyChangesBrowser
    extends ChangesBrowserBase {
        @NotNull
        private final Ref<? extends JBPopup> myRef;
        @NotNull
        private final ListSelection<? extends T> myChanges;

        MyChangesBrowser(@NotNull Project project, Ref<? extends JBPopup> popupRef) {
            if (project == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (popupRef == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project, false, false);
            this.myRef = popupRef;
            this.myChanges = PresentableGoToChangePopupAction.this.getChanges();
            this.myViewer.setSelectionMode(1);
            this.init();
            this.myViewer.rebuildTree();
            if (this.myChanges.getSelectedIndex() != -1) {
                UiNotifyConnector.doWhenFirstShown((JComponent)this, () -> {
                    DefaultMutableTreeNode toSelect2 = TreeUtil.findNode(this.myViewer.getRoot(), node2 -> node2 instanceof GenericChangesBrowserNode && ((GenericChangesBrowserNode)node2).getIndex() == this.myChanges.getSelectedIndex());
                    if (toSelect2 != null) {
                        TreeUtil.selectNode((JTree)((Object)this.myViewer), (TreeNode)toSelect2);
                    }
                });
            }
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel() {
            DefaultTreeModel defaultTreeModel = PresentableGoToChangePopupAction.this.buildTreeModel(this.myProject, this.getGrouping(), this.myChanges.getList());
            if (defaultTreeModel == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            return defaultTreeModel;
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Override
        protected void onDoubleClick() {
            ((JBPopup)this.myRef.get()).cancel();
            ChangesBrowserNode selection = VcsTreeModelData.selected((JTree)((Object)this.myViewer)).nodesStream().findFirst().orElse(null);
            GenericChangesBrowserNode node2 = (GenericChangesBrowserNode)ObjectUtils.tryCast((Object)selection, GenericChangesBrowserNode.class);
            if (node2 == null) {
                return;
            }
            Object newSelection = this.myChanges.getList().get(node2.getIndex());
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> PresentableGoToChangePopupAction.this.onSelected(newSelection));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popupRef";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$MyChangesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class Default<T extends PresentableChange>
    extends PresentableGoToChangePopupAction<T> {
        @Override
        protected PresentableChange getPresentation(@NotNull T change) {
            if (change == null) {
                Default.$$$reportNull$$$0(0);
            }
            return change;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$Default", "getPresentation"));
        }
    }
}

