/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.ChangesBrowserToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListViewerDialog
extends DialogWrapper {
    private static final String CHANGES_DETAILS_WINDOW_KEY = "CommittedChangesDetailsLock";
    public static final String DIMENSION_SERVICE_KEY = "VCS.ChangeListViewerDialog";
    @NotNull
    private final LoadingCommittedChangeListPanel myLoadingPanel;

    public static void show(@NotNull Project project, @Nullable @Nls String title2, @NotNull LoadingCommittedChangeListPanel loadingPanel) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(0);
        }
        if (loadingPanel == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(1);
        }
        ChangeListViewerDialog.show(project, title2, loadingPanel, null, AbstractVcsHelperImpl.showCommittedChangesAsTab());
    }

    public static void show(@NotNull Project project, @Nullable @Nls String title2, @NotNull LoadingCommittedChangeListPanel loadingPanel, @Nullable BackgroundableActionLock lock2, boolean showAsTab) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(2);
        }
        if (loadingPanel == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(3);
        }
        if (showAsTab) {
            ChangeListViewerDialog.showAsTab(project, title2, loadingPanel);
        } else {
            ChangeListViewerDialog.showDialog(project, title2, loadingPanel, lock2);
        }
    }

    private static void showAsTab(@NotNull Project project, @Nullable @NlsContexts.TabTitle String title2, @NotNull LoadingCommittedChangeListPanel loadingPanel) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(4);
        }
        if (loadingPanel == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(5);
        }
        loadingPanel.hideSideBorders();
        SimpleChangesBrowser changesBrowser = loadingPanel.getChangesBrowser();
        DiffPreview diffPreview = ChangesBrowserToolWindow.createDiffPreview(project, changesBrowser, loadingPanel);
        changesBrowser.setShowDiffActionPreview(diffPreview);
        Content content2 = ContentFactory.SERVICE.getInstance().createContent(loadingPanel.getContent(), title2, false);
        content2.setPreferredFocusableComponent(loadingPanel.getPreferredFocusedComponent());
        content2.setDisposer((Disposable)loadingPanel);
        ChangesBrowserToolWindow.showTab(project, content2);
    }

    public static void showDialog(@NotNull Project project, @Nullable @NlsContexts.DialogTitle String title2, @NotNull LoadingCommittedChangeListPanel loadingPanel) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(6);
        }
        if (loadingPanel == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(7);
        }
        ChangeListViewerDialog.showDialog(project, title2, loadingPanel, null);
    }

    private static void showDialog(@NotNull Project project, @Nullable @NlsContexts.DialogTitle String title2, @NotNull LoadingCommittedChangeListPanel loadingPanel, @Nullable BackgroundableActionLock lock2) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(8);
        }
        if (loadingPanel == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(9);
        }
        ChangeListViewerDialog dlg = new ChangeListViewerDialog(project, loadingPanel);
        if (title2 != null) {
            dlg.setTitle(title2);
        }
        if (lock2 != null) {
            lock2.lock();
            UIUtil.putWindowClientProperty((Window)dlg.getWindow(), (Object)CHANGES_DETAILS_WINDOW_KEY, (Object)lock2);
            Disposer.register((Disposable)dlg.getDisposable(), () -> lock2.unlock());
        }
        dlg.show();
    }

    public static boolean tryFocusExistingDialog(@Nullable BackgroundableActionLock lock2) {
        if (lock2 == null || !lock2.isLocked()) {
            return false;
        }
        for (Window window : Window.getWindows()) {
            Object windowLock = UIUtil.getWindowClientProperty((Window)window, (Object)CHANGES_DETAILS_WINDOW_KEY);
            if (windowLock == null || !lock2.equals(windowLock)) continue;
            UIUtil.toFront((Window)window);
            return true;
        }
        return true;
    }

    public ChangeListViewerDialog(@NotNull Project project, @NotNull LoadingCommittedChangeListPanel loadingPanel) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(10);
        }
        if (loadingPanel == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(11);
        }
        this(project, null, loadingPanel);
    }

    public ChangeListViewerDialog(@NotNull Project project, @Nullable Component parentComponent, @NotNull LoadingCommittedChangeListPanel loadingPanel) {
        if (project == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(12);
        }
        if (loadingPanel == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(13);
        }
        super(project, parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.myLoadingPanel = loadingPanel;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myLoadingPanel);
        this.setTitle(VcsBundle.message((String)"dialog.title.changes.browser", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        this.setModal(false);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    public JComponent createCenterPanel() {
        return this.myLoadingPanel.getContent();
    }

    protected Action @NotNull [] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        Action[] actionArray = new Action[]{cancelAction};
        if (actionArray == null) {
            ChangeListViewerDialog.$$$reportNull$$$0(14);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLoadingPanel.getPreferredFocusedComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangeListViewerDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangeListViewerDialog";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showAsTab";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

