/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.CommittedChangeListPanel;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.browser.LoadingChangesPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.StatusText;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingCommittedChangeListPanel
implements Disposable {
    private final CommittedChangeListPanel myChangesPanel;
    private final LoadingChangesPanel myLoadingPanel;

    public LoadingCommittedChangeListPanel(@NotNull Project project) {
        if (project == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(0);
        }
        this.myChangesPanel = new CommittedChangeListPanel(project);
        StatusText emptyText = this.myChangesPanel.getChangesBrowser().getViewer().getEmptyText();
        this.myLoadingPanel = new LoadingChangesPanel(this.myChangesPanel, emptyText, this);
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getContent() {
        LoadingChangesPanel loadingChangesPanel = this.myLoadingPanel;
        if (loadingChangesPanel == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(1);
        }
        return loadingChangesPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myChangesPanel.getPreferredFocusedComponent();
        if (jComponent == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    public SimpleChangesBrowser getChangesBrowser() {
        CommittedChangesBrowser committedChangesBrowser = this.myChangesPanel.getChangesBrowser();
        if (committedChangesBrowser == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(3);
        }
        return committedChangesBrowser;
    }

    public void hideCommitMessage() {
        this.myChangesPanel.setShowCommitMessage(false);
    }

    public void hideSideBorders() {
        this.myChangesPanel.setShowSideBorders(false);
    }

    public void markChangesInAir(boolean inAir) {
        this.myChangesPanel.getChangesBrowser().setUseCase(inAir ? CommittedChangesBrowserUseCase.IN_AIR : null);
    }

    public void setDescription(@Nullable @NlsContexts.Label String description) {
        this.myChangesPanel.setDescription(description);
    }

    public void setChanges(@NotNull CommittedChangeList changeList, @Nullable VirtualFile toSelect2) {
        if (changeList == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(4);
        }
        this.myChangesPanel.setChangeList(changeList);
        this.myChangesPanel.getChangesBrowser().getViewer().selectFile(toSelect2);
    }

    public void setChanges(@NotNull Collection<Change> changes, @Nullable VirtualFile toSelect2) {
        if (changes == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(5);
        }
        this.hideCommitMessage();
        this.myChangesPanel.setChangeList((CommittedChangeList)CommittedChangeListPanel.createChangeList(changes));
        this.myChangesPanel.getChangesBrowser().getViewer().selectFile(toSelect2);
    }

    public void loadChangesInBackground(@NotNull ThrowableComputable<? extends ChangelistData, ? extends VcsException> computable) {
        if (computable == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(6);
        }
        this.myLoadingPanel.loadChangesInBackground(computable, result2 -> {
            if (result2 != null) {
                this.myChangesPanel.setChangeList(result2.changeList);
                this.myChangesPanel.getChangesBrowser().getViewer().selectFile(result2.toSelect);
            } else {
                this.myChangesPanel.setChangeList((CommittedChangeList)CommittedChangeListPanel.createChangeList(Collections.emptySet()));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LoadingCommittedChangeListPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LoadingCommittedChangeListPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesInBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ChangelistData {
        @NotNull
        public final CommittedChangeList changeList;
        @Nullable
        public final FilePath toSelect;

        public ChangelistData(@NotNull CommittedChangeList changeList, @Nullable FilePath toSelect2) {
            if (changeList == null) {
                ChangelistData.$$$reportNull$$$0(0);
            }
            this.changeList = changeList;
            this.toSelect = toSelect2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ui/LoadingCommittedChangeListPanel$ChangelistData", "<init>"));
        }
    }
}

